<?php
/**
 * NameConfigure.
 * @package magic.core
 * @subpackage config
 */
/**
 * 各種の命名規則を設定するインターフェイスです.
 * <p>
 * フレームワークはここで設定された命名規則に基づいて、
 * ファイルのincludeやリクエストのインジェクション処理などを実行します。<br/>
 * アプリケーションの命名規則に従って、適切な実装クラスを作成してください。<br/>
 * このインターフェイスの実装クラスでは、すべてのメソッドにおいて、
 * {@link NamingType}を実装したいずれかのクラス
 * <ul>
 * <li>{@link UpperCamelCase}</li>
 * <li>{@link LowerCamelCase}</li>
 * <li>{@link UpperSnakeCase}</li>
 * <li>{@link LowerSnakeCase}</li>
 * </ul>
 * を返す必要があります。
 * </p>
 * @package magic.core
 * @subpackage config
 * @author T.Okumura
 * @version 1.0.0
 * @see NamingType
 * @see UpperCamelCase
 * @see LowerCamelCase
 * @see UpperSnakeCase
 * @see LowerSnakeCase
 */
interface NameConfigure {
    /**
     * PHPファイルの命名規則を取得します.
     * @return NamingType
     */
    function getPhpFileNamingType();
    /**
     * HTMLファイルの命名規則を取得します.
     * @return NamingType
     */
    function getHtmlFileNamingType();
    /**
     * クラス名の命名規則を取得します.
     * @return NamingType
     */
    function getClassNamingType();
    /**
     * ファンクション名の命名規則を取得します.
     * @return NamingType
     */
    function getMethodNamingType();
    /**
     * リクエストパラメータの命名規則を取得します.
     * <p>
     * これは、<br/>
     * ＜input name="xxx" type="" value="＜?=$xxx＞"<br/>
     * で表されるname属性と、value属性に設定される変数の、xxx部分の命名規則です。
     * この命名規則は、レスポンスにも影響することに注意してください。<br/>
     * </p>
     * @return NamingType
     */
    function getRequestNamingType();
}
// EOF.