<?php
/**
 * AppController.
 * @package magic.app
 */
/**
 * フレームワークのコントローラーを読み込みます.
 */
require_once CORE . 'Controller.php';
/**
 * アプリケーションのモジュール読み込みを実行します.
 */
require_once APP . 'Bootstrap.php';
/**
 * アプリケーション側のコントローラーのサンプルです.
 * @package magic.app
 * @final
 */
final class AppController extends Controller {
    /**
     * アプリケーション独自の設定ファイルを読み込ませます。
     * <p>
     * ここで設定しなかったクラスについては、
     * フレームワークのデフォルト設定が使用されます。
     * </p>
     * @see Controller::configure()
     */
    protected function configure() {
        // セッション名を設定します。
        $this->session->setName('セッション名');
        // NameConfigureの実装クラスを指定します。
        $this->name = NULL;
        // PathConfigureの実装クラスを指定します。
        $this->path = NULL;
        // RouteConfigureの実装クラスを指定します。
        $this->route = NULL;
        // DataSourceConfigureの実装クラスを指定します。
        $this->dataSource = NULL;
        // セッションを自動的に開始するかどうかを設定します。
        $this->sessionAutoStart = FALSE;
        // ロケールを固定したい場合のみ設定してください。
        LocaleProvider::setDefaultLocale(NULL);
        // メッセージファイルがあれば設定してください。
        MessageBehavior::setMessageClass(NULL);
        // 必要があれば、リクエストのエンコードやサニタイズを実行してください。
    }
    /**
     * システムエラーが発生した場合の処理を拡張します.
     * @see Controller::systemExceptionHandler()
     */
    protected function systemExceptionHandler() {
    }
    /**
     * データベースエラーが発生した場合の処理を拡張します.
     * @see Controller::sqlExceptionHandler()
     */
    protected function sqlExceptionHandler() {
    }
}
// EOF.