package map.route;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import map.model.Node;
import map.model.Road;

public class RouteEntry {

	private double cost;
	private Node previous;
	private Node next;
	private Set<Road> route;
	public RouteEntry(Node n1, Node n2) {
		this.previous = n1;
		this.next = n2;
		this.route = new HashSet<Road>();
	}

	public void setCost(double cost) {
		this.cost = cost;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof RouteEntry) {
			RouteEntry entry = (RouteEntry) obj;
			return (entry.previous.equals(this.previous) && entry.next.equals(this.next)) || (entry.previous.equals(this.next) && entry.next.equals(this.previous));
		} else if (obj instanceof Node) {
			Node node = (Node) obj;
			return node.equals(this.previous);
		}
		return false;
	}

	public double getCost() {
		return this.cost;
	}

	public Collection<Road> getRoute() {
		return this.route;
	}
	public boolean add(Road road) {
		return this.route.add(road);
	}
	public void clear() {
		this.route.clear();
	}
	@Override
	public int hashCode() {
		return this.previous.hashCode();
	}
	
	public Node getNext() {
		return this.next;
	}
	public Node getPrevious() {
		return this.previous;
	}

	public void setPrevious(Node node) {
		this.previous = node;
	}
	public void setNext(Node node) {
		this.next = node;
	}
}
