/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    private static final int DefaultCacheSize = 1024;
    private OutputStream out;
    private byte[] cache;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;

    private BitOutputStream() {
    }

    public BitOutputStream(OutputStream out) {
        this(out, 1024);
    }

    public BitOutputStream(OutputStream out, int CacheSize) {
        if (out == null || 4 > CacheSize || (CacheSize & 3) != 0) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            if (CacheSize < 4) {
                throw new IllegalArgumentException("CacheSize must be 4 or more.");
            }
            throw new IllegalArgumentException("CacheSize must be multiple of 4.");
        }
        this.out = out;
        this.cache = new byte[CacheSize];
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
    }

    public void write(int data) throws IOException {
        this.writeBits(8, data);
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] buffer, int index, int length) throws IOException {
        block1: {
            if (this.bitCount % 8 != 0) ** GOTO lbl6
            this.flush();
            this.out.write(buffer, index, length);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.writeBits(8, buffer[index++]);
lbl6:
                // 2 sources

                ** while (length-- > 0)
            }
        }
    }

    public void flush() throws IOException {
        while (8 <= this.bitCount) {
            this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
            this.bitBuffer <<= 8;
            this.bitCount -= 8;
        }
        this.out.write(this.cache, 0, this.cachePosition);
        this.cachePosition = 0;
        this.out.flush();
    }

    public void close() throws IOException {
        while (this.bitCount > 0) {
            this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
            this.bitBuffer <<= 8;
            this.bitCount -= 8;
        }
        this.out.write(this.cache, 0, this.cachePosition);
        this.cachePosition = 0;
        this.out.flush();
        this.out.close();
        this.out = null;
        this.cache = null;
        this.cachePosition = 0;
        this.bitCount = 128;
        this.bitBuffer = 0;
    }

    public void writeBit(int data) throws IOException {
        this.bitBuffer |= (data & 1) << 31 - this.bitCount;
        ++this.bitCount;
        if (32 <= this.bitCount) {
            this.writeOutBitBuffer();
        }
    }

    public void writeBoolean(boolean bool) throws IOException {
        if (bool) {
            this.bitBuffer |= 1 << 31 - this.bitCount;
        }
        ++this.bitCount;
        if (32 <= this.bitCount) {
            this.writeOutBitBuffer();
        }
    }

    public void writeBits(int count, int data) throws IOException {
        while (count > 0) {
            int available = 32 - this.bitCount;
            if (count < available) {
                this.bitBuffer |= (data & -1 >>> 32 - count) << available - count;
                this.bitCount += count;
                count = 0;
                continue;
            }
            this.bitBuffer |= data >> (count -= available) & -1 >>> 32 - available;
            this.writeOutBitBuffer();
        }
    }

    private void writeOutBitBuffer() throws IOException {
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 16);
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 8);
        this.cache[this.cachePosition++] = (byte)this.bitBuffer;
        this.bitBuffer = 0;
        this.bitCount = 0;
        if (this.cache.length <= this.cachePosition) {
            this.out.write(this.cache);
            this.cachePosition = 0;
        }
    }
}

