package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import jp.sourceforge.ma38su.util.Log;

/**
 * 設定ファイル
 * @author ma38su
 */
public class Setting implements Serializable {

	/**
	 * 設定を読み込みます。
	 * 設定ファイルが存在しない場合は、新たに作成します。
	 * @param dir 
	 * @return 設定
	 */
	public static Setting readSetting(String dir) {
		ObjectInputStream bo = null;
		Setting setting = null;
		File file = new File(dir + "setting.obj");
		try {
			try {
				bo = new ObjectInputStream(new FileInputStream(file));
				setting = (Setting) bo.readObject();
			} finally {
				if (bo != null) {
					bo.close();
				}
			}
		} catch (Exception e) {
			if (file.exists()) {
				file.delete();
			}
			setting = null;
		}
		if (setting == null) {
			setting = new Setting();
		}
		setting.setFile(file);
		return setting;
	}

	/**
	 * 設定の保存先
	 */
	private transient File file;
	
	/**
	 * 起動時に利用規約を確認するフラグ
	 */
	private boolean isCheckTerms;

	/**
	 * アップデートを確認するフラグ
	 */
	private boolean isCheckUpdate;
	
	private Setting() {
		this.isCheckUpdate = true;
		this.isCheckTerms = true;
	}
	
	/**
	 * 利用規約の表示確認を行うかどうか
	 * @return 利用規約の表示確認を促す場合はtrue
	 */
	public boolean isCheckTerms() {
		return this.isCheckTerms;
	}
	
	public boolean isCheckUpdate() {
		return this.isCheckUpdate;
	}

	/**
	 * 更新情報の確認するかどうか設定します。
	 * @param flag 
	 */
	public void setCheckUpdate(boolean flag) {
		this.isCheckUpdate = flag;
		this.write();
	}
	
	/**
	 * 利用規約を確認するかどうか設定します。
	 * @param flag
	 */
	public void setCheckTerms(boolean flag) {
		this.isCheckTerms = flag;
		this.write();
	}
	
	private void setFile(File file) {
		this.file = file;
	}
		
	/**
	 * 設定を保存します。
	 * @return 保存に成功すればtrue
	 */
	public boolean write() {
		try {
			ObjectOutputStream bo = null;
			try {
				bo = new ObjectOutputStream(new FileOutputStream(this.file));
				bo.writeObject(this);
			} finally {
				if (bo != null) {
					bo.close();
				}
			}
		} catch (IOException e) {
			if (this.file.exists()) {
				this.file.delete();
			}
			Log.err(this, e);
			return false;
		}
		return true;
	}
}
