package labeling;

import java.awt.Graphics2D;

import map.model.Station;

/**
 * ラベル配置アルゴリズムのインターフェース
 * @author ma38su
 */
public interface Labeling {

	/**
	 * 駅を追加する
	 * @param labels
	 */
	public void add(Station[] labels);
	public void add(Label[] labels);
	public void add(Labels labels);

	/**
	 * 描画をおこないます。
	 */
	public void draw();

	public void add(String city, int x, int y, boolean isPoint);

	public void set(String city, int x, int y);
	
	/**
	 * ラベリングのための初期化を行います。
	 * @param g
	 * @param scale 倍率
	 * @param width 表示幅
	 * @param height 表示高さ
	 * @param isShadow 影の有無
	 */
	public void init(Graphics2D g, float scale, int width, int height, boolean isShadow);
}
