import java.io.File;

import javax.swing.UIManager;

import util.Loader;
import view.DialogFactory;

/**
 * アプリケーション起動のためのクラス
 * 
 * 必要な外部JARにクラスパスを通して、
 * StartUpクラスを呼び出します。
 * 
 * @author ma38su
 */
public class Main {
	public static void main(String[] args) {
		String mapDir = ".digital_map" + File.separatorChar;
		String pluginDir = "plugin" + File.separatorChar;
		String libDir = "lib" + File.separatorChar;
		switch (args.length) {
			case 3: libDir = args[2];
			case 2: pluginDir = args[1];
			case 1: mapDir = args[0];
		}
		try {
			// 外部JARをロードします。
			Loader.addExternalJar(libDir);
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			DialogFactory.errorDialog(null, e);
			return;
		}
		StartUp.startup(libDir, pluginDir, mapDir);
	}
}
