package view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

import controller.MainController;
import controller.SearchController;
import controller.SearchEntry;

import database.CodeDatabase;

/**
 * 市区町村の検索パネル
 * @author ma38su
 */
public class SearchPanel extends JPanel {
	public SearchPanel(final CodeDatabase db, final MainController c) {
		this.setLayout(new BorderLayout(4, 4));
		final JTextField keywordField = new JTextField();
		JPanel keywordPanel = new JPanel(new BorderLayout(4, 4));
		final DefaultListModel list = new DefaultListModel();
		keywordPanel.add(keywordField, BorderLayout.CENTER);
		JButton searchButton = new JButton("検索");
		ActionListener controller = new SearchController(db, list, keywordField);
		searchButton.addActionListener(controller);
		keywordField.addActionListener(controller);
		keywordPanel.add(searchButton, BorderLayout.EAST);
		this.setPreferredSize(new Dimension(200, 0));
		this.setMinimumSize(new Dimension(0, 0));
		JPanel resultPanel = new JPanel(new BorderLayout(4, 4));
		final JList resultList = new JList(list);
		resultList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		resultList.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2) {
					final SearchEntry entry = (SearchEntry) resultList.getSelectedValue();
					new Thread() {
						@Override
						public void run() {
							c.moveMap(entry.getCode());
						}
					}.start();
				}
			}
			public void mouseEntered(MouseEvent e) {
			}
			public void mouseExited(MouseEvent e) {
			}
			public void mousePressed(MouseEvent e) {
			}
			public void mouseReleased(MouseEvent e) {
			}
		});
		resultPanel.add(new JScrollPane(resultList));
		this.add(keywordPanel, BorderLayout.NORTH);
		this.add(resultPanel, BorderLayout.CENTER);
	}
}
