package util;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.ma38su.util.Log;

/**
 * 天気情報クラス
 * @author ma38su
 */
public class Weather {
	
	public static List<Weather> getJapanWeather() {
		Pattern pattern = Pattern.compile("<title>\\[ 今日の天気 \\] ([^ <>]+) - ([^ <>]+) - ([^ <>]+) - ([^ <>]+)</title>");
		List<Weather> list = new ArrayList<Weather>();
		BufferedReader bi = null;
		try {
			URL url = new URL("http://weather.livedoor.com/forecast/rss/index.xml");
			bi = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
			String line;
			while ((line = bi.readLine()) != null) {
				Matcher match = pattern.matcher(line);
				if (match.find()) {
					String area = match.group(1);
					String state = match.group(2);
					String temp = match.group(3);
					String date = match.group(4);
					int code = 0;
					int x = 0;
					int y = 0;
					if (area.contains("札幌")) {
						code = 1101;
						x = 508523939;
						y = 154803759;
					} else if (area.contains("釧路")) {
						code = 1206;
						x = 520062311;
						y = 154599807;
					} else if (area.contains("秋田")) {
						code = 5201;
						x = 504436797;
						y = 142456920;
					} else if (area.contains("仙台")) {
						code = 4101;
						x = 506639018;
						y = 137694211;
					} else if (area.contains("新潟")) {
						code = 15201;
						x = 500852433;
						y = 136655028;
					} else if (area.contains("東京")) {
						code = 13102;
						x = 503195625;
						y = 128356292;
					} else if (area.contains("長野")) {
						code = 20201;
						x = 497037453;
						y = 131614966;
					} else if (area.contains("名古屋")) {
						code = 23101;
						x = 493050980;
						y = 126594287;
					} else if (area.contains("大阪")) {
						code = 27128;
						x = 487788964;
						y = 124810008;
					} else if (area.contains("高知")) {
						code = 39201;
						x = 480936319;
						y = 120650146;
					} else if (area.contains("広島")) {
						code = 34101;
						x = 476830009;
						y = 123781737;
					} else if (area.contains("福岡")) {
						code = 40133;
						x = 469323016;
						y = 120977457;
					} else if (area.contains("鹿児島")) {
						code = 46201;
						x = 470602771;
						y = 113627074;
					} else if (area.contains("那覇")) {
						code = 47201;
						x = 459702695;
						y = 94382114;
					}
					if (code != 0) {
						list.add(new Weather(code, x, y, area, state, temp, date));
					}
					Log.out(Weather.class, "地点 " + area);
					Log.out(Weather.class, "天気 " + state);
					Log.out(Weather.class, "気温 " + temp);
					Log.out(Weather.class, "日付 " + date);
				}
			}
		} catch (Exception e) {
			list.clear();
		} finally {
			if (bi != null) {
				try {
					bi.close();
				} catch (IOException e) {
					Log.err(Weather.class, e);
				}
			}
		}
		return list;
	}

	private String area;

	private String date;

	public String getDate() {
		return this.date;
	}

	private String state;
	
	private String temp;

	public String getTemp() {
		return this.temp;
	}
	
	private Point point;
	public Point getPoint() {
		return this.point;
	}
	public void setPoint(Point point) {
		this.point = point;
	}
	/**
	 * 都道府県コード
	 */
	private int code;

	private int x;

	private int y;
	
	/**
	 * 天気
	 * @param code 
	 * @param x X座標
	 * @param y Y座標
	 * @param area
	 * @param state
	 * @param temp
	 * @param date
	 * @param icon
	 */
	public Weather(int code, int x, int y, String area, String state, String temp, String date) {
		this.code = code;
		this.x = x;
		this.y = y;
		this.area = area;
		this.state = state;
		this.temp = temp;
		this.date = date;
	}

	public int getX() {
		return this.x;
	}
	public int getY() {
		return this.y;
	}

	/**
	 * 都道府県コードを取得します。
	 * @return 都道府県コード
	 */
	public int getCode() {
		return this.code;
	}

	/**
	 * 天気を取得する
	 * @return 天気
	 */
	public String getState() {
		return this.state;
	}

	/**
	 * 地域を取得する
	 * @return 地域
	 */
	public String getArea() {
		return this.area;
	}
}