package map.model;

import java.awt.Color;
import java.io.Serializable;

/**
 * メッシュ標高
 * @author ma38su
 */
public class Mesh implements Serializable {
	public static final int SIZE = 2000;
	private final int x;
	private final int y;
	private final int height;
	private final Color color;
	public Mesh (int x, int y, int height) {
		this.x = x;
		this.y = y;
		this.height = height;
		float n = (float) height / 1300;
		float n2 = (float) height / 3500;
		if (n > 1f) {
			n = 1f;
		}
		this.color = Color.getHSBColor(40 / 360f + n2 * 0.39f, 0.04f + n * 0.15f, 0.95f - n * 0.20f);
	}
	public int getX() {
		return this.x;
	}
	public int getY() {
		return this.y;
	}
	public int getHeight() {
		return this.height;
	}
	public Color getColor() {
		return this.color;
	}
	public double distance (int x, int y) {
		long dx = this.x - x;
		long dy = this.y - y;
		return Math.sqrt(dx * dx + dy * dy);
	}
	@Override
	public boolean equals(Object o) {
		Mesh m = (Mesh)o;
		return (this.x == m.getX() && this.y == m.getY());
	}
}
