package controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;

import javax.swing.DefaultListModel;
import javax.swing.JTextField;

import view.DialogFactory;
import database.CodeDatabase;

/**
 * 検索のためのコントローラ
 * @author ma38su
 */
public class SearchController implements ActionListener, Runnable {
	
	private final DefaultListModel list;
	private final CodeDatabase db;
	private final JTextField field;
	
	public SearchController(CodeDatabase db, DefaultListModel list, JTextField field) {
		this.db = db;
		this.field = field;
		this.list = list;
	}
	
	public void actionPerformed(ActionEvent e) {
		new Thread(this).start();
	}
	
	public void run() {
		try {
			this.list.clear();
			Map<Integer, String> result = this.db.get(this.field.getText(), CodeDatabase.MATCH_CONTAINS);
			for (Map.Entry<Integer, String> entry : result.entrySet()) {
				this.list.addElement(new SearchEntry(entry.getKey(), entry.getValue()));
			}
		} catch (IOException ex) {
			DialogFactory.errorDialog(null, ex);
		}
	}
}
