package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import util.Log;

import map.model.City;
import map.store.ChainStore;

/**
 * ケンタッキーフライドチキンの店舗情報を取得します。
 * @author Masayasu Fujiwara
 *
 */
public class KFCPlugin extends ChainStore {
	private Pattern addressParser;

	public KFCPlugin() {
		super("ケンタッキー", "EUC-JP");
		this.addressParser = Pattern.compile("");
	}

	@Override
	protected URL getURL(City city, int page) {
		URL url = null;
		if (page == 1) {
			try {
				url = new URL("http://search.kfc.co.jp/store_search.cgi?pref="+ (city.getCode() / 1000) +"&gid=KFC&city=" + city.getCode());
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
			this.addressParser = Pattern.compile("([^<>]*"+ city.getName() +"[^<>]+)");
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.addressParser.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
