package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import util.Log;

import map.model.City;
import map.store.ChainStore;

/**
 * ブックオフの店舗情報を取得するクラスです。
 * @author Masayasu Fujiwara
 */
public class BookOffPlugin extends ChainStore {
	
	/**
	 * 住所解析用のパターン
	 */
	private Pattern ADDRESS_PARSER;
	
	/**
	 * Pluginロードのためのコンストラクタ
	 * キャッシュディレクトリを設定する必要がある。
	 */
	public BookOffPlugin() {
		super("ブックオフ");
	}

	@Override
	protected URL getURL(City city, int page) {
		URL url = null;
		if (page == 1) {
			try {
				url = new URL("http://www2.info-mapping.com/bookoff/kensaku/searchshop.asp?fkncode=" + Integer.toString(city.getCode() / 1000));
				this.ADDRESS_PARSER = Pattern.compile("<td width=\"180\" class=\"s3\">\\s*([^市区町村]*"+ city.getName() +"[^<>]+)\\s*<br>");
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
