package util;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * 簡易に一般化したFileFilter
 * @author Masayasu Fujiwara
 */
public class GeneralFileFilter extends FileFilter implements java.io.FileFilter {

	/**
	 * 許可する拡張子
	 */
	private final String[] extensions;
	
	/**
	 * FileFilterの説明
	 */
	private final String description;

	/**
	 * ディレクトリを許可するかどうか
	 */
	private boolean dir;
	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * @param extension
	 */
	public GeneralFileFilter(String extension) {
		this(new String[]{extension}, extension, true);
	}

	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * @param extension
	 * @param description 
	 */
	public GeneralFileFilter(String extension, String description) {
		this(new String[]{extension}, description, true);
	}

	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * @param extension
	 * @param description 
	 */
	public GeneralFileFilter(String[] extension, String description) {
		this(extension, description, true);
	}

	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * 
	 * @param extensions 許可する拡張子
	 * @param description FileFilterの説明
	 * @param dir ディレクトリを許可するかどうか
	 */
	public GeneralFileFilter(String[] extensions, String description, boolean dir) {
		this.extensions = extensions;
		this.description = description;
		this.dir = dir;
	}

	@Override
	public boolean accept(File file) {
		if (file.isDirectory()) {
			return this.dir;
		}
		String path = file.getPath();
		String format = path.substring(path.lastIndexOf('.') + 1, path.length());
		for (String extension : this.extensions) {
			if (extension.compareToIgnoreCase(format) == 0) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 標準の拡張子を返します
	 * @return 標準の拡張子
	 */
	public String getDefaultExtension() {
		return this.extensions[0];
	}
	@Override
	public String getDescription() {
		return this.description;
	}
}
