package util;

/**
 * ログ出力のためのクラス
 * @author Masayasu Fujiwara
 */
public class Log {

	/**
	 * デバッグモードの時はtrue
	 */
	private static boolean isDebug = false;

	static {
	}

	/**
	 * 標準出力
	 * @param c 呼び出し元のクラス
	 * @param message メッセージ
	 */
	public static void out(Class c, String message) {
		if (Log.isDebug) {
			System.out.println(c.getName() + ": "+ message);
		}
	}

	/**
	 * 標準出力
	 * @param o 呼び出し元のインスタンス
	 * @param message メッセージ
	 */
	public static void out(Object o, String message) {
		if (Log.isDebug) {
			System.out.println(o.getClass().getName() + ": "+ message);
		}
	}

	/**
	 * エラー出力
	 * @param o 呼び出し元のインスタンス
	 * @param e 投げられたクラス
	 */
	public static void err(Object o, Throwable e) {
		if (Log.isDebug) {
			Log.err(o.getClass(), e);
		}
	}

	/**
	 * エラー出力
	 * @param c 呼び出し元のクラス
	 * @param message メッセージ
	 */
	public static void err(Class c, String message) {
		System.out.println(c.getName() + ": "+ message);
	}

	/**
	 * エラー出力
	 * @param o 呼び出し元のインスタンス
	 * @param message
	 */
	public static void err(Object o, String message) {
		Log.err(o.getClass(), message);
	}

	/**
	 * エラー
	 * @param c 呼び出し元のクラス
	 * @param e 投げられたクラス
	 */
	public static void err(Class c, Throwable e) {
		if (Log.isDebug) {
			e.printStackTrace();
		} else {
			System.out.println(c.getName() + ": "+ e.getMessage());
		}
	}

	private Log() {
	}
}
