package map.model;

import java.awt.Polygon;

/**
 * アークデータ
 * @author Masayasu Fujiwara
 */
public class Arc {

	public static Polygon transformPolygon(Arc[] arcs) {
		int length = 0;
		for (Arc arc : arcs) {
			length += arc.x.length;
		}
		int[] x = new int[length];
		int[] y = new int[length];
		int count = 0;
		for (Arc arc : arcs) {
			for (int i = 0; i < arc.x.length; i++) {
				x[count] = (int)(arc.x[i] * 3600000 + 0.5);
				y[count] = (int)(arc.y[i] * 3600000 + 0.5);
				count++;
			}
		}
		return new Polygon(x, y, length);
	}

	private double[] x;
	private double[] y;
	private int tag;
	private int type;
	public Arc(double[] x, double[] y, int type, int tag) {
		this.x = x;
		this.y = y;
		this.tag = tag;
		this.type = type;
	}
	
	/**
	 * 反対方向のアークのを新たに作成します。
	 * @return 反対方向のアーク
	 */
	public Arc reverse() {
		int length = this.x.length;
		double[] reverseX = new double[length];
		double[] reverseY = new double[length];
		for (int i = 0; i < length; i++) {
			reverseX[i] = this.x[length - i - 1];
			reverseY[i] = this.y[length - i - 1];
		}
		return new Arc(reverseX, reverseY, this.type, this.tag);
	}
	
	public Curve transformCurve() {
		int length = this.x.length;
		int[] aryX = new int[length];
		int[] aryY = new int[length];
		for (int i = 0; i < length; i++) {
			aryX[i] = (int)(this.x[i] * 3600000 + 0.5);
			aryY[i] = (int)(this.y[i] * 3600000 + 0.5);
			System.out.println(aryX[i] +", "+ aryY[i]);
		}
		return new Curve(aryX, aryY, 0);
	}

	@Override
	public String toString() {
		int length = this.x.length;
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < length; i++) {
			sb.append(this.x[i]);
			sb.append(", ");
			sb.append(this.y[i]);
			sb.append('\n');
		}
		return sb.toString();
	}
}
