package map.map25000.util;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import map.data.MapData;
import map.data.Node;
import map.map25000.MapFactory;
import map.map25000.Warehouse;

public class NodeConnectPreprocessing {
	/**
	 * 地域番号リスト
	 */
	private File cityList = new File("files25k.csv");
	public static void main(String[] args) throws FileNotFoundException, IOException {
		// �?ィレクトリ�?�?
		String dir = "/home2/staff2/masayasu/data25k/";
		if(args.length > 0) {
			dir = args[0];
		}
		final String gsi = "http://sdf.gsi.go.jp/";
		final String list = "pref25k.csv";
		new NodeConnectPreprocessing(dir, gsi, System.class.getResourceAsStream(list));
	}
	public NodeConnectPreprocessing(String dir, String gsi, InputStream list) throws FileNotFoundException, IOException {
		MapFactory factory = new MapFactory(new Warehouse(dir, gsi, list, null));
		File edgedir = new File(dir +"edge/");
		if(!edgedir.isDirectory()) {
			edgedir.mkdirs();
		}
		final List<String> code = new ArrayList<String>();
		BufferedReader bi = new BufferedReader(new InputStreamReader(new FileInputStream(this.cityList), "SJIS"));
		while (bi.ready()) {
			String[] data = bi.readLine().split(",");
			code.add(data[2]);
		}
		String[] areaCode = code.toArray(new String[]{});
		Map<String, MapData> cache = new HashMap<String, MapData>();

		for (int i = 0; i < areaCode.length; i++) {
			File nodefile = new File(dir + "edge/"+ areaCode[i].substring(0, 2) + "/"+ areaCode[i] +".nod");
			File parent = nodefile.getParentFile();
			if(!parent.isDirectory()) {
				parent.mkdirs();
			}
			RandomAccessFile disc = null;
			MapData map1;
			if (cache.containsKey(areaCode[i])) {
				map1 = cache.get(areaCode[i]);
				if(!map1.hasData()) {
					factory.product(map1);
				}
			} else {
				map1 = factory.product(areaCode[i]);
				cache.put(areaCode[i], map1);
			}
			Map<Point, Node> common = new HashMap<Point, Node>();
			for(Node node : map1.getNode()) {
				common.put(new Point(node.getX(), node.getY()), node);
			}
			map1.dump();

			for(int j = 0; j < areaCode.length; j++) {
				if(i == j) {
					continue;
				}
				MapData map2;
				if (cache.containsKey(areaCode[j])) {
					map2 = cache.get(areaCode[j]);
				} else {
					map2 = factory.preproduct(Integer.parseInt(areaCode[j]));
					cache.put(areaCode[j], map2);
				}
				if(map1.getArea().intersects(map2.getArea())) {
					System.out.println(map1.getCode() + " : "+ map2.getCode());
					if(disc == null) {
						disc = new RandomAccessFile(nodefile, "rw");
					}
					if(!map2.hasData()) {
						factory.product(map2);
					}
					for(Node node : map2.getNode()) {
						Point tmpoint = new Point(node.getX(), node.getY());
						if(common.containsKey(tmpoint)) {
							Node tmpnode = common.get(tmpoint);
							disc.writeInt((int)(tmpnode.getID() % 1000000));
							disc.writeLong(node.getID());
						}
					}
				}
				map2.dump();
			}
			if(disc != null) {
				disc.close();
			}
		}
	}
	/**
	 * 都道府県番号の取�?
	 * @param pref
	 * @return
	 * @throws IOException 
	 */
	public String[] getPrefCode(String pref) throws IOException {
		final List<String> code = new ArrayList<String>();
		BufferedReader bi = new BufferedReader(new InputStreamReader(new FileInputStream(this.cityList), "SJIS"));
		Pattern splitCSV = Pattern.compile(",");
		while (bi.ready()) {
			String[] data = splitCSV.split(bi.readLine());
			if (data[0].contains(pref)) {
				code.add(data[2]);
			}
		}
		return code.toArray(new String[]{});
	}
}
