package map.labeling;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LabelCandidate extends Rectangle {
	static List<Site> staticlist = new ArrayList<Site>();
	private Map<Site, List<LabelCandidate>> conflict;
	public LabelCandidate (int x, int y, int width, int height) {
		super(x, y, width, height);
		this.conflict = new HashMap<Site, List<LabelCandidate>>();
	}
	/**
	 * コンフリクトを記録
	 * @param candidate
	 */
	public void conflict(Site site0, LabelCandidate candidate, Site site) {
		if(!this.conflict.containsKey(site)) {
			this.conflict.put(site, new LinkedList<LabelCandidate>());
		}
		if(!candidate.conflict.containsKey(site0)) {
			candidate.conflict.put(site0, new LinkedList<LabelCandidate>());
		}
		this.conflict.get(site).add(candidate);
		candidate.conflict.get(site0).add(this);
	}
	/**
	 * このラベルに対してのコンフリクトを解除する。
	 */
	public void disconflict(Site site, Set<Site> set) {
		Iterator<Map.Entry<Site, List<LabelCandidate>>> itr = this.conflict.entrySet().iterator();
		while (itr.hasNext()) {
			Map.Entry<Site, List<LabelCandidate>> entry = itr.next();
			Site key = entry.getKey();
			if(!key.equals(site)) {
				// なぜラベル候補が決まったものとコンフリクトしたのか？
				if(!key.isFixed()) {
					for (LabelCandidate candidate : key.getCandidates()) {
						candidate.conflict.remove(site);
					}
					for (LabelCandidate candidate : entry.getValue()) {
						candidate.conflict.remove(site);
					}
					set.add(key);
				} else {
					itr.remove();
					try {
						for (Site c : LabelCandidate.staticlist) {
							System.out.println(c.getName());
						}
						throw new RuntimeException();
					} catch (Exception e) {
						e.printStackTrace();
						System.exit(0);
					}
				}
			}
		}
	}
	/**
	 * コンフリクトの次数を返す
	 */
	public int conflictOrder() {
		return this.conflict.size();
	}
	/**
	 * ルール2のコンフリクトを探す
	 * 
	 */
	public void checkRule2(Site site0) {
		for (Map.Entry<Site, List<LabelCandidate>> entry : this.conflict.entrySet()) {
			Site site = entry.getKey();
			for (LabelCandidate candidate : site.getCandidates()) {
				List<LabelCandidate> c = candidate.conflict.get(site0);
			}
		}
	}
}
