package map.ksj;

import java.awt.Polygon;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import map.data.MapData;


public class Preprocessing2 {
	public static void main(String[] args) throws NumberFormatException {
		Map<Integer, List<Polygon>> map = new HashMap<Integer, List<Polygon>>();
		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(new File("ksj.aaa")));
			for (int i = 1; i <= 47; i++) {
				Preprocessing process = new Preprocessing("../", i);
				map = process.getPolygonMap();
				Preprocessing2.writePolygonMap(map, out);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				out.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	private static void writePolygonMap (Map<Integer, List<Polygon>> map, BufferedWriter out) throws IOException {
		for (Map.Entry<Integer, List<Polygon>> entry : map.entrySet()) {
			int code = entry.getKey();
			for (Polygon polygon : entry.getValue()) {
				int[] x = polygon.xpoints;
				int[] y = polygon.ypoints;
				StringBuilder sb = new StringBuilder();
				sb.append(MapData.codeFormat.format(code));
				sb.append(',');
				sb.append(x[0]);
				sb.append(',');
				sb.append(y[0]);
				for (int i = 1; i < polygon.npoints; i++) {
					sb.append(',');
					sb.append(x[i]);
					sb.append(',');
					sb.append(y[i]);
				}
				out.write(sb.toString());
				out.newLine();
			}
		}
		out.flush();
	}
}
