package map.ksj;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

import kumano.ShapeIO;


public class Preprocessing {
	public static void main(String[] args) throws NumberFormatException, IOException {
		args = new String[]{"北海道", "青森県", "岩手県", "宮城県", "秋田県", "山形県", "福島県", "茨城県", "栃木県", "群馬県", "埼玉県", "千葉県", "東京都", "神奈川県", "新潟県", "富山県", "石川県", "福井県", "山梨県", "長野県", "岐阜県", "静岡県", "愛知県", "三重県", "滋賀県", "京都府", "大阪府", "兵庫県", "奈良県", "和歌山県", "鳥取県", "島根県", "岡山県", "広島県", "山口県", "徳島県", "香川県", "愛媛県", "高知県", "福岡県", "佐賀県", "長崎県", "熊本県", "大分県", "宮崎県", "鹿児島県", "沖縄県"};
		Map<Shape, String> map = new LinkedHashMap<Shape, String>();
		for (int i = 1; i <= 47; i++) {
			Preprocessing process = new Preprocessing("../", i);
			System.out.print(" CAG : "+ i);
			map.put(process.cag(), args[i - 1]);
			System.out.println();
		}
		OutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(new File("ksj.dat")));
			ShapeIO.writeShape(map, out);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				out.close();
			}
		}
	}
	/**
	 * 文字列の分割
	 */
	private final static NumberFormat codeFormat = new DecimalFormat("00");
	private final Map<Integer, Map<Integer, Point[]>> links;
	private final Map<Integer, List<Polygon>> area;
	private Area cag() {
		Area area = new Area();
		for (Collection<Polygon> collection : this.area.values()) {
			for (Polygon polygon : collection) {
				area.add(new Area(polygon));
			}
		}
		return area;
	}
	public Preprocessing(String dir) throws NumberFormatException, IOException {
		Warehouse warehouse = new Warehouse(dir + "ksj/");
		this.links = new HashMap<Integer, Map<Integer, Point[]>>();
		this.area = new LinkedHashMap<Integer, List<Polygon>>();
		for(int i = 1; i <= 47; i++) {
			File file = warehouse.get(Preprocessing.codeFormat.format(i));
			BufferedReader bi = new BufferedReader(new FileReader(file));
			while(bi.ready()) {
				String line = bi.readLine();
				switch (line.charAt(0)) {
					case 'L': {
							final int mesh = this.parseInt(line, 3, 9);
							final int linkID = this.parseInt(line, 27, 33);
							int length = this.parseInt(line, 45, 51);
							Point[] np = new Point[length];
							Point[] rp = new Point[length];
							// 中間点データの読み込み
							int index = 0;
							int end = (length - 1) / 5 + 1;
							for(int j = 0; j < end; j++) {
								line = bi.readLine();
								StringTokenizer st = new StringTokenizer(line);
								while(st.hasMoreTokens()) {
									Point p = new Point(Integer.parseInt(st.nextToken()) * 100, Integer.parseInt(st.nextToken()) * 100);
									np[index] = p;
									rp[length - 1 - index] = p;
									index++;
								}
							}
							if(length != index) {
								System.out.printf("length:%d, index:%d\n", length, index);
							}
							if(!this.links.containsKey(mesh)) {
								this.links.put(mesh, new HashMap<Integer, Point[]>());
							}
							this.links.get(mesh).put( linkID, np);
							this.links.get(mesh).put(-linkID, rp);
						break;
					}
					case 'A' : {
						final int code = this.parseInt(line, 40, 45);
						final int length = this.parseInt(line, 45, 51);
						int end = (length - 1) / 5 + 1;
						List<Integer> aryX = new ArrayList<Integer>();
						List<Integer> aryY = new ArrayList<Integer>();
						for (int j = 0; j < end; j++) {
							line = bi.readLine();
							for (int k = 0; k < 5; k++) {
								int index = k * 14;
								if(12 + index >= line.length()) {
									break;
								}
								int meshL = this.parseInt(line, 0 + index, 6 + index);
								int idL = this.parseInt(line, 6 + index, 12 + index);
								for(Point p : this.links.get(meshL).get(idL)) {
									aryX.add(p.x);
									aryY.add(p.y);
								}
							}
						}
						int[] x = new int[aryX.size()];
						int[] y = new int[aryY.size()];
						for (int j = 0; j < aryX.size(); j++) {
							x[j] = aryX.get(j);
							y[j] = aryY.get(j);
						}
						if(!this.area.containsKey(code)) {
							this.area.put(code, new ArrayList<Polygon>());
						}
						this.area.get(code).add(new Polygon(x, y, x.length));
					}
				}
			}
		}
	}
	public Map<Integer, List<Polygon>> getPolygonMap() {
		return this.area;
	}
	public Preprocessing(String dir, int prefID) throws NumberFormatException, IOException {
		Warehouse warehouse = new Warehouse(dir + "ksj/");
		this.links = new HashMap<Integer, Map<Integer, Point[]>>();
		this.area = new TreeMap<Integer, List<Polygon>>();
		File file = warehouse.get(Preprocessing.codeFormat.format(prefID));
		BufferedReader bi = new BufferedReader(new FileReader(file));
		while(bi.ready()) {
			String line = bi.readLine();
			switch (line.charAt(0)) {
				case 'L': {
					final int mesh = this.parseInt(line, 3, 9);
					final int linkID = this.parseInt(line, 27, 33);
					int length = this.parseInt(line, 45, 51);
					Point[] np = new Point[length];
					Point[] rp = new Point[length];
					// 中間点データの読み込み
					int index = 0;
					int end = (length - 1) / 5 + 1;
					for(int j = 0; j < end; j++) {
						line = bi.readLine();
						StringTokenizer st = new StringTokenizer(line);
						while(st.hasMoreTokens()) {
							Point p = new Point(Integer.parseInt(st.nextToken()) * 100, Integer.parseInt(st.nextToken()) * 100);
							np[index] = p;
							rp[length - 1 - index] = p;
							index++;
						}
					}
					if(length != index) {
						System.out.printf("length:%d, index:%d\n", length, index);
					}
					if(!this.links.containsKey(mesh)) {
						this.links.put(mesh, new HashMap<Integer, Point[]>());
					}
					this.links.get(mesh).put( linkID, np);
					this.links.get(mesh).put(-linkID, rp);
					break;
				}
				case 'A' : {
					final int code = this.parseInt(line, 40, 45);
					final int length = this.parseInt(line, 45, 51);
					int end = (length - 1) / 5 + 1;
					List<Integer> aryX = new ArrayList<Integer>();
					List<Integer> aryY = new ArrayList<Integer>();
					for (int j = 0; j < end; j++) {
						line = bi.readLine();
						for (int k = 0; k < 5; k++) {
							int index = k * 14;
							if(12 + index >= line.length()) {
								break;
							}
							int meshL = this.parseInt(line, 0 + index, 6 + index);
							int idL = this.parseInt(line, 6 + index, 12 + index);
							for(Point p : this.links.get(meshL).get(idL)) {
								aryX.add(p.x);
								aryY.add(p.y);
							}
						}
					}
					int[] x = new int[aryX.size()];
					int[] y = new int[aryY.size()];
					for (int j = 0; j < aryX.size(); j++) {
						x[j] = aryX.get(j);
						y[j] = aryY.get(j);
					}
					if(!this.area.containsKey(code)) {
						this.area.put(code, new ArrayList<Polygon>());
					}
					this.area.get(code).add(new Polygon(x, y, x.length));
					break;
				}
			}
		}
	}
	/**
	 * 読み込んだポリゴンファイルをx0,y0,x1,y1,x2,y2,...のように
	 * 指定したファイルに出力します。
	 * @param file 出力ファイル
	 */
	public void outputPolygon(String file) {
		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(file));
			for (List<Polygon> list : this.area.values()) {
				for (Polygon polygon : list) {
					int[] x = polygon.xpoints;
					int[] y = polygon.ypoints;
					StringBuilder sb = new StringBuilder();
					sb.append(x[0]);
					sb.append(',');
					sb.append(y[0]);
					for (int i = 1; i < polygon.npoints; i++) {
						sb.append(',');
						sb.append(x[i]);
						sb.append(',');
						sb.append(y[i]);
					}
					out.write(sb.toString());
					out.newLine();
				}
			}
			out.flush();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if(out != null) {
					out.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	private int parseInt(String str, int s, int t) {
		return Integer.parseInt(str.substring(s, t).replace(" ", ""));
	}
	public Polygon[] getPolygon() {
		List<Polygon> tmp = new ArrayList<Polygon>();
		for (List<Polygon> list : this.area.values()) {
			tmp.addAll(list);
		}
		return tmp.toArray(new Polygon[]{});
	}
}
