package map.cell;

import java.awt.Shape;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CellSearch {
	/**
	 * 都道府県セル
	 */
	private PrefectureCell[] Prefcell;
	/**
	 * コンストラクタ
	 * @param size
	 * @throws FileNotFoundException 
	 * @throws IOException
	 */
	public CellSearch(String file) throws IOException {
		BufferedReader bi = null;
		try {
			bi = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file), "SJIS"));
			List<PrefectureCell> prefCell = new ArrayList<PrefectureCell>(47);
			while(bi.ready()) {
				String[] param = bi.readLine().split(",");
				int code = Integer.parseInt(param[0]);
	
				prefCell.add(new PrefectureCell(code, param));
			}
			this.Prefcell = prefCell.toArray(new PrefectureCell[]{});
		} finally {
			if (bi != null) {
				bi.close();
			}
		}
	}
	/**
	 * 地域番号を取得する
	 * @param screen
	 * @return
	 * @throws IOException 
	 */
	public int[] search(Shape screen) throws IOException {
		Set<String> codes = new HashSet<String>();
		for(PrefectureCell cell : this.Prefcell) {
			if(screen.intersects(cell)) {
				cell.product();
				cell.search(codes, screen);
			}else{
				cell.dump();
			}
		}
		int[] result = new int[codes.size()];
		int i = 0;
		for (String code : codes) {
			result[i++] = Integer.parseInt(code);
		}
		return result;
	}
}