import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Polygon;
import java.io.IOException;

import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import util.Operation;
import util.StatusBar;



import map.MapPanel;
import map.cell.CellSearch;
import map.data.MapMap;
import map.ksj.KsjFactory;
import map.map25000.MapFactory;
import map.map25000.Warehouse;

public class Main {
	/**
	 * フレーム高さ
	 */
	private static final int F_WIDTH = 800;
	/**
	 * フレーム幅
	 */
	private static final int F_HEIGHT = 600;

	// main class
	public static void main(String[] args) {
		if(args.length == 0) {
			args = new String[]{"./"};
		}
		// ディレクトリ指定
		final String gsi = "http://sdf.gsi.go.jp/data25k/";
		final String list = "/data/prefecture.csv";
		final String city = "/data/city.dat";
		final String prefecture = "/data/prefecture.dat";
		final String cell = "/data/prefecture.cell";
		new Main(args[0], gsi, list, city, prefecture, cell);
	}
	private final MapPanel panel;
	/**
	 * コンストラクタ
	 * @param dir
	 * @param gsi
	 * @param list
	 */
	public Main(String dir, String gsi, String list, String cityData, String prefData, String cellData) {

		// JFrame
		final JFrame frame = new JFrame("Digital Map");

		// Close Setting
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (UnsupportedLookAndFeelException e) {
			e.printStackTrace();
		}
		

		this.panel = new MapPanel();
		
		final StatusBar statusbar = new StatusBar(" ");

		final Container container = frame.getContentPane();
		container.add(statusbar, BorderLayout.SOUTH);
		container.add(this.panel, BorderLayout.CENTER);

		// Listener
		final Operation listener = new Operation(this.panel);
		
		// Frame に メインメニューバーを設定
		frame.setJMenuBar(listener.getMenuBar());

		frame.setPreferredSize(new Dimension(Main.F_WIDTH, Main.F_HEIGHT));
		frame.pack();
		// Size of Frame Setting
		frame.setVisible(true);
		
		try {
			statusbar.setReading("データ構造");
			final MapFactory factory = new MapFactory(new Warehouse(dir + "data25k/", gsi, this.getClass().getResourceAsStream(list), statusbar));
			statusbar.setReading();
	
			// セルメソッド
			statusbar.setReading("都道府県位置データ");
			final CellSearch cell = new CellSearch(cellData);
			statusbar.setReading();
	
	
			statusbar.setReading("国土数値情報 都道府県データ");
			Polygon[] prefecture = KsjFactory.readPolygon(this.getClass().getResourceAsStream(prefData));
			statusbar.setReading();
			
			MapMap maps = new MapMap(this.panel, cell, factory, statusbar);
			statusbar.setReading("国土数値情報 市町村データ");
			KsjFactory.readMapPolygon(maps, this.getClass().getResourceAsStream(cityData));

			this.panel.init(maps, prefecture);
			maps.start();
		} catch (IOException e) {
			e.printStackTrace();
		}

		statusbar.setReading();

		frame.addKeyListener(listener);
		this.panel.addKeyListener(listener);
		this.panel.addMouseListener(listener);
		this.panel.addMouseMotionListener(listener);
		this.panel.addMouseWheelListener(listener);
		
		statusbar.setThreadPriority(Thread.MIN_PRIORITY);
	}
}
