package util;


import java.io.File;

import javax.swing.JLabel;

import map.route.SearchThread;

public class StatusBar extends JLabel implements Runnable {
	private float size;
	private File file;
	private String dlCode;
	private String rdCode;
	private String ckCode;
	private float memory;
	private final Thread thread;
	private SearchThread search;
	private float y;
	private float x;
	private int height;
	public StatusBar(String msg) {
		super(msg);
		this.x = Integer.MIN_VALUE;
		this.y = Integer.MIN_VALUE;
		this.height = Integer.MIN_VALUE;
		this.thread = new Thread(this);
		this.thread.start();
	}
	public void setThreadPriority(int priority) {
		this.thread.setPriority(priority);
	}
	public synchronized void set(String code, int length, File file) {
		this.dlCode = code;
		this.size = length;
		this.file = file;
	}
	public synchronized void set(SearchThread thread) {
		this.search = thread;
	}
	public synchronized void setLocation(float x, float y, int height) {
		this.x = x;
		this.y = y;
		this.height = height;
	}
	public synchronized void clearLocation() {
		this.x = Integer.MIN_VALUE;
		this.y = Integer.MIN_VALUE;
		this.height = Integer.MIN_VALUE;
	}
	public synchronized void setReading(String code) {
		this.rdCode = code;
	}
	public synchronized void setReading() {
		this.rdCode = null;
	}
	public synchronized void setCheckCode(String code) {
		this.ckCode = code;
	}
	public synchronized void setCheckCode() {
		this.ckCode = null;
	}
	public void run() {
		while(true) {
			this.memory = (float)(int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000) / 1000;
			this.loop();
		}
	}
	private synchronized void loop () {
		if(this.file != null && this.file.length() < this.size) {
			super.setText("MEMORY : "+ this.memory +"MB / DOWNLOAD "+ this.dlCode + " : " + (int)(this.file.length() * 100 / this.size + 0.5f) + "%");
			super.repaint();
		} else {
			this.file = null;
			boolean flag = false;
			StringBuilder sb = new StringBuilder("MEMORY : " + this.memory + "MB");
			if (this.search != null) {
				flag = true;
				sb.append(this.search);
			}
			if (this.rdCode != null) {
				flag = true;
				sb.append(" / READING " + this.rdCode);
			} else if(this.ckCode != null) {
				flag = true;
				sb.append(" / CHECKING " + this.ckCode);
			}
			if (this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE) {
				sb.append(" / 東経 : ");
				sb.append(this.x);
				sb.append("° 北緯 : ");
				sb.append(this.y);
				sb.append("°");
				if (this.height != Integer.MIN_VALUE) {
					sb.append(" 標高 : ");
					sb.append(this.height);
					sb.append("m");
				}
			}
			super.setText(sb.toString());
			super.repaint();
			try {
				if(!flag) {
					Thread.sleep(2000L);
				} else {
					Thread.sleep(250L);
				}
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
