package util;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

import map.MapPanel;
import map.data.Road;


/**
 * マウス操作 クラス
 * @author  Masayasu FUJIWARA
 */
public class Operation implements MouseListener, MouseMotionListener, MouseWheelListener, KeyListener, ActionListener {
	// Graph class
	private final MapPanel panel;
	private int x;
	private int y;
	private int dx;
	private int dy;
	private boolean isEntered;
	private final JMenuBar menu;
	private final JCheckBoxMenuItem help;
	public Operation (final MapPanel panel) {
		
		this.panel = panel;
		this.x = panel.getWidth() / 2;
		this.y = panel.getHeight() / 2;

		// メインメニュー
		this.menu = new JMenuBar();
		
		final JMenu menu1 = new JMenu("探索設定");
		final JMenu menu2 = new JMenu("表示設定");
		final JMenu menu3 = new JMenu("ヘルプ");

		this.menu.add(menu1);
		this.menu.add(menu2);
		this.menu.add(menu3);

		final JCheckBoxMenuItem item1_1 = new JCheckBoxMenuItem("Dijkstra", false);
		item1_1.setActionCommand("path_dijkstra");
		final JCheckBoxMenuItem item1_2 = new JCheckBoxMenuItem("A*", true);
		item1_2.setActionCommand("path_a*");
		
		final JCheckBoxMenuItem item1_3 = new JCheckBoxMenuItem("高速道路", true);
		item1_3.setActionCommand("highway");

		ButtonGroup group = new ButtonGroup();
		group.add(item1_1);
		group.add(item1_2);

		menu1.add(item1_1);
		menu1.add(item1_2);
		menu1.addSeparator();
		menu1.add(item1_3);

		final JCheckBoxMenuItem item2_1 = new JCheckBoxMenuItem("ラベル表示", true);
		item2_1.setActionCommand("label");
		final JCheckBoxMenuItem item2_2 = new JCheckBoxMenuItem("頂点表示", false);
		item2_2.setActionCommand("node");
		final JCheckBoxMenuItem item2_3 = new JCheckBoxMenuItem("アンチエイリアス", true);
		item2_3.setActionCommand("alias");
		final JCheckBoxMenuItem item2_4 = new JCheckBoxMenuItem("水域区間の塗りつぶしβ", false);
		item2_4.setActionCommand("fill");
		
		menu2.add(item2_1);
		menu2.add(item2_2);
		menu2.add(item2_3);
		menu2.add(item2_4);
		

		item1_1.addActionListener(this);
		item1_2.addActionListener(this);
		item1_3.addActionListener(this);

		item2_1.addActionListener(this);
		item2_2.addActionListener(this);
		item2_3.addActionListener(this);
		item2_4.addActionListener(this);

		this.help = new JCheckBoxMenuItem("操作マニュアル", true);
		this.help.setActionCommand("help");
		
		menu3.add(this.help);

		this.help.addActionListener(this);
	}
	public JMenuBar getMenuBar() {
		return this.menu;
	}
	public void mouseClicked(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON3) {
			this.panel.changeBoundary(e.getX(), e.getY(), (e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0);
		}
	}
	public void mouseEntered(MouseEvent e) {
		this.isEntered = true;
	}
	public void mouseExited (MouseEvent e) {
		this.isEntered = false;
		if (!this.panel.isOperation()) {
			this.x = this.panel.getWidth() / 2;
			this.y = this.panel.getHeight() / 2;
		}
	}
	public void mousePressed (MouseEvent e) {
//		if(!this.panel.isOperation()) {
//			this.panel.getLocation(e.getX(), e.getY());
//		}
		this.panel.setOperation(true);
	}
	public void mouseReleased (MouseEvent e) {
//		this.panel.clearLocation();
		if (!this.isEntered && (e.getModifiersEx() & (InputEvent.BUTTON1_DOWN_MASK | InputEvent.BUTTON2_DOWN_MASK | InputEvent.BUTTON3_DOWN_MASK)) == 0) {
			this.x = this.panel.getWidth() / 2;
			this.y = this.panel.getHeight() / 2;
		}
		this.panel.setOperation(false);
	}
	public void mouseDragged (MouseEvent e) {
		// ポインター座標変化量を計算
		this.dx = e.getX() - this.x;
		this.dy = e.getY() - this.y;
		// 変化時のポインター座標
		this.x = e.getX();
		this.y = e.getY();
		// 平行移動
		this.panel.moveLocation(this.dx, this.dy);
		this.panel.setOperation(true);
	}
	public void mouseMoved (MouseEvent e) {
		if(this.isEntered) {
			this.x = e.getX();
			this.y = e.getY();
		}
	}
	public void mouseWheelMoved(MouseWheelEvent e){
		int d = e.getWheelRotation();
		this.panel.zoom(e.getX(), e.getY(), d);
	}
	public void keyTyped(KeyEvent e) {
		switch (e.getKeyChar()) {
		case '?' :
			this.help.doClick();
		}
	}
	public void keyPressed(KeyEvent e) {
		this.panel.setOperation(true);
		switch(e.getKeyCode()) {
		case KeyEvent.VK_RIGHT :
		case KeyEvent.VK_KP_RIGHT :
			this.panel.moveLocation(-this.panel.getWidth() / 8, 0);
			break;
		case KeyEvent.VK_LEFT :
		case KeyEvent.VK_KP_LEFT :
			this.panel.moveLocation(this.panel.getWidth() / 8, 0);
			break;
		case KeyEvent.VK_UP :
		case KeyEvent.VK_KP_UP :
			this.panel.moveLocation(0, this.panel.getHeight() / 8);
			break;
		case KeyEvent.VK_DOWN :
		case KeyEvent.VK_KP_DOWN :
			this.panel.moveLocation(0, -this.panel.getHeight() / 8);
			break;
		case KeyEvent.VK_PLUS :
		case KeyEvent.VK_SEMICOLON :
		case KeyEvent.VK_PAGE_UP :
			this.panel.zoom(this.x, this.y, 1);
			break;
		case KeyEvent.VK_MINUS :
		case KeyEvent.VK_PAGE_DOWN :
		case KeyEvent.VK_EQUALS :
			this.panel.zoom(this.x, this.y, -1);
			break;
		}
	}
	public void keyReleased(KeyEvent e) {
		this.panel.setOperation(false);
		this.panel.repaint();
	}
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().startsWith("path_")) {
			this.panel.switchShortestPathAlgorithm(e.getActionCommand());
		} else if (e.getActionCommand().equals("label")) {
			this.panel.switchLabel();
		} else if (e.getActionCommand().equals("node")) {
			this.panel.switchNodeView();
		} else if (e.getActionCommand().equals("alias")) {
			this.panel.switchRendering();
		} else if (e.getActionCommand().equals("fill")) {
			this.panel.switchFill();
		} else if (e.getActionCommand().equals("highway")) {
			Road.switchHighway();
			this.panel.reroute();
		} else if (e.getActionCommand().equals("help")) {
			this.panel.switchHelp();
		}
	}
}
