package map.labeling;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.List;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import map.data.Facility;

public class SimpleLabeling implements Labeling {
	private final Graphics2D g;
	private final Rectangle screen0;
	private final Rectangle screen;
	private final float scale;
	private final FontMetrics metrics;
	private final int labelAscent;
	private final int labelHeight;
	private final Map<Rectangle, String> lap;
	private final List<Label> label;
	public SimpleLabeling(final Graphics2D g, final Rectangle screen, final int width, final int height, final float scale) {
		this.scale = scale;
		this.g = g;
		this.screen0 = screen;
		this.screen = new Rectangle(0, 0, width, height);
		this.metrics = g.getFontMetrics();
		// ラベルの重なり
		this.lap = new HashMap<Rectangle, String>();
		this.labelAscent = this.metrics.getAscent();
		this.labelHeight = this.metrics.getHeight();
		this.label = new ArrayList<Label>();
	}
	public void draw() {
		this.g.setColor(Color.BLACK);
		for (final Label l : this.label) {
			this.g.drawString(l.getName(), l.getX(), l.getY());
		}
	}
	public void add(Facility[] data) {
		for (final Facility facility : data) {
		
			String name = facility.getName();
	
			// 表示領域内のであれば描画する
			if (this.screen0.contains(facility.getX(), facility.getY())) {
				int x = (int) ((facility.getX() - this.screen0.x) * this.scale);
				int y = this.screen.height - (int) ((facility.getY() - this.screen0.y) * this.scale);
		
				int labelWidth = this.metrics.stringWidth(name);
	
				// 施設の位置を描画する
				boolean flag = false;

				Rectangle label = null;

				for (int i = 0; i < 4; i++) {
					boolean isLap = false;
					label = new Rectangle(x - (i / 2) * (labelWidth + 6) + 3, y - ((i % 2) * this.labelHeight), labelWidth, this.labelHeight);
					for (Map.Entry<Rectangle, String> entry : this.lap.entrySet()) {
						Rectangle rect = entry.getKey();
						if (rect.intersects(label)) {
							isLap = true;
							break;
						}
					}
					// 重なるか，スクリーン内からはみでる場合は再計算
					if (isLap || !this.screen.contains(label))
						continue;
	
					this.lap.put(label, name);
					this.label.add(new Label(name, label.x + 1, label.y + this.labelAscent));
					flag = true;

					break;
				}
				if (flag) {
					this.g.setColor(Color.BLACK);
					this.g.fillOval(x - 2, y - 2, 4, 4);
				} else {
					this.g.setColor(Color.GRAY);
					this.g.drawLine(x - 2, y - 2, x + 2, y + 2);
					this.g.drawLine(x + 2, y - 2, x - 2, y + 2);
				}
			}
		}
	}
}
