package map.cell;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

import map.data.MapData;


public class PrefectureCell extends Rectangle {
	private final int code;
	private Cell[][] cells;
	private int cellMinX;
	private int cellMinY;
	private int size;
	public PrefectureCell(int code, String[] state) {
		super(Integer.parseInt(state[1]), Integer.parseInt(state[2]), Integer.parseInt(state[3]), Integer.parseInt(state[4]));
		this.code = code;
	}
	public void product() throws IOException {
		if(this.cells == null) {
			BufferedReader bi = null;
			try {
				bi = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/data/" + MapData.prefFormat.format(this.code) + "/" + MapData.prefFormat.format(this.code) + ".cell"), "SJIS"));
				String[] state = bi.readLine().split(",");
				this.cellMinX = Integer.parseInt(state[0]);
				this.cellMinY = Integer.parseInt(state[1]);
				this.size = Integer.parseInt(state[2]);
				this.cells = new Cell[Integer.parseInt(state[3])][Integer.parseInt(state[4])];
				for(int i = 0; i < this.cells.length; i++) {
					for(int j = 0; j < this.cells[i].length; j++) {
						String[] codes = bi.readLine().split(",");
						if(codes[0].equals("")) {
							this.cells[i][j] = null;
						}else{
							this.cells[i][j] = new Cell(codes);
						}
					}
				}
			} finally {
				if(bi != null) {
					bi.close();
				}
			}
		}
	}
	public void dump() {
		this.cells = null;
	}
	/**
	 * 地域番号を取得する
	 * @param screen
	 * @return
	 */
	public Set<String> get(Rectangle screen) {
		int minX = screen.x / this.size - this.cellMinX;
		int minY = screen.y / this.size - this.cellMinY;
		int maxX = (screen.x + screen.width)  / this.size - this.cellMinX;
		int maxY = (screen.y + screen.height) / this.size - this.cellMinY;
		
		Set<String> codes = new HashSet<String>();

		for(int i = minX; i < this.cells.length && i <= maxX; i++) {
			for(int j = minY; j < this.cells[i].length && j <= maxY; j++) {
				
				if(this.cells[i][j] == null) continue;
				
				for(String code : this.cells[i][j].getCodes()) {
					codes.add(code);
				}
			}
		}
		return codes;
	}
	/**
	 * 地域検索
	 * @param codes
	 * @param screen
	 */
	public void search(Set<String> codes, Rectangle screen) {
		int minX = screen.x / this.size - this.cellMinX;
		int minY = screen.y / this.size - this.cellMinY;
		int maxX = (screen.x + screen.width)  / this.size - this.cellMinX;
		int maxY = (screen.y + screen.height) / this.size - this.cellMinY;
		
		if(minX < 0) minX = 0;
		if(minY < 0) minY = 0;

		for(int i = minX; i < this.cells.length && i <= maxX; i++) {
			for(int j = minY; j < this.cells[i].length && j <= maxY; j++) {
				
				if(this.cells[i][j] == null) continue;
				
				for(String code : this.cells[i][j].getCodes()) {
					codes.add(code);
				}
			}
		}
	}
}
