package map.cell;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import map.data.MapData;
import map.map25000.MapFactory;
import map.map25000.Warehouse;

public class CellPreprocessing {
	private File cityList = new File("files25k.csv");
	public static void main(String[] args) throws FileNotFoundException, IOException {
		if(args.length == 0) {
			args = new String[]{"北海道", "青森県", "岩手県", "宮城県", "秋田県", "山形県", "福島県", "茨城県", "栃木県", "群馬県", "埼玉県", "千葉県", "東京都", "神奈川県", "新潟県", "富山県", "石川県", "福井県", "山梨県", "長野県", "岐阜県", "静岡県", "愛知県", "三重県", "滋賀県", "京都府", "大阪府", "兵庫県", "奈良県", "和歌山県", "鳥取県", "島根県", "岡山県", "広島県", "山口県", "徳島県", "香川県", "愛媛県", "高知県", "福岡県", "佐賀県", "長崎県", "熊本県", "大分県", "宮崎県", "鹿児島県", "沖縄県"};
		}
		/**
		 * 250000×250000で区切る。
		 */
		// ディレクトリ指定
		final String dir = "/home2/staff2/masayasu/data25k/";
		final String gsi = "http://sdf.gsi.go.jp/";
		final String list = "pref25k.csv";
		new CellPreprocessing(dir, gsi, System.class.getResourceAsStream(list), args);
	}
	public CellPreprocessing(String dir, String gsi, InputStream list, String[] prefs) throws FileNotFoundException, IOException {
		File celldir = new File(dir +"cell");
		if(!celldir.isDirectory()) {
			celldir.mkdirs();
		}
		BufferedWriter prefWriter = new BufferedWriter(new FileWriter(dir +"cell/pref.cell", false));
		for(String pref : prefs) {

			final String[] codes = this.getPrefCode(pref);
			MapFactory factory = new MapFactory(new Warehouse(dir, gsi, list, null));
			MapData[] maps = new MapData[codes.length];
			// 外接長方形
			int n = Integer.MIN_VALUE;
			int s = Integer.MAX_VALUE;
			int w = Integer.MAX_VALUE;
			int e = Integer.MIN_VALUE;
			for(int i = 0; i < codes.length; i++) {
				maps[i] = factory.preproduct(Integer.parseInt(codes[i]));
				Rectangle area = maps[i].getArea();
				// 西
				if(area.x < w) {
					w = area.x;
				}
				// 東
				if(area.x + area.width > e) {
					e = area.x + area.width;
				}
				// 南
				if(area.y < s) {
					s = area.y;
				}
				// 北
				if(area.y + area.height > n) {
					n = area.y + area.height;
				}
			}
			String codePref = codes[0].substring(0, 2);
			System.out.println(pref +" : "+ codePref);
			System.out.printf("%s,%d,%d,%d,%d\n", codePref, e, w, s, n);
			System.out.printf("%s,%d,%d,%d,%d\n", codePref, w, s, e - w, n - s);
			
			prefWriter.write(codePref +","+ w + ","+ s + "," + (e - w) +","+ (n-s));
			prefWriter.newLine();
			
			System.out.println(codePref +","+ w + ","+ s + "," + (e - w) +","+ (n-s));
			
			int cellSize = 250000;
			int cellMinX = w - w % cellSize;
			int cellMinY = s - s % cellSize;
			int cellMaxX = e - e % cellSize + cellSize;
			int cellMaxY = n - n % cellSize + cellSize;
			
			BufferedWriter bo = new BufferedWriter(new FileWriter(dir +"cell/"+ codePref +".cell", false));
			
			bo.write((cellMinX / cellSize) + "," + (cellMinY / cellSize) + "," + cellSize + "," + (cellMaxX / cellSize - cellMinX / cellSize) + "," + (cellMaxY / cellSize - cellMinY / cellSize));
			bo.newLine();
			
			for(int cellX = cellMinX; cellX < cellMaxX; cellX += cellSize) {
				for(int cellY = cellMinY; cellY < cellMaxY; cellY += cellSize) {
	
					List<MapData> tmp = new ArrayList<MapData>();
					for(MapData map : maps) {
						if(new Rectangle(cellX, cellY, cellSize, cellSize).intersects(map.getArea())) {
							tmp.add(map);
						}
					}
					boolean flag = true;
					for(MapData map : tmp) {
						if(flag) {
							flag = false;
							bo.write(map.getCode());
							continue;
						}
						bo.write("," + map.getCode());
					}
					bo.newLine();
				}
			}
			bo.close();
		}
		prefWriter.close();
	}
	/**
	 * 都道府県番号の取得
	 * @param pref
	 * @return
	 */
	public String[] getPrefCode(String pref) {
		final List<String> code = new ArrayList<String>();
		try {
			BufferedReader bi = new BufferedReader(new InputStreamReader(new FileInputStream(this.cityList), "SJIS"));
			Pattern splitCSV = Pattern.compile(",");
			while (bi.ready()) {
				String[] data = splitCSV.split(bi.readLine());
				if (data[0].contains(pref)) {
					code.add(data[2]);
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return code.toArray(new String[]{});
	}
}
