unit options;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, IniFiles, Dialogs;

type
  TOptions = class
  public
    ShowDotFiles  : Boolean;
    ShowBackups   : Boolean;
    DebugLevel    : Integer;
    AutoSave      : Boolean;
    DirsInList    : Boolean;

    ShowDebug   : Boolean;
    ShowStatus  : Boolean;
    ShowToolbar : Boolean;

    ViewStyle : TViewStyle;

    Prefix : String;

{    WriteSupport  : Boolean; }
    FloppyScan    : Boolean;

    NonStandard : Integer;

    UseEI13    : Boolean;
    UseNative  : Boolean;

    UMask      : String;

    PasswdFile : String;
    GroupFile  : String;

    DefaultImage : String;

    ViewerProg : String;
{    ViewText   : Boolean; }

    SortColumn : Integer;
    SortDir    : Boolean;

    ColumnWidths : TList;


    constructor Create;
    destructor Destroy; override;
    function Execute : Boolean;

    procedure ReadOptions;
    procedure SaveOptions;

    function GetUMask : Integer;
  end;

  TOptionsDlg = class(TForm)
    OKBtn: TButton;
    CancelButton: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DebugLevel: TRadioGroup;
    DebugWindow: TCheckBox;
    GroupBox1: TGroupBox;
    DotFiles: TCheckBox;
    Backups: TCheckBox;
    GroupBox2: TGroupBox;
    ToolbarCheckBox: TCheckBox;
    StatusCheckBox: TCheckBox;
    TabSheet3: TTabSheet;
    Label1: TLabel;
    PrefixEdit: TEdit;
    NonStandardCheckBox: TCheckBox;
    NonStandardEdit: TEdit;
    Label2: TLabel;
{    FloppyCheckBox: TCheckBox; }
    Bevel1: TBevel;
    Label3: TLabel;
    UMaskEdit: TEdit;
    TabSheet4: TTabSheet;
    Label4: TLabel;
    PasswdEdit: TEdit;
    Label5: TLabel;
    GroupEdit: TEdit;
    PasswdButton: TButton;
    GroupButton: TButton;
    OpenDialog1: TOpenDialog;
    Label6: TLabel;
    ViewerEdit: TEdit;
    ViewerButton: TButton;
    AutoSaveCheckBox: TCheckBox;
    UseEI13CheckBox: TCheckBox;
    ListDirs: TCheckBox;
    UseNative: TCheckBox;
    DefaultImage: TLabel;
    DImageEdit: TEdit;
    DImageBtn: TButton;
{    ViewTextCheckBox: TCheckBox; }
{    procedure RWCheckBoxClick(Sender: TObject); }
    procedure NonStandardCheckBoxClick(Sender: TObject);
    procedure PasswdButtonClick(Sender: TObject);
    procedure GroupButtonClick(Sender: TObject);
    procedure ViewerButtonClick(Sender: TObject);
    procedure DImageButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure UseNativeClick(Sender: TObject);
    procedure UseEI13CheckBoxClick(Sender: TObject);
{    procedure FloppyCheckBoxClick(Sender: TObject); }
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    CurrentOptions : TOptions;
  public
    { Public declarations }
    RequireRescan : Boolean;
  end;

var
  OptionsDlg: TOptionsDlg;

implementation

uses ex2explore;

{$R *.DFM}

/////////////////////////////
// TOptions
/////////////////////////////

constructor TOptions.Create;
begin
   ColumnWidths := Tlist.Create;
   ReadOptions;
end;

destructor TOptions.Destroy;
begin
   SaveOptions;
   ColumnWidths.Free;
end;

function TOptions.Execute : Boolean;
var
   Dlg : TOptionsDlg;
begin
   //
   Dlg := TOptionsDlg.Create(Application.MainForm);
   try
      Dlg.CurrentOptions := self;

      Dlg.DotFiles.Checked := ShowDotFiles;
      Dlg.Backups.Checked  := ShowBackups;
      Dlg.ListDirs.Checked := DirsInList;

      Dlg.DebugLevel.ItemIndex     := DebugLevel;
      Dlg.DebugWindow.Checked      := ShowDebug;
      Dlg.AutoSaveCheckBox.Checked := AutoSave;

      Dlg.ToolbarCheckBox.Checked := ShowToolbar;
      Dlg.StatusCheckBox.Checked  := ShowStatus;

      Dlg.PrefixEdit.Text := Prefix;

{      Dlg.RWCheckBox.Checked := WriteSupport; }

{      Dlg.FloppyCheckBox.Checked := FloppyScan; }

      if NonStandard > 0 then
      begin
         Dlg.NonStandardCheckBox.Checked := True;
         Dlg.NonStandardEdit.Text := IntToHex(NonStandard, 2);
         Dlg.NonStandardEdit.Enabled := True;
      end
      else
      begin
         Dlg.NonStandardCheckBox.Checked := False;
         Dlg.NonStandardEdit.Enabled := False;
      end;

      Dlg.UseEI13CheckBox.Checked := UseEI13;
      Dlg.UseNative.Checked := UseNative;

      Dlg.UMaskEdit.Text := UMask;

      Dlg.PasswdEdit.Text  := PasswdFile;
      Dlg.GroupEdit.Text   := GroupFile;
      Dlg.ViewerEdit.Text  := ViewerProg;
      Dlg.DImageEdit.Text  := DefaultImage;
{      Dlg.ViewTextCheckBox.Checked := ViewText;  }

      if Dlg.ShowModal = mrOK then
      begin
         ShowDotFiles   := Dlg.DotFiles.Checked;
         ShowBackups    := Dlg.Backups.Checked;
         DirsInList     := Dlg.ListDirs.Checked;

         DebugLevel     := Dlg.DebugLevel.ItemIndex;
         ShowDebug      := Dlg.DebugWindow.Checked;
         AutoSave       := Dlg.AutoSaveCheckBox.Checked;

         ShowToolbar := Dlg.ToolbarCheckBox.Checked;
         ShowStatus  := Dlg.StatusCheckBox.Checked;

         Prefix := Dlg.PrefixEdit.Text;

{         WriteSupport := False; //Dlg.RWCheckBox.Checked;}
{         FloppyScan   := Dlg.FloppyCheckBox.Checked; }

         if Dlg.NonStandardCheckBox.Checked then
         begin
            NonStandard := StrToInt('$' + Dlg.NonStandardEdit.Text);
         end
         else
         begin
            NonStandard := 0;
         end;

         UseEI13 := Dlg.UseEI13CheckBox.Checked;
         UseNative := Dlg.UseNative.Checked;

         UMask := Dlg.UMaskEdit.Text;

         PasswdFile  := Dlg.PasswdEdit.Text;
         GroupFile   := Dlg.GroupEdit.Text;
         DefaultImage := Dlg.DImageEdit.Text;
         ViewerProg  := Dlg.ViewerEdit.Text;
{         ViewText    := Dlg.ViewTextCheckBox.Checked; }

         Result := True;
      end
      else
      begin
         Result := False;
      end;
   finally
      Dlg.Free;
   end;
end;

procedure TOptions.ReadOptions;
var
   Ini: TIniFile;
   i     : Integer;
   Width : Integer;
begin
   // Be a real prick and use the registry
   Ini := TIniFile.Create(ChangeFileExt(Application.ExeName,'.INI' ));
   try
      ShowDotFiles   := Ini.ReadBool( 'metamosetup','ShowDotFiles', True);
      ShowBackups    := Ini.ReadBool( 'metamosetup','ShowBackups',  True);
      DirsInList     := Ini.ReadBool( 'metamosetup','ListDirectories',  False);

      DebugLevel  := Ini.ReadInteger( 'metamosetup','DebugLevel', DebugOff);
      AutoSave    := Ini.ReadBool( 'metamosetup','AutoSaveDebug', True);

      ShowDebug    := Ini.ReadBool( 'metamosetup','ShowDebug',   False);
      ShowStatus   := Ini.ReadBool( 'metamosetup','ShowStatus',  True);
      ShowToolbar  := Ini.ReadBool( 'metamosetup','ShowToolbar', True);

      ViewStyle := TViewStyle(Ini.ReadInteger( 'metamosetup','ViewStyle', Integer(vsIcon)));

      Prefix := Ini.ReadString( 'metamosetup','Prefix', 'hd');

{      WriteSupport   := Ini.ReadBool( 'metamosetup','DangerWriteSupport', False); }
{      FloppyScan     := Ini.ReadBool( 'metamosetup','Floppy', False);  }

      NonStandard := Ini.ReadInteger( 'metamosetup','NonStandard', 0);
      UseEI13     := Ini.ReadBool( 'metamosetup','ExtendedInt13', True);
      UseNative   := Ini.ReadBool( 'metamosetup','NativeIO', True);

      UMask := Ini.ReadString( 'metamosetup','umask', '022');

      PasswdFile := Ini.ReadString( 'metamosetup','PasswdFile', 'etc/passwd');
      GroupFile  := Ini.ReadString( 'metamosetup','GroupFile',  'etc/group');

      DefaultImage := Ini.ReadString( 'metamosetup','DImage', 'Debian.ext3.2gb');

      ViewerProg := Ini.ReadString( 'metamosetup','Viewer',  'sakura');
{      ViewText   := Ini.ReadBool( 'metamosetup','ViewText',  false);  }

      SortColumn := Ini.ReadInteger( 'metamosetup','SortColumn', 0);
      SortDir    := Ini.ReadBool( 'metamosetup','SortDir',  false);

      // read the column header widths
      i := 0;
      while True do
      begin
         Width := Ini.ReadInteger( 'metamosetup','Column' + IntToStr(i), -1);
         if Width <> -1 then
         begin
            ColumnWidths.Add(Pointer(Width));
            i := i + 1;
         end
         else break;
      end;

   finally
      Ini.Free;
   end;
end;

procedure TOptions.SaveOptions;
var
   Ini:TIniFile;
   i   : Integer;
begin
   // Be a real prick and use the registry
   Ini :=TIniFile.Create(ChangeFileExt(Application.ExeName,'.INI' ));
   try
      Ini.WriteBool( 'metamosetup','ShowDotFiles', ShowDotFiles);
      Ini.WriteBool( 'metamosetup','ShowBackups',  ShowBackups);
      Ini.WriteBool( 'metamosetup','ListDirectories', DirsInList);

      Ini.WriteInteger( 'metamosetup','DebugLevel', DebugLevel);
      Ini.WriteBool( 'metamosetup','AutoSaveDebug', AutoSave);

      Ini.WriteBool( 'metamosetup','ShowDebug',   ShowDebug);
      Ini.WriteBool( 'metamosetup','ShowStatus',  ShowStatus);
      Ini.WriteBool( 'metamosetup','ShowToolbar', ShowToolbar);

      Ini.WriteInteger( 'metamosetup','ViewStyle', Integer(ViewStyle));

      Ini.WriteString( 'metamosetup','Prefix', Prefix);

{      Ini.WriteBool( 'metamosetup','WriteSupport', WriteSupport); }
{      Ini.WriteBool( 'metamosetup','Floppy', FloppyScan);  }

      Ini.WriteInteger( 'metamosetup','NonStandard', NonStandard);
      Ini.WriteBool( 'metamosetup','ExtendedInt13', UseEI13);
      Ini.WriteBool( 'metamosetup','NativeIO', UseNative);

      Ini.WriteString( 'metamosetup','umask', UMask);

      Ini.WriteString( 'metamosetup','PasswdFile', PasswdFile);
      Ini.WriteString( 'metamosetup','GroupFile',  GroupFile);

      Ini.WriteString( 'metamosetup','DImage', DefaultImage);

      Ini.WriteString( 'metamosetup','Viewer', ViewerProg);
{      Ini.WriteBool( 'metamosetup','ViewText', ViewText);  }

      Ini.WriteInteger( 'metamosetup','SortColumn', SortColumn);
      Ini.WriteBool( 'metamosetup','SortDir', SortDir);

      for i := 0 to ColumnWidths.Count - 1 do
      begin
         Ini.WriteInteger( 'metamosetup','Column' + IntToStr(i), Integer(ColumnWidths[i]));
      end;
   finally
      Ini.Free;
   end;
end;

function TOptions.GetUMask : Integer;
var
   i     : Integer;
   Mask  : Integer;
begin
   // convert the UMask octal string into a decimal
//   UMask := '0' + UMask;
   Mask := 0;
   for i := 1 to Length(UMask) do
   begin
      if UMask[i] in ['0'..'7'] then
      begin
         Mask := (Mask * 8) + (Ord(UMask[i]) - Ord('0'));
      end
      else
      begin
         break;
      end;
   end;

   // now we have the mask
   // but we realy want to return the permissions to give the file
   Result := ($1B6 and (not mask)) and $1FF;
end;

{ procedure TOptionsDlg.RWCheckBoxClick(Sender: TObject);
begin
   if RWCheckBox.Focused and RWCheckBox.Checked then
   begin
      MessageDlg('WARNING'#10'Write support is experimental, use at your own risk!', mtInformation, [mbOK], 0);
      if MessageDlg('WARNING'#10'Are you sure you have done a backup of your system?', mtInformation, [mbYes, mbNo], 0) = mrNo then
      begin
         RWCheckBox.Checked := False;
      end;
   end;
   RequireRescan := True;
end;
}

procedure TOptionsDlg.NonStandardCheckBoxClick(Sender: TObject);
begin
   NonStandardEdit.Enabled := NonStandardCheckBox.Checked;
   RequireRescan := True;
end;

procedure TOptionsDlg.PasswdButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 2; // I hope
   OpenDialog1.FileName := PasswdEdit.Text;
   if OpenDialog1.Execute then
   begin
      PasswdEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.GroupButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 3;
   OpenDialog1.FileName := GroupEdit.Text;
   if OpenDialog1.Execute then
   begin
      GroupEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.ViewerButtonClick(Sender: TObject);
begin
   OpenDialog1.FilterIndex := 4;
   OpenDialog1.FileName := ViewerEdit.Text;
   if OpenDialog1.Execute then
   begin
      ViewerEdit.Text := OpenDialog1.FileName;
   end;
end;

procedure TOptionsDlg.DImageButtonClick(Sender: TObject);
begin
   if MainForm.Ex2OpenDialog.Execute then
   begin
      DImageEdit.Text := MainForm.Ex2OpenDialog.FileName;
   end;
end;

procedure TOptionsDlg.FormCreate(Sender: TObject);
begin
   if not MainForm.OSis95 then
   begin
      UseEI13CheckBox.Visible := False;
   end
   else
   begin
      UseNative.Visible := False;
   end;
end;

procedure TOptionsDlg.OKBtnClick(Sender: TObject);
begin
   if RequireRescan then
   begin
      MessageDlg('You have changed the way in which Explore2fs reads the disks attached to'#10 +
                 'your system.  These changes will not take effect until you restart this'#10 +
                 'program or select ''Rescan Partitions'' from the file menu', mtInformation, [mbOK], 0);
   end;
end;

procedure TOptionsDlg.UseNativeClick(Sender: TObject);
begin
   RequireRescan := True;
end;

procedure TOptionsDlg.UseEI13CheckBoxClick(Sender: TObject);
begin
   RequireRescan := True;
end;

{
procedure TOptionsDlg.FloppyCheckBoxClick(Sender: TObject);
begin
   RequireRescan := True;
end;
}

procedure TOptionsDlg.FormShow(Sender: TObject);
begin
   RequireRescan := False;
end;

end.
