﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using NetMonitor.Network;
using NetMonitor.AmfFormat;
using System.IO;
using NetMonitor.LoW;
using NetMonitor.View;
using NetMonitor.LoW.StaticData;
using NetMonitor.LoW.BattleData;
using NetMonitor.Setting;



namespace NetMonitor
{
	public partial class MainWindow : Form
	{
		public MainWindow()
		{
			InitializeComponent();
			//capture.Open();
			buttonGo.Enabled = false;
			timer.Enabled = true;
			try
			{
				Config.Load();
			}
			catch
			{
				NMConsole.Quit("configの読み込みに失敗", "configエラー");
				return;
			}
			capture = new PacketCapture();
			capture.SetIP(Config.Instance.ServerIP, Config.Instance.LocalIP);
			Thread thread = new Thread(new ThreadStart(DeviceOpen));
			thread.Start();
			if (!LoWDataStatic.LoadCsvFiles())
			{
				NMConsole.Quit("csvの読み込みに失敗", "csvエラー");
			}
			this.FormClosed += new FormClosedEventHandler(MainWindow_FormClosed);
			////debug用
			//this.AllowDrop = true;
			//this.DragEnter += new DragEventHandler(form_DragEnter);
			//this.DragDrop += new DragEventHandler(form_DragDrop);
#if DEBUG
#else
			this.tabControl.Controls.Remove(tabPageSet);
#endif
			maxSize = this.Size;
			minSize = maxSize;
			minSize.Height = minSize.Height - tabControl.Height - 6;
			MainData.Start();
		}
		private Size maxSize;
		private Size minSize;

		PacketCapture capture;

		void MainWindow_FormClosed(object sender, FormClosedEventArgs e)
		{
			if(capture != null)
				capture.Dispose();
		}

		/// <summary>
		/// タイマー。実質メインループ
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void timer_Tick(object sender, EventArgs e)
		{
			if (NMConsole.Error)
			{
				timer.Enabled = false;
				if (deviceOpend && capture.captureRunning)
				{
					capture.Stop();
				}
				if (this.Created)
				{
					MessageBox.Show(NMConsole.ErrorMes, NMConsole.ErrorCaption);
					this.Close();
					NMConsole.Error = false;
				}
				return;
			}
			if (NMConsole.TextCount > 0 && this.Created)
			{
				string mes = NMConsole.TextDequeue();
				textBoxConsole.Text += mes + System.Environment.NewLine;
			}

			if (NMConsole.NeedFocus)
			{
				NMConsole.NeedFocus = false;
				textBoxWindow.Text = NMConsole.TextBoxText;
				for (int i = 0; i < NMConsole.TabTextList.Length; i++)
				{
					switch (i)
					{
						case 0:
							textBoxMain.Text = NMConsole.TabTextList[i];
							break;
						case 1:
							textBoxLBoss.Text = NMConsole.TabTextList[i];
							break;
						case 2:
							textBoxTower.Text = NMConsole.TabTextList[i];
							break;
						case 3:
							textBoxBattle.Text = NMConsole.TabTextList[i];
							break;
						case 4:
							textBoxLog.Text = NMConsole.TabTextList[i];
							break;
					}
				}
				if (NMConsole.FocusTab >= 0)
					tabControl.SelectedIndex = NMConsole.FocusTab;
				NMConsole.FocusTab = -1;

			}
			if (!deviceOpend)
				return;
			if (capture.captureRunning)
			{
				buttonStop.Enabled = true;
				buttonGo.Enabled = false;
			}
			else
			{
				buttonStop.Enabled = false;
				buttonGo.Enabled = true;
			}
			if (NMConsole.DataCount > 0 && this.Created)
			{
				MainData.ReceiveData(NMConsole.DataDequeue());
			}
		}
		volatile bool deviceOpend = false;
		private void DeviceOpen()
		{
			try
			{
				capture.Open();
				deviceOpend = true;
				StringBuilder sb = new StringBuilder();
				sb.Append("キャプチャ開始:");
				if(capture.localIP != null)
					sb.Append("local = " + capture.localIP.ToString() + " / ");
				if(capture.targetServer != null)
					sb.Append("target = " + capture.targetServer.ToString());
				NMConsole.TextEnqueue(sb.ToString(), TextType.Network);
				capture.Start();
			}
			catch (DllNotFoundException)
			{
				NMConsole.Quit("動作に必要なdllが見つかりませんでした\nWinpcapが正しくインストールされていることを確認してください", "DllNotFoundException");
				return;
			}
			catch (Exception e)
			{
				NMConsole.Quit("キャプチャデバイスのオープンに失敗しました", e.GetType().ToString());
				return;
			}
			//別スレッドから直接コントロールを弄ってはいけないらしい
			//タイマーにやらせる
			//buttonGo.Enabled = true;
		}
		private void checkBoxMinMode_CheckedChanged(object sender, EventArgs e)
		{
			this.SuspendLayout();
			if (checkBoxMinMode.Checked)
			{
				this.MinimumSize = minSize;
				this.Size = minSize;
				this.MaximumSize = minSize;
				tabControl.Visible = false;
			}
			else
			{
				this.MaximumSize = maxSize;
				this.Size = maxSize;
				this.MinimumSize = maxSize;
				tabControl.Visible = true;
			}
			this.ResumeLayout();
		}

		private void checkBoxTopMost_CheckedChanged(object sender, EventArgs e)
		{
			this.TopMost = checkBoxTopMost.Checked;
		}
		#region debug
		private void buttonGo_Click(object sender, EventArgs e)
		{
			//if (!threadStop)
			//	return;
			//threadStop = false;
			buttonStop.Enabled = true;
			buttonGo.Enabled = false;
			capture.Start();
			//timer.Enabled = true;
			//Thread threadA = new Thread(new ThreadStart(ThreadMethod));
			//threadA.Start();
		}

		private void buttonStop_Click(object sender, EventArgs e)
		{
			//threadStop = true;
			//timer.Enabled = false;
			buttonStop.Enabled = false;
			buttonGo.Enabled = true;

			capture.Stop();

		}
		private void form_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop))
			{

				// ドラッグ中のファイルやディレクトリの取得
				string[] drags = (string[])e.Data.GetData(DataFormats.FileDrop);

				foreach (string d in drags)
				{
					if (!System.IO.File.Exists(d))
					{
						// ファイル以外であればイベント・ハンドラを抜ける
						return;
					}
				}
				e.Effect = DragDropEffects.Copy;
			}
		}
		private void form_DragDrop(object sender, DragEventArgs e)
		{
			// ドラッグ＆ドロップされたファイル
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
			foreach (string file in files)
				if (file.EndsWith(".amf", StringComparison.OrdinalIgnoreCase))
				{
					byte[] buf = File.ReadAllBytes(file);
					MainData.ReceiveData(buf, DateTime.Now);
					//Amf0Archive amf = Amf0Reader.ReadAmf0(buf);
					//StreamWriter writer = new StreamWriter(new FileStream(Path.GetDirectoryName(file) + "\\" + Path.GetFileNameWithoutExtension(file) + ".txt", FileMode.Create), Encoding.GetEncoding("SHIFT-JIS"));
					//writer.WriteLine(file);
					//amf.Messages[0].Data.Write(writer, 0, 999);
					//writer.Close();
				}

		}

		private void buttonTest_Click(object sender, EventArgs e)
		{
			///amf→txt
			{
				StreamWriter writer = new StreamWriter(new FileStream(Program.ExeDir + "amf\\test3.txt", FileMode.Create), Encoding.GetEncoding("SHIFT-JIS"));
				List<Amf0Archive> arc = new List<Amf0Archive>();// + "amf\\"
				string[] files = Directory.GetFiles(Program.ExeDir, "*.amf");
				//string[] files = Directory.GetFiles(Program.ExeDir, "201309290255400895.amf");
				foreach (string file in files)
				{
					FileStream fs = new FileStream
						(file, FileMode.Open);
					Amf0Archive amf = Amf0Reader.ReadAmf0(fs);
					fs.Close();
					arc.Add(amf);
					writer.WriteLine(file);
					amf.Messages[0].Data.Write(writer, 0, 999);
				}
				writer.Close();
				//StreamWriter writer = new StreamWriter(new FileStream(Program.ExeDir + "amf\\test2.txt", FileMode.Create), Encoding.GetEncoding("SHIFT-JIS"));
			}
			//amf解析
			{
				//List<MessageData> arc = new List<MessageData>();
				//List<BattleResult> res = new List<BattleResult>();
				//string[] files = Directory.GetFiles(Program.ExeDir + "amf\\", "*_対戦開始.amf");
				////string[] files = Directory.GetFiles(Program.ExeDir, "201309290255400895.amf");
				//foreach (string file in files)
				//{
				//    FileStream fs = new FileStream
				//        (file, FileMode.Open);
				//    Amf0Archive amf = Amf0Reader.ReadAmf0(fs);
				//    fs.Close();
				//    MessageData mes = MessageData.FromAmf0Archive(amf);
				//    res.Add(BattleResult.FromAmfObject(mes.Data));
				//    //arc.Add(MessageData.FromAmf0Archive(amf));
				//    //writer.WriteLine(file);
				//    //amf.Messages[0].Data.Write(writer, 0, 1);
				//}
				////writer.Close();
			}
		}
		private void checkBoxFileGz_CheckedChanged(object sender, EventArgs e)
		{
			Program.FlagOutputAmf = checkBoxFileAmf.Checked;
			Program.FlagOutputGz = checkBoxFileGz.Checked;
			Program.FlagOutputTxt = checkBoxFileTxt.Checked;
		}
		#endregion


	}
}
