﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.Network;

namespace NetMonitor.View
{
	enum TextType
	{
		None = 0,
		Warnning,
		Caption,
		Error,
		FileLoad,
		Network,
	}

	static class NMConsole
	{
		static NMConsole()
		{
			for (int i = 0; i < TabTextList.Length; i++)
				TabTextList[i] = "";
		}

		public static volatile bool Error;
		public static volatile string ErrorMes;
		public static volatile string ErrorCaption;
		public static void Quit(string mes, string caption)
		{
			ErrorMes = mes;
			ErrorCaption = caption;
			Error = true;
		}

		static volatile Queue<string> lines = new Queue<string>();
		public static int TextCount { get { return lines.Count; } }
		public static string TextDequeue()
		{
			return lines.Dequeue();
		}

		public static void TextEnqueue(string str, TextType type)
		{
			Enqueue(str, type, DateTime.Now);
		}
		public static void Enqueue(string str, TextType type, DateTime time)
		{
			StringBuilder sb = new StringBuilder();
			sb.Append(time.ToString("yyyyMMddHHmmss"));
			sb.Append(":");
			switch (type)
			{
				case TextType.Warnning:
					sb.Append("Warning :"); break;
				case TextType.Caption:
					sb.Append("Caption :"); break;
				case TextType.Error:
					sb.Append("Error   :"); break;
				case TextType.Network:
					sb.Append("Network :"); break;
				case TextType.FileLoad:
					sb.Append("FileLoad:"); break;
				default:
					sb.Append("????????:"); break;
			}
			sb.Append(str);
			lines.Enqueue(sb.ToString());
		}

		static volatile Queue<Datagram> datas = new Queue<Datagram>();
		public static int DataCount { get { return datas.Count; } }
		internal static void DataEnqueue(Datagram data)
		{
			datas.Enqueue(data);
		}
		public static Datagram DataDequeue()
		{
			return datas.Dequeue();
		}



		public static volatile int FocusTab;
		public static volatile bool NeedFocus;
		public static volatile string[] TabTextList = new string[5];
		public static volatile string TextBoxText = "";
	}
}
