﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.View;

namespace NetMonitor.Network
{
	class DatagramList
	{
		public List<Datagram> PartialDatagrams = new List<Datagram>();
		//public List<Datagram> BrokenDatagrams = new List<Datagram>();
		//public List<Datagram> Datagrams = new List<Datagram>();
		public void AddSegment(TCPSegment seg)
		{
			Datagram data = null;
			for(int i = 0;i<PartialDatagrams.Count;i++)
			{
				if(PartialDatagrams[i].AcknowledgmentNumber == seg.AcknowledgmentNumber)
				{
					data = PartialDatagrams[i];
					data.AddSegment(seg);
					data.CheckComplete();
					return;
				}
			}
			if (data == null)
			{
				data = new Datagram();
				data.AcknowledgmentNumber = seg.AcknowledgmentNumber;
				if (data.AddSegment(seg))
				{
					data.CheckComplete();
					PartialDatagrams.Add(data);
				}
			}
			return;
		}

		public void SeekComplete()
		{
			Datagram data = null;
			for (int i = 0; i < PartialDatagrams.Count; i++)
			{
				data = PartialDatagrams[i];
				data.CheckComplete();
				if(data.IsCompleted)
				{
					PartialDatagrams.Remove(data);
					NMConsole.DataEnqueue(data);
					i--;
					continue;
				}
				if (data.Time < DateTime.Now - TimeSpan.FromMinutes(10))
				{
					data.IsBroken = true;
				}
				if (data.IsBroken)
				{
#if DEBUG
					NMConsole.TextEnqueue("不完全なパケットを廃棄しました:AckNum = " + data.AcknowledgmentNumber.ToString(), TextType.Warnning);
#endif
					PartialDatagrams.Remove(data);
					//BrokenDatagrams.Add(data);
					i--;
				}
			}
		}
	}
}
