﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.IO.Compression;
using NetMonitor.View;
using System.Text.RegularExpressions;

namespace NetMonitor.Network
{
	enum DatagramType
	{
		None,
		X_AMF,
		TEXT
	}

	class Datagram
	{
		public UInt32 AcknowledgmentNumber { get; set; }
		public DateTime Time = DateTime.Now;
		public List<TCPSegment> segments = new List<TCPSegment>();
		public byte[] Payload;
		public bool FlagFIN;
		HttpHeader httph;
		public DatagramType type = DatagramType.None;

		public bool IsCompleted;
		public bool IsBroken;
		public bool AddSegment(TCPSegment seg)
		{
			if (IsCompleted || IsBroken)
				return false;
			if (AcknowledgmentNumber != seg.AcknowledgmentNumber)
				return false;
			if (seg.FlagFIN)
				this.FlagFIN = true;
			if (seg.Payload == null || seg.Payload.Length == 0)
				return false;
			segments.Add(seg);
			return true;

		}
		public bool CheckComplete()
		{
			if (IsCompleted || IsBroken)
				return false;
			if (segments.Count == 0)
				return false;
			//if (segments[segments.Count - 1].RecievedTime > DateTime.Now - TimeSpan.FromSeconds(1))
			//    return false;
			if (!FlagFIN)
				return false;
			bool hasHttp = false;
			int length = 0;
			foreach (TCPSegment seg in segments)
			{
				if (seg.HasHttpHeader)
				{
					httph = seg.HttpHeader;
					hasHttp = true;
				}
				if (seg.Payload != null)
				{
					length += seg.Payload.Length;
				}
			}
			if (!hasHttp || httph.ContentLength > length)
			{
				//if (segments[segments.Count - 1].RecievedTime < DateTime.Now - TimeSpan.FromSeconds(10))
				//	this.IsBroken = true;
				return false;
			}
			segments.Sort();
			MemoryStream st = new MemoryStream();
			for (int i = 0; i < segments.Count; i++)
			{
				if (segments[i].Payload != null)
				{
					st.Write(segments[i].Payload, 0, segments[i].Payload.Length);
				}
			}
			if (Program.FlagOutputGz)
			{
				string extName = ".packet";
				if (httph.ContentEncoding.Equals("gzip", StringComparison.OrdinalIgnoreCase))
					extName = ".gz";
				Program.OutputDebugFile(st.ToArray(), extName, Time);
			}

			byte[] buf = new byte[0x4000];
			int count = 0;
			try
			{
				if (httph.ContentEncoding.Equals("gzip", StringComparison.OrdinalIgnoreCase))
				{
					st.Seek(0, SeekOrigin.Begin);
					GZipStream gzip = new GZipStream(st, CompressionMode.Decompress, false);
					st = new MemoryStream();
					while (true)
					{
						count = gzip.Read(buf, 0, buf.Length);
						if (count == 0)
							break;
						st.Write(buf, 0, count);
					}
					gzip.Dispose();
				}
				else if (httph.ContentEncoding.Equals("deflate", StringComparison.OrdinalIgnoreCase))
				{
					st.Seek(0, SeekOrigin.Begin);
					DeflateStream deflate = new DeflateStream(st, CompressionMode.Decompress, false);
					st = new MemoryStream();
					while (true)
					{
						count = deflate.Read(buf, 0, buf.Length);
						if (count == 0)
							break;
						st.Write(buf, 0, count);
					}
					deflate.Dispose();
				}
				else if (httph.ContentEncoding.Equals("sdch", StringComparison.OrdinalIgnoreCase))
				{
					IsBroken = true;
					return false;
				}
				Payload = st.ToArray();
			}
			catch (Exception)
			{
				NMConsole.TextEnqueue("受信したデータの解凍に失敗しました", TextType.Warnning);
				IsBroken = true;
				return false;
			}
			finally
			{
				st.Dispose();
			}

			IsCompleted = true;
			type = DatagramType.None;
			if (httph.ContentType.StartsWith("application/json", StringComparison.OrdinalIgnoreCase))
			{
				Payload = UnicodeUnescape(Payload);
				type = DatagramType.TEXT;
			}
			else if (httph.ContentType.StartsWith("application/x-amf", StringComparison.OrdinalIgnoreCase))
				type = DatagramType.X_AMF;
			segments.Clear();
			if (Program.FlagOutputAmf)
			{
				string extName = ".dat";
				if (httph.ContentType.StartsWith("application/json", StringComparison.OrdinalIgnoreCase))
				{
					Payload = UnicodeUnescape(Payload);
					extName = ".txt";
				}
				else if (httph.ContentType.StartsWith("application/x-amf", StringComparison.OrdinalIgnoreCase))
					extName = ".amf";
				Program.OutputDebugFile(Payload,extName, Time);
			}


			return true;
		}

		static string Replace(Match m) {
			int code = Convert.ToInt32(m.Groups["code"].Value, 16);
			// char 型は UTF-16 で同等の数値型と可換。
			return ((char)code).ToString();
		}

		public byte[] UnicodeUnescape(byte[] buf)
		{
			string str = Encoding.UTF8.GetString(buf);
			string result = Regex.Replace(str, @"\\u(?<code>[0-9a-fA-F]{4})", Replace);
			result = result.Replace("\\n", "\n");
			return Encoding.GetEncoding("SHIFT-JIS").GetBytes(result);
		}

		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("count = ");
			sb.Append(segments.Count.ToString());
			sb.Append(": A.Num = ");
			sb.Append(AcknowledgmentNumber.ToString());
			if(IsBroken)
				return sb.ToString() + ": Broken";
			if (!IsCompleted)
				return sb.ToString() + ": Not Completed";
			sb.Append(": HttpLength = ");
			sb.Append(httph.ContentLength.ToString());
			sb.Append(": PLLength = ");
			if (Payload != null)
				sb.Append(Payload.Length.ToString());
			else
				sb.Append("null");
			return sb.ToString();
		}
	}
}
