﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using NetMonitor.View;

namespace NetMonitor.LoW.StaticData
{
	enum Rarity
	{
		None = 0,
		C = 1,
		UC = 2,
		R = 3,
		SR = 4,
		SSR = 5
	}

	static class LoWDataStatic
	{
		public readonly static Dictionary<string, LBossStatic> LBossDic = new Dictionary<string, LBossStatic>();
		public readonly static Dictionary<string, EquipmentStatic> EquipDic = new Dictionary<string, EquipmentStatic>();
		public readonly static Dictionary<string, CardGroupStatic> CardGroupDic = new Dictionary<string, CardGroupStatic>();

		public static CardStatic GetCardData(string key, int card_class)
		{
			if(card_class < 1 || card_class > 3)
				return null;
			int index = key.IndexOf('+');
			if(index > 0)
			{
				key = key.Substring(0,index).Trim();
			}
			
			if(CardGroupDic.ContainsKey(key))
			{
				CardGroupStatic group = CardGroupDic[key];
				if (card_class == 1 && group.Sala != null)
					return group.Sala;
				return group.Cards[card_class-1];
			}
			return null;
		}
		public static LBossStatic GetLBossData(string key, int max_hp)
		{
			if(LBossDic.ContainsKey(key))
				return LBossDic[key];
			LBossStatic boss;
			if(LBossDic.ContainsKey(key + "A"))
			{
				boss = LBossDic[key + "A"];
				if (boss.max_hp == max_hp)
				return boss;
			}
			if(LBossDic.ContainsKey(key + "B"))
			{
				boss = LBossDic[key + "B"];
				if (boss.max_hp == max_hp)
				return boss;
			}
			return null;
		}
		public static EquipmentStatic GetEquipData(string key)
		{
			int index = key.IndexOf('+');
			if (index > 0)
			{
				key = key.Substring(0,index).Trim();
			}
			if(EquipDic.ContainsKey(key))
				return EquipDic[key];
			return null;
		}
	
		public static bool LoadCsvFiles()
		{
			try
			{
				FileStream fs = null;
				StreamReader reader = null;
				string bossfile = Program.DataDir + "boss.csv";
				string equipfile = Program.DataDir + "equip.csv";
				string cardfile = Program.DataDir + "card.csv";
				string line = null;
				using (fs = new FileStream(bossfile, FileMode.Open))
				{
					reader = new StreamReader(fs, Encoding.GetEncoding("SHIFT-JIS"));
					while ((line = reader.ReadLine()) != null)
					{
						if (line.Length == 0 || line.StartsWith("#") || line.StartsWith(","))
							continue;
						string[] tokens = line.Split(',');
						LBossStatic data = new LBossStatic();
						data.ReadCsvLine(tokens);
						LBossDic.Add(data.GetDictionaryKey(), data);
					}
				}
				using (fs = new FileStream(equipfile, FileMode.Open))
				{
					reader = new StreamReader(fs, Encoding.GetEncoding("SHIFT-JIS"));
					while ((line = reader.ReadLine()) != null)
					{
						if (line.Length == 0 || line.StartsWith("#") || line.StartsWith(","))
							continue;
						string[] tokens = line.Split(',');
						if (tokens.Length < 1 || tokens[0].Length == 0)
							continue;
						EquipmentStatic data = new EquipmentStatic();
						data.ReadCsvLine(tokens);
						EquipDic.Add(data.GetDictionaryKey(), data);
					}
				}
				using (fs = new FileStream(cardfile, FileMode.Open))
				{
					reader = new StreamReader(fs, Encoding.GetEncoding("SHIFT-JIS"));
					while ((line = reader.ReadLine()) != null)
					{
						if (line.Length == 0 || line.StartsWith("#") || line.StartsWith(","))
							continue;
						string[] tokens = line.Split(',');
						CardStatic data = new CardStatic();
						data.ReadCsvLine(tokens);
						string key = data.GetDictionaryKey();
						CardGroupStatic group = null;

						if (CardGroupDic.ContainsKey(key))
							group = CardGroupDic[key];
						else
						{
							group = new CardGroupStatic();
							CardGroupDic.Add(key, group);
						}
						if (group.Cards[data.card_class - 1] == null)
							group.Cards[data.card_class - 1] = data;
						else if (data.card_class == 1 && group.Sala == null)
							group.Sala = data;
						else
							throw new Exception("card.csvに重複データあり");
						data.Group = group;
						if (data.Doubt)
							data.Group.Doubt = true;

					}
				}
			}
			catch
			{
				NMConsole.TextEnqueue("csvファイル読み取り失敗", TextType.Error);
				return false;
			}
			NMConsole.TextEnqueue("csvファイル読み取り完了", TextType.FileLoad);
			return true;
		}
	}

}
