﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetMonitor.LoW.StaticData
{
	class LBossStatic : AbstractLoWDataStatic
	{

		/// <summary>
		/// ランク
		/// </summary>
		public int lboss_rank { get; set; }
		/// <summary>
		/// 特殊能力 物理/魔法無効
		/// </summary>
		//public LBossAbility lboss_ability { get; set; }
		/// <summary>
		/// 分類
		/// </summary>
		public string lboss_group{get;set;}
		/// <summary>
		/// 必要フォース
		/// </summary>
		public int req_force{get;set;}
		/// <summary>
		/// 最大HP
		/// </summary>
		public int max_hp;
		/// <summary>
		/// 報酬ライン
		/// </summary>
		public int req_damage;
		///// <summary>
		///// 防御力
		///// </summary>
		//public int def;
		/// <summary>
		/// 制限時間(分)
		/// </summary>
		public int limit{get;set;}
		public override void ReadCsvLine(string[] tokens)
		{
			base.ReadCsvLine(tokens);
			int i = 6;
			lboss_rank = int.Parse(tokens[i++]);
			switch (tokens[i++])
			{
				case "無": Param.ability = BattleAbility.None; break;
				case "魔法無効": Param.ability = BattleAbility.ImmuneToMagic; break;
				case "物理無効": Param.ability = BattleAbility.ImmuneToPhysical; break;
				default:
					Doubt = true;
					Param.ability = BattleAbility.None;
					break;
			}
			lboss_group = tokens[i++];
			req_force = int.Parse(tokens[i++]);
			max_hp = int.Parse(tokens[i++]);
			req_damage = int.Parse(tokens[i++]);
			Param.def = int.Parse(tokens[i++]);
			Param.rst = Param.def;
			if (Param.element.type != Element.None)
				Param.element.num = 50;
			limit = int.Parse(tokens[i++]);
		}
		public override string GetDictionaryKey()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append(name);
			if (Param.ability == BattleAbility.ImmuneToMagic)
				sb.Append("A");
			if (Param.ability == BattleAbility.ImmuneToPhysical)
				sb.Append("B");
			return sb.ToString();
		}
	}
}
