﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetMonitor.LoW.StaticData
{
	class CardGroupStatic
	{
		public CardStatic[] Cards = new CardStatic[3];
		public CardStatic Sala = null;
		/// <summary>
		/// データが疑わしいフラグ
		/// </summary>
		public bool Doubt { get; set; }
		public void SetDoubtFlag()
		{
			Doubt = true;
			foreach (CardStatic c in Cards)
				if (c != null)
					c.Doubt = true;
			if (Sala != null)
				Sala.Doubt = true;
		}
	}
	
	
	
	class CardStatic : AbstractLoWDataStatic
	{
		public CardGroupStatic Group{get;set;}
		/// <summary>
		/// 最大LV
		/// </summary>
		public int lvup_max{get;set;}
		/// <summary>
		/// レアリティ
		/// </summary>
		public int card_rarity{get;set;}
		/// <summary>
		/// 進化段階
		/// </summary>
		public int card_class{get;set;}
		/// <summary>
		/// コスト
		/// </summary>
		public int setcost{get;set;}
		/// <summary>
		/// Lv制限
		/// </summary>
		public int req_lv{get;set;}

		public GrowthRate GRate;
		///// <summary>
		///// 物理 = 1,魔法 = 2
		///// </summary>
		//public int card_type{get;set;}
		///// <summary>
		///// 消費MP
		///// </summary>
		//public int sp{get;set;}
		///// <summary>
		///// 発動率(千分率)
		///// </summary>
		//public int card_per{get;set;}
		///// <summary>
		///// クリティカル
		///// </summary>
		//public int critical{get;set;}
		///// <summary>
		///// バランス
		///// </summary>
		//public int balance{get;set;}
		///// <summary>
		///// 通常D 図鑑値
		///// </summary>
		//public int atk{get;set;}
		///// <summary>
		///// スキルD 図鑑値
		///// </summary>
		//public int satk{get;set;}
		///// <summary>
		///// 成長率通常D
		///// </summary>
		//public double growthrate_atk{get;set;}
		///// <summary>
		///// 成長率スキルD
		///// </summary>
		//public double growthrate_satk{get;set;}
		
		public const double ClassUpRate = 0.05;
		public const double ClassUpRate_LvMax = 0.1;
		public Card CreateBestCard(int lv)
		{
			if (lv < 0)
				lv = this.lvup_max;
			Card result = new Card(this);
			result.card_lv = lv;
			switch (card_class)
			{
				case 1:
					{
						result.CardParam = result.StParam.Growth(GRate, lv - 1);
						return result;
					}
				case 2:
				case 3:
					{
						if (this.Group.Cards[card_class - 1 - 1] == null)
							goto case 1;
						Card lesser = this.Group.Cards[card_class - 1 - 1].CreateBestCard(-1);
						if (lesser.Doubt)
							result.Doubt = true;
						result.AddParam.atk = ((int)(lesser.CardParam.atk * ClassUpRate_LvMax + 0.0001)) * 2;
						result.AddParam.satk = ((int)(lesser.CardParam.satk * ClassUpRate_LvMax + 0.0001)) * 2;
						result.CardParam = (result.StParam + result.AddParam).Growth(GRate, lv -1);
						return result;
					}
			}
			return null;
		}
		public Card CreateWorstCard(int lv)
		{
			if (lv < 0)
				lv = this.lvup_max;
			Card result = new Card(this);
			result.card_lv = lv;
			switch (card_class)
			{
				case 1:
					{
						if (lv > 1)
							result.CardParam = result.StParam.Growth(GRate, lv - 1);
						return result;
					}
				case 2:
				case 3:
					{
						if (this.Group.Cards[card_class - 1 - 1] == null)
							goto case 1;
						Card lesser = this.Group.Cards[card_class - 1 - 1].CreateWorstCard(1);
						if (lesser.Doubt)
							result.Doubt = true;
						double rate = ClassUpRate;
						if (this.Group.Cards[card_class - 1 - 1].lvup_max == 1)
							rate = ClassUpRate_LvMax;
						result.AddParam.atk = ((int)(lesser.CardParam.atk * rate + 0.0001)) * 2;
						result.AddParam.satk = ((int)(lesser.CardParam.satk * rate + 0.0001)) * 2;
						result.CardParam = (result.StParam + result.AddParam).Growth(GRate, lv - 1);
						return result;
					}
			}
			return null;
		}
		public override void ReadCsvLine(string[] tokens)
		{
			base.ReadCsvLine(tokens);
			int i = 6;
			lvup_max = int.Parse(tokens[i++]);
			switch(tokens[i++])
			{
				case "C": card_rarity = 1;break;
				case "UC": card_rarity = 2;break;
				case "R": card_rarity = 3;break;
				case "SR": card_rarity = 4;break;
				case "SSR": card_rarity = 5;break;
				default:
					Doubt = true;
					card_rarity = -1;
					break;
			}
			card_class = int.Parse(tokens[i++]);
			setcost = int.Parse(tokens[i++]);
			req_lv = int.Parse(tokens[i++]);
			switch(tokens[i++])
			{
				case "物": Param.type = 1; break;
				case "魔": Param.type = 2; break;
				default:
					Doubt = true;
					Param.type = -1;
					break;
			}
			Param.sp = int.Parse(tokens[i++]);
			Param.s_per = int.Parse(tokens[i++]);
			Param.critical = int.Parse(tokens[i++]);
			Param.balance = int.Parse(tokens[i++]);
			Param.atk = int.Parse(tokens[i++]);
			Param.satk = int.Parse(tokens[i++]);
			GRate.atk = double.Parse(tokens[i++]);
			GRate.satk = double.Parse(tokens[i++]);
		}
		public override string GetDictionaryKey()
		{
			int index = name.IndexOf('_');
			if(index < 0)
				return name;
			return name.Substring(0,index);
		}


	}
}
