﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetMonitor.LoW.StaticData
{
	abstract class AbstractLoWDataStatic
	{
		//共通データ
		public bool 課金専用 { get; set; }
		public bool 期間限定 { get; set; }
		public string name { get; set; }
		public BParameter Param;
		/// <summary>
		/// データが疑わしいフラグ
		/// </summary>
		public bool Doubt { get; set; }
		public virtual void ReadCsvLine(string[] tokens)
		{
			switch (tokens[0])
			{
				case "0": Doubt = false; break;
				case "1": Doubt = true; break;
				default:
					Doubt = true;
					break;
			}
			switch (tokens[1])
			{
				case "課金": 課金専用 = true; break;
				case "一般": 課金専用 = false; break;
				default:
					Doubt = true;
					break;
			}
			switch (tokens[2])
			{
				case "限定": 期間限定 = true; break;
				case "常設": 期間限定 = false; break;
				default:
					Doubt = true;
					break;
			}
			name = tokens[3];
			switch (tokens[4])
			{
				case "無": Param.element.type = Element.None; break;
				case "地": Param.element.type = Element.Earth; break;
				case "水": Param.element.type = Element.Water; break;
				case "火": Param.element.type = Element.Fire; break;
				case "風": Param.element.type = Element.Wind; break;
				default:
					Doubt = true;
					break;
			}
			Param.element.num = int.Parse(tokens[5]);
		}
		public abstract string GetDictionaryKey();

	}
}
