﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.AmfFormat;
using System.IO;
using NetMonitor.View;
using NetMonitor.LoW.BattleData;

namespace NetMonitor.LoW
{
	enum LowState
	{
		None,
		Town,
		LBossList,
		LBoss,
		Tower,
		Tower_Opponent,
		Quest, 
		Friends,
	}
	
	static class MainData
	{
		public static Chara Me = new Chara();
		public static List<Card> CardList = new List<Card>();
		public static List<Equipment> EquipmentList = new List<Equipment>();
		public static Dictionary<string, Chara> CharaList = new Dictionary<string, Chara>();
		//public static Dictionary<int, LBoss> LBossList = new Dictionary<int, LBoss>();
		public static LBossList LBossList = new LBossList();
		static AbstractIdealBattle lastIdeal;

		//public static void UpdateLBossList(AmfData[] lbossObjArray, DateTime time)
		//{
		//    Dictionary<int, LBoss> newLBossList = new Dictionary<int, LBoss>();
		//    foreach (AmfData amf in lbossObjArray)
		//    {
		//        LBoss lboss = null;
		//        AmfObjectData lboss_data = amf as AmfObjectData;
		//        if (lboss_data == null)
		//            continue;
		//        int ld_id = lboss_data.GetMember("ld_id").GetIntValue();
		//        if (LBossList.ContainsKey(ld_id))
		//        {
		//            lboss = LBossList[ld_id];
		//            lboss.UpdateDate(lboss_data, time);
		//        }
		//        else
		//        {
		//            lboss = LBoss.FromAmfObject(lboss_data, time);
		//        }
		//        newLBossList.Add(lboss.ld_id, lboss);
		//    }
		//    LBossList.Clear();
		//    LBossList = newLBossList;
		//}

		//public static void RemoveLBoss(LBoss lboss)
		//{
		//    if (LBossList.ContainsKey(lboss.ld_id))
		//        LBossList.Remove(lboss.ld_id);
		//    if (lastLBoss != null && lastLBoss.ld_id == lboss.ld_id)
		//        lastLBoss = null;
		//}

		//public static LBoss GetLBoss(AmfObjectData lboss_data, DateTime time)
		//{
		//    LBoss lboss = null;
		//    int ld_id = lboss_data.GetMember("ld_id").GetIntValue();
		//    if (LBossList.ContainsKey(ld_id))
		//    {
		//        lboss = LBossList[ld_id];
		//        lboss.UpdateDate(lboss_data, time);
		//        return lboss;
		//    }
		//    lboss = LBoss.FromAmfObject(lboss_data, time);
		//    LBossList.Add(lboss.ld_id, lboss);
		//    return lboss;
		//}

		public static Chara GetChara(AmfObjectData chara_data, DateTime time)
		{
			Chara chara = null;
			string chara_name = chara_data.GetMember("chara_name").GetStrValue();
			if (Me.chara_name == chara_name)
				return Me;
			if (CharaList.ContainsKey(chara_name))
			{
				chara = CharaList[chara_name];
				chara.UpdateData(chara_data, time);
				return chara;
			}
			chara = new Chara();
			chara.UpdateData(chara_data, time);
			CharaList.Add(chara.chara_name, chara);
			return chara;
		}

		public static void RenewCharaData(AmfObjectData chara_data, DateTime time)
		{
			Me.UpdateData(chara_data, time);
			Me.myself = true;
			//Me.Read(chara_data);
			//NWConsole.Update
		}
		
		static LowState state;
		public static void ReceiveData(NetMonitor.Network.Datagram data)
		{
			if (data.type != Network.DatagramType.X_AMF)
				return;
			ReceiveData(data.Payload, data.Time);
		}

		public static void Start()
		{
			NMConsole.TabTextList[0] = Me.MyData();
			NMConsole.NeedFocus = true;
			NMConsole.FocusTab = -1;
		}
		public static void ReceiveData(byte[] buffer, DateTime time)
		{
			MemoryStream st = null;
			Amf0Archive arc = null;
			try
			{
				using (st = new MemoryStream(buffer))
				{
					arc = Amf0Reader.ReadAmf0(st);
				}
			}
			catch
			{
				NMConsole.TextEnqueue("amfの解釈に失敗しました", TextType.Error);
				return;
			}

			if (arc.Headers.Length != 1 || arc.Headers[0].HeaderData == null || arc.Messages.Length != 1 || arc.Messages[0].Data == null)
			{
				NMConsole.TextEnqueue("定型外amfデータ", TextType.Error);
				return;
			}
			AmfObjectData objData = arc.Messages[0].Data as AmfObjectData;
			if (objData == null || objData.Members.Count == 0)
			{
				NMConsole.TextEnqueue("定型外amfデータ", TextType.Error);
				return;
			}
			AmfObjectMember member = objData.Members[objData.Members.Count - 1];
			if (member.Key != "auth" || !(member.Value is AmfBooleanData) || !((AmfBooleanData)member.Value).b)
			{
				NMConsole.TextEnqueue("定型外amfデータ", TextType.Error);
				return;
			}
			if (Program.FlagOutputTxt)
			{
				Program.OutputDebugFile(objData, ".txt", time);
			}
			try
			{
				LowState newState = LowState.None;
				AmfData err = objData.GetMember("error");
				AmfData amf;
				AmfObjectData chara_data = objData.GetMember("chara_data") as AmfObjectData;
				bool charaUpdate = false;
				if (chara_data != null)
				{
					RenewCharaData(chara_data, time);
					charaUpdate = true;
				}
				foreach (AmfObjectMember mem in objData.Members)
				{
					switch (mem.Key)
					{
						case "lboss_list"://大ボスリスト
							newState = LowState.LBossList;
							LBossList.UpdateData(((AmfArrayData)mem.Value).Array, time);
							{
								NMConsole.NeedFocus = true;
								NMConsole.FocusTab = 1;
								NMConsole.TabTextList[1] = LBossList.GetConsoleText();
								NMConsole.TextBoxText = LBossList.GetTextBoxText();
							}
							goto finished;
						case "recent_damage"://大ボス
							newState = LowState.LBoss;
							LBossList.LastLBoss = LBossList.GetLBoss(objData, time);
							goto finished;
						
						case "rank_data"://対戦 - 初期
							{
								//rank_data自体はchara_dataの方にも含まれているので読み捨て
								newState = LowState.Tower;
							}
							goto finished;
						case "target"://対戦 - 相手選択中
							{
								AmfData passData = objData.GetMember("pass_num");
								int pass_num = passData != null ? passData.GetIntValue() : 5;
								Chara chara = GetChara((AmfObjectData)mem.Value, time);
								chara.battle_rank = Me.battle_rank;
								IdealTowerBattle battle = new IdealTowerBattle(Me, chara);
								battle.CalcExpectedValue();
								battle.CalcOdds(Setting.Config.Instance.NumberOfSimBattle);
								NMConsole.NeedFocus = true;
								NMConsole.FocusTab = 3;
								NMConsole.TabTextList[3] = battle.GetConsoleText();
								NMConsole.TextBoxText = battle.GetTextBoxText();
								newState = LowState.Tower_Opponent;
								lastIdeal = battle;
							}
							goto finished;
						case "battle"://対戦 or 大ボス- 対戦結果
						//case "finish"://対戦 - 対戦結果
							{
								if (mem.Value is AmfArrayData)//クエスト進行
									goto finished;
								BattleResult result = BattleResult.FromAmfObject(objData);
								string mes = null;
								if (lastIdeal != null)
								{
									if ((result.type == BattleType.Tower && state == LowState.Tower_Opponent))
										mes = result.Confirm(lastIdeal as IdealTowerBattle);
									else if (result.type == BattleType.LBoss && state == LowState.LBoss)
										mes = result.Confirm(lastIdeal as IdealLBossBattle);
									if (mes != null)
									{
										NMConsole.NeedFocus = true;
										NMConsole.FocusTab = 4;
										NMConsole.TabTextList[4] = mes;
										NMConsole.TextBoxText = result.TextBoxText;
									}
								}
							}
							goto finished;
						case "pstock":
							{
								if (LBossList.LastLBoss != null && LBossList.LastLBoss.timelimit > DateTime.Now)
								{
								}
								else
									newState = LowState.Town;
							}
							goto finished;

						case "charisma"://カードリスト
							{
								if ((amf = objData.GetMember("card")) != null)
								{
									CardList.Clear();
									AmfData[] cardObjs = ((AmfArrayData)amf).Array;
									Card[] setcard = new Card[3];
									foreach (AmfData cardMem in cardObjs)
									{
										Card card = Card.FromAmfObject((AmfObjectData)cardMem);
										if (card != null)
											CardList.Add(card);
										if (card.set_flg > 0)
											setcard[card.set_flg - 1] = card;
									}
									if (Me.UpdateSetcard(setcard))
										charaUpdate = true;
								}
							}
							goto finished;
						case "reward_list":
							newState = LowState.Quest;
							goto finished;
						case "friend":
							newState = LowState.Friends;
							goto finished;
					}
				}
			finished:
			//	if (newState != LowState.None && newState != state)
			//	{
			//	}
			bool stateUpdate = newState != LowState.None && newState != state;
				if(stateUpdate)
					state = newState;
				if(charaUpdate)
				{
					NMConsole.TabTextList[0] = Me.MyData();
					NMConsole.NeedFocus = true;
					NMConsole.FocusTab = -1;
				}
				if (state == LowState.LBoss && LBossList.LastLBoss != null && (stateUpdate || charaUpdate))
				{

					IdealLBossBattle battle = null;
					if (lastIdeal != null && lastIdeal is IdealLBossBattle && ((IdealLBossBattle)lastIdeal).lboss.ld_id == LBossList.LastLBoss.ld_id)
						battle = (IdealLBossBattle)lastIdeal;
					else
						battle = new IdealLBossBattle(Me, LBossList.LastLBoss);
					battle.CalcExpectedValue();
					battle.CalcOdds(Setting.Config.Instance.NumberOfSimBattle);
					NMConsole.NeedFocus = true;
					NMConsole.FocusTab = 1;
					NMConsole.TabTextList[1] = battle.GetConsoleText();
					NMConsole.TextBoxText = battle.GetTextBoxText();
					lastIdeal = battle;
				}


			}
			catch
			{
				NMConsole.TextEnqueue("amfデータの処理中に予期しないエラー", TextType.Error);
				return;
			}


		}
	}
}
