﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.AmfFormat;
using NetMonitor.LoW.StaticData;

namespace NetMonitor.LoW
{
	enum EquipmentInfo
	{
		None = 0,
		/// <summary>
		/// サーバーからのデータが不完全でcsvデータもなく推測もできない
		/// </summary>
		Unknown,
		/// <summary>
		/// サーバーから送られてきたデータのうちnameから算出したデータ
		/// </summary>
		Calculated,
		/// <summary>
		/// サーバーから送られてきた完全データ
		/// </summary>
		Complete,
	}
	class Equipment
	{
		private Equipment(string name, int plus)
		{
			item_name = name;
			this.plus = plus;
		}
		public Equipment(EquipmentStatic data, int plus)
		{
			item_name = data.name;
			Param = data.Param;
			item_rarity = data.item_rarity;
			area = data.area;
			plus_max = data.plus_max;
			sell_cost = data.sell_cost;
			Doubt = data.Doubt;
			Info = EquipmentInfo.Calculated;
			this.plus = plus;
			if(plus > 0)
				Param = Param.Growth(data.GRate, plus);
		}

		public static bool Consistent(Equipment[] x, Equipment[] y)
		{
			if (x == y)
				return true;
			if (x == null || y == null)
				return false;
			if (x.Length != y.Length)
				return false;
			for (int i = 0; i < x.Length; i++)
				if (!Consistent(x[i], y[i]))
					return false;
			return true;
		}

		public static bool Consistent(Equipment x, Equipment y)
		{
			if (x == y)
				return true;
			if (x == null || y == null)
				return false;
			if (x.item_name != y.item_name)
				return false;
			if (x.plus != y.plus)
				return false;
			if (x.Info == y.Info)
				return true;
			return (x.Param == y.Param);
		}

		public static Equipment[] EquipFromAmfObject(AmfObjectData obj)
		{
			Equipment[] result = new Equipment[3];

			foreach (AmfObjectMember mem in obj.Members)
			{
				EquipmentArea equip_area = EquipmentArea.None;
				int iArea = -1;
				switch (mem.Key)
				{
					case "r_hand":
						equip_area = EquipmentArea.r_hand;
						iArea = (int)equip_area;break;
					case "l_hand":
						equip_area = EquipmentArea.l_hand;
						iArea = (int)equip_area;break;

					case "body":
						equip_area = EquipmentArea.body;
						iArea = (int)equip_area;break;
				}
				if (iArea >= 0)
				{
					AmfObjectData amfObj = mem.Value as AmfObjectData;
					if (amfObj == null && mem.Value is AmfArrayData)
					{
						amfObj = ((AmfArrayData)mem.Value).Array[0] as AmfObjectData;
					}
					if (amfObj == null)
						continue;
					result[iArea] = FromAmfObject(amfObj, equip_area);
				}
			}

			return result;
		}
		public static Equipment FromAmfObject(AmfObjectData obj, EquipmentArea area)
		{
			AmfStringData nameData = obj.GetMember("item_name") as AmfStringData;
			//item_nameを持たないデータ 使用できない
			if (nameData == null)
				return null;
			string row_name = nameData.s;
			int index = row_name.IndexOf('+');
			string true_name = row_name;
			int plus = 0;
			if (index > 0)
			{
				true_name = row_name.Substring(0, index).Trim();
				plus = int.Parse(row_name.Substring(index + 1));
			}
			Equipment result = new Equipment(true_name, plus);
			EquipmentStatic stEq = LoWDataStatic.GetEquipData(true_name);
			bool complateData = false;
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "item_id": result.item_id = ((AmfStringData)mem.Value).s; break;
					case "plus": result.plus = mem.Value.GetIntValue(); break;
					case "trade_flg": result.trade_flg = mem.Value.GetIntValue(); break;
					case "lock": result.lock_flg = mem.Value.GetBooleanValue(); break;
					case "equip": result.equip = mem.Value.GetBooleanValue(); break;
					case "item_rarity": result.item_rarity = mem.Value.GetIntValue(); break;
					case "item_type": result.Param.type = mem.Value.GetIntValue(); break;
					case "sp": result.Param.sp = mem.Value.GetIntValue(); break;
					case "atk": result.Param.atk = mem.Value.GetIntValue(); complateData = true; break;
					case "mag": result.Param.mag = mem.Value.GetIntValue(); complateData = true; break;
					case "def": result.Param.def = mem.Value.GetIntValue(); complateData = true; break;
					case "rst": result.Param.rst = mem.Value.GetIntValue(); complateData = true; break;
					case "plus_max": result.plus_max = mem.Value.GetIntValue(); break;
					case "sell_cost": result.sell_cost = mem.Value.GetIntValue(); complateData = true; break;
					case "balance": result.Param.balance = mem.Value.GetIntValue(); break;
					case "critical": result.Param.critical = mem.Value.GetIntValue(); break;
					case "water": result.Param.element.type = Element.Water; result.Param.element.num = mem.Value.GetIntValue(); break;
					case "wind": result.Param.element.type = Element.Wind; result.Param.element.num = mem.Value.GetIntValue(); break;
					case "earth": result.Param.element.type = Element.Earth; result.Param.element.num = mem.Value.GetIntValue(); break;
					case "fire": result.Param.element.type = Element.Fire; result.Param.element.num = mem.Value.GetIntValue(); break;
				}
			}
			if (complateData)
			{
				result.Info = EquipmentInfo.Complete;
				result.Doubt = false;
				if (stEq != null && !stEq.Doubt)
				{
					//TODO:データ照合
				}
				return result;
			}
			if (stEq == null)
			{
				result.Doubt = true;
				result.Info = EquipmentInfo.Unknown;
				return result;
			}
			result = new Equipment(stEq, plus);
			result.Info = EquipmentInfo.Calculated;
			return result;
		}
		public EquipmentInfo Info;
		public bool Doubt;

		/// <summary>
		/// レアリティ
		/// マスクデータ
		/// </summary>
		public int item_rarity { get; set; }
		/// <summary>
		/// 装備中フラグ
		/// </summary>
		public bool equip { get; set; }

		
		public EquipmentArea area { get; set; }



		///// <summary>
		///// MP上昇量
		///// </summary>
		//public int sp { get; set; }
		/// <summary>
		/// 最大強化値
		/// </summary>
		public int plus_max { get; set; }

		public BParameter Param;
		///// <summary>
		///// 属性
		///// </summary>
		//public Element element.type { get; set; }
		///// <summary>
		///// 属性値
		///// </summary>
		//public int element.num { get; set; }
		///// <summary>
		///// 物理 = 1,魔法 = 2
		///// 装備品に関してはこの項目は大した意味はない
		///// </summary>
		//public int item_type { get; set; }
		///// <summary>
		///// クリティカル
		///// </summary>
		//public int critical { get; set; }
		///// <summary>
		///// バランス
		///// </summary>
		//public int balance { get; set; }
		///// <summary>
		///// 攻撃力
		///// </summary>
		//public int atk { get; set; }
		///// <summary>
		///// 魔法攻撃力
		///// </summary>
		//public int mag { get; set; }
		///// <summary>
		///// 防御力
		///// </summary>
		//public int def { get; set; }
		///// <summary>
		///// 魔法防御力
		///// </summary>
		//public int rst { get; set; }
		/// <summary>
		/// 売却額
		/// </summary>
		public int sell_cost { get; set; }

		
		/// <summary>
		/// itemID
		/// </summary>
		public string item_id { get; set; }
		
		/// <summary>
		/// 現在強化値
		/// </summary>
		public int plus { get; set; }
		/// <summary>
		/// ロックフラグ
		/// </summary>
		public bool lock_flg { get; set; }
		/// <summary>
		/// 名前 強化値を含まない
		/// </summary>
		public string item_name { get; set; }
		/// <summary>
		/// 謎フラグ トレードシステム実装予定なのかNPC売りのことなのか
		/// </summary>
		public int trade_flg{get;set;}
		
		//説明文 使用しない
		//public string item_note { get; set; }
		//item_idとは異なるナニカ。使用しない
		//public int ii_id{get;set;}
		// 倉庫フラグ？使用しない
		//public int stock_flg { get; set; }
		//public int ii_status { get; set; }
		public string NameWithPlus
		{
			get
			{
				if (plus == 0)
					return item_name;
				return item_name + " +" + plus.ToString();
			}
		}
	}
}
