﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW
{
	enum BattleAbility
	{
		None = 0,
		ImmuneToPhysical = 1,
		ImmuneToMagic = 2
	}
	
	struct GrowthRate
	{
		public double atk;
		public double satk;
		public double def;
		public double mag;
		public double rst;
	}

	struct BParameter
	{
		public int atk;
		public int type;
		public int balance;
		public int critical;
		public int sp;
		public ElementStr element;
		public BattleAbility ability;

		public int s_per;
		public int satk;

		public int def;
		public int mag;
		public int rst;
		//public BParameter(BParameter rother)
		//{
		//    atk = rother.atk;
		//    type = rother.type;
		//    balance = rother.balance;
		//    critical = rother.critical;
		//    sp = rother.sp;
		//    element = rother.element;

		//    s_per = rother.s_per;
		//    satk = rother.satk;

		//    def = rother.def;
		//    mag = rother.mag;
		//    rst = rother.rst;
		//}
		public static BParameter Lv1Chara
		{
			get
			{
				BParameter p = new BParameter();
				p.atk = 10;
				p.def = 10;
				p.mag = 10;
				p.rst = 10;
				p.balance = 5;
				p.critical = 10;
				p.sp = 110;
				return p;
			}
		}
		public BParameter Growth(GrowthRate rate, int num)
		{
			if (num == 0)
				return this;
			BParameter p = this;
			if (atk != 0 && rate.atk != 0.0)
				p.atk += (int)(p.atk * rate.atk * num + 0.001);
			if (satk != 0 && rate.satk != 0.0)
				p.satk += (int)(p.satk * rate.satk * num + 0.001);
			if (def != 0 && rate.def != 0.0)
				p.def += (int)(p.def * rate.def * num + 0.001);
			if (mag != 0 && rate.mag != 0.0)
				p.mag += (int)(p.mag * rate.mag * num + 0.001);
			if (rst != 0 && rate.rst != 0.0)
				p.rst += (int)(p.rst * rate.rst * num + 0.001);
			return p;

		}
		public static BParameter operator+(BParameter x, BParameter y)
		{
			BParameter p = x;
			p.atk = x.atk + y.atk;
			p.def = x.def + y.def;
			p.mag = x.mag + y.mag;
			p.rst = x.rst + y.rst;
			p.balance = x.balance + y.balance;
			p.critical = x.critical + y.critical;
			p.sp = x.sp + y.sp;
			p.satk = x.satk + y.satk;
			return p;
		}
		public override bool Equals(object obj)
		{
			if (!(obj is BParameter))
				return false;
			return this == (BParameter)obj;
		}
		public override int GetHashCode()
		{
			return base.GetHashCode();
		}
		//public override bool Equals(BParameter obj)
		public bool Equals(BParameter obj)
		{
			return this == obj;
		}
		public static bool operator==(BParameter x, BParameter y)
		{
			return x.atk == y.atk && x.type == y.type && x.balance == y.balance && x.critical == y.critical &&
				x.sp == y.sp && x.element.num == y.element.num && x.element.type == y.element.type &&
				x.s_per == y.s_per && x.satk == y.satk && x.def == y.def && x.mag == y.mag && x.rst == y.rst;
		}
		public static bool operator !=(BParameter x, BParameter y)
		{
			return !(x == y);
		}
		
		public static BParameter FromAmfObject(AmfObjectData obj)
		{
			BParameter result = new BParameter();
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "s_per": result.s_per = mem.Value.GetIntValue(); break;
					case "def": result.def = mem.Value.GetIntValue(); break;
					case "mag": result.mag = mem.Value.GetIntValue(); break;
					case "rst": result.rst = mem.Value.GetIntValue(); break;
					case "type": result.type = mem.Value.GetIntValue(); break;
					case "sp": result.sp = mem.Value.GetIntValue(); break;
					case "atk": result.atk = mem.Value.GetIntValue(); break;
					case "satk": result.satk = mem.Value.GetIntValue(); break;
					case "balance": result.balance = mem.Value.GetIntValue(); break;
					case "critical": result.critical = mem.Value.GetIntValue(); break;
					case "water": result.element.type = Element.Water; result.element.num = mem.Value.GetIntValue(); break;
					case "wind": result.element.type = Element.Wind; result.element.num = mem.Value.GetIntValue(); break;
					case "earth": result.element.type = Element.Earth; result.element.num = mem.Value.GetIntValue(); break;
					case "fire": result.element.type = Element.Fire; result.element.num = mem.Value.GetIntValue(); break;
					case "element": result.element = ElementStr.FromAmfObject((AmfObjectData)mem.Value); break;
				}
			}
			return result;
		}
	}
}
