﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;

namespace NetMonitor.LoW.BattleData
{

	class IdealTowerBattle : AbstractIdealBattle
	{
		public readonly Chara[] chara = new Chara[2];
		public IdealTowerBattle(Chara me, Chara target)
		{
			chara[0] = me;
			chara[1] = target;
			//サーバーから受け取ってしまった過剰な情報を推論に使用しない。
			if(!target.myself)
				for(int i = 0;i<target.setcard.Length;i++)
				{
					if(target.setcard[i] != null && target.setcard[i].StaticData != null)
						target.setcard[i] = target.setcard[i].StaticData.CreateBestCard(-1);
				}
		}
		
		public double Odds;
		public readonly ExpectedDamage[][] damages = new ExpectedDamage[2][];

		ExpectedDamage[] DamAve = new ExpectedDamage[2];
		public override  string GetConsoleText()
		{
			StringBuilder sb = new StringBuilder();
			if (string.IsNullOrEmpty(chara[0].chara_name))
			{
				sb.Append("情報不足により計算不能"); sb.Append(System.Environment.NewLine);
				sb.Append("自分の情報がありません"); sb.Append(System.Environment.NewLine);
				sb.Append("装備、街に戻る等をクリックして情報を更新して下さい"); 
				return sb.ToString();
			}
			if (!calced || !expected)
			{
				sb.Append("不明な理由により計算失敗"); sb.Append(System.Environment.NewLine);
				sb.Append("プログラムのエラーです"); sb.Append(System.Environment.NewLine);
				return sb.ToString();
			}
			if (!chara[0].cardInfoComplete)
			{
				sb.Append("◆自己カードの育成情報がありません(最良育成を仮定)"); sb.Append(System.Environment.NewLine);
			}
			if (Doubt)
			{
				sb.Append("◆装備またはカードのcsv情報が不足または矛盾しています"); sb.Append(System.Environment.NewLine);
			}
			sb.Append("※対戦相手のカードは最良の育成(2MM、4MM)を仮定します"); sb.Append(System.Environment.NewLine);
			sb.Append("※期待値の計算にはMPを考慮しません"); sb.Append(System.Environment.NewLine);

			sb.Append(chara[0].chara_name);
			sb.Append(" (");
			sb.Append(chara[0].Param.element.ToString());
			sb.Append(") vs ");
			sb.Append(chara[1].chara_name);
			sb.Append(" (");
			sb.Append(chara[1].Param.element.ToString());
			sb.Append(") :");
			//double affinity = chara[0].Param.element.GetAffinity(chara[1].Param.element);
			//if (affinity > 0.1)
			//    sb.Append(string.Format("有利属性 {0:0.0}倍", affinity));
			//else if (affinity < -0.1)
			//    sb.Append(string.Format("不利属性 {0:0.0}倍", -affinity));
			//else
			//    sb.Append("属性相性なし");
			sb.Append(System.Environment.NewLine);


			for (int atkID = 0; atkID < 2; atkID++)
			{
				for (int i = -1; i < 5; i++)
				{
					string name = "";
					int wordCount = 0;
					Chara attacker = chara[atkID];
					
					if (i == -1)
					{
						if (atkID == 0)
							name = " -You- ";
						else
							name = " -Opponent- ";
					}
					else if(i == 0)
						name = attacker.chara_name;
					else if (i == 4)
						name = "合計";
					else
					{
						Card card = attacker.setcard[i - 1];
						if (card == null)
						{
							sb.Append("(カードなし)");
							sb.Append(System.Environment.NewLine);
							continue;
						}
						name = card.NameWithClass;
						if (card.Info == CardInfo.Unknown)
						{
							sb.Append(name);
							sb.Append("(csvデータなし)");
							sb.Append(System.Environment.NewLine);
							continue;
						}
					}
					sb.Append(name);
					wordCount = MinorShift._Library.LangManager.GetStrlenLang(name);
					if (wordCount < MAX_NAME_COUNT)
						sb.Append(new string(' ', MAX_NAME_COUNT - wordCount));
					if (i == -1)
						sb.Append(ExpectedDamage.Title);
					else
					{
						sb.Append(damages[atkID][i].ToString());
						if (i == 0)
							sb.Append(" * 3");
						else if (i != 4)
							sb.Append(" * 2");
					}

					sb.Append(System.Environment.NewLine);
				}
			}
			//sb.Append("your atk    = "); sb.Append(new string(' ', MAX_NAME_COUNT - "your atk    = ".Length)); sb.Append(DamAve[0].ToString()); sb.Append(System.Environment.NewLine);
			//sb.Append("your damage = "); sb.Append(new string(' ', MAX_NAME_COUNT - "your damage = ".Length)); sb.Append(DamAve[1].ToString()); sb.Append(System.Environment.NewLine);
			sb.Append(GetTextBoxText());
			return sb.ToString();
		}
		public override string GetTextBoxText()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("[対戦]勝率  ");
			if (!calced)
			{
				sb.Append("情報不足");
				return sb.ToString();
			}

			if (double.IsPositiveInfinity(Odds))
				sb.Append("100.0%");
			else if (double.IsNegativeInfinity(Odds))
				sb.Append("  0.0%");
			else if (Odds > 0.9995)
				sb.Append(">99.9%");
			else if (Odds < 0.0005)
				sb.Append("< 0.1%");
			else
			{
				string oddStr = Odds.ToString("0.0%");
				sb.Append(string.Format("{0,5:0.0}%", Odds * 100));
			}
			if (Doubt)
			{
				sb.Append(" (csvデータ不足)");
			}
			return sb.ToString();
		}
		
		//SimulateCount * SimulateCount がintの範囲内であること
		public void CalcOdds(int SimulateCount)
		{
			if (string.IsNullOrEmpty(chara[0].chara_name))
				return;
			if(!expected)
				CalcExpectedValue();
			Doubt = false;
			foreach (Chara c in chara)
			{
				if (c.ParamIsDoubt)
					Doubt = true;
				foreach (Card sc in c.setcard)
					if (sc != null && sc.Doubt)
						Doubt = true;
			}
			if (damages[0][4].Min > damages[1][4].Max)//必勝
			{
				Odds = Double.PositiveInfinity;
				calced = true;
				return;
			}
			if (damages[0][4].Max < damages[1][4].Min)//必敗
			{
				Odds = Double.NegativeInfinity;
				calced = true;
				return;
			}
			//long[] DamSum = new long[2];
			int[] sim = base.m_DamageSimulate(SimulateCount, chara[0], chara[1].Param);
			int[] e_sim = base.m_DamageSimulate(SimulateCount, chara[1], chara[0].Param);

			//お互いのダメージで総当たり戦
			Array.Sort(sim);
			Array.Sort(e_sim);
			long i = 0;
			long j = 0;
			long winCount = 0;
			while(true)
			{
				if(sim[i] < e_sim[j])
				{
					i++;
					winCount += j;
					if(i >= SimulateCount)
					{
						//残りのiは全敗
						break;
					}
				}
				else
				{
					j++;
					if(j >= SimulateCount)
					{
						//残りのiは全勝
						winCount += (SimulateCount - i) * SimulateCount;
						break;
					}
				}
			}
			this.Odds = ((double)winCount) / SimulateCount;
			this.Odds = Odds / SimulateCount;
			calced = true;
			//DamAve[0].Min = sim[0];
			//DamAve[1].Min = e_sim[0];
			//DamAve[0].Expected = (int)(DamSum[0] / SimulateCount);
			//DamAve[1].Expected = (int)(DamSum[1] / SimulateCount);
			//DamAve[0].Max = sim[SimulateCount-1];
			//DamAve[1].Max = e_sim[SimulateCount - 1];
		}
		
		public void CalcExpectedValue()
		{
			if (string.IsNullOrEmpty(chara[0].chara_name))
				return;
			chara[1].CalcParam();
			damages[0] = base.m_ExpectedValue(chara[0], chara[1].Param);
			damages[1] = base.m_ExpectedValue(chara[1], chara[0].Param);
			expected = true;
		}
	}
}
