<?php

// fetch config
$config = $config2 = unserialize($_POST["config"]);

// merge existing configuration with new one
$config = array_merge($wakkaConfig, $config);

// remove config values for whatever reason
unset($config["allow_doublequote_html"]);

// set version to current version, yay!
$config["wakka_version"] = WAKKA_VERSION;

// convert config array into PHP code
$configCode = "<?php\n// wikka.config.php written at ".strftime("%c")."\n// do not change wikka_version manually!\n\n\$wakkaConfig = array(\n";
foreach ($config as $k => $v)
{
	$entries[] = "\t\"".$k."\" => \"".$v."\"";
}
$configCode .= implode(",\n", $entries).");\n?>";

// try to write configuration file
print("<strong>書込み可能な構成</strong><br />\n");
test("構成ファイル<tt>".$wakkaConfigLocation."</tt>の書込み...", $fp = @fopen($wakkaConfigLocation, "w"), "", 0);

if ($fp)
{
	fwrite($fp, $configCode);
	// write
	fclose($fp);
	
	print("<p>全て完了! あなたは<a href=\"".$config["base_url"]."\">あなたのWikkaサイトへ行く</a>ことができます。しかし、<tt>wikka.config.php</tt>は書込み可能ですので、書込み権限を削除することを推奨します。ファイルを書込み可能のままにしておくとセキュリティ上のリスクがあります!</p>");
}
else
{
	// complain
	print("<p><span class=\"failed\">警告:</span> 構成ファイル<tt>".$wakkaConfigLocation."</tt>は書込みできません。Wikkaディレクトリーもしくは<tt>wikka.config.php</tt>へ一時的に書込みできるようにする必要があります。(<tt>touch wikka.config.php ; chmod 666 wikka.config.php</tt>;この後に書き込み権限を削除するのを忘れないでください。例 <tt>chmod 644 wikka.config.php</tt>).もし、何らかの理由で出来ない場合は、新規ファイルに下記のテキストをコピーして、Wikkaディレクトリーに<tt>wikka.config.php</tt>として保存/アップロードしてください。これが完了したら、Wikkaサイトは動作しているはずです。動作していない場合は<a href=\"http://wikka.jsnx.com/WikkaInstallation\">Wikka:WakkaInstallation</a>へ訪問してください。</p>\n");
	?>
	<form action="<?php echo myLocation() ?>?installAction=writeconfig" method="POST">
	<input type="hidden" name="config" value="<?php echo htmlspecialchars(serialize($config2)) ?>" />
	<input type="submit" value="Try again" />
	</form>	
	<?php
	print("<div style=\"background-color: #EEEEEE; padding: 10px 10px;\">\n<xmp>".$configCode."</xmp>\n</div>\n");
}

?>