/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MindIcon {
    private String name;
    private String description;
    private Icon associatedIcon;
    private static Vector mAllIconNames;
    private static Icon iconNotFound;

    public MindIcon(String name) {
        this.setName(name);
        this.associatedIcon = null;
    }

    public String toString() {
        return "Icon_name: " + this.name;
    }

    public String getName() {
        return this.name == null ? "notfound" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription(FreeMindMain frame) {
        String resource = new String("icon_" + this.getName());
        try {
            return frame.getResources().getString(resource);
        }
        catch (Exception ex) {
            System.err.println("Warning - resource string not found:" + resource);
            return this.getName();
        }
    }

    public String getIconFileName() {
        return "images/icons/" + this.getName() + ".png";
    }

    public Icon getIcon(FreeMindMain frame) {
        if (iconNotFound == null) {
            iconNotFound = new ImageIcon(frame.getResource("images/IconNotFound.png"));
        }
        if (this.associatedIcon != null) {
            return this.associatedIcon;
        }
        if (this.name != null) {
            URL imageURL = frame.getResource(this.getIconFileName());
            Icon icon = imageURL == null ? iconNotFound : new ImageIcon(imageURL);
            this.setIcon(icon);
            return icon;
        }
        this.setIcon(iconNotFound);
        return iconNotFound;
    }

    protected void setIcon(Icon _associatedIcon) {
        this.associatedIcon = _associatedIcon;
    }

    public static Vector getAllIconNames() {
        if (mAllIconNames != null) {
            return mAllIconNames;
        }
        Vector<String> mAllIconNames = new Vector<String>();
        mAllIconNames.add("help");
        mAllIconNames.add("messagebox_warning");
        mAllIconNames.add("idea");
        mAllIconNames.add("button_ok");
        mAllIconNames.add("button_cancel");
        mAllIconNames.add("back");
        mAllIconNames.add("forward");
        mAllIconNames.add("attach");
        mAllIconNames.add("ksmiletris");
        mAllIconNames.add("clanbomber");
        mAllIconNames.add("desktop_new");
        mAllIconNames.add("flag");
        mAllIconNames.add("gohome");
        mAllIconNames.add("kaddressbook");
        mAllIconNames.add("knotify");
        mAllIconNames.add("korn");
        mAllIconNames.add("Mail");
        mAllIconNames.add("password");
        mAllIconNames.add("pencil");
        mAllIconNames.add("stop");
        mAllIconNames.add("wizard");
        mAllIconNames.add("xmag");
        mAllIconNames.add("bell");
        mAllIconNames.add("bookmark");
        mAllIconNames.add("penguin");
        mAllIconNames.add("licq");
        return mAllIconNames;
    }
}

