
/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GameSound.cpp,v 1.5 2009/02/16 08:09:30 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// SE δ
////////////////////////////////////////////////////////////////

#define GAME_SOUND_CPP	1
#include "inc.h"

#ifdef D_MFC
# pragma comment( lib, "SDL.lib" )
# pragma comment( lib, "SDLmain.lib" )
# pragma comment( lib, "SDL_mixer.lib" )
#endif

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

GameSound::GameSound()
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	lsDoorOpen.next = NULL;
	lsDoorClose.next = NULL;

	lsShopPay.next = NULL;
	lsShopDrink.next = NULL;

	lsHitMbr.next = NULL;
	lsHitMnstr.next = NULL;
	lsCrtclMbr.next = NULL;
	lsCrtclMnstr.next = NULL;
#endif
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

GameSound::~GameSound()
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	this->close();
#endif
}

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void GameSound::init()
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	// door

	initLsSound( &lsDoorOpen, "door/open/" );
	initLsSound( &lsDoorClose, "door/close/" );

	// shop

	initLsSound( &lsShopPay, "shop/" );
	initLsSound( &lsShopDrink, "shop/drink/" );

	// hit

	initLsSound( &lsHitMbr, "hit/member/" );
	initLsSound( &lsHitMnstr, "hit/monster/" );

	// critical

	initLsSound( &lsCrtclMbr, "hit/member/critical/" );
	initLsSound( &lsCrtclMnstr, "hit/monster/critical/" );
#endif
}

////////////////////////////////////////////////////////////////
// SE ꥹȤν
// LsSound *ls : SE ꥹ
// WSCstring dir : SE ǥ쥯ȥ
////////////////////////////////////////////////////////////////

void GameSound::initLsSound( LsSound *ls, WSCstring dir )
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	// SEθ

	FileList::setStrDirSelSound( STR_DEFAULT_SOUND_DIR_NAME );
	FileList fls;

	//

	ls->next = NULL;
	LsSound *p = ls;
	fls.reset( dir, STR_SOUND_FILE_EXT );
	for( long n = 0; n < LOOP_MAX_1000; n++ ){
		WSCstring path = fls.next();
		if( path.getChars() <= 0 )
			break;

		p->next = new LsSound();
		if( p->next == NULL )
			break;
		p = p->next;

		p->next = NULL;
		p->name = path;

		p->chunk = Mix_LoadWAV( p->name );
	}
#endif
}

////////////////////////////////////////////////////////////////
// SE λ
////////////////////////////////////////////////////////////////

void GameSound::close()
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	Mix_HaltChannel( -1 );
# ifndef	D_MFC
	freeAll();
# endif
#endif
}

////////////////////////////////////////////////////////////////
// Ƥ SE 
////////////////////////////////////////////////////////////////

void GameSound::freeAll()
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	// hit

	freeLsSound( &lsHitMbr );
	freeLsSound( &lsHitMnstr );

	// critical

	freeLsSound( &lsCrtclMbr );
	freeLsSound( &lsCrtclMnstr );
#endif
}

////////////////////////////////////////////////////////////////
//  SE 
// LsSound *ls : SE ꥹ
////////////////////////////////////////////////////////////////

void GameSound::freeLsSound( LsSound *ls )
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	if( ls == NULL )
		return;

	LsSound *p = ls->next;
	for( long n = 0; n < LOOP_MAX_1000; n++ ){
		if( p == NULL )
			break;
		LsSound *next_p = p->next;

		if( p->chunk != NULL )
			Mix_FreeChunk( p->chunk );
		delete p;

		p = next_p;
	}
#endif
}

////////////////////////////////////////////////////////////////
// SE κ
// sound_kind_t kind : SE μ
// long nRepeat : 
////////////////////////////////////////////////////////////////

void GameSound::play( sound_kind_t kind, long nRepeat )
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	switch( kind ){
	case SOUND_KIND_NULL:
		break;
	case SOUND_KIND_DOOR_OPEN:
		playRandm( lsDoorOpen.next, nRepeat );
		break;
	case SOUND_KIND_DOOR_CLOSE:
		playRandm( lsDoorClose.next, nRepeat );
		break;
	case SOUND_KIND_SHOP_PAY:
		playRandm( lsShopPay.next, nRepeat );
		break;
	case SOUND_KIND_SHOP_DRINK:
		playRandm( lsShopDrink.next, nRepeat );
		break;
	case SOUND_KIND_HIT_MBR:
		playRandm( lsHitMbr.next, nRepeat );
		break;
	case SOUND_KIND_HIT_MNSTR:
		playRandm( lsHitMnstr.next, nRepeat );
		break;
	case SOUND_KIND_CRTCL_MBR:
		playRandm( lsCrtclMbr.next, nRepeat );
		break;
	case SOUND_KIND_CRTCL_MNSTR:
		playRandm( lsCrtclMnstr.next, nRepeat );
		break;
	case SOUND_KIND_MAX_N:
		break;
	}
#endif
}

////////////////////////////////////////////////////////////////
// ꥹȤ SE 
// LsSound *p : SE Υꥹ
// long nRepeat : 
////////////////////////////////////////////////////////////////

void GameSound::playRandm( LsSound *p, long nRepeat )
{
#ifdef	HAVE_SDL_SDL_MIXER_H
	Mix_Chunk *playChunk = NULL;
	for( long i = 0; i < LOOP_MAX_1000; i++ ){
		if( p == NULL )
			break;

		if( gui_randm( i + 1 ) == 0 )
			playChunk = p->chunk;

		p = p->next;
	}
	if( playChunk == NULL )
		return;

	if( nRepeat > 0 )
		nRepeat--;
	else
		nRepeat = -1;

	Mix_PlayChannel( -1, playChunk, nRepeat );
#endif
}
