/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: dun-tab.h,v 1.14 2008/10/07 10:27:00 bowkenken Exp $
***************************************************************/

#ifndef	DUN_TAB_H
#define	DUN_TAB_H

/***************************************************************
* µܥǡơ֥
***************************************************************/

/*  */

#define	FACE_ROOM_PTN_ITEM	'$'
#define	FACE_ROOM_PTN_MIMIC	'&'
#define	FACE_ROOM_PTN_TRAP	'^'

/***************************************************************
* ޥåסǡ
***************************************************************/

#if	0
typedef struct {
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	char	ptn[AREA_MAX_Y][AREA_MAX_X * 2];
	sect_t	sect[AREA_MAX_Y][AREA_MAX_X];
} room_ptn_t;
#endif

static room_ptn_t	room_ptn[] = {
	{
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		1, DUN_MAX_LEV_BASE, -1, (rate_t)40,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . . . . . . . ####",
			"##. . . . . . . . . . . . . . . ########",
			"##. . . . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . ##. . . ########",
			"##. . . . . . . . . . . ####. ##########",
			"##. . . . . . . . . ####################",
			"##. ##. . . . . . . . ##################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaaaaaaaabb",
			"baaaaaaaaaaaaaaabbbb",
			"baaaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaabaaabbbb",
			"baaaaaaaaaaabbabbbbb",
			"baaaaaaaaabbbbbbbbbb",
			"babaaaaaaaabbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		5, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaabbbbbbbbbb",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"bbbbbbbbbbbccccccccc",
		}
	},

	{
		10, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"########################################",
		},
		{
			"cccccbbbbbbbbbbccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"bbbbbbaaaaaaaabbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbaaaaaaaabbbbbb",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbbbbbbbbbbccccc",
		}
	},

	{
		15, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"################. . . . ################",
			"############. . . . . . . . ############",
			"########. . . . . . . . . . . . ########",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"####. . . . . . . . . . . . . . . . ####",
			"####. . . . . . . . . . . . . . . . ####",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"####. . . . . . . . . . . . . . . . ####",
			"####. . . . . . . . . . . . . . . . ####",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"########. . . . . . . . . . . . ########",
			"############. . . . . . . . ############",
			"################. . . . ################",
			"########################################",
		},
		{
			"cccccccbbbbbbccccccc",
			"cccccbbbaaaabbbccccc",
			"cccbbbaaaaaaaabbbccc",
			"ccbbaaaaaaaaaaaabbcc",
			"ccbaaaaaaaaaaaaaabcc",
			"cbbaaaaaaaaaaaaaabbc",
			"cbaaaaaaaaaaaaaaaabc",
			"bbaaaaaaaaaaaaaaaabb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbaaaaaaaaaaaaaaaabb",
			"cbaaaaaaaaaaaaaaaabc",
			"cbbaaaaaaaaaaaaaabbc",
			"ccbaaaaaaaaaaaaaabcc",
			"ccbbaaaaaaaaaaaabbcc",
			"cccbbbaaaaaaaabbbccc",
			"cccccbbbaaaabbbccccc",
			"cccccccbbbbbbccccccc",
		}
	},

	{
		20, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . + + ##################",
			"##################+ + ##################",
			"##################+ + ##################",
			"##################+ + . . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaaeefffffffff",
			"bbbbbbbbbeefffffffff",
			"fffffffffeeddddddddd",
			"fffffffffeeccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdddddddddd",
		}
	},

	{
		25, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ##+ + ##. . . . . . . ##",
			"##. . . . . . . ##. . ##. . . . . . . ##",
			"##. . . . . . . ##$ . ##. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"########################################",
		},
		{
			"eeeeeddddddddddeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"ddddddccccccccdddddd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"dcccccccbbbbcccccccd",
			"dcccccccbaabcccccccd",
			"dcccccccbaabcccccccd",
			"dcccccccbbbbcccccccd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"ddddddccccccccdddddd",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeeddddddddddeeeee",
		}
	},

	{
		30, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ########################. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . ##. . . . . . . . . . ##. . . ##",
			"##. . . ##. . . . . $ . . . . ##. . . ##",
			"##. . . ##. . . . $ . . . . . ##. . . ##",
			"##. . . ##. . . . . . . . . . ##. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ########################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"eeeeeeeeeeeeeeeeeeee",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddccbbbbbbbbccddde",
			"edddccbaaaaaabccddde",
			"edddccbaaaaaabccddde",
			"edddbbbaaaaaabbbddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbbbaaaaaabbbddde",
			"edddccbaaaaaabccddde",
			"edddccbaaaaaabccddde",
			"edddccbbbbbbbbccddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"eeeeeeeeeeeeeeeeeeee",
		}
	},

	{
		35, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ $ $ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ $ $ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		40, DUN_MAX_LEV_BASE, -1, (rate_t)5,
		{
			"########################################",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . & . . . . . . & . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . & . . . . . . & . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		45, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ####. $ . ####. . . ####. . . ##",
			"##. . . ####. . . ####. $ . ####. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"######. . . ####. . . . ####. . . ######",
			"######. . . ####. . . . ####. . . ######",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ####. $ . ####. . . ####. . . ##",
			"##. . . ####. . . ####. $ . ####. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaabbaaabbaaabbaaab",
			"baaabbaaabbaaabbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbaaabbaaaabbaaabbb",
			"bbbaaabbaaaabbaaabbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaabbaaabbaaabbaaab",
			"baaabbaaabbaaabbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
};

/***************************************************************
* ܥΥޥåסǡ
***************************************************************/

static room_ptn_t	boss_room_ptn[] = {
	{
		10, 10, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . GH. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . ####. ##. . . . . . ##",
			"##. . . . . . . ##. . ####. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . ################. . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		20, 20, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . . . . . . . . . ####. . ##",
			"##. . ####. . . . . . . . . . ####. . ##",
			"##. . ############. . ####. . ####. . ##",
			"##. . ############. . ####. . ####. . ##",
			"##. . . . . . . . YM. . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . . . . . ####. . . . . . . . . . ##",
			"##. . . . . . ####. . . . . . . . . . ##",
			"##########. . ####. . ############. . ##",
			"##########. . ####. . ############. . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"mmmmmmmmmmmmmmmmmmmm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mmmmmmmmmmmmmmmmmmmm",
		}
	},

	{
		30, 30, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . WU. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . ########. . . . . . . . . . ##",
			"##. . . . . . ########. . . . . . . . ##",
			"##. . . . . . . . ########. . . . . . ##",
			"##. . . . . . . . . . ########. . . ####",
			"##. . . . . . . . . . . . ##############",
			"##. . . . . . . . . . . . . . ##########",
			"##. . . . . . . . . . . . . ############",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		40, 40, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . #@. . ##",
			"##. #@. . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . #@. . . . . . . . ##",
			"##. . . . . . . . . . . . . . #@. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . #@. . . . . . . #@. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . #@. YD. . . . #@. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . #@. . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . #@. . . . . . . . . . . . ##",
			"##. . . . . . . . . . . #@. . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		50, 50, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . BC. . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . ####. . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . ####. . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		60, 60, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . ##. UV. . ##. . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . . ##+ + ##. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaabbaabbaaaaaab",
			"baaaaaabaaaabaaaaaab",
			"baaaaaabbaabbaaaaaab",
			"baaaaaabbaabbaaaaaab",
			"baaaaaabbaabbaaaaaab",
			"baaaaaaabaabaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
};

/***************************************************************
* 饹ܥΥޥåסǡ
***************************************************************/

static room_ptn_t	last_boss_room_ptn[LAST_BOSS_ROOM_PTN_MAX_N] = {
	{
		DUN_LEV_LAST_BOSS, DUN_LEV_LAST_BOSS, -1, _100_PERCENT,
		{
			".0####################################. ",
			"####        . . . . . . .           ####",
			"##        . . . ######. . .           ##",
			"##        . . . ##XX##. . .           ##",
			"##        . . . . . . . . .           ##",
			"##        . . XL. . . XR. .           ##",
			"##          . . . . . . .             ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##    . . . . . . . . . . . . . .     ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  .9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9  ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . .2. . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
		}
	},
	{
		DUN_LEV_LAST_BOSS, DUN_LEV_LAST_BOSS, -1, _100_PERCENT,
		{
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##    . . . . . . . . . . . . . .     ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
		},
		{
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
		}
	},
	{
		DUN_LEV_LAST_BOSS, DUN_LEV_LAST_BOSS, -1, _100_PERCENT,
		{
			"################+ + + + ################",
			"################+ + + + ################",
			"##. . . .b####.b. . . . .c####.c. . . ##",
			"##. . . .b####.b. . . . .c####.c. . . ##",
			"##. . . .b.b.b.b. . . . .c.c.c.c. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##.a.a.a. . . . . . . . . . . . .d.d.d##",
			"######.a. . . . . .1. . . . . . .d######",
			"######.a. . . . . . . . . . . . .d######",
			"##.a.a.a. . . . . . . . . . . . .d.d.d##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . .f.f.f.f. . . . .e.e.e.e. . . ##",
			"##. . . .f####.f. . . . .e####.e. . . ##",
			"##. . . .f####.f. . . . .e####.e. . . ##",
			"########################################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	}
};

/* ޥåס٥ */

map_event_tab_t	last_boss_map_event_tab[] = {
	/* ݥ */
	{ 'a', NULL, },
	{ 'b', NULL, },
	{ 'c', NULL, },
	{ 'd', NULL, },
	{ 'e', NULL, },
	{ 'f', NULL, },

	/* ѡƥи */
	{ MAP_EVENT_LAST_BOSS_APPEAR_PARTY, NULL, },
	/* Ʈϰ */
	{ MAP_EVENT_LAST_BOSS_BATTLE, NULL, },
	/* 饹ܥ٥ȳϰ */
	{ MAP_EVENT_LAST_BOSS_WORDS, begin_last_boss_event, },

	{ '\0', NULL, },
};

#endif	/* DUN_TAB_H */
