/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gfile.c,v 1.182 2008/04/03 09:15:37 bowkenken Exp $
***************************************************************/

/***************************************************************
* ե
***************************************************************/

#define	GFILE_C
#include	"inc.h"

#include	"gfile-ver.h"
#include	"gfile-tab.h"

/***************************************************************/

#define	BUF_LINE_LEN	1024
#define	MAX_TOKEN	10

/***************************************************************
* ե̾
***************************************************************/

#define	STR_FILE_NAME_GAME_RC	"lnlrc"
#define	STR_FILE_NAME_GAME_CONF	"lnl.conf"
#define	STR_FILE_NAME_TOWN_PTN	"town-ptn.xpm"
#define	STR_FILE_NAME_CRSR_PTN	"crsr-ptn.h"

#define	STR_DIR_NAME_GAME_DATA_SAVE	\
		STR_DIR_NAME_GAME STR_SLASH "save"
#define	STR_DIR_NAME_GAME_DATA_TXT	\
		STR_DIR_NAME_GAME_DATA_SAVE STR_SLASH "txt"
#define	STR_DIR_NAME_GAME_DATA_BIN	\
		STR_DIR_NAME_GAME_DATA_SAVE STR_SLASH "bin"
#define	STR_DIR_NAME_GAME_DATA_CNF	\
		STR_DIR_NAME_GAME_DATA_SAVE STR_SLASH "cnf"
#define	STR_DIR_NAME_GAME_DATA_REP	\
		STR_DIR_NAME_GAME_DATA_SAVE STR_SLASH "rep"
#define	STR_DIR_NAME_BUG_REPO	\
		STR_DIR_NAME_GAME STR_SLASH "bug-repo"
#define	STR_FILE_NAME_GAME_DATA_TXT	"save"
#define	STR_FILE_NAME_GAME_DATA_BIN	"save"
#define	STR_FILE_NAME_GAME_DATA_CNF	"conf"
#define	STR_FILE_NAME_GAME_DATA_REP	"rply"

#define	STR_FILE_NAME_BUG_REPO_TXT	"save-bug"
#define	STR_FILE_NAME_BUG_REPO_BIN	"save-bug"
#define	STR_FILE_NAME_BUG_REPO_CNF	"conf-bug"
#define	STR_FILE_NAME_BUG_REPO_REP	"rply-bug"

#define	STR_EXT_NAME_GAME_DATA_TXT	".txt"
#define	STR_EXT_NAME_GAME_DATA_BIN	".bin"
#define	STR_EXT_NAME_GAME_DATA_CNF	".txt"
#define	STR_EXT_NAME_GAME_DATA_REP	".txt"

#define	STR_EXT_NAME_BUG_REPO_TXT	".txt"
#define	STR_EXT_NAME_BUG_REPO_BIN	".bin"
#define	STR_EXT_NAME_BUG_REPO_CNF	".txt"
#define	STR_EXT_NAME_BUG_REPO_REP	".txt"

#define	STR_ENV_HOME	"HOME"
#define	STR_SLASH	"/"
#define	STR_DIR_NAME_CUR	"."
#define	STR_DIR_NAME_GAME	".lnl"
#define	STR_FILE_NAME_TMP	"tmp"

#define	STR_DIR_NAME_USR	"usr"
#define	STR_DIR_NAME_GAME_USR	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_USR

#define	STR_DIR_NAME_BAK	"bak"
#define	STR_EXT_NAME_BAK_1	".%03ld"
#define	STR_EXT_NAME_BAK_2	".bak"
#define	STR_DIR_NAME_GAME_BAK	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_BAK

#define	STR_DIR_NAME_OUT_MAP	"out"
#define	STR_FILE_NAME_OUT_MAP	"map"
#define	STR_EXT_NAME_OUT_MAP	".%03ld"
#define	STR_DIR_NAME_GAME_OUT_MAP	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_OUT_MAP

#define	STR_CRSR_PTN_HEAD	"crsr_ptn_t"

/***************************************************************
* ե̾ΥХѿ
***************************************************************/

static char	dir_name_game[FILE_NAME_MAX_LEN + 1];
static char	dir_name_usr[FILE_NAME_MAX_LEN + 1];
static char	dir_name_game_data_txt[FILE_NAME_MAX_LEN + 1];
static char	dir_name_game_data_bin[FILE_NAME_MAX_LEN + 1];
static char	dir_name_game_data_cnf[FILE_NAME_MAX_LEN + 1];
static char	dir_name_game_data_rep[FILE_NAME_MAX_LEN + 1];
static char	dir_name_bug_repo[FILE_NAME_MAX_LEN + 1];
static char	path_name_game_conf[FILE_NAME_MAX_LEN + 1];
static char	path_name_town_ptn[FILE_NAME_MAX_LEN + 1];
static char	path_name_crsr_ptn[FILE_NAME_MAX_LEN + 1];

/***************************************************************
* Хѿ
***************************************************************/

static char	g_rc_lex_file_name[FILE_NAME_MAX_LEN + 1];
static long	g_rc_lex_line;
static bool_t	g_flg_rc_lex_err;
static long	g_tab_lev;
static long	g_randm_crypt_seed;
static unsigned char	g_crypt_sum;
static long	g_un_c;
static rc_token_t	g_un_token;
static rc_union_t	g_un_union;
static bool_t	g_flg_crypt_txt;

static curs_attr_n_t	g_crnt_attr_n;

static long	g_game_data_save_n;
static replay_kind_t	g_replay_kind_cur;

/***************************************************************
* եν
***************************************************************/

void	init_game_file( void )
{
	char	*home, *s;

	g_game_data_save_n = 0;
	g_randm_seed_save = get_randm_seed();

	/* ۡࡦǥ쥯ȥ */

	home = get_home_dir();

	if( !chk_exist_dir( home ) ){
		print_err( MSG_ERR_HOME_DIR, home );
		exit_game( EXIT_FAILURE );
	}

	/* ࡦǥ쥯ȥ */

	s = init_dir_game( home, STR_DIR_NAME_GAME, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_game, s, FILE_NAME_MAX_LEN );

	s = init_dir_game( home, STR_DIR_NAME_GAME_USR, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_usr, s, FILE_NAME_MAX_LEN );

	init_dir_game( home, STR_DIR_NAME_GAME_BAK, FALSE );
	init_dir_game( home, STR_DIR_NAME_GAME_OUT_MAP, FALSE );
	init_dir_game( home, STR_DIR_NAME_GAME_DATA_SAVE, FALSE );

	init_dir_game( home, STR_DIR_NAME_GAME_DATA_TXT, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_game_data_txt, s, FILE_NAME_MAX_LEN );
	init_dir_game( home, STR_DIR_NAME_GAME_DATA_BIN, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_game_data_bin, s, FILE_NAME_MAX_LEN );
	init_dir_game( home, STR_DIR_NAME_GAME_DATA_CNF, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_game_data_cnf, s, FILE_NAME_MAX_LEN );
	init_dir_game( home, STR_DIR_NAME_GAME_DATA_REP, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_game_data_rep, s, FILE_NAME_MAX_LEN );
	init_dir_game( home, STR_DIR_NAME_BUG_REPO, FALSE );
	if( s != NULL )
		str_nz_cpy( dir_name_bug_repo, s, FILE_NAME_MAX_LEN );

	str_nz_cpy( path_name_game_conf,
			cat_path( dir_name_usr, STR_FILE_NAME_GAME_CONF ),
			FILE_NAME_MAX_LEN );

	str_nz_cpy( path_name_town_ptn,
			cat_path( dir_name_usr, STR_FILE_NAME_TOWN_PTN ),
			FILE_NAME_MAX_LEN );

	str_nz_cpy( path_name_crsr_ptn,
			cat_path( dir_name_usr, STR_FILE_NAME_CRSR_PTN ),
			FILE_NAME_MAX_LEN );

	if( !chk_exist_file( path_name_game_conf ) )
		about_game();
}

/***************************************************************
* ǥ쥯ȥν
* char *home : ۡࡦǥ쥯ȥ
* char *dir : ǥ쥯ȥ
* bool_t flg_GPL : ɽ뤫?
* return : ǥ쥯ȥΥեѥ(顼ʤNULL)
***************************************************************/

char	*init_dir_game( char *home, char *dir, bool_t flg_GPL )
{
	char	*name;

	/* ࡦǥ쥯ȥ */
	name = cat_path( home, dir );

	if( chk_exist_dir( name ) )
		return name;

	/* ̵ GPL ɽ */
	if( flg_GPL )
		about_game();

	/* ̵к */
	if( make_dir( name ) )
		return name;

	return NULL;
}

/***************************************************************
* ۡࡦǥ쥯ȥõ
* return : ۡࡦǥ쥯ȥ
***************************************************************/

char	*get_home_dir( void )
{
	char	*home;

	home = getenv( STR_ENV_HOME );

	/* ̵Хȥǥ쥯ȥ */
	if( (home == NULL) || (home[0] == '\0') )
		home = STR_DIR_NAME_CUR;

	return home;
}

/***************************************************************
* եΥ
* return : ե뤬¸ߤ?
***************************************************************/

bool_t	load_game_conf( void )
{
	ver_t	ver;
	FILE	*fp;
	bool_t	flg_err;

	flg_err = TRUE;

	/* ե뤬¸ߤ뤫å */

	if( !chk_exist_file( path_name_game_conf ) )
		return FALSE;

	/* ե򥪡ץ */

	fp = fopen( path_name_game_conf, "r" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_game_conf, TRUE );

	/* إåɤ߹ */

	if( !load_game_conf_head( fp, &ver ) ){
		fclose( fp );
		return TRUE;
	}

	/* СΥå */

	if( !chk_ver_old( &ver,
			GAME_CONF_VER_MJR,
			GAME_CONF_VER_MNR,
			GAME_CONF_VER_PAT ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		fclose( fp );
		return TRUE;
	}

	/* ǡɤ߹ */

	switch( ver.mjr ){
	case 1:
		load_game_conf_data_ver_1( fp, &ver );
		flg_err = get_rc_lex_err();
		break;
	default:
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		flg_err = TRUE;
		break;
	}

	/* ե򥯥 */

	if( fclose( fp ) == EOF )
		return TRUE;

	/* 顼åɽ */

	if( flg_err ){
		print_msg( FLG_MSG_ERR, MSG_ERR_RC );
		print_msg( FLG_MSG_ERR, "'%s'", get_rc_lex_file_name() );
	}

	return TRUE;
}

/***************************************************************
* եΥإåΥ
* FILE *fp : ե
* ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_head( FILE *fp, ver_t *ver )
{
	const long	len_head = str_len_std( STR_GAME_CONF_HEAD );
	char	*s;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ver->mjr = 0;
	ver->mnr = 0;
	ver->pat = 0;

	s = load_line( fp, TRUE );
	if( strncmp( s, STR_GAME_CONF_HEAD, len_head ) != 0 ){
		print_lex_err( MSG_ERR_LOAD_GAME_HEAD );
		return FALSE;
	}

	/* С󡦥å */

	if( str_len_std( s ) < len_head )
		return FALSE;
	s = &(s[len_head]);

	sscanf( s, " %ld.%ld.%ld ", &(ver->mjr), &(ver->mnr), &(ver->pat) );

	if( (ver->mjr == 0) && (ver->mnr == 0) && (ver->pat == 0) )
		return FALSE;

	/**/

	return TRUE;
}

/***************************************************************
* եΥǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
***************************************************************/

void	load_game_conf_data_ver_1( FILE *fp, const ver_t *ver )
{
	while( 1 ){
		if( !load_game_conf_parse_ver_1( fp, ver ) )
			break;
	}
}

/***************************************************************
* եΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_parse_ver_1( FILE *fp, const ver_t *ver )
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	bool_t	flg_err_exit, flg_err;
	long	i;

	flg_err_exit = FALSE;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	for( i = 0; i < MAX_TOKEN; i++ ){
		t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
		if( t[i] == RC_TOKEN_EOF )
			break;
		if( t[i] == '\n' )
			break;
	}
	if( i >= MAX_TOKEN ){
		for( i = 0; i < LOOP_MAX_100; i++ ){
			rc_token_t	t;
			rc_union_t	u;

			t = rc_lex( fp, &u, flg_err_exit );
			if( t == RC_TOKEN_EOF )
				break;
			if( t == '\n' )
				break;
		}
	}

	flg_err = FALSE;

	if( t[0] == RC_TOKEN_EOF ){
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_NUM)
			&& (t[3] == '\n') ){
		/* foo = n */

		if( !load_game_conf_set_val(
				fp, ver, flg_err_exit,
				u[0].str, u[2].n ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_STR)
			&& (t[3] == '\n') ){
		/* foo = str */

		if( !load_game_conf_set_str(
				fp, ver, flg_err_exit,
				u[0].str, u[2].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_CHAR)
			&& (t[2] == RC_TOKEN_STR)
			&& (t[3] == '\n') ){
		/* foo c str */

		if( !load_game_conf_id_char_str(
				fp, ver, flg_err_exit,
				u[0].str, u[1].c, u[2].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_CHAR)
			&& (t[2] == '\n') ){
		/* foo c */

		if( !load_game_conf_id_char(
				fp, ver, flg_err_exit,
				u[0].str, u[1].c ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == '{')
			&& (t[2] == '\n') ){
		/* foo { */

		if( !load_game_conf_id_brace(
				fp, ver, flg_err_exit,
				u[0].str ) ){
			flg_err = TRUE;
		}
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	}

	if( flg_err ){
		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
		return FALSE;
	} else {
		return TRUE;
	}
}

/***************************************************************
* եѿ˿ͤ
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ѿ̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_set_val(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long val
)
{
	if( strcmp( id, "clk_tck" ) == 0 ){
		return load_game_conf_clk_tck( id, val );

	} else if( strcmp( id, "screen_size_auto" ) == 0 ){
		return load_game_conf_screen_size_auto( id, val );

	} else if( strcmp( id, "screen_size_lines" ) == 0 ){
		return load_game_conf_screen_size_lines( id, val );

	} else if( strcmp( id, "clear_key_buffer_every" ) == 0 ){
		return load_game_conf_clr_key_buf_every( id, val );

	} else if( strcmp( id, "clear_key_buffer_menu" ) == 0 ){
		return load_game_conf_clr_key_buf_menu( id, val );

	} else if( strcmp( id, "space_select" ) == 0 ){
		return load_game_conf_space_select( id, val );

	} else if( strcmp( id, "redraw_every_turn" ) == 0 ){
		return load_game_conf_redraw_every_turn( id, val );

	} else if( strcmp( id, "multiple_message_line" ) == 0 ){
		return load_game_conf_mul_line( id, val );

	} else if( strcmp( id, "vfx_member_cure" ) == 0 ){
		return load_game_conf_vfx_mbr( FLG_VFX_MBR_CURE, val );

	} else if( strcmp( id, "vfx_member_damage" ) == 0 ){
		return load_game_conf_vfx_mbr( FLG_VFX_MBR_DAM, val );

	} else if( strcmp( id, "vfx_member_critical" ) == 0 ){
		return load_game_conf_vfx_mbr( FLG_VFX_MBR_CRTCL, val );

	} else if( strcmp( id, "vfx_member_arrow" ) == 0 ){
		return load_game_conf_vfx_mbr( FLG_VFX_MBR_ARW, val );

	} else if( strcmp( id, "vfx_monster_cure" ) == 0 ){
		return load_game_conf_vfx_mnstr( FLG_VFX_MNSTR_CURE, val );

	} else if( strcmp( id, "vfx_monster_damage" ) == 0 ){
		return load_game_conf_vfx_mnstr( FLG_VFX_MNSTR_DAM, val );

	} else if( strcmp( id, "vfx_monster_critical" ) == 0 ){
		return load_game_conf_vfx_mnstr( FLG_VFX_MNSTR_CRTCL, val );

	} else if( strcmp( id, "vfx_monster_arrow" ) == 0 ){
		return load_game_conf_vfx_mnstr( FLG_VFX_MNSTR_ARW, val );

	} else if( strcmp( id, "vfx_wait" ) == 0 ){
		return load_game_conf_vfx_wait( id, val );

	} else if( strcmp( id, "attribute_underline" ) == 0 ){
		return load_game_conf_attribute_underline( id, val );

	} else if( strcmp( id, "attribute_reverse" ) == 0 ){
		return load_game_conf_attribute_reverse( id, val );

	} else if( strcmp( id, "attribute_blink" ) == 0 ){
		return load_game_conf_attribute_blink( id, val );

	} else if( strcmp( id, "attribute_bold" ) == 0 ){
		return load_game_conf_attribute_bold( id, val );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );
		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եѿʸ
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ѿ̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_set_str(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, char *str
)
{
	if( strcmp( id, "language" ) == 0 ){
		return load_game_conf_lang( id, str );

	} else if( strcmp( id, "scroll" ) == 0 ){
		return load_game_conf_scroll( id, str );

	} else if( strcmp( id, "color" ) == 0 ){
		return load_game_conf_color_name( id, str );

	} else if( strcmp( id, "fg_color" ) == 0 ){
		return load_game_conf_color_fg( id, str );

	} else if( strcmp( id, "bg_color" ) == 0 ){
		return load_game_conf_color_bg( id, str );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եΥѡ(̻ ʸ ʸ)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ̻
* long c : ʸ
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_id_char_str(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long c, char *str
)
{
	if( strcmp( id, "set_key" ) == 0 ){
		return load_game_conf_set_key( id, c, str );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եΥѡ(̻ ʸ)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ̻
* long c : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_id_char(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long c
)
{
	if( strcmp( id, "unset_key" ) == 0 ){
		return load_game_conf_unset_key( id, c );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եΥѡ(̻ ֥졼)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ̻
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_id_brace(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
)
{
	if( strcmp( id, "user_menu" ) == 0 ){
		return load_game_conf_menu( fp, ver, flg_err_exit, id );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եθ
* char *id : ̻
* char *str : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_lang( char *id, char *str )
{
	if( strcmp( str, "" ) == 0 )
		return TRUE;

	reset_msg( trans_lang_id_to_kind( str ) );

	set_flg_lang_ls_priority( TRUE );

	return TRUE;
}

/***************************************************************
* ե clock tick 
* char *id : ̻
* char *str : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_clk_tck( char *id, long val )
{
	long	*tck;

	tck = get_clk_tck();
	if( tck != NULL )
		*tck = val;

	return TRUE;
}

/***************************************************************
* եβ̥ưꤹ뤫ɤ
* char *id : ̻
* long val : ̥ưꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_screen_size_auto( char *id, long val )
{
	set_flg_screen_size_auto( val );

	return TRUE;
}

/***************************************************************
* եβ̥(Կ)
* char *id : ̻
* long val : Կ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_screen_size_lines( char *id, long val )
{
	set_screen_size_lines( val );

	return TRUE;
}

/***************************************************************
* եΥ롦⡼ɤ
* char *id : ̻
* char *str : 롦⡼
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_scroll( char *id, char *str )
{
	if( strcmp( str, "page" ) == 0 ){
		set_scroll_page();
	} else if( strcmp( str, "smooth" ) == 0 ){
		set_scroll_smooth();
	} else if( strcmp( str, "center" ) == 0 ){
		set_scroll_center();
	} else {
		return TRUE;
	}

	return TRUE;
}

/***************************************************************
* եξ˥Хåե򥯥ꥢ뤫
* char *id : ̻
* long val : Хåե򥯥ꥢ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_clr_key_buf_every( char *id, long val )
{
	g_flg_clr_key_buf = (bool_t)val;

	return TRUE;
}

/***************************************************************
* եΥ˥塼˥Хåե򥯥ꥢ뤫
* char *id : ̻
* long val : Хåե򥯥ꥢ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_clr_key_buf_menu( char *id, long val )
{
	g_flg_clr_key_buf_menu = (bool_t)val;

	return TRUE;
}

/***************************************************************
* եΥڡǥ˥塼򤹤
* char *id : ̻
* long val : ڡǥ˥塼򤹤뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_space_select( char *id, long val )
{
	set_flg_space_select( (bool_t)val );

	return TRUE;
}

/***************************************************************
* ե西̤褹
* char *id : ̻
* long val : 褹뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_redraw_every_turn( char *id, long val )
{
	set_redraw_every_turn( (bool_t)val );

	return TRUE;
}

/***************************************************************
* եΥåʣɽ뤫
* char *id : ̻
* long val : ʣɽ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_mul_line( char *id, long val )
{
	set_msg_mul_line( (bool_t)val );

	return TRUE;
}

/***************************************************************
* եΥСλи̤ɽ뤫
* flg_vfx_mbr_t flg : ꤹե饰
* long val : ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_vfx_mbr( flg_vfx_mbr_t flg, long val )
{
	flg_vfx_mbr_t	flg_dst;

	flg_dst = get_flg_vfx_mbr();

	if( val )
		flg_dst |= flg;
	else
		flg_dst &= ~(flg);

	set_flg_vfx_mbr( flg_dst );

	return TRUE;
}

/***************************************************************
* եΥ󥹥λи̤ɽ뤫
* flg_vfx_mnstr_t flg : ꤹե饰
* long val : ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_vfx_mnstr( flg_vfx_mnstr_t flg, long val )
{
	flg_vfx_mbr_t	flg_dst;

	flg_dst = get_flg_vfx_mnstr();

	if( val )
		flg_dst |= flg;
	else
		flg_dst &= ~(flg);

	set_flg_vfx_mnstr( flg_dst );

	return TRUE;
}

/***************************************************************
* եλи̤ɽ֤
* char *id : ̻
* long val : ɽ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_vfx_wait( char *id, long val )
{
	rate_t	ret;

	ret = set_vfx_wait( (rate_t)val );

	/* ͤ褿? */

	if( ret == val )
		return TRUE;
	else
		return FALSE;
}

/***************************************************************
* եꤹ̤ο̾򵭲
* char *id : ̻
* char *name : ̾
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_color_name( char *id, char *name )
{
	if( id == NULL )
		return FALSE;
	if( name == NULL )
		return FALSE;

	if( strcmp( name, "normal" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_NORMAL;
	if( strcmp( name, "rev" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_REV;
	if( strcmp( name, "err" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_ERR;
	if( strcmp( name, "menu_dis" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MENU_DIS;
	if( strcmp( name, "menu_sel" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MENU_SEL;
	if( strcmp( name, "map_item" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MAP_ITEM;
	if( strcmp( name, "map_square" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MAP_SQUARE;
	if( strcmp( name, "map_mnstr" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MAP_MNSTR;
	if( strcmp( name, "map_npc" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MAP_NPC;
	if( strcmp( name, "map_crsr" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MAP_CRSR;
	if( strcmp( name, "fx_mbr_plus" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MBR_PLUS;
	if( strcmp( name, "fx_mbr_minus" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MBR_MINUS;
	if( strcmp( name, "fx_mbr_crtcl" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MBR_CRTCL;
	if( strcmp( name, "fx_mnstr_plus" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MNSTR_PLUS;
	if( strcmp( name, "fx_mnstr_minus" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MNSTR_MINUS;
	if( strcmp( name, "fx_mnstr_crtcl" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_FX_MNSTR_CRTCL;
	if( strcmp( name, "vfx" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_VFX;
	if( strcmp( name, "mbr_1" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_1;
	if( strcmp( name, "mbr_2" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_2;
	if( strcmp( name, "mbr_3" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_3;
	if( strcmp( name, "mbr_4" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_4;
	if( strcmp( name, "mbr_5" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_5;
	if( strcmp( name, "mbr_6" ) == 0 )
		g_crnt_attr_n = CURS_ATTR_N_MBR_6;

	return TRUE;
}

/***************************************************************
* եʿ
* char *id : ̻
* char *color : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_color_fg( char *id, char *color )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;
	if( color == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_fg_color( &(attr[g_crnt_attr_n]),
			cv_name_to_color( color ) );

	return TRUE;
}

/***************************************************************
* եطʿ
* char *id : ̻
* char *color : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_color_bg( char *id, char *color )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;
	if( color == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_bg_color( &(attr[g_crnt_attr_n]),
			cv_name_to_color( color ) );

	return TRUE;
}

/***************************************************************
* եβ̤β°
* char *id : ̻
* long val : °ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_attribute_underline( char *id, long val )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_color_attr( &(attr[g_crnt_attr_n]), (bool_t)val, A_UNDERLINE );

	return TRUE;
}

/***************************************************************
* եβ̤ȿž°
* char *id : ̻
* long val : ȿž°ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_attribute_reverse( char *id, long val )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_color_attr( &(attr[g_crnt_attr_n]), (bool_t)val, A_REVERSE );

	return TRUE;
}

/***************************************************************
* եβ̤°
* char *id : ̻
* long val : °ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_attribute_blink( char *id, long val )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_color_attr( &(attr[g_crnt_attr_n]), (bool_t)val, A_BLINK );

	return TRUE;
}

/***************************************************************
* եβ̤ζĴ°
* char *id : ̻
* long val : Ĵ°ꤹ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_attribute_bold( char *id, long val )
{
	curs_attr_t	*attr;

	if( id == NULL )
		return FALSE;

	attr = get_curs_attr();
	if( attr == NULL )
		return FALSE;

	set_color_attr( &(attr[g_crnt_attr_n]), (bool_t)val, A_BOLD );

	return TRUE;
}

/***************************************************************
* եΥƤ
* char *id : ̻
* long c : 
* char *str : Ƥʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_set_key( char *id, long c, char *str )
{
	set_key_tab_char( c, str );

	return TRUE;
}

/***************************************************************
* եΥƤβ
* char *id : ̻
* long c : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_unset_key( char *id, long c )
{
	set_key_tab_char( c, NULL );

	return TRUE;
}

/***************************************************************
* եΥ桼˥塼
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ̻
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_menu(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
)
{
	long	i;

	clr_user_menu();

	for( i = 0; i < USER_MENU_MAX_N; i++ ){
		if( !load_game_conf_menu_line( fp, ver, flg_err_exit, id ) )
			break;
	}

	return TRUE;
}

/***************************************************************
* եΥ桼˥塼 1 
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ̻
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_conf_menu_line(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
)
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	long	i;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	do {
		t[0] = rc_lex( fp, &u[0], flg_err_exit );
		if( t[0] == RC_TOKEN_EOF )
			break;
		if( t[0] == '\n' )
			break;

		t[1] = rc_lex( fp, &u[1], flg_err_exit );
		if( t[1] == RC_TOKEN_EOF )
			break;
		if( t[1] == '\n' )
			break;

		t[2] = rc_lex( fp, &u[2], flg_err_exit );
		if( t[2] == RC_TOKEN_EOF )
			break;
		if( t[2] == '\n' )
			break;
	} while( 0 );

	if( t[0] == RC_TOKEN_EOF ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_STR)
			&& (t[1] == RC_TOKEN_STR)
			&& (t[2] == '\n') ){
		add_user_menu( u[0].str, u[1].str );
		return TRUE;
	} else if( (t[0] == '}') && (t[1] == '\n') ){
		/* λ */
		return FALSE;
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* եΥХåå
***************************************************************/

void	back_up_game_conf( void )
{
	rename_back_up_file( path_name_game_conf );
}

/***************************************************************
* եΥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf( void )
{
	ver_t	ver;

	ver.mjr = GAME_CONF_VER_MJR;
	ver.mnr = GAME_CONF_VER_MNR;
	ver.pat = GAME_CONF_VER_PAT;

	switch( ver.mjr ){
	case 1:
		return save_game_conf_ver_1( &ver );
		break;
	default:
		return FALSE;
		break;
	}

	return FALSE;
}

/***************************************************************
* եΥ(С 1)
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_ver_1( const ver_t *ver )
{
	FILE	*fp;

	fp = fopen( path_name_game_conf, "w" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_game_conf, TRUE );

	/* header */

	fprintf( fp, "%s", STR_GAME_CONF_HEAD );
	fprintf( fp, "%ld.%ld.%ld\n", ver->mjr, ver->mnr, ver->pat );

	/* contents */

	if( !save_game_conf_contents( fp, ver ) ){
		fclose( fp );
		return FALSE;
	}

	/* footer */

	fputs( "\n", fp );
	fputs( "# end\n", fp );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* եƤΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_contents( FILE *fp, const ver_t *ver )
{
	bool_t	flg_err = FALSE;

	flg_err |= !save_game_conf_language( fp, ver );
	flg_err |= !save_game_conf_frame_rate( fp, ver );
	flg_err |= !save_game_conf_screen_size( fp, ver );
	flg_err |= !save_game_conf_scroll( fp, ver );
	flg_err |= !save_game_conf_flg( fp, ver );
	flg_err |= !save_game_conf_vfx( fp, ver );
	flg_err |= !save_game_conf_color( fp, ver );
	flg_err |= !save_game_conf_key_tab( fp, ver );
	flg_err |= !save_game_conf_user_menu( fp, ver );

	if( flg_err )
		return FALSE;
	else
		return TRUE;
}

/***************************************************************
* եθΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_language( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# language\n" );
	if( get_flg_lang_ls_priority() ){
		fprintf( fp, "language = \"%s\"\n", get_lang_id_next() );
	} else {
		fprintf( fp, "language = \"\"\n" );
	}

	return TRUE;
}

/***************************************************************
* եΥե졼ࡦ졼ȤΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_frame_rate( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# frame rate\n" );
	fprintf( fp, "clk_tck = %ld\n",
			(long)(*get_clk_tck()) );

	return TRUE;
}

/***************************************************************
* եβ̥Υ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_screen_size( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# screen size\n" );

	fprintf( fp, "screen_size_auto = %ld\n",
			(long)chk_flg_screen_size_auto() );
	fprintf( fp, "screen_size_lines = %ld\n",
			(long)get_screen_size_lines() );

	return TRUE;
}

/***************************************************************
* եΥ롦⡼ɤΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_scroll( FILE *fp, const ver_t *ver )
{
	flg_scroll_t	flg;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	flg = get_flg_scroll();

	fprintf( fp, "\n" );
	fprintf( fp, "# scroll mode\n" );
	fprintf( fp, "#  center, smooth or page\n" );

	fprintf( fp, "scroll = " );

	if( chk_flg( flg, FLG_SCROLL_CENTER ) ){
		fprintf( fp, "\"center\"" );
	} else if( chk_flg( flg, FLG_SCROLL_SMOOTH ) ){
		fprintf( fp, "\"smooth\"" );
	} else {
		fprintf( fp, "\"page\"" );
	}

	fprintf( fp, "\n" );

	return TRUE;
}

/***************************************************************
* եγƥե饰Υ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_flg( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# clear key buffer every time\n" );
	fprintf( fp, "clear_key_buffer_every = %ld\n",
			(long)g_flg_clr_key_buf );

	fprintf( fp, "\n" );
	fprintf( fp, "# clear key buffer menu select\n" );
	fprintf( fp, "clear_key_buffer_menu = %ld\n",
			(long)g_flg_clr_key_buf_menu );

	fprintf( fp, "\n" );
	fprintf( fp, "# It's flag that you chose menu with space bar\n" );
	fprintf( fp, "space_select = %ld\n",
			(long)get_flg_space_select() );

	fprintf( fp, "\n" );
	fprintf( fp, "# redraw every turn\n" );
	fprintf( fp, "redraw_every_turn = %ld\n",
			(long)chk_redraw_every_turn() );

	fprintf( fp, "\n" );
	fprintf( fp, "# multiple message line\n" );
	fprintf( fp, "multiple_message_line = %ld\n",
			(long)chk_msg_mul_line() );

	return TRUE;
}

/***************************************************************
* եλи̤Υ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_vfx( FILE *fp, const ver_t *ver )
{
	flg_vfx_mbr_t	flg_mbr;
	flg_vfx_mnstr_t	flg_mnstr;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# vfx\n" );

	/* С */

	flg_mbr = get_flg_vfx_mbr();
	fprintf( fp, "vfx_member_cure = %ld\n",
			(long)chk_flg( flg_mbr, FLG_VFX_MBR_CURE ) );
	fprintf( fp, "vfx_member_damage = %ld\n",
			(long)chk_flg( flg_mbr, FLG_VFX_MBR_DAM ) );
	fprintf( fp, "vfx_member_critical = %ld\n",
			(long)chk_flg( flg_mbr, FLG_VFX_MBR_CRTCL ) );
	fprintf( fp, "vfx_member_arrow = %ld\n",
			(long)chk_flg( flg_mbr, FLG_VFX_MBR_ARW ) );

	/* 󥹥 */

	flg_mnstr = get_flg_vfx_mnstr();
	fprintf( fp, "vfx_monster_cure = %ld\n",
			(long)chk_flg( flg_mnstr, FLG_VFX_MNSTR_CURE ) );
	fprintf( fp, "vfx_monster_damage = %ld\n",
			(long)chk_flg( flg_mnstr, FLG_VFX_MNSTR_DAM ) );
	fprintf( fp, "vfx_monster_critical = %ld\n",
			(long)chk_flg( flg_mnstr, FLG_VFX_MNSTR_CRTCL ) );
	fprintf( fp, "vfx_monster_arrow = %ld\n",
			(long)chk_flg( flg_mnstr, FLG_VFX_MNSTR_ARW ) );

	/*  */

	fprintf( fp, "vfx_wait = %ld\n",
			(long)get_vfx_wait() );

	/**/

	return TRUE;
}

/***************************************************************
* եοΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_color( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# color\n" );

	save_game_conf_color_sub( fp, "normal",
			CURS_ATTR_N_NORMAL );
	save_game_conf_color_sub( fp, "rev",
			CURS_ATTR_N_REV );
	save_game_conf_color_sub( fp, "err",
			CURS_ATTR_N_ERR );
	save_game_conf_color_sub( fp, "menu_dis",
			CURS_ATTR_N_MENU_DIS );
	save_game_conf_color_sub( fp, "menu_sel",
			CURS_ATTR_N_MENU_SEL );
	save_game_conf_color_sub( fp, "map_item",
			CURS_ATTR_N_MAP_ITEM );
	save_game_conf_color_sub( fp, "map_square",
			CURS_ATTR_N_MAP_SQUARE );
	save_game_conf_color_sub( fp, "map_mnstr",
			CURS_ATTR_N_MAP_MNSTR );
	save_game_conf_color_sub( fp, "map_npc",
			CURS_ATTR_N_MAP_NPC );
	save_game_conf_color_sub( fp, "map_crsr",
			CURS_ATTR_N_MAP_CRSR );
	save_game_conf_color_sub( fp, "fx_mbr_plus",
			CURS_ATTR_N_FX_MBR_PLUS );
	save_game_conf_color_sub( fp, "fx_mbr_minus",
			CURS_ATTR_N_FX_MBR_MINUS );
	save_game_conf_color_sub( fp, "fx_mbr_crtcl",
			CURS_ATTR_N_FX_MBR_CRTCL );
	save_game_conf_color_sub( fp, "fx_mnstr_plus",
			CURS_ATTR_N_FX_MNSTR_PLUS );
	save_game_conf_color_sub( fp, "fx_mnstr_minus",
			CURS_ATTR_N_FX_MNSTR_MINUS );
	save_game_conf_color_sub( fp, "fx_mnstr_crtcl",
			CURS_ATTR_N_FX_MNSTR_CRTCL );
	save_game_conf_color_sub( fp, "vfx",
			CURS_ATTR_N_VFX );
	save_game_conf_color_sub( fp, "mbr_1",
			CURS_ATTR_N_MBR_1 );
	save_game_conf_color_sub( fp, "mbr_2",
			CURS_ATTR_N_MBR_2 );
	save_game_conf_color_sub( fp, "mbr_3",
			CURS_ATTR_N_MBR_3 );
	save_game_conf_color_sub( fp, "mbr_4",
			CURS_ATTR_N_MBR_4 );
	save_game_conf_color_sub( fp, "mbr_5",
			CURS_ATTR_N_MBR_5 );
	save_game_conf_color_sub( fp, "mbr_6",
			CURS_ATTR_N_MBR_6 );

	return TRUE;
}

/***************************************************************
* եοΥ֤ζ̽
* FILE *fp : ե
* char *name : ̾
* curs_attr_n_t attr_n : °ֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_color_sub(
	FILE *fp, char *name, curs_attr_n_t attr_n
)
{
	curs_attr_t	*attr;

	if( fp == NULL )
		return FALSE;
	if( name == NULL )
		return FALSE;

	attr = get_curs_attr();

	fprintf( fp, "\n" );
	fprintf( fp, "color = \"%s\"\n", cv_esc_quote_str( name ) );

	fprintf( fp, "\tfg_color = \"%s\"\n",
			cv_esc_quote_str( cv_color_to_name(
			attr[attr_n].fg ) ) );

	fprintf( fp, "\tbg_color = \"%s\"\n",
			cv_esc_quote_str( cv_color_to_name(
			attr[attr_n].bg ) ) );

	fprintf( fp, "\tattribute_underline = %d\n",
			chk_flg( attr[attr_n].attr, A_UNDERLINE ) );
	fprintf( fp, "\tattribute_reverse = %d\n",
			chk_flg( attr[attr_n].attr, A_REVERSE ) );
	fprintf( fp, "\tattribute_blink = %d\n",
			chk_flg( attr[attr_n].attr, A_BLINK ) );
	fprintf( fp, "\tattribute_bold = %d\n",
			chk_flg( attr[attr_n].attr, A_BOLD ) );

	return TRUE;
}

/***************************************************************
* ֹ椫鿧ʸѴ
* int color : ֹ
* return : ʸ
***************************************************************/

char	*cv_color_to_name( int color )
{
	switch( color ){
	case COLOR_BLACK:
		return "black";
	case COLOR_RED:
		return "red";
	case COLOR_GREEN:
		return "green";
	case COLOR_YELLOW:
		return "yellow";
	case COLOR_BLUE:
		return "blue";
	case COLOR_MAGENTA:
		return "magenta";
	case COLOR_CYAN:
		return "cyan";
	case COLOR_WHITE:
		return "white";
	}

	return "error";
}

/***************************************************************
* ʸ󤫤鿧ֹѴ
* int color : ʸ
* return : ֹ
***************************************************************/

int	cv_name_to_color( char *name )
{
	if( name == NULL )
		return COLOR_WHITE;

	if( strcmp( name, "black" ) == 0 )
		return COLOR_BLACK;
	if( strcmp( name, "red" ) == 0 )
		return COLOR_RED;
	if( strcmp( name, "green" ) == 0 )
		return COLOR_GREEN;
	if( strcmp( name, "yellow" ) == 0 )
		return COLOR_YELLOW;
	if( strcmp( name, "blue" ) == 0 )
		return COLOR_BLUE;
	if( strcmp( name, "magenta" ) == 0 )
		return COLOR_MAGENTA;
	if( strcmp( name, "cyan" ) == 0 )
		return COLOR_CYAN;
	if( strcmp( name, "white" ) == 0 )
		return COLOR_WHITE;

	return COLOR_WHITE;
}

/***************************************************************
* եΥ桼˥塼Υ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_user_menu( FILE *fp, const ver_t *ver )
{
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# define user menu\n" );
	fprintf( fp, "# ex.\n" );
	fprintf( fp, "# user_menu {\n" );
	fprintf( fp, "# \t\"text\" \"command\"\n" );
	fprintf( fp, "# \t\"text\" \"command\"\n" );
	fprintf( fp, "# \t...\n" );
	fprintf( fp, "# }\n" );
	fprintf( fp, "\n" );
	fprintf( fp, "user_menu {\n" );

	for( i = 0; i < USER_MENU_MAX_N; i++ ){
		char	*name, *cmd;

		name = get_user_menu_name( i );
		cmd = get_user_menu_cmd( i );
		if( name == NULL )
			break;
		if( cmd == NULL )
			break;

		fprintf( fp, "\t\"%s\"", cv_esc_quote_str( name ) );
		fprintf( fp, "\t\"%s\"", cv_esc_quote_str( cmd ) );
		fprintf( fp, "\n" );
	}

	fprintf( fp, "}\n" );

	return TRUE;
}

/***************************************************************
* եΥƤΥ
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_conf_key_tab( FILE *fp, const ver_t *ver )
{
	char	**key_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	key_tab = get_key_tab();
	if( key_tab == NULL )
		return FALSE;

	fprintf( fp, "\n" );
	fprintf( fp, "# bind key\n" );
	fprintf( fp, "# ex.\n" );
	fprintf( fp, "# set_key 'key' \"command\"\n" );
	fprintf( fp, "# unset_key 'key'\n" );
	fprintf( fp, "\n" );

	for( i = 0; i < KEY_TAB_MAX_N; i++ ){
		char	key[15 + 1];

		if( key_tab[i] != NULL ){
			if( isprint( (char)i ) ){
				sprintf( key, "%c", (char)i );
			} else if( ('A' - '@' <= i) && (i <= 'Z' - '@') ){
				sprintf( key, "^%c", (char)(i + '@') );
			} else {
				sprintf( key, "\\%04o", (char)i );
			}

			fprintf( fp, "set_key '%s'",
					cv_esc_quote_str( key ) );
			fprintf( fp, " \"%s\"\n",
					cv_esc_quote_str( key_tab[i] ) );
		}
	}

	return TRUE;
}

/***************************************************************
* 롦ѥΥ
* crsr_ptn_t *ptn : ѥ󡦥ǡγǼ
* long *max_n : ѥκγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_crsr_ptn( crsr_ptn_t *ptn, long *max_n )
{
	FILE	*fp;
	bool_t	ret;

	*max_n = 0;
	ret = TRUE;

	if( !chk_exist_file( path_name_crsr_ptn ) )
		return FALSE;

	fp = fopen( path_name_crsr_ptn, "r" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_crsr_ptn, TRUE );

	do {
		if( !load_crsr_ptn_head( fp, ptn ) ){
			ret = FALSE;
			break;
		}
		for( *max_n = 0; *max_n < CRSR_PTN_MAX_N; (*max_n)++ ){
			if( !load_crsr_ptn_misc( fp, &(ptn[*max_n]) ) )
				break;
			if( !load_crsr_ptn_data( fp, &(ptn[*max_n]) ) ){
				ret = FALSE;
				break;
			}
		}
	} while( 0 );

	if( fclose( fp ) == EOF )
		return FALSE;

	return ret;
}

/***************************************************************
* 롦ѥΥإåΥ
* FILE *fp : ե
* crsr_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_crsr_ptn_head( FILE *fp, crsr_ptn_t *ptn )
{
	const long	len_head = str_len_std( STR_CRSR_PTN_HEAD );
	char	*s;

	while( 1 ){
		s = load_line_skip_spc( fp, TRUE );
		if( strncmp( s, STR_CRSR_PTN_HEAD, len_head ) == 0 )
			break;
	}

	return TRUE;
}

/***************************************************************
* 롦ѥΤ¾Υ
* FILE *fp : ե
* crsr_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_crsr_ptn_misc( FILE *fp, crsr_ptn_t *ptn )
{
	char	*s;

	s = load_line_skip_spc( fp, TRUE );
	if( strchr( s, '}' ) != NULL )
		return FALSE;

	s = load_line_skip_spc( fp, TRUE );
	sscanf( s, "%ld, %ld", &(ptn->x), &(ptn->y) );

	s = load_line_skip_spc( fp, TRUE );	/* "size" */

	s = load_line_skip_spc( fp, TRUE );
	s = strchr( s, '\'' );
	if( s == NULL )
		return FALSE;
	s++;
	ptn->transmit_chr = s[0];

	return TRUE;
}

/***************************************************************
* 롦ѥΥǡΥ
* FILE *fp : ե
* crsr_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_crsr_ptn_data( FILE *fp, crsr_ptn_t *ptn )
{
	char	*s;
	long	x, y, idx;

	while( 1 ){
		s = load_line_skip_spc( fp, TRUE );
		if( strchr( s, '{' ) != NULL )
			break;
	}

	y = 0;
	while( 1 ){
		if( y >= CRSR_PTN_MAX_Y_LEN )
			break;

		s = load_line_skip_spc( fp, TRUE );
		if( strchr( s, '}' ) != NULL )
			break;

		s = strchr( s, '\"' );
		if( s == NULL )
			continue;
		s++;

		idx = 0;
		for( x = 0; x < CRSR_PTN_MAX_X_LEN * 2; x++ ){
			if( s[idx] == '\"' )
				break;
			if( s[idx] == '\\' )
				idx++;

			ptn->face[y][x] = s[idx];
			idx++;
		}
		ptn->face[y][x] = '\0';
		y++;
	}

	s = load_line_skip_spc( fp, TRUE );	/* "}," */

	return TRUE;
}

/***************************************************************
* ѥΥ
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_town_ptn( town_ptn_t *ptn )
{
	FILE	*fp;

	if( ptn == NULL )
		return FALSE;

	if( !chk_exist_file( path_name_town_ptn ) )
		set_town_ptn_dflt( ptn );

	fp = fopen( path_name_town_ptn, "r" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_town_ptn, TRUE );

	do {
		if( !load_town_ptn_head( fp, ptn ) )
			break;
		if( !load_town_ptn_col( fp, ptn ) )
			break;
		if( !load_town_ptn_map( fp, ptn ) )
			break;

		/*  */

		if( fclose( fp ) == EOF )
			return FALSE;

		return TRUE;
	} while( 0 );

	/* 顼 */

	if( fclose( fp ) == EOF )
		return FALSE;

	back_up_town_ptn();
	set_town_ptn_dflt( ptn );
	save_town_ptn( ptn );

	return FALSE;
}

/***************************************************************
* ѥΥإåΥ
* FILE *fp : ե
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_town_ptn_head( FILE *fp, town_ptn_t *ptn )
{
	long	c;
	char	*s;

	if( !set_town_ptn_init( ptn ) )
		return FALSE;

	while( 1 ){
		c = load_char( fp, TRUE );
		if( c == '\"' )
			break;
	}

	s = load_line( fp, TRUE );
	if( !set_town_ptn_head( ptn, s ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ѥοơ֥Υ
* FILE *fp : ե
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_town_ptn_col( FILE *fp, town_ptn_t *ptn )
{
	long	i;
	long	c;
	char	*s;

	for( i = 0; i < ptn->col_n; i++ ){
		while( 1 ){
			c = load_char( fp, TRUE );
			if( c == '\"' )
				break;
		}

		s = load_line( fp, TRUE );
		if( !set_town_ptn_col( ptn, s ) )
			return FALSE;
	}

	if( !set_town_ptn_col_count( ptn ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ѥΥޥåפΥ
* FILE *fp : ե
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	load_town_ptn_map( FILE *fp, town_ptn_t *ptn )
{
	long	i;
	char	*s, *rchr;
	long	len;

	for( i = 0; i < MAP_MAX_Y; i++ ){
		while( 1 )
			if( load_char( fp, TRUE ) == '\"' )
				break;

		s = load_line( fp, TRUE );

		rchr = strrchr( s, '\"' );
		if( rchr == NULL ){
			print_err( MSG_S, MSG_ERR_LOAD_WQUOTE );
			return FALSE;
		}
		len = rchr - s;
		if( len != MAP_MAX_X * ptn->col_str_len ){
			print_err( MSG_ERR_LOAD_LINE_LEN,
					len, MAP_MAX_X * ptn->col_str_len );
			return FALSE;
		}

		if( !set_town_ptn_map( ptn, s, i ) )
			return FALSE;
	}

	return TRUE;
}

/***************************************************************
* 롦ѥΥ
* crsr_ptn_t *ptn : ѥ󡦥ǡγǼ
* long max_n : ѥκ
* return : 顼̵ä?
***************************************************************/

bool_t	save_crsr_ptn( crsr_ptn_t *ptn, long max_n )
{
	FILE	*fp;
	long	x, y;
	long	i;

	fp = fopen( path_name_crsr_ptn, "w" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_crsr_ptn, TRUE );

	/* header */

	fputs( "#ifndef\tCRSR_PTN_H\n", fp );
	fputs( "#define\tCRSR_PTN_H\n", fp );
	fputs( "\n", fp );
	fputs( "crsr_ptn_t\tcrsr_ptn_dflt[] = {\n", fp );

	for( i = 0; i < max_n; i++ ){
		/* size */

		fputs( "\t{\n", fp );
		fprintf( fp, "\t\t%ld, %ld,\t/* offset x, y */\n",
				ptn[i].x, ptn[i].y );
		fprintf( fp, "\t\t%ld, %ld,\t/* dummy */\n",
				ptn[i].x_len, ptn[i].y_len );
		fprintf( fp, "\t\t'%c',\t/* transmit char */\n",
				(int)ptn[i].transmit_chr );

		/* pattern */

		fputs( "\t\t{\n", fp );
		for( y = 0; y < ptn[i].y_len; y++ ){
			fputs( "\t\t\t\"", fp );
			for( x = 0; x < ptn[i].x_len * 2; x++ ){
				long	c;

				c = ptn[i].face[y][x];

				if( c == '\"' )
					fputc( '\\', fp );

				fputc( c, fp );

				if( c == '\\' )
					fputc( '\\', fp );
			}
			fputs( "\",\n", fp );
		}
		fputs( "\t\t},\n", fp );
		fputs( "\t},\n", fp );
	}

	/* footer */

	fputs( "};\n\n", fp );
	fputs( "#endif\t/* CRSR_PTN_H */\n", fp );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ѥΥХåå
***************************************************************/

void	back_up_town_ptn( void )
{
	rename_back_up_file( path_name_town_ptn );
}

/***************************************************************
* ѥΥ
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
* return : 顼̵ä?
***************************************************************/

bool_t	save_town_ptn( town_ptn_t *ptn )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	FILE	*fp;
	long	col_n;
	long	i, j;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	if( (ptn->col_str_len != 1) && (ptn->col_str_len != 2) )
		return FALSE;

	fp = fopen( path_name_town_ptn, "w" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path_name_town_ptn, TRUE );

	/* header */

	if( ptn->col_str_len == 1 )
		col_n = ptn->col_n;
	else if( ptn->col_str_len == 2 )
		col_n = col_tab_max_n;
	else
		col_n = 0;

	fputs( "/* XPM */\n", fp );
	fputs( "static char\t*town_ptn_xpm[] = {\n", fp );
	fprintf( fp, "\"%d %d %ld %ld\",\n",
			MAP_MAX_X, MAP_MAX_Y, col_n + 1, ptn->col_str_len );

	/* color */

	if( ptn->col_str_len == 1 ){
		fputs( "\" \tc None\",\n", fp );
		save_town_ptn_col_1byte( fp, ptn );
	} else if( ptn->col_str_len == 2 ){
		fputs( "\"  \tc None\",\n", fp );
		save_town_ptn_col_2byte( fp );
	}

	/* data */

	for( i = 0; i < MAP_MAX_Y; i++ ){
		fputs( "\"", fp );
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( ptn->col_str_len == 1 ){
				fprintf( fp, "%c", ptn->map_mjr[i][j] );
			} else if( ptn->col_str_len == 2 ){
				fprintf( fp, "%c%c",
						ptn->map_mjr[i][j],
						ptn->map_mnr[i][j] );
			}
		}
		fputs( "\",\n", fp );
	}
	fputs( "};\n", fp );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ѥοơ֥Υ(1 Х)
* FILE *fp : ե
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
***************************************************************/

void	save_town_ptn_col_1byte( FILE *fp, town_ptn_t *ptn )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	i, j;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	for( i = 0; i < TOWN_PTN_COL_MAX_N; i++){
		if( ptn->col_mjr[i] == '\0' )
			continue;
		if( ptn->col_mnr[i] == '\0' )
			continue;

		for( j = 0; j < col_tab_max_n; j++){
			if( col_tab[j].mjr != ptn->col_mjr[i] )
				continue;
			if( col_tab[j].mnr != ptn->col_mnr[i] )
				continue;

			fprintf( fp, "\"%c\tc #%06lx\",\n", (char)i,
					col_tab[j].col_code );
		}
	}
}

/***************************************************************
* ѥοơ֥Υ(2 Х)
* FILE *fp : ե
* town_ptn_t *ptn : ѥ󡦥ǡγǼ
***************************************************************/

void	save_town_ptn_col_2byte( FILE *fp )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	i;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	for( i = 0; i < col_tab_max_n; i++){
		fprintf( fp, "\"%c%c\tc #%06lx\",\n",
				col_tab[i].mjr, col_tab[i].mnr,
				col_tab[i].col_code );
	}
}

/***************************************************************
* ࡦǡΥ
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data( bool_t flg_txt, long n )
{
	FILE	*fp;
	ver_t	ver;

	/* եΥץ */

	fp = open_game_data( 'r', n, flg_txt );
	if( fp == NULL )
		return FALSE;

	/* إåɤ߹ */

	set_flg_crypt_txt( TRUE );
	load_game_data_head_ver_1( fp, &ver, flg_txt );
	set_flg_crypt_txt( flg_txt );

	/* СΥå */

	if( !chk_ver_old( &ver,
			GAME_DATA_VER_MJR,
			GAME_DATA_VER_MNR,
			GAME_DATA_VER_PAT ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		fclose( fp );
		return FALSE;
	}

	/* ǡν */

	reset_load_game_data();

	/* ǡɤ߹ */

	switch( ver.mjr ){
	case 1:
		if( !load_game_data_ver_1( fp, &ver, flg_txt ) ){
			fclose( fp );
			return FALSE;
		}
		break;
	default:
		fclose( fp );

		print_lex_err( MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_lex_err( MSG_ERR_FILE_VER_B );

		exit_game( EXIT_FAILURE );
		return FALSE;
		break;
	}

	/* եΥ */

	if( fclose( fp ) == EOF )
		return FALSE;

	/* Сʥå */

	if( chk_ver_old( &ver, 1, 0, 3 ) )
		ver_up_game_data_1_0_4();

	if( chk_ver_old( &ver, 1, 1, 0 ) )
		ver_up_game_data_1_1_1();

	/* ǡå */

	if( !chk_load_game_data() )
		return FALSE;

	/* Υ */

	if( !chk_ver_old( &ver, 1, 0, 8 ) ){
		if( !load_game_data_cnf( n ) ){
			return FALSE;
		}
	} else {
		ver_up_auto_mark_1_1_3();
	}

	bgn_reg_replay( n );

	return TRUE;
}

/***************************************************************
* Υ
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_cnf( long n )
{
	FILE	*fp;
	ver_t	ver;
	bool_t	flg_txt = TRUE;

	/* եΥץ */

	fp = open_game_data_cnf( 'r', n );
	if( fp == NULL )
		return TRUE;	/* FALSE ǤϤʤ */

	/* إåɤ߹ */

	set_flg_crypt_txt( TRUE );
	load_game_data_head_ver_1( fp, &ver, flg_txt );
	set_flg_crypt_txt( flg_txt );

	/* СΥå */

	if( !chk_ver_old( &ver,
			GAME_DATA_VER_MJR,
			GAME_DATA_VER_MNR,
			GAME_DATA_VER_PAT ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		fclose( fp );
		return FALSE;
	}

	/* ǡν */

	reset_load_game_data_cnf();

	/* ǡɤ߹ */

	switch( ver.mjr ){
	case 1:
		if( !load_game_data_cnf_ver_1( fp, &ver ) ){
			fclose( fp );
			return FALSE;
		}
		break;
	default:
		fclose( fp );

		print_lex_err( MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_lex_err( MSG_ERR_FILE_VER_B );

		exit_game( EXIT_FAILURE );
		return FALSE;
		break;
	}

	/* Сʥå */

	if( chk_ver_old( &ver, 1, 0, 3 ) )
		ver_up_game_data_1_0_4();

	if( chk_ver_old( &ver, 1, 1, 0 ) )
		ver_up_game_data_1_1_1();

	if( chk_ver_old( &ver, 1, 1, 2 ) )
		ver_up_game_data_1_1_3();

	/* եΥ */

	if( fclose( fp ) == EOF )
		return FALSE;

	/* ǡå */

	if( !chk_load_game_data_cnf() )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥСѴ
***************************************************************/

void	ver_up_game_data_1_0_4( void )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		ver_up_auto_mark_1_0_4( i );
	}
}

/***************************************************************
* ࡦǡΥСѴ
***************************************************************/

void	ver_up_game_data_1_1_1( void )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		ver_up_auto_mark_1_1_1( i );
	}
}

/***************************************************************
* ࡦǡΥСѴ
***************************************************************/

void	ver_up_game_data_1_1_3( void )
{
	ver_up_auto_mark_1_1_3();
}

/***************************************************************
* ࡦǡΥν
***************************************************************/

void	reset_load_game_data( void )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	pet_t	**ls_pet = get_ls_pet();
	long	i;

	/* դȥν */

	set_game_day( 0 );
	set_turn( 0 );

	/* 饯ǡν */

	for( i = LS_MBR_MAX_N - 1; i >= 0; i-- ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		remove_mbr( ls_mbr[i] );
	}

	for( i = LS_PET_MAX_N - 1; i >= 0; i-- ){
		if( ls_pet[i] == NULL )
			continue;
		if( chk_flg( ls_pet[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		remove_pet( ls_pet[i] );
	}
}

/***************************************************************
* Υν
***************************************************************/

void	reset_load_game_data_cnf( void )
{
}

/***************************************************************
* ࡦǡΥɻΥå
* return : ǡ˰۾郎̵ä?
***************************************************************/

bool_t	chk_load_game_data( void )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	pet_t	**ls_pet = get_ls_pet();
	long	i, j;

	/* PC ΥǡʣƤʤå */

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		for( j = 0; j < LS_MBR_MAX_N; j++ ){
			if( ls_mbr[j] == NULL )
				continue;
			if( chk_flg( ls_mbr[j]->stat, FLG_STAT_NOT_EXIST ) )
				continue;
			if( i == j )
				continue;

			if( ls_mbr[i]->id1 != ls_mbr[j]->id1 )
				continue;
			if( ls_mbr[i]->id2 != ls_mbr[j]->id2 )
				continue;

			print_lex_err( MSG_S, MSG_ERR_RC_PARSE_CHR_ID );
			exit_game( EXIT_FAILURE );
			return FALSE;
		}
	}

	/* ڥåȤΥǡʣƤʤå */

	for( i = 0; i < LS_PET_MAX_N; i++ ){
		if( ls_pet[i] == NULL )
			continue;
		if( chk_flg( ls_pet[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		for( j = 0; j < LS_PET_MAX_N; j++ ){
			if( ls_pet[j] == NULL )
				continue;
			if( chk_flg( ls_pet[j]->stat, FLG_STAT_NOT_EXIST ) )
				continue;
			if( i == j )
				continue;

			if( ls_pet[i]->id1 != ls_pet[j]->id1 )
				continue;
			if( ls_pet[i]->id2 != ls_pet[j]->id2 )
				continue;

			print_lex_err( MSG_S, MSG_ERR_RC_PARSE_CHR_ID );
			exit_game( EXIT_FAILURE );
			return FALSE;
		}
	}

	return TRUE;
}

/***************************************************************
* ΥɻΥå
* return : ǡ˰۾郎̵ä?
***************************************************************/

bool_t	chk_load_game_data_cnf( void )
{
	return TRUE;
}

/***************************************************************
* ࡦǡΥإåΥ(С 1)
* FILE *fp : ե
* ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_head_ver_1( FILE *fp, ver_t *ver, bool_t flg_txt )
{
	const long	len_head = str_len_std( STR_GAME_DATA_HEAD );
	char	*s;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ver->mjr = 0;
	ver->mnr = 0;
	ver->pat = 0;

	s = load_line( fp, TRUE );
	if( strncmp( s, STR_GAME_DATA_HEAD, len_head ) != 0 ){
		print_lex_err( MSG_S, MSG_ERR_LOAD_GAME_HEAD );
		return FALSE;
	}

	/* С󡦥å */

	if( str_len_std( s ) < len_head )
		return FALSE;
	s = &(s[len_head]);

	sscanf( s, " %ld.%ld.%ld ", &(ver->mjr), &(ver->mnr), &(ver->pat) );

	if( (ver->mjr == 0) && (ver->mnr == 0) && (ver->pat == 0) )
		return FALSE;

	/**/

	s = load_line( fp, TRUE );
	sscanf( s, "%ld:", &g_game_data_save_n );

	reset_load_crypt( fp, flg_txt );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_ver_1( FILE *fp, const ver_t *ver, bool_t flg_txt )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	clr_map_all_mbr();
	clr_map_all_pet();

	while( 1 ){
		if( !load_game_data_parse_ver_1( fp, ver, flg_txt ) )
			break;
	}

	return TRUE;
}

/***************************************************************
* Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_cnf_ver_1( FILE *fp, const ver_t *ver )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	while( 1 ){
		if( !load_game_data_cnf_parse_ver_1( fp, ver ) )
			break;
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : ѡ³뤫?
***************************************************************/

bool_t	load_game_data_parse_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	bool_t	flg_err_exit, flg_err;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	flg_err_exit = TRUE;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	for( i = 0; i < MAX_TOKEN; i++ ){
		t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
		if( t[i] == RC_TOKEN_EOF )
			break;
		if( t[i] == '\n' )
			break;
		if( t[i] == RC_TOKEN_ADD_OP ){
			long	sign_n = +1;

			for( j = i + 1; j < MAX_TOKEN; j++ ){
				if( u[i].c == '-' )
					sign_n = -sign_n;

				t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
				if( t[i] != RC_TOKEN_ADD_OP ){
					break;
				}
			}

			if( t[i] == RC_TOKEN_NUM ){
				u[i].n *= sign_n;
			}
		}
	}
	if( i >= MAX_TOKEN ){
		for( i = 0; i < LOOP_MAX_100; i++ ){
			rc_token_t	t;
			rc_union_t	u;

			t = rc_lex( fp, &u, flg_err_exit );
			if( t == RC_TOKEN_EOF )
				break;
			if( t == '\n' )
				break;
		}
	}

	flg_err = FALSE;

	if( t[0] == RC_TOKEN_EOF ){
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_NUM)
			&& (t[3] == '\n') ){
		/* foo = n */

		if( !load_game_data_id_eq_num_ver_1(
				fp, ver, flg_txt,
				u[0].str, u[2].n ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_NUM)
			&& (t[2] == RC_TOKEN_EQ_OP)
			&& (t[3] == RC_TOKEN_STR)
			&& (t[4] == '\n') ){
		/* foo n = "bar" */

		if( !load_game_data_id_num_eq_str_ver_1(
				fp, ver, flg_txt,
				u[0].str, u[1].n, u[3].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == '{')
			&& (t[3] == '\n') ){
		/* foo = { */

		if( !load_game_data_block_ver_1(
				fp, ver, flg_txt,
				u[0].str, 0 ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_NUM)
			&& (t[2] == RC_TOKEN_EQ_OP)
			&& (t[3] == '{')
			&& (t[4] == '\n') ){
		/* foo n = { */

		if( !load_game_data_block_ver_1(
				fp, ver, flg_txt,
				u[0].str, u[1].n ) ){
			flg_err = TRUE;
		}
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	}

	if( flg_err ){
		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
		return FALSE;
	} else {
		return TRUE;
	}
}

/***************************************************************
* Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : ѡ³뤫?
***************************************************************/

bool_t	load_game_data_cnf_parse_ver_1(
	FILE *fp, const ver_t *ver
)
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	bool_t	flg_err_exit, flg_err;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	flg_err_exit = TRUE;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	for( i = 0; i < MAX_TOKEN; i++ ){
		t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
		if( t[i] == RC_TOKEN_EOF )
			break;
		if( t[i] == '\n' )
			break;
	}
	if( i >= MAX_TOKEN ){
		for( i = 0; i < LOOP_MAX_100; i++ ){
			rc_token_t	t;
			rc_union_t	u;

			t = rc_lex( fp, &u, flg_err_exit );
			if( t == RC_TOKEN_EOF )
				break;
			if( t == '\n' )
				break;
		}
	}

	flg_err = FALSE;

	if( t[0] == RC_TOKEN_EOF ){
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_NUM)
			&& (t[3] == '\n') ){
		/* foo = n */

		if( !load_game_conf_set_val(
				fp, ver, flg_err_exit,
				u[0].str, u[2].n ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_STR)
			&& (t[3] == '\n') ){
		/* foo = str */

		if( !load_game_conf_set_str(
				fp, ver, flg_err_exit,
				u[0].str, u[2].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_CHAR)
			&& (t[2] == RC_TOKEN_STR)
			&& (t[3] == '\n') ){
		/* foo c str */

		if( !load_game_conf_id_char_str(
				fp, ver, flg_err_exit,
				u[0].str, u[1].c, u[2].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_CHAR)
			&& (t[2] == '\n') ){
		/* foo c */

		if( !load_game_conf_id_char(
				fp, ver, flg_err_exit,
				u[0].str, u[1].c ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == '{')
			&& (t[2] == '\n') ){
		/* foo { */

		if( !load_game_conf_id_brace(
				fp, ver, flg_err_exit,
				u[0].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_NUM)
			&& (t[2] == RC_TOKEN_EQ_OP)
			&& (t[3] == RC_TOKEN_STR)
			&& (t[4] == '\n') ){
		/* foo n = "bar" */

		if( !load_game_data_cnf_id_num_eq_str_ver_1(
				fp, ver,
				u[0].str, u[1].n, u[3].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == '{')
			&& (t[3] == '\n') ){
		/* foo = { */

		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_NUM)
			&& (t[2] == RC_TOKEN_EQ_OP)
			&& (t[3] == '{')
			&& (t[4] == '\n') ){
		/* foo n = { */

		if( !load_game_data_cnf_block_ver_1(
				fp, ver,
				u[0].str, u[1].n ) ){
			flg_err = TRUE;
		}
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	}

	if( flg_err ){
		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
		return FALSE;
	} else {
		return TRUE;
	}
}

/***************************************************************
* ࡦǡΥѡ(̻ =  : С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* char *id : ̻
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_id_eq_num_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;

	if( strcmp( id, "randm_seed" ) == 0 ){
		srandm( n );
		g_randm_seed_save = n;
		return TRUE;
	} else if( strcmp( id, "dun_lev" ) == 0 ){
		dun_t	*dun;

		dun = get_dun();
		dun->lev = n;
		return TRUE;
	} else if( strcmp( id, "day" ) == 0 ){
		set_game_day( n );
		return TRUE;
	} else if( strcmp( id, "turn" ) == 0 ){
		set_turn( n );
		return TRUE;
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* ࡦǡΥѡ(̻  = ʸ : С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* char *id : ̻
* long n : 
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_id_num_eq_str_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n, char *str
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;
	if( str == NULL )
		return FALSE;

	if( strcmp( id, "auto_mark_title" ) == 0 ){
		return( load_game_data_auto_mark_ttl_ver_1(
				fp, ver, flg_txt, n, str ) );
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* Υѡ(̻  = ʸ : С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* char *id : ̻
* long n : 
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_cnf_id_num_eq_str_ver_1(
	FILE *fp, const ver_t *ver,
	char *id, long n, char *str
)
{
	bool_t	flg_txt = TRUE;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;
	if( str == NULL )
		return FALSE;

	if( strcmp( id, "auto_mark_title" ) == 0 ){
		return( load_game_data_auto_mark_ttl_ver_1(
				fp, ver, flg_txt, n, str ) );
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* ࡦǡμưޡΥȥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : ưޡֹ
* char *ttl : ȥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_auto_mark_ttl_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n, char *ttl
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ttl == NULL )
		return FALSE;

	if( n < 0 )
		return FALSE;
	if( n > AUTO_MARK_MAX_N - 1 )
		n = AUTO_MARK_MAX_N - 1;

	str_nz_cpy( get_msg_ttl_auto_mark_code( n ), ttl,
			MSG_TTL_AUTO_MARK_MAX_LEN );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ֥åΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* char *id : ̻
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_block_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;

	if( strcmp( id, "class" ) == 0 ){
		return( load_game_data_class_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "member" ) == 0 ){
		return( load_game_data_mbr_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "pet" ) == 0 ){
		return( load_game_data_pet_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "potion_color" ) == 0 ){
		return( load_game_data_potion_color_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "scroll_ttl_syllable" ) == 0 ){
		return( load_game_data_scroll_ttl_syllable_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "wand_material" ) == 0 ){
		return( load_game_data_stick_material_ver_1(
				fp, ver, flg_txt, STICK_KIND_WAND ) );

	} else if( strcmp( id, "rod_material" ) == 0 ){
		return( load_game_data_stick_material_ver_1(
				fp, ver, flg_txt, STICK_KIND_ROD ) );

	} else if( strcmp( id, "staff_material" ) == 0 ){
		return( load_game_data_stick_material_ver_1(
				fp, ver, flg_txt, STICK_KIND_STAFF ) );

	} else if( strcmp( id, "ring_material" ) == 0 ){
		return( load_game_data_acce_material_ver_1(
				fp, ver, flg_txt, ACCE_KIND_RING ) );

	} else if( strcmp( id, "amulet_material" ) == 0 ){
		return( load_game_data_acce_material_ver_1(
				fp, ver, flg_txt, ACCE_KIND_AMULET ) );

	} else if( strcmp( id, "necklace_material" ) == 0 ){
		return( load_game_data_acce_material_ver_1(
				fp, ver, flg_txt, ACCE_KIND_NECKLACE ) );

	} else if( strcmp( id, "potion_identified" ) == 0 ){
		return( load_game_data_potion_identified_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "scroll_identified" ) == 0 ){
		return( load_game_data_scroll_identified_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "member_item" ) == 0 ){
		return( load_game_data_item_mbr_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "auto_mark" ) == 0 ){
		return( load_game_data_auto_mark_ls_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "auto_mark_appoint_item" ) == 0 ){
		return( load_game_data_auto_mark_appoint_item_ls_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "flg_srch" ) == 0 ){
		return( load_game_data_flg_srch_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "spell" ) == 0 ){
		return( load_game_data_spell_ls_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "member_formation" ) == 0 ){
		return( load_game_data_mbr_formation_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "pet_formation" ) == 0 ){
		return( load_game_data_pet_formation_ver_1(
				fp, ver, flg_txt ) );

	} else if( strcmp( id, "request" ) == 0 ){
		return( load_game_data_request_ver_1(
				fp, ver, flg_txt ) );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* Υ֥åΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* char *id : ̻
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_cnf_block_ver_1(
	FILE *fp, const ver_t *ver,
	char *id, long n
)
{
	bool_t	flg_txt = TRUE;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;

	if( strcmp( id, "auto_mark" ) == 0 ){
		return( load_game_data_auto_mark_ls_ver_1(
				fp, ver, flg_txt, n ) );

	} else if( strcmp( id, "auto_mark_appoint_item" ) == 0 ){
		return( load_game_data_auto_mark_appoint_item_ls_ver_1(
				fp, ver, flg_txt, n ) );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* ࡦǡΥ饹Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_class_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
)
{
	class_t	*p;
	long	tmp_n;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= CLASS_MAX_N )
		return FALSE;

	p = get_class_tab();
	if( p == NULL )
		return FALSE;

	p[n].n_name = N_MSG_NULL;

	if( !load_game_data_s( fp, p[n].name, CLASS_NAME_MAX_LEN ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	p[n].dflt = (class_dflt_t)tmp_n;


	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p[n].abl_rate[i] = tmp_n;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥСΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
)
{
	mbr_t	**ls_mbr = get_ls_mbr();

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= LS_MBR_MAX_N )
		return FALSE;

	return( load_game_data_chr_ver_1( fp, ver, flg_txt, ls_mbr[n] ) );
}

/***************************************************************
* ࡦǡΥڥåȤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_pet_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
)
{
	pet_t	**ls_pet = get_ls_pet();

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	if( n < 0 )
		return FALSE;
	if( n >= PET_MAX_N )
		return FALSE;
	if( ls_pet[n] == NULL )
		return FALSE;

	make_pet_alloc( ls_pet[n], 10, MNSTR_KIND_PYON_PYON );

	return( load_game_data_chr_ver_1( fp, ver, flg_txt, ls_pet[n] ) );
}

/***************************************************************
* ࡦǡΥ饯Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : 
* chr_t *chr : 饯
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_chr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
)
{
	mbr_t	**ls_mbr = get_ls_mbr();
	long	tmp_n;
	char	tmp_c;
	long	i, j;
	move_ls_kind_t	k;
	long	max_idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->kind = trans_idx_to_chr_kind( tmp_n );

	if( !load_game_data_s( fp, chr->name, CHR_NAME_MAX_LEN ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->id1 = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->id2 = tmp_n;

	/* long	mbr_n, ls_mbr_n; */
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->mbr_n = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->ls_mbr_n = tmp_n;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	chr->face.mjr = tmp_c;
	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	chr->face.mnr = tmp_c;
	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	chr->face.mjr_org = tmp_c;
	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	chr->face.mnr_org = tmp_c;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->race.main = trans_idx_to_main_race_kind( tmp_n );
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->race.sub = trans_idx_to_sub_race_kind( tmp_n );
	if( !load_game_data_s( fp, chr->race.name, RACE_NAME_MAX_LEN ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->sex.cur = trans_idx_to_sex_kind( tmp_n );
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->sex.org = trans_idx_to_sex_kind( tmp_n );
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->x = MAP_DEL_X;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->y = MAP_DEL_Y;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->pre_x = MAP_DEL_X;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->pre_y = MAP_DEL_Y;

	if( !load_game_data_n( fp, &(chr->dx) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->dy) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->move.speed.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->move.speed.rate_org) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->move.speed.n) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->move.force_kind = trans_idx_to_move_kind( tmp_n );

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	max_idx = sizeof( g_move_ls_trans_tab )
			/ sizeof( g_move_ls_trans_tab[0] );
	for( i = 0; i < max_idx; i++ ){
		if( !load_game_data_skip_c( fp, '{', FALSE ) )
			break;

		k = trans_idx_to_move_ls_kind( i );

		for( j = 0; j < MOVE_LS_MAX_N; j++ ){
			if( !load_game_data_skip_c( fp, '{', FALSE ) )
				break;

			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;
			chr->move.ls[k][j].kind = trans_idx_to_move_kind(
					tmp_n );

			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;
			chr->move.ls[k][j].ratio = tmp_n;

			if( !load_game_data_skip_c( fp, '}', TRUE ) )
				return FALSE;
			if( !load_game_data_skip_c( fp, ',', TRUE ) )
				return FALSE;
		}

		/* Сʥåפ¿ʤä硢­ʤʬ䤦 */

		for( ; j < MOVE_LS_MAX_N; j++ ){
			chr->move.ls[k][j].kind = MOVE_KIND_NULL;
			chr->move.ls[k][j].ratio = (ratio_t)0;
		}

		/* СʥåפǾʤä硢¿ʬɤФ */

		for( j = 0; j < LOOP_MAX_100; j++ ){
			if( !load_game_data_skip_c( fp, '{', FALSE ) )
				break;

			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;
			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;

			if( !load_game_data_skip_c( fp, '}', TRUE ) )
				return FALSE;
			if( !load_game_data_skip_c( fp, ',', TRUE ) )
				return FALSE;
		}

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	/* Сʥåפ¿ʤä硢­ʤʬ䤦 */

	for( ; i < max_idx; i++ ){
		k = trans_idx_to_move_ls_kind( i );

		for( j = 0; j < MOVE_LS_MAX_N; j++ ){
			chr->move.ls[k][j].kind = MOVE_KIND_NULL;
			chr->move.ls[k][j].ratio = (ratio_t)0;
		}
	}

	/* СʥåפǾʤä硢¿ʬɤФ */

	for( i = 0; i < LOOP_MAX_100; i++ ){
		if( !load_game_data_skip_c( fp, '{', FALSE ) )
			break;

		for( j = 0; j < LOOP_MAX_100; j++ ){
			if( !load_game_data_skip_c( fp, '{', FALSE ) )
				break;

			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;
			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;

			if( !load_game_data_skip_c( fp, '}', TRUE ) )
				return FALSE;
			if( !load_game_data_skip_c( fp, ',', TRUE ) )
				return FALSE;
		}

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(chr->gold) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(chr->dun_max_lev_floor) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->dun_max_lev_base) ) )
		return FALSE;

	/* trgt_t	trgt; */
	/* act_t	act, pre_act; */

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->flg_chr = tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->flg_map = tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->attitude = trans_idx_to_attitude_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	if( tmp_n > -1 )
		chr->owner = ls_mbr[tmp_n];
	else
		chr->owner = NULL;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->stat = tmp_n;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		if( !load_game_data_skip_c( fp, '{', TRUE ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->abl.exp[i].n) ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->abl.exp[i].max) ) )
			return FALSE;

		if( !load_game_data_n( fp, &(chr->abl.lev[i].n) ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->abl.lev[i].max) ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->abl.lev[i].add) ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->abl.hp.n) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->abl.hp.max) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->abl.mp.n) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->abl.mp.max) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(chr->class_n) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		if( !load_game_data_skip_c( fp, '{', TRUE ) )
			return FALSE;

		if( !load_game_data_n( fp, &(chr->resi[i].n) ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->resi[i].max) ) )
			return FALSE;
		if( !load_game_data_n( fp, &(chr->resi[i].add_n) ) )
			return FALSE;

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(chr->add_def) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->add_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->add_ac) ) )
		return FALSE;

	if( !load_game_data_chr_fx_all_ver_1(
			fp, ver, flg_txt, chr ) ){
		return FALSE;
	}

	if( !load_game_data_fx_data_ver_1(
			fp, ver, flg_txt, &(chr->fx_data) ) ){
		return FALSE;
	}

	if( !load_game_data_modifier_ver_1(
			fp, ver, flg_txt, &(chr->modifier_equip) ) ){
		return FALSE;
	}
	if( !load_game_data_modifier_ver_1(
			fp, ver, flg_txt, &(chr->modifier_fx) ) ){
		return FALSE;
	}

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->mnstr_kind = trans_idx_to_mnstr_kind( tmp_n );

	if( chr->kind == CHR_KIND_MBR )
		chr->mnstr_tab = NULL;
	else
		chr->mnstr_tab = get_mnstr_tab( chr->mnstr_kind, 0 );

	/* ¾ */

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	chr->work.flg = tmp_n;

	if( !load_game_data_n( fp, &(chr->work.caught) ) )
		return FALSE;

	chr->work.catch_chr = NULL;
	chr->work.link_chr = NULL;

	if( !load_game_data_n( fp, &(chr->work.teleport_n) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->work.teleport_party_n) ) )
		return FALSE;

	if( !chk_ver_old( ver, 1, 1, 3 ) ){
		request_t	*req_ls = get_request_ls();

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;

		if( tmp_n <= -1 )
			chr->work.request = NULL;
		else if( tmp_n >= REQUEST_MAX_N )
			chr->work.request = NULL;
		else
			chr->work.request = &(req_ls[tmp_n]);
	}

	if( !load_game_data_n( fp, &(chr->work.towner_dx) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(chr->work.towner_dy) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(chr->work.dismissal_turn) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	/**/

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	clr_chr_trgt_act( chr, TRUE );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饯Ƥθ̤Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* chr_t *chr : 饯
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_chr_fx_all_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	if( load_game_data_skip_c( fp, '}', FALSE ) ){
		/* ǡξ */

		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;

		return TRUE;
	}

	while( 1 ){
		if( !load_game_data_skip_c( fp, '{', FALSE ) )
			break;

		if( !load_game_data_chr_fx_ver_1( fp, ver, flg_txt, chr ) )
			return FALSE;

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饯γơθ̤Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* chr_t *chr : 饯
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_chr_fx_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
)
{
	fx_t	*fx;
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	fx = asgn_fx( chr->fx.next );
	if( fx == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	fx->kind = trans_idx_to_fx_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	fx->turn = tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	fx->n = tmp_n;

	fx->chr = chr;
	fx->cast_chr = NULL;

	/* ֡ե뤬ɤ߹ʤХα޽ */

	if( !load_game_data_n( fp, &tmp_n ) ){
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;

		tmp_n = ABL_KIND_HP;
	}
	fx->abl_kind = (abl_kind_t)tmp_n;

	return TRUE;
}

/***************************************************************
* ࡦǡθ̤ΥǡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* fx_data_t *fx_data : ̤ε
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_fx_data_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_data_t *fx_data
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( fx_data == NULL )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->wpn_hit) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->wpn_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->wpn_dam) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->armor_def) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->armor_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->armor_ac) ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	fx_data->resi_stat = tmp_n;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_hp.count) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_hp.turn) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_hp.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_hp.n) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_mp.count) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_mp.turn) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_mp.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->cure_mp.n) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->infra_vision) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.full_rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.digest_p_day) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.digest_n) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.hungry_rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->stomach.starvation_rate) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->drunk_rate) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->nicotine.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->nicotine.poisoning_rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(fx_data->nicotine.lost_rate) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->friend_turn) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(fx_data->bless) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡνͤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* modifier_t *m : ͤε
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_modifier_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	modifier_t *m
)
{
	long	tmp_n;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	if( !load_game_data_c( fp, &(m->face_mjr) ) )
		return FALSE;
	if( !load_game_data_c( fp, &(m->face_mnr) ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	m->sex = trans_idx_to_sex_kind( tmp_n );

	if( !load_game_data_n( fp, &(m->wpn_hit) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->wpn_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->wpn_dam) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(m->armor_def) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->armor_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->armor_ac) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		if( !load_game_data_n( fp, &(m->add_lev[i]) ) )
			return FALSE;
	}
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		if( !load_game_data_n( fp, &(m->add_resi_n[i]) ) )
			return FALSE;
	}
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	m->resi_stat = tmp_n;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_hp.count) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_hp.turn) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_hp.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_hp.n) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_mp.count) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_mp.turn) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_mp.rate) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->cure_mp.n) ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	if( !load_game_data_n( fp, &(m->add_move_speed) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(m->stomach_digest_n) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(m->teleport_n) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(m->teleport_party_n) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(m->bless) ) )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡοΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_potion_color_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_color_tab();
	idx_tab = get_color_idx_tab();

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( !load_game_data_n( fp, &(tab[i].name_idx) ) )
			return FALSE;

		tab[i].flg_used = FALSE;

		if( tab[i].name_idx <= -1 )
			break;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	reset_potion_tab();
	reset_potion_color();

	return TRUE;
}

/***************************************************************
* ࡦǡδʪΥȥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_scroll_ttl_syllable_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	scroll_tab_t	*tab;
	n_msg_t	*idx_tab;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_scroll_tab_head();
	idx_tab = get_ttl_syllable_idx_tab();

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		long	ttl_n;
		long	tmp_n;

		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_skip_c( fp, '{', TRUE ) )
			return FALSE;

		ttl_n = 0;
		for( j = 0; j < SCROLL_TTL_SYLLABLE_MAX_N; j++ ){
			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;

			tab[i].ttl_idx[j] = tmp_n;
			if( tmp_n > -1 )
				ttl_n++;
		}
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;

		tab[i].ttl_idx[j] = -1;
		tab[i].ttl_n = ttl_n;

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	reset_scroll_ttl_syllable();

	return TRUE;
}

/***************************************************************
* ࡦǡξκΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* stick_kind_t kind : μ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_stick_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	stick_kind_t kind
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	idx_tab = get_stick_material_idx_tab();
	tab = NULL;

	switch( kind ){
	case STICK_KIND_NULL:
	case STICK_KIND_MAX_N:
		break;
	case STICK_KIND_WAND:
		tab = get_wand_material_tab();
		break;
	case STICK_KIND_ROD:
		tab = get_rod_material_tab();
		break;
	case STICK_KIND_STAFF:
		tab = get_staff_material_tab();
		break;
	}
	if( tab == NULL )
		return FALSE;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( !load_game_data_n( fp, &(tab[i].name_idx) ) )
			return FALSE;

		tab[i].flg_used = FALSE;

		if( tab[i].name_idx <= -1 )
			break;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	switch( kind ){
	case STICK_KIND_NULL:
	case STICK_KIND_MAX_N:
		break;
	case STICK_KIND_WAND:
		reset_wand_tab();
		reset_wand_material();
		break;
	case STICK_KIND_ROD:
		reset_rod_tab();
		reset_rod_material();
		break;
	case STICK_KIND_STAFF:
		reset_staff_tab();
		reset_staff_material();
		break;
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥκΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* acce_kind_t kind : μ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_acce_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	acce_kind_t kind
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	idx_tab = get_acce_material_idx_tab();
	tab = NULL;

	switch( kind ){
	case ACCE_KIND_NULL:
	case ACCE_KIND_MAX_N:
		break;
	case ACCE_KIND_RING:
		tab = get_ring_material_tab();
		break;
	case ACCE_KIND_AMULET:
		tab = get_amulet_material_tab();
		break;
	case ACCE_KIND_NECKLACE:
		tab = get_necklace_material_tab();
		break;
	}
	if( tab == NULL )
		return FALSE;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( !load_game_data_n( fp, &(tab[i].name_idx) ) )
			return FALSE;

		tab[i].flg_used = FALSE;

		if( tab[i].name_idx <= -1 )
			break;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	switch( kind ){
	case ACCE_KIND_NULL:
	case ACCE_KIND_MAX_N:
		break;
	case ACCE_KIND_RING:
		reset_ring_tab();
		reset_ring_material();
		break;
	case ACCE_KIND_AMULET:
		reset_amulet_tab();
		reset_amulet_material();
		break;
	case ACCE_KIND_NECKLACE:
		reset_necklace_tab();
		reset_necklace_material();
		break;
	}

	return TRUE;
}

/***************************************************************
* ࡦǡμ̥ե饰Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_potion_identified_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	potion_tab_t	*tab;
	potion_kind_t	kind;
	long	flg;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_potion_tab_head();

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_n( fp, &flg ) )
			return FALSE;

		kind = trans_idx_to_potion_kind( i );
		tab[kind].flg_identified = (bool_t)flg;
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡδʪμ̥ե饰Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_scroll_identified_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	scroll_tab_t	*tab;
	scroll_kind_t	kind;
	long	flg;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_scroll_tab_head();

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_n( fp, &flg ) )
			return FALSE;

		kind = trans_idx_to_scroll_kind( i );
		tab[kind].flg_identified = (bool_t)flg;
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥСΥƥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
)
{
	mbr_t	**ls_mbr;
	mbr_t	*mbr;
	rc_token_t	t;
	rc_union_t	u;
	item_t	*item;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;

	ls_mbr = get_ls_mbr();
	mbr = ls_mbr[ls_mbr_n];

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		bool_t	flg_eq;

		/* ƥμ̻Ҥå */

		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		t = rc_lex( fp, &u, TRUE );
		if( t == '}' )
			break;
		if( t != RC_TOKEN_ID ){
			print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
			return FALSE;
		}

		flg_eq = TRUE;
		if( strcmp( u.str, "item" ) == 0 ){
			flg_eq = FALSE;

			if( !load_game_data_skip_token(
					fp, RC_TOKEN_EQ_OP, TRUE ) ){
				return FALSE;
			}
			if( !load_game_data_skip_c( fp, '{', TRUE ) )
				return FALSE;

			item = alloc_item();
			if( item == NULL )
				return FALSE;
		} else if( strcmp( u.str, "equip" ) == 0 ){
			rc_token_t	t;
			rc_union_t	u;

			flg_eq = TRUE;

			t = rc_lex( fp, &u, TRUE );
			if( t != RC_TOKEN_NUM ){
				return FALSE;
			}

			if( !load_game_data_skip_token(
					fp, RC_TOKEN_EQ_OP, TRUE ) ){
				return FALSE;
			}
			if( !load_game_data_skip_c( fp, '{', TRUE ) )
				return FALSE;

			item = get_mbr_item_asgn_equip( mbr );
			if( item == NULL )
				return FALSE;
			item = &(item[u.n]);
		} else {
			return FALSE;
		}

		/* ǡΥ */

		if( !load_game_data_item_ver_1(
				fp, ver, flg_txt, mbr, item ) ){
			return FALSE;
		}

		/* ǡ֥åνüå */

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;

		/* ƥ򥭥饯˻ */

		if( !flg_eq ){
			if( !give_mbr_item( mbr, item, TRUE ) ){
				return FALSE;
			}
		}
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥƥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;
	char	tmp_c;
	bool_t	flg_success;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->kind = trans_idx_to_item_kind( tmp_n );

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	flg_success = FALSE;

	switch( item->kind ){
	case ITEM_KIND_NULL:
		return FALSE;
	case ITEM_KIND_WPN:
		flg_success = load_game_data_item_wpn_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ARMOR:
		flg_success = load_game_data_item_armor_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_POTION:
		flg_success = load_game_data_item_potion_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_SCROLL:
		flg_success = load_game_data_item_scroll_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_STICK:
		flg_success = load_game_data_item_stick_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ACCE:
		flg_success = load_game_data_item_acce_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_INST:
		flg_success = load_game_data_item_inst_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ANTHOLOGY:
		flg_success = load_game_data_item_anthology_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_LIGHT:
		flg_success = load_game_data_item_light_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_SPIKE:
		flg_success = load_game_data_item_spike_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_FOOD:
		flg_success = load_game_data_item_food_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_CHEST:
		flg_success = load_game_data_item_chest_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_TOBACCO:
		flg_success = load_game_data_item_tobacco_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_PIPE:
		flg_success = load_game_data_item_pipe_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_DISPOSAL:
		flg_success = load_game_data_item_disposal_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_RARE_GOODS:
		flg_success = load_game_data_item_rare_goods_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_BONE:
		flg_success = load_game_data_item_bone_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_COIN:
		flg_success = load_game_data_item_coin_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_JUNK:
		flg_success = load_game_data_item_junk_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_MAX_N:
		return FALSE;
	}
	if( !flg_success )
		return FALSE;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	/* item->next, item->prev */

	if( !load_game_data_s( fp, item->name,
			ITEM_NAME_MAX_LEN ) ){
		return FALSE;
	}
	if( !load_game_data_s( fp, item->art_name,
			ITEM_ART_NAME_MAX_LEN ) ){
		return FALSE;
	}

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->equip_kind = (equip_kind_t)tmp_n;

	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	item->mjr = tmp_c;
	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	item->mnr = tmp_c;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->x = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->y = tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->n = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->stock = tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->flg = tmp_n;

	if( !load_game_data_modifier_ver_1(
			fp, ver, flg_txt, &(item->modifier) ) ){
		return FALSE;
	}

	/* ̾ꥻå */

	set_item_name( item );

	return TRUE;
}

/***************************************************************
* ࡦǡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_wpn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;
	char	tmp_c;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.wpn.kind = trans_idx_to_wpn_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.wpn.add_hit = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.wpn.add_crtcl = tmp_n;
	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.wpn.add_dam = tmp_n;

	if( !load_game_data_c( fp, &tmp_c ) )
		return FALSE;
	item->dat.wpn.slayer = tmp_c;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.wpn.flg = tmp_n;

	item->tab.wpn = get_wpn_tab( item->dat.wpn.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡɶΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_armor_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.armor.kind = trans_idx_to_armor_kind( tmp_n );

	if( !load_game_data_n( fp, &(item->dat.armor.add_def) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(item->dat.armor.add_crtcl) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(item->dat.armor.add_ac) ) )
		return FALSE;

	item->tab.armor = get_armor_tab( item->dat.armor.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_potion_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.potion.kind = trans_idx_to_potion_kind( tmp_n );

	item->tab.potion = get_potion_tab( item->dat.potion.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡδʪΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_scroll_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.scroll.kind = trans_idx_to_scroll_kind( tmp_n );

	item->tab.scroll = get_scroll_tab( item->dat.scroll.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡξΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_stick_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.stick.kind = trans_idx_to_stick_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.stick.spell_kind = trans_idx_to_spell_kind( tmp_n );

	if( !load_game_data_n( fp, &(item->dat.stick.n) ) )
		return FALSE;

	item->tab.stick = get_stick_tab(
			item->dat.stick.kind,
			item->dat.stick.spell_kind );

	return TRUE;
}

/***************************************************************
* ࡦǡΥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_acce_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.acce.kind = trans_idx_to_acce_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.acce.ring_kind = trans_idx_to_ring_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.acce.amulet_kind = trans_idx_to_amulet_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.acce.necklace_kind = trans_idx_to_necklace_kind( tmp_n );

	item->tab.acce = get_acce_tab(
			item->dat.acce.ring_kind,
			item->dat.acce.amulet_kind,
			item->dat.acce.necklace_kind );

	return TRUE;
}

/***************************************************************
* ࡦǡγڴΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_inst_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.inst.kind = trans_idx_to_inst_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.inst.flg_limit = (bool_t)tmp_n;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.inst.spell_kind = trans_idx_to_spell_kind( tmp_n );

	item->tab.inst = get_inst_tab( item->dat.inst.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡλΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_anthology_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.anthology.kind = trans_idx_to_anthology_kind( tmp_n );

	item->tab.anthology = get_anthology_tab( item->dat.anthology.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_light_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.light.kind = trans_idx_to_light_kind( tmp_n );

	if( !load_game_data_n( fp, &(item->dat.light.turn) ) )
		return FALSE;

	item->tab.light = get_light_tab( item->dat.light.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡţΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_spike_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	item->tab.wpn = NULL;

	return TRUE;
}

/***************************************************************
* ࡦǡοΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_food_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.food.kind = trans_idx_to_food_kind( tmp_n );

	item->tab.food = get_food_tab( item->dat.food.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡȢΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_chest_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	item_t	*contents;
	trap_t	trap, *p_trap;
	long	tmp_n;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	item = make_item_chest_alloc( item, 0, 0, FALSE );
	if( item == NULL )
		return FALSE;

	/* chest->contents */

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		contents = alloc_item();
		if( contents == NULL )
			return FALSE;

		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_skip_c( fp, '{', TRUE ) )
			return FALSE;

		load_game_data_item_ver_1(
				fp, ver, flg_txt, mbr, contents );

		ins_ls_item( item->dat.chest.contents, contents );

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	/* chest->trap */

	if( !load_game_data_skip_c( fp, '{', TRUE ) )
		return FALSE;

	trap.next = NULL;
	trap.prev = NULL;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	trap.kind = trans_idx_to_trap_kind( tmp_n );

	if( !load_game_data_n( fp, &(trap.x) ) )
		return FALSE;
	if( !load_game_data_n( fp, &(trap.y) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(trap.lev) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(trap.difficulty) ) )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	trap.flg_chked = (bool_t)tmp_n;

	trap.tab = get_trap_tab( trap.kind );

	/* 櫤Υ꡼Ƥ */

	p_trap = alloc_trap();
	if( p_trap == NULL )
		return FALSE;

	*p_trap = trap;
	item->dat.chest.trap = p_trap;

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	/* chest->ref */

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.chest.contents->dat.chest.ref = tmp_n;

	/* chest->tab */

	item->tab.wpn = NULL;

	return TRUE;
}

/***************************************************************
* ࡦǡαΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_tobacco_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.tobacco.kind = trans_idx_to_tobacco_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.tobacco.brand = trans_idx_to_tobacco_brand( tmp_n );

	if( !load_game_data_n( fp, &(item->dat.tobacco.turn) ) )
		return FALSE;

	item->tab.tobacco = get_tobacco_tab(
			item->dat.tobacco.kind,
			item->dat.tobacco.brand );

	return TRUE;
}

/***************************************************************
* ࡦǡΥѥפΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_pipe_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.pipe.kind = trans_idx_to_pipe_kind( tmp_n );

	if( !load_game_data_n( fp, &(item->dat.pipe.turn) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(item->dat.pipe.consume_turn) ) )
		return FALSE;

	item->tab.pipe = get_pipe_tab( item->dat.pipe.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡεۤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_disposal_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &(item->dat.disposal.n) ) )
		return FALSE;

	if( !load_game_data_n( fp, &(item->dat.disposal.max_n) ) )
		return FALSE;

	item->tab.wpn = NULL;

	return TRUE;
}

/***************************************************************
* ࡦǡΥ쥢åΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_rare_goods_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.rare_goods.kind = trans_idx_to_rare_goods_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.rare_goods.mnstr_kind = trans_idx_to_mnstr_kind( tmp_n );

	item->tab.rare_goods = get_rare_goods_tab(
			item->dat.rare_goods.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡιΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_bone_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	mnstr_kind_t	kind;
	long	lev;
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	kind = trans_idx_to_mnstr_kind( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	lev = tmp_n;

	item->dat.bone.mnstr_tab = get_mnstr_tab( kind, lev );
	item->dat.bone.dun_lev = lev;

	return TRUE;
}

/***************************************************************
* ࡦǡζߤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_coin_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	item->dat.coin.kind = trans_idx_to_coin_kind( tmp_n );

	item->tab.coin = get_coin_tab( item->dat.coin.kind );

	return TRUE;
}

/***************************************************************
* ࡦǡΥߤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_item_junk_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡꥹȤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_auto_mark_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
)
{
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( !load_game_data_skip_c( fp, '{', FALSE ) )
			break;

		if( !load_game_data_auto_mark_ver_1(
				fp, ver, flg_txt, ls_mbr_n, i ) ){
			return FALSE;
		}

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* long auto_mark_n : ưޡֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_auto_mark_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n, long auto_mark_n
)
{
	mbr_t	**ls_mbr = get_ls_mbr();
	auto_mark_t	*a;
	long	tmp_n;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;
	if( auto_mark_n < 0 )
		return FALSE;

	if( auto_mark_n > AUTO_MARK_MAX_N - 1 )
		auto_mark_n = AUTO_MARK_MAX_N - 1;

	/* ưɻ */

	if( ls_mbr[ls_mbr_n] != NULL )
		ls_mbr[ls_mbr_n]->flg_chr &= ~FLG_CHR_AUTO_MARK_CONT;

	/**/

	a = get_ls_auto_mark( ls_mbr_n );
	if( a == NULL )
		return FALSE;

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	a[auto_mark_n].trgt = trans_idx_to_am_trgt( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	a[auto_mark_n].dist = trans_idx_to_am_dist( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	a[auto_mark_n].act = trans_idx_to_am_act( tmp_n );

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	a[auto_mark_n].cond = trans_idx_to_am_cond( tmp_n );

	if( chk_ver_old( ver, 1, 1, 0 ) ){
		a[auto_mark_n].macro[0] = '\0';
	} else {
		if( !load_game_data_s( fp, a[auto_mark_n].macro,
				MACRO_MAX_LEN ) ){
			return FALSE;
		}
	}

	if( !load_game_data_n( fp, &tmp_n ) )
		return FALSE;
	a[auto_mark_n].flg = tmp_n;

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡΥƥࡦꥹȤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_auto_mark_appoint_item_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
)
{
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_auto_mark_appoint_item_ver_1(
				fp, ver, flg_txt, ls_mbr_n, i ) ){
			return FALSE;
		}
	}

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡΥƥΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* long auto_mark_n : ưޡֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_auto_mark_appoint_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n, long auto_mark_n
)
{
	auto_mark_appoint_item_t	*ls;
	long	tmp_n;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;
	if( auto_mark_n < 0 )
		return FALSE;

	if( auto_mark_n > AUTO_MARK_MAX_N - 1 )
		auto_mark_n = AUTO_MARK_MAX_N - 1;

	/**/

	if( !load_game_data_skip_c( fp, '{', FALSE ) )
		return FALSE;

	for( i = 0; i < AUTO_MARK_APPOINT_ITEM_MAX_N; i++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		ls = get_ls_auto_mark_appoint_item( ls_mbr_n, auto_mark_n );
		if( ls == NULL )
			continue;

		if( !load_game_data_c( fp, &(ls[i].mjr) ) )
			return FALSE;

		if( !load_game_data_c( fp, &(ls[i].mnr) ) )
			return FALSE;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		ls[i].flg_ena = (bool_t)tmp_n;
	}

	if( i >= AUTO_MARK_APPOINT_ITEM_MAX_N )
		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥ⡼ɡե饰Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_flg_srch_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	bool_t	*ls;
	long	tmp_n;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ls = get_ls_flg_srch();
	if( ls == NULL )
		return FALSE;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		ls[i] = (bool_t)tmp_n;
	}

	if( i >= LS_MBR_MAX_N )
		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡμʸꥹȤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_spell_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
)
{
	mbr_t	**ls_mbr = get_ls_mbr();
	cast_tab_t	*tab;
	spell_kind_t	kind;
	long	tmp_n;
	long	j, adjust;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( ls_mbr_n < 0 )
		return FALSE;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return FALSE;

	if( chk_ver_old( ver, 1, 0, 1 ) )
		adjust = 1;
	else
		adjust = 0;

	for( j = 0 + adjust; j < SPELL_KIND_MAX_N; j++ ){
		if( load_game_data_skip_c( fp, '}', FALSE ) )
			break;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;

		kind = trans_idx_to_spell_kind( j );
		if( kind >= SPELL_KIND_MAX_N )
			continue;

		tab = get_cast_tab( ls_mbr[ls_mbr_n], kind );
		if( tab == NULL )
			continue;

		tab->flg_cast = (bool_t)tmp_n;
	}
	if( j >= SPELL_KIND_MAX_N )
		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
	for( ; j < SPELL_KIND_MAX_N; j++ ){
		kind = trans_idx_to_spell_kind( j );

		tab = get_cast_tab( ls_mbr[ls_mbr_n], kind );
		if( tab == NULL )
			continue;

		tab->flg_cast = FALSE;
	}
	tab = get_cast_tab( ls_mbr[ls_mbr_n], SPELL_KIND_NULL );
	if( tab != NULL )
		tab->flg_cast = FALSE;

	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥСΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_mbr_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	party_t	*pty = get_party();
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	for( i = 0; i < MBR_MAX_N; i++ )
		not_join_mbr( pty->mbr[i]->ls_mbr_n, i );

	for( i = 0; i < MBR_MAX_N; i++ ){
		long	ls_mbr_n;

		if( !load_game_data_n( fp, &ls_mbr_n ) )
			return FALSE;

		if( ls_mbr_n <= -1 )
			continue;
		if( ls_mbr_n >= LS_MBR_MAX_N )
			continue;

		join_mbr( ls_mbr_n, i );
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΥڥåȤΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_pet_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	pet_t	**pty_pet = get_party_pet();
	pet_t	**ls_pet = get_ls_pet();
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( pty_pet[i] == NULL )
			continue;

		not_join_pet( pty_pet[i] );
	}

	for( i = 0; i < PET_MAX_N; i++ ){
		long	ls_pet_n;
		pet_t	*p;

		if( !load_game_data_n( fp, &ls_pet_n ) )
			return FALSE;

		if( ls_pet_n <= -1 )
			continue;
		if( ls_pet_n >= LS_PET_MAX_N )
			continue;

		p = ls_pet[ls_pet_n];
		if( p == NULL )
			continue;

		clr_map_chr( p );
		draw_pet( p );
		p->x = MAP_DEL_X;
		p->y = MAP_DEL_Y;

		join_pet( p );
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡΰΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_request_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	request_t	*req, *p;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	req = get_request_ls();
	if( req == NULL )
		return FALSE;

	for( i = 0; i < REQUEST_MAX_N; i++ )
		req[i].kind = REQUEST_KIND_NULL;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		long	tmp_n;

		if( !load_game_data_skip_c( fp, '{', FALSE ) )
			break;

		if( chk_ver_old( ver, 1, 1, 4 ) ){
			p = &(req[i]);
		} else {
			if( !load_game_data_n( fp, &tmp_n ) )
				return FALSE;
			p = &(req[tmp_n]);
		}

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->kind = trans_idx_to_request_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->dun_min_lev = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->dun_max_lev = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->dun_true_lev = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->prize = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->exp = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->limit = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->flg_contract = (bool_t)tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->flg_contract_mbr = (bool_t)tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_contract_name = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->contract_sex = trans_idx_to_sex_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->flg_finish = (bool_t)tmp_n;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->rare_goods_kind
				= trans_idx_to_rare_goods_kind( tmp_n );

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->flg_mnstr_is_npc = (bool_t)tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->mnstr_kind = trans_idx_to_mnstr_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->mnstr_n = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->mnstr_exterminate_n = tmp_n;

		if( !load_game_data_s( fp, p->heading,
				MENU_MSG_MAX_LEN ) )
			return FALSE;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_fmt = tmp_n;
		if( !load_game_data_s( fp, p->msg,
				REQUEST_MSG_MAX_LEN ) )
			return FALSE;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_client_name = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_mnstr_name = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_rescue_trgt_name = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_client_family_name = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_client_mate_name = tmp_n;

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->client_sex = trans_idx_to_sex_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->mnstr_sex = trans_idx_to_sex_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->rescue_trgt_sex = trans_idx_to_sex_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->client_family_sex = trans_idx_to_sex_kind( tmp_n );
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->client_mate_sex = trans_idx_to_sex_kind( tmp_n );

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->rescue_trgt_kind = trans_idx_to_mnstr_kind( tmp_n );

		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_when_1 = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_when_2 = tmp_n;
		if( !load_game_data_n( fp, &tmp_n ) )
			return FALSE;
		p->idx_weapon = tmp_n;

		if( !load_game_data_skip_c( fp, '}', TRUE ) )
			return FALSE;
		if( !load_game_data_skip_c( fp, ',', TRUE ) )
			return FALSE;
	}

	if( !load_game_data_skip_c( fp, '}', TRUE ) )
		return FALSE;
	if( !load_game_data_skip_c( fp, ',', TRUE ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ץ쥤Υ
* bool_t flg_txt_data : ࡦǡƥȡ⡼ɤ?
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_replay( bool_t flg_txt_data, long n )
{
	FILE	*fp;
	ver_t	ver;
	bool_t	flg_txt = TRUE;

	if( get_flg_play_replay() )
		return TRUE;

	/* ࡦǡΥ */

	if( !load_game_data( flg_txt_data, n ) )
		return FALSE;

	/* եΥץ */

	fp = open_game_replay( 'r', n );
	if( fp == NULL )
		return FALSE;

	/* إåɤ߹ */

	set_flg_crypt_txt( TRUE );
	load_game_replay_head_ver_1( fp, &ver, flg_txt );
	set_flg_crypt_txt( flg_txt );

	/* СΥå */

	if( !chk_ver_old( &ver,
			GAME_DATA_VER_MJR,
			GAME_DATA_VER_MNR,
			GAME_DATA_VER_PAT ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		fclose( fp );
		return FALSE;
	}

	/* ǡν */

	reset_load_game_replay( n );

	/* ǡɤ߹ */

	switch( ver.mjr ){
	case 1:
		if( !load_game_replay_ver_1( fp, &ver, flg_txt ) ){
			fclose( fp );
			return FALSE;
		}
		break;
	default:
		fclose( fp );

		print_lex_err( MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_lex_err( MSG_ERR_FILE_VER_B );

		exit_game( EXIT_FAILURE );
		return FALSE;
		break;
	}

	/* եΥ */

	if( fclose( fp ) == EOF )
		return FALSE;

	set_flg_play_replay( TRUE );

	print_msg( FLG_NULL, MSG_LOAD_GAME_REPLAY_SUCCESS, n );

	return TRUE;
}

/***************************************************************
* ץ쥤Υν
* long n : ǡåֹ
***************************************************************/

void	reset_load_game_replay( long n )
{
	end_reg_replay( SAVE_N_AUTO );
	reset_replay( SAVE_N_AUTO );

	end_reg_replay( get_replay_save_n() );
	reset_replay( get_replay_save_n() );

	reset_replay_slot( REPLAY_SLOT_PLAY );
	bgn_reg_replay_play();

	g_replay_kind_cur = REPLAY_KIND_KEY;
}

/***************************************************************
* ץ쥤ΥإåΥ(С 1)
* FILE *fp : ե
* ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_replay_head_ver_1( FILE *fp, ver_t *ver, bool_t flg_txt )
{
	const long	len_head = str_len_std( STR_GAME_REPLAY_HEAD );
	char	*s;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ver->mjr = 0;
	ver->mnr = 0;
	ver->pat = 0;

	s = load_line( fp, TRUE );
	if( strncmp( s, STR_GAME_REPLAY_HEAD, len_head ) != 0 ){
		print_lex_err( MSG_S, MSG_ERR_LOAD_GAME_HEAD );
		return FALSE;
	}

	/* С󡦥å */

	if( str_len_std( s ) < len_head )
		return FALSE;
	s = &(s[len_head]);

	sscanf( s, " %ld.%ld.%ld ", &(ver->mjr), &(ver->mnr), &(ver->pat) );

	if( (ver->mjr == 0) && (ver->mnr == 0) && (ver->pat == 0) )
		return FALSE;

	/**/

	s = load_line( fp, TRUE );

	reset_load_crypt( fp, flg_txt );

	return TRUE;
}

/***************************************************************
* ץ쥤Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_replay_ver_1( FILE *fp, const ver_t *ver, bool_t flg_txt )
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	while( 1 ){
		if( !load_game_replay_parse_ver_1( fp, ver, flg_txt ) )
			break;
	}

	return TRUE;
}

/***************************************************************
* ץ쥤Υѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : ѡ³뤫?
***************************************************************/

bool_t	load_game_replay_parse_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	bool_t	flg_err_exit, flg_err;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	flg_err_exit = TRUE;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	for( i = 0; i < MAX_TOKEN; i++ ){
		t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
		if( t[i] == RC_TOKEN_EOF )
			break;
		if( t[i] == '\n' )
			break;
		if( t[i] == RC_TOKEN_ADD_OP ){
			long	sign_n = +1;

			for( j = i + 1; j < MAX_TOKEN; j++ ){
				if( u[i].c == '-' )
					sign_n = -sign_n;

				t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
				if( t[i] != RC_TOKEN_ADD_OP ){
					break;
				}
			}

			if( t[i] == RC_TOKEN_NUM ){
				u[i].n *= sign_n;
			}
		}
	}
	if( i >= MAX_TOKEN ){
		for( i = 0; i < LOOP_MAX_100; i++ ){
			rc_token_t	t;
			rc_union_t	u;

			t = rc_lex( fp, &u, flg_err_exit );
			if( t == RC_TOKEN_EOF )
				break;
			if( t == '\n' )
				break;
		}
	}

	flg_err = FALSE;

	if( t[0] == RC_TOKEN_EOF ){
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_ID) ){
		/* bar, */

		if( !load_game_replay_id_ver_1(
				fp, ver, flg_txt,
				u[0].str ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_STR)
			&& (t[1] == ',') ){
		/* "baz", */

		if( !load_game_replay_str_ver_1(
				fp, ver, flg_txt,
				u[0].str ) ){
			flg_err = TRUE;
		}
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	}

	if( flg_err ){
		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
		return FALSE;
	} else {
		return TRUE;
	}
}

/***************************************************************
* ץ쥤Υѡ(̻ : С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* char *id : ̻
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_replay_id_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( id == NULL )
		return FALSE;

	if( strcmp( id, MSG_REPLAY_KIND_KEY ) == 0 ){
		g_replay_kind_cur = REPLAY_KIND_KEY;

		return TRUE;
	} else if( strcmp( id, MSG_REPLAY_KIND_GETS ) == 0 ){
		g_replay_kind_cur = REPLAY_KIND_GETS;

		return TRUE;
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* ץ쥤Υѡ(ʸ : С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_replay_str_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *str
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( str == NULL )
		return FALSE;

	set_replay_str_slot( g_replay_kind_cur, REPLAY_SLOT_PLAY, str );

	return TRUE;
}

/***************************************************************
* եοͤΥѡ
* FILE *fp : ե
* long *n : ֤ͤ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_n( FILE *fp, long *n )
{
	long	sign_n;
	rc_token_t	t;
	rc_union_t	u;

	if( fp == NULL )
		return FALSE;
	if( n == NULL )
		return FALSE;

	sign_n = +1;
	do {
		do {
			t = rc_lex( fp, &u, TRUE );
			if( t != '\n' )
				break;
		} while( 1 );

		if( t == RC_TOKEN_ADD_OP ){
			if( u.c == '-' )
				sign_n = -sign_n;
			continue;
		}

		break;
	} while( 1 );

	if( t != RC_TOKEN_NUM ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_NUM );
		return FALSE;
	}

	*n = sign_n * u.n;

	t = rc_lex( fp, &u, TRUE );
	if( t != ',' ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_COMMA );
		return FALSE;
	}

	return TRUE;
}

/***************************************************************
* եʸΥѡ
* FILE *fp : ե
* char *s : ʸ֤
* long len : ʸκĹ
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_s( FILE *fp, char *s, long len )
{
	rc_token_t	t;
	rc_union_t	u;

	if( fp == NULL )
		return FALSE;
	if( s == NULL )
		return FALSE;

	do {
		t = rc_lex( fp, &u, TRUE );
		if( t != '\n' )
			break;
	} while( 1 );

	if( t != RC_TOKEN_STR ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_STR );
		return FALSE;
	}

	str_nz_cpy( s, u.str, len );

	t = rc_lex( fp, &u, TRUE );
	if( t != ',' ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_COMMA );
		return FALSE;
	}

	return TRUE;
}

/***************************************************************
* եʸΥѡ
* FILE *fp : ե
* char *c : ʸ֤
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_c( FILE *fp, char *c )
{
	rc_token_t	t;
	rc_union_t	u;

	if( fp == NULL )
		return FALSE;
	if( c == NULL )
		return FALSE;

	do {
		t = rc_lex( fp, &u, TRUE );
		if( t != '\n' )
			break;
	} while( 1 );

	if( t != RC_TOKEN_CHAR ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_CHAR );
		return FALSE;
	}

	*c = (char)(u.c);

	t = rc_lex( fp, &u, TRUE );
	if( t != ',' ){
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_COMMA );
		return FALSE;
	}

	return TRUE;
}

/***************************************************************
* եʸɤФ(㤦ʸä饨顼)
* FILE *fp : ե
* rc_token_t c : ʸ
* bool_t flg_draw : 顼ɽ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_skip_c( FILE *fp, char c, bool_t flg_draw )
{
	return load_game_data_skip_token( fp, (rc_token_t)c, flg_draw );
}

/***************************************************************
* եΥȡɤФ(㤦ȡä饨顼)
* FILE *fp : ե
* rc_token_t c : ʸ
* bool_t flg_draw : 顼ɽ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	load_game_data_skip_token( FILE *fp, rc_token_t c, bool_t flg_draw )
{
	rc_token_t	t;
	rc_union_t	u;

	if( fp == NULL )
		return FALSE;

	do {
		t = rc_lex( fp, &u, TRUE );
		if( (t != '\n') && (t != '\r') )
			break;
	} while( 1 );

	if( t != c ){
		if( flg_draw ){
			print_lex_err( MSG_ERR_RC_PARSE_SKIP_CHAR, c );
		}

		rc_unlex( fp, &u, t );

		return FALSE;
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥ
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data( bool_t flg_txt, long n )
{
	bool_t	flg_success = TRUE;

	g_randm_seed_save = get_randm_seed();

	if( (n != SAVE_N_AUTO) && (n != SAVE_N_BUG_REPO) )
		g_game_data_save_n++;

	if( flg_txt ){
		/* ǥХåѤΥƥȡ */
		flg_success = save_game_data_sub( flg_txt, n );
	} else {
		/* ǥХåѤΥƥȡ */
		if( !save_game_data_sub( TRUE, n ) )
			flg_success = FALSE;

		/* ̾ΥХʥ꡼ */
		if( !save_game_data_sub( FALSE, n ) )
			flg_success = FALSE;
	}

	remove_replay_file( n );
	bgn_reg_replay( n );

	return flg_success;
}

/***************************************************************
* ࡦǡΥ
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_sub( bool_t flg_txt, long n )
{
	ver_t	ver;

	ver.mjr = GAME_DATA_VER_MJR;
	ver.mnr = GAME_DATA_VER_MNR;
	ver.pat = GAME_DATA_VER_PAT;

	switch( ver.mjr ){
	case 1:
		return save_game_data_ver_1( &ver, flg_txt, n );
		break;
	default:
		return FALSE;
		break;
	}

	return FALSE;
}

/***************************************************************
* ࡦǡΥ(С 1)
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_ver_1( const ver_t *ver, bool_t flg_txt, long n )
{
	FILE	*fp;
	time_t	save_time_buf;
	struct tm	*save_time;

	if( ver == NULL )
		return FALSE;

	fp = open_game_data( 'w', n, flg_txt );
	if( fp == NULL )
		return FALSE;

	/* header */

	fprintf( fp, "%s%ld.%ld.%ld\n",
			STR_GAME_DATA_HEAD,
			ver->mjr, ver->mnr, ver->pat );

	time( &save_time_buf );
	save_time = localtime( &save_time_buf );
	if( save_time == NULL )
		return FALSE;
	fprintf( fp, "%04ld: %04d/%02d/%02d  %02d:%02d:%02d\n",
			g_game_data_save_n,
			save_time->tm_year + 1900,
			save_time->tm_mon + 1,
			save_time->tm_mday,
			save_time->tm_hour,
			save_time->tm_min,
			save_time->tm_sec );

	reset_save_crypt( fp, flg_txt );
	reset_save_crypt_tab();

	/* contents */

	if( !save_game_data_contents( fp, ver, flg_txt ) ){
		fclose( fp );
		return FALSE;
	}

	/* footer */

	save_crypt_str( fp, "\n" );
	save_crypt_tab( fp, "// end\n" );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	/* config */

	if( !chk_ver_old( ver, 1, 0, 8 ) )
		if( !save_game_data_cnf_ver_1( ver, n ) )
			return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡƤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_contents(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	bool_t	flg_err = FALSE;

	/* misc */

	flg_err |= !save_game_data_randm_seed_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_dun_lev_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_turn_ver_1( fp, ver, flg_txt );

	/* member */

	flg_err |= !save_game_data_class_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_mbr_ver_1( fp, ver, flg_txt );

	/* potion */

	flg_err |= !save_game_data_potion_color_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_potion_identified_ver_1(
			fp, ver, flg_txt );

	/* scroll */

	flg_err |= !save_game_data_scroll_ttl_syllable_ver_1(
			fp, ver, flg_txt );
	flg_err |= !save_game_data_scroll_identified_ver_1(
			fp, ver, flg_txt );

	/* stick */

	flg_err |= !save_game_data_stick_material_ver_1(
			fp, ver, flg_txt, STICK_KIND_WAND );
	flg_err |= !save_game_data_stick_material_ver_1(
			fp, ver, flg_txt, STICK_KIND_ROD );
	flg_err |= !save_game_data_stick_material_ver_1(
			fp, ver, flg_txt, STICK_KIND_STAFF );

	/* acce */

	flg_err |= !save_game_data_acce_material_ver_1(
			fp, ver, flg_txt, ACCE_KIND_RING );
	flg_err |= !save_game_data_acce_material_ver_1(
			fp, ver, flg_txt, ACCE_KIND_AMULET );
	flg_err |= !save_game_data_acce_material_ver_1(
			fp, ver, flg_txt, ACCE_KIND_NECKLACE );

	/* members item */

	flg_err |= !save_game_data_item_all_mbr_ver_1( fp, ver, flg_txt );

	/* misc */

	flg_err |= !save_game_data_auto_mark_ls_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_flg_srch_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_spell_ls_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_mbr_formation_ver_1( fp, ver, flg_txt );
	flg_err |= !save_game_data_pet_formation_ver_1( fp, ver, flg_txt );

	/* request */

	flg_err |= !save_game_data_request_ver_1( fp, ver, flg_txt );

	/**/

	if( flg_err )
		return FALSE;
	else
		return TRUE;
}

/***************************************************************
* ࡦǡμΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_randm_seed_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// random seed\n" );
	save_crypt_tab( fp, "randm_seed = %ld\n", g_randm_seed_save );

	return TRUE;
}

/***************************************************************
* ࡦǡµܤγؤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_dun_lev_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// dungeon level\n" );
	save_crypt_tab( fp, "dun_lev = %ld\n", get_dun_lev() );

	return TRUE;
}

/***************************************************************
* ࡦǡΥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_turn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// day\n" );
	save_crypt_tab( fp, "day = %ld\n", get_game_day() );
	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "turn = %ld\n", get_turn() );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饹Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_class_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	class_t	*p;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// class\n" );

	p = get_class_tab();
	if( p == NULL )
		return FALSE;

	for( i = 0; i < CLASS_MAX_N; i++ ){
		if( p[i].name[0] == '\0' )
			break;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "class %ld = ", i );

		set_save_crypt_tab( fp, +1 );

		/* n_name */

		save_crypt_tab( fp, "// name\n" );
		save_crypt_tab( fp, "\"%s\",\n",
				cv_esc_quote_str( p[i].name ) );

		save_crypt_tab( fp, "// dflt\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(p[i].dflt) );

		save_crypt_tab( fp, "// abl_rate\n" );
		set_save_crypt_tab( fp, +1 );
		for( j = 0; j < ABL_KIND_MAX_N; j++ ){
			save_crypt_tab( fp, "// %s\n",
					get_abl_name( (abl_kind_t)j ) );
			save_crypt_tab( fp, "%ld,\n",
					(long)(p[i].abl_rate[j]) );
		}
		set_save_crypt_tab( fp, -1 );

		set_save_crypt_tab( fp, -1 );
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥСȥڥåȤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	mbr_t	**ls_mbr;
	pet_t	**ls_pet;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	/* С */

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// mbr\n" );

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "member %ld = ", i );
		save_game_data_chr_ver_1( fp, ver, flg_txt, ls_mbr[i] );
	}

	/* ڥå */

	ls_pet = get_ls_pet();
	if( ls_pet == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// pet\n" );

	for( i = 0; i < LS_PET_MAX_N; i++ ){
		if( ls_pet[i] == NULL )
			continue;
		if( chk_flg( ls_pet[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "pet %ld = ", i );
		save_game_data_chr_ver_1( fp, ver, flg_txt, ls_pet[i] );
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饯Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* chr_t *chr : 饯
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_chr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
)
{
	fx_t	*fx, *end;
	long	idx;
	long	max_idx;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;
	if( chk_flg( chr->stat, FLG_STAT_NOT_EXIST ) )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	idx = trans_chr_kind_to_idx( chr->kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	save_crypt_tab( fp, "// name\n" );
	save_crypt_tab( fp, "\"%s\",\n", cv_esc_quote_str( chr->name ) );

	save_crypt_tab( fp, "// id1, id2\n" );
	save_crypt_tab( fp, "%ld, %ld,\n", chr->id1, chr->id2 );

	save_crypt_tab( fp, "// mbr_n, ls_mbr_n\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->mbr_n, chr->ls_mbr_n );

	save_crypt_tab( fp, "// face\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( chr->face.mjr ) );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( chr->face.mnr ) );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( chr->face.mjr_org ) );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( chr->face.mnr_org ) );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// race\n" );
	set_save_crypt_tab( fp, +1 );
	idx = trans_main_race_kind_to_idx( chr->race.main );
	save_crypt_tab( fp, "%ld,\n", idx );
	idx = trans_sub_race_kind_to_idx( chr->race.sub );
	save_crypt_tab( fp, "%ld,\n", idx );
	save_crypt_tab( fp, "\"%s\",\n",
			cv_esc_quote_str( chr->race.name ) );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// sex\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "%ld, %ld,\n",
			trans_sex_kind_to_idx( chr->sex.cur ),
			trans_sex_kind_to_idx( chr->sex.org ) );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// x, y\n" );
	save_crypt_tab( fp, "%ld, %ld,\n", chr->x, chr->y );

	save_crypt_tab( fp, "// pre_x, pre_y\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->pre_x, chr->pre_y );

	save_crypt_tab( fp, "// dx, dy\n" );
	save_crypt_tab( fp, "%ld, %ld,\n", chr->dx, chr->dy );

	save_crypt_tab( fp, "// move\n" );
	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "// speed\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->move.speed.rate,
			chr->move.speed.rate_org );
	save_crypt_tab( fp, "%ld,\n", chr->move.speed.n );
	set_save_crypt_tab( fp, -1 );

	idx = trans_move_kind_to_idx( chr->move.force_kind );
	save_crypt_tab( fp, "// force_kind\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	save_crypt_tab( fp, "// ls\n" );
	set_save_crypt_tab( fp, +1 );
	max_idx = sizeof( g_move_ls_trans_tab )
			/ sizeof( g_move_ls_trans_tab[0] );
	for( i = 0; i < max_idx; i++ ){
		move_ls_kind_t	k;

		k = trans_idx_to_move_ls_kind( i );

		set_save_crypt_tab( fp, +1 );
		for( j = 0; j < MOVE_LS_MAX_N; j++ ){
			idx = trans_move_kind_to_idx(
					chr->move.ls[k][j].kind );

			set_save_crypt_tab( fp, +1 );
			save_crypt_tab( fp, "%ld,\n", idx );
			save_crypt_tab( fp, "%ld,\n",
					chr->move.ls[k][j].ratio );
			set_save_crypt_tab( fp, -1 );
		}
		set_save_crypt_tab( fp, -1 );
	}
	set_save_crypt_tab( fp, -1 );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// gold\n" );
	save_crypt_tab( fp, "%ld,\n", chr->gold );

	save_crypt_tab( fp, "// dun_max_lev_floor, "
			"dun_max_lev_base\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->dun_max_lev_floor,
			chr->dun_max_lev_base );

	/* trgt_t	trgt; */
	/* act_t	act, pre_act; */

	save_crypt_tab( fp, "// flg_chr\n" );
	save_crypt_tab( fp, "0x%08lx,\n", chr->flg_chr );

	save_crypt_tab( fp, "// flg_map\n" );
	save_crypt_tab( fp, "0x%08lx,\n", chr->flg_map );

	idx = trans_attitude_kind_to_idx( chr->attitude );
	save_crypt_tab( fp, "// attitude\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	save_crypt_tab( fp, "// owner_ls_mbr_n\n" );
	if( (chr->owner != NULL) && is_mbr( chr->owner ) ){
		save_crypt_tab( fp, "%ld,\n", chr->ls_mbr_n );
	} else {
		save_crypt_tab( fp, "-1,\n" );
	}

	save_crypt_tab( fp, "// stat\n" );
	save_crypt_tab( fp, "%ld,\n", chr->stat );

	save_crypt_tab( fp, "// abl\n" );
	set_save_crypt_tab( fp, +1 );
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		save_crypt_tab( fp, "// %s\n",
				get_abl_name( (abl_kind_t)i ) );
		set_save_crypt_tab( fp, +1 );

		save_crypt_tab( fp, "// exp_n, exp_max\n" );
		save_crypt_tab( fp, "%ld, %ld,\n",
				chr->abl.exp[i].n,
				chr->abl.exp[i].max );

		save_crypt_tab( fp, "// lev_n, lev_max\n" );
		save_crypt_tab( fp, "%ld, %ld, %ld,\n",
				chr->abl.lev[i].n,
				chr->abl.lev[i].max,
				chr->abl.lev[i].add );
		set_save_crypt_tab( fp, -1 );
	}
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// hp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// n, max\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->abl.hp.n,
			chr->abl.hp.max );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// mp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// n, max\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->abl.mp.n,
			chr->abl.mp.max );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// class_n\n" );
	save_crypt_tab( fp, "%ld,\n", chr->class_n );

	save_crypt_tab( fp, "// resi\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// n, max_n, add_n\n" );
	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		set_save_crypt_tab( fp, +1 );
		save_crypt_tab( fp, "%ld, %ld, %ld,\n",
				chr->resi[i].n,
				chr->resi[i].max,
				chr->resi[i].add_n );
		set_save_crypt_tab( fp, -1 );
	}
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// add_def, add_crtcl, add_ac\n" );
	save_crypt_tab( fp, "%ld, %ld, %ld,\n",
			chr->add_def,
			chr->add_crtcl,
			chr->add_ac );

	save_crypt_tab( fp, "// fx\n" );
	set_save_crypt_tab( fp, +1 );
	end = &(chr->fx);
	for( fx = end->next->next; fx->prev != end; fx = fx->next ){
		save_game_data_fx_ver_1( fp, ver, flg_txt, fx->prev );
	}
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// fx_data\n" );
	save_game_data_fx_data_ver_1( fp, ver, flg_txt, &(chr->fx_data) );

	save_crypt_tab( fp, "// modifier_equip\n" );
	save_game_data_modifier_ver_1(
			fp, ver, flg_txt,
			&(chr->modifier_equip) );

	save_crypt_tab( fp, "// modifier_fx\n" );
	save_game_data_modifier_ver_1(
			fp, ver, flg_txt,
			&(chr->modifier_fx) );

	idx = trans_mnstr_kind_to_idx( chr->mnstr_kind );
	save_crypt_tab( fp, "// mnstr_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	/* mnstr_tab_t	*mnstr_tab; */

	save_game_data_work_ver_1( fp, ver, flg_txt, chr );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饯θ̤Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* fx_t *fx : 
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_fx_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_t *fx
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( fx == NULL )
		return FALSE;

	if( fx->cast_chr != NULL )
		return TRUE;

	set_save_crypt_tab( fp, +1 );

	idx = trans_fx_kind_to_idx( fx->kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", fx->turn );

	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", fx->n );

	/* fx->chr, fx->cast_chr */

	save_crypt_tab( fp, "// abl_kind\n" );
	save_crypt_tab( fp, "%ld,\n", fx->abl_kind );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ饯θ̤ΥǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* fx_data_t *fx_data : ̤Υǡ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_fx_data_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_data_t *fx_data
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( fx_data == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "// wpn_hit, wpn_crtcl, wpn_dam\n" );
	save_crypt_tab( fp, "%ld, %ld, %ld,\n",
			fx_data->wpn_hit,
			fx_data->wpn_crtcl,
			fx_data->wpn_dam );

	save_crypt_tab( fp, "// armor_def, armor_crtcl, armor_ac\n" );
	save_crypt_tab( fp, "%ld, %ld, %ld,\n",
			fx_data->armor_def,
			fx_data->armor_crtcl,
			fx_data->armor_ac );

	save_crypt_tab( fp, "// resi_stat\n" );
	save_crypt_tab( fp, "%08lx,\n", fx_data->resi_stat );

	save_crypt_tab( fp, "// cure_hp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// count\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_hp.count );
	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_hp.turn );
	save_crypt_tab( fp, "// rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_hp.rate );
	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_hp.n );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// cure_mp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// count\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_mp.count );
	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_mp.turn );
	save_crypt_tab( fp, "// rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_mp.rate );
	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->cure_mp.n );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// infra_vision\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->infra_vision );

	save_crypt_tab( fp, "// stomach\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// rate\n" );
	save_crypt_tab( fp, "%ld,\n",
			fx_data->stomach.rate );
	save_crypt_tab( fp, "// full_rate\n" );
	save_crypt_tab( fp, "%ld,\n",
			fx_data->stomach.full_rate );
	save_crypt_tab( fp, "// digest_p_day\n" );
	save_crypt_tab( fp, "%ld,\n",
			fx_data->stomach.digest_p_day );
	save_crypt_tab( fp, "// digest_n\n" );
	save_crypt_tab( fp, "%ld,\n",
			fx_data->stomach.digest_n );
	save_crypt_tab( fp, "// hungry_rate, starvation_rate\n" );
	save_crypt_tab( fp, "%ld, %ld, \n",
			fx_data->stomach.hungry_rate,
			fx_data->stomach.starvation_rate );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// drunk_rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->drunk_rate );

	save_crypt_tab( fp, "// nicotine\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "// rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->nicotine.rate );
	save_crypt_tab( fp, "// poisoning_rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->nicotine.poisoning_rate );
	save_crypt_tab( fp, "// lost_rate\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->nicotine.lost_rate );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// friend_turn\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->friend_turn );

	save_crypt_tab( fp, "// bless\n" );
	save_crypt_tab( fp, "%ld,\n", fx_data->bless );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡνͤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* const modifier_t *m : 
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_modifier_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	const modifier_t *m
)
{
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "// face_mjr, face_mnr\n" );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( m->face_mjr ) );
	save_crypt_tab( fp, "\'%s\',\n",
			cv_esc_quote_c( m->face_mnr ) );

	save_crypt_tab( fp, "// sex\n" );
	save_crypt_tab( fp, "%ld,\n",
			trans_sex_kind_to_idx( m->sex ) );

	save_crypt_tab( fp, "// wpn_hit, wpn_crtcl, wpn_dam\n" );
	save_crypt_tab( fp, "%ld, %ld, %ld,\n",
			m->wpn_hit, m->wpn_crtcl, m->wpn_dam );

	save_crypt_tab( fp, "// armor_def, armor_crtcl, armor_ac\n" );
	save_crypt_tab( fp, "%ld, %ld, %ld,\n",
			m->armor_def, m->armor_crtcl, m->armor_ac );

	save_crypt_tab( fp, "// abl_lev\n" );
	set_save_crypt_tab( fp, +1 );
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		save_crypt_tab( fp, "// %s\n",
				get_abl_name( (abl_kind_t)i ) );
		save_crypt_tab( fp, "%ld,\n", m->add_lev[i] );
	}
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// add_resi_n\n" );
	set_save_crypt_tab( fp, +1 );
	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		save_crypt_tab( fp, "%ld,\n", m->add_resi_n[i] );
	}
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// resi_stat\n" );
	save_crypt_tab( fp, "0x%08lx,\n", m->resi_stat );

	save_crypt_tab( fp, "// cure_hp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "%ld, %ld, %ld, %ld,\n",
			m->cure_hp.count, m->cure_hp.turn,
			m->cure_hp.rate, m->cure_hp.n );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// cure_mp\n" );
	set_save_crypt_tab( fp, +1 );
	save_crypt_tab( fp, "%ld, %ld, %ld, %ld,\n",
			m->cure_mp.count, m->cure_mp.turn,
			m->cure_mp.rate, m->cure_mp.n );
	set_save_crypt_tab( fp, -1 );

	save_crypt_tab( fp, "// add_move_speed\n" );
	save_crypt_tab( fp, "%ld,\n", m->add_move_speed );

	save_crypt_tab( fp, "// stomach_digest_n\n" );
	save_crypt_tab( fp, "%ld,\n", m->stomach_digest_n );

	save_crypt_tab( fp, "// teleport_n, teleport_party_n\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			m->teleport_n, m->teleport_party_n );

	save_crypt_tab( fp, "// bless\n" );
	save_crypt_tab( fp, "%ld,\n", m->bless );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡκȥǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* chr_t *chr : 饯
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_work_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	save_crypt_tab( fp, "// work\n" );
	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "// flg\n" );
	save_crypt_tab( fp, "0x%08lx,\n", chr->work.flg );

	save_crypt_tab( fp, "// caught\n" );
	save_crypt_tab( fp, "%ld,\n", chr->work.caught );

	/* struct chr_t	*catch_chr; */

	/* struct chr_t	*link_chr; */

	save_crypt_tab( fp, "// teleport_n\n" );
	save_crypt_tab( fp, "%ld,\n", chr->work.teleport_n );

	save_crypt_tab( fp, "// teleport_party_n\n" );
	save_crypt_tab( fp, "%ld,\n", chr->work.teleport_party_n );

	if( !chk_ver_old( ver, 1, 1, 3 ) ){
		long	n;

		if( chr->work.request == NULL ){
			n = -1;
		} else {
			request_t	*req_ls = get_request_ls();

			n = chr->work.request - req_ls;
		}

		save_crypt_tab( fp, "// request\n" );
		save_crypt_tab( fp, "%ld,\n", n );
	}

	save_crypt_tab( fp, "// towner_dx, towner_dy\n" );
	save_crypt_tab( fp, "%ld, %ld,\n",
			chr->work.towner_dx,
			chr->work.towner_dy );

	/* door_t	*enter_door; */

	save_crypt_tab( fp, "// dismissal_turn\n" );
	save_crypt_tab( fp, "%ld,\n", chr->work.dismissal_turn );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡƤΥСΥƥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_all_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	mbr_t	**ls_mbr;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// item\n" );

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "member_item %ld = ", i );
		save_game_data_item_mbr_ver_1( fp, ver, flg_txt, ls_mbr[i] );
	}

	return TRUE;
}

/***************************************************************
* ࡦǡΥСΥƥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr
)
{
	item_t	*head, *p, *item;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( chk_flg( mbr->stat, FLG_STAT_NOT_EXIST ) )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	head = get_mbr_item_asgn( mbr );
	p = head->next->next;
	for( i = 0; i < MBR_ITEM_MAX_N; i++, p = p->next ){
		item = p->prev;

		if( item == head )
			break;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "item = " );
		save_game_data_item_ver_1( fp, ver, flg_txt, mbr, item );
	}

	p = get_mbr_item_asgn_equip( mbr );
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		item = &(p[i]);

		if( item->kind == ITEM_KIND_NULL )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "equip %ld = ", i );
		save_game_data_item_ver_1( fp, ver, flg_txt, mbr, item );
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥƥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	bool_t	flg_success;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "// %s\n", get_item_mjr_name( item->mjr ) );
	save_crypt_tab( fp, "// %s\n",
			get_item_mnr_name( item->mjr, item->mnr ) );
	save_crypt_tab( fp, "\n" );

	idx = trans_item_kind_to_idx( item->kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// dat\n" );
	set_save_crypt_tab( fp, +1 );

	flg_success = FALSE;

	switch( item->kind ){
	case ITEM_KIND_NULL:
		return FALSE;
	case ITEM_KIND_WPN:
		flg_success = save_game_data_item_wpn_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ARMOR:
		flg_success = save_game_data_item_armor_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_POTION:
		flg_success = save_game_data_item_potion_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_SCROLL:
		flg_success = save_game_data_item_scroll_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_STICK:
		flg_success = save_game_data_item_stick_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ACCE:
		flg_success = save_game_data_item_acce_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_INST:
		flg_success = save_game_data_item_inst_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_ANTHOLOGY:
		flg_success = save_game_data_item_anthology_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_LIGHT:
		flg_success = save_game_data_item_light_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_SPIKE:
		flg_success = save_game_data_item_spike_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_FOOD:
		flg_success = save_game_data_item_food_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_CHEST:
		flg_success = save_game_data_item_chest_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_TOBACCO:
		flg_success = save_game_data_item_tobacco_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_PIPE:
		flg_success = save_game_data_item_pipe_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_DISPOSAL:
		flg_success = save_game_data_item_disposal_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_RARE_GOODS:
		flg_success = save_game_data_item_rare_goods_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_BONE:
		flg_success = save_game_data_item_bone_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_COIN:
		flg_success = save_game_data_item_coin_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_JUNK:
		flg_success = save_game_data_item_junk_ver_1(
				fp, ver, flg_txt, mbr, item );
		break;
	case ITEM_KIND_MAX_N:
		return FALSE;
	}
	if( !flg_success )
		return FALSE;

	set_save_crypt_tab( fp, -1 );

	/* item->next, item->prev */

	save_crypt_tab( fp, "// name\n" );
	save_crypt_tab( fp, "\"%s\",\n",
			cv_esc_quote_str( item->name ) );
	save_crypt_tab( fp, "// art_name\n" );
	save_crypt_tab( fp, "\"%s\",\n",
			cv_esc_quote_str( item->art_name ) );

	save_crypt_tab( fp, "// equip_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->equip_kind) );

	save_crypt_tab( fp, "// mjr\n" );
	save_crypt_tab( fp, "'%s',\n", cv_esc_quote_c( item->mjr ) );

	save_crypt_tab( fp, "// mnr\n" );
	save_crypt_tab( fp, "'%s',\n", cv_esc_quote_c( item->mnr ) );

	save_crypt_tab( fp, "// x\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->x) );
	save_crypt_tab( fp, "// y\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->y) );

	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->n) );
	save_crypt_tab( fp, "// stock\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->stock) );

	save_crypt_tab( fp, "// flg\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->flg) );

	save_game_data_modifier_ver_1(
			fp, ver, flg_txt, &(item->modifier) );

	/* tab */

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_wpn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_WPN )
		return FALSE;

	idx = trans_wpn_kind_to_idx( item->dat.wpn.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// add_hit\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.wpn.add_hit) );

	save_crypt_tab( fp, "// add_crtcl\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.wpn.add_crtcl) );

	save_crypt_tab( fp, "// add_dam\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.wpn.add_dam) );

	save_crypt_tab( fp, "// slayer\n" );
	save_crypt_tab( fp, "'%s',\n",
			cv_esc_quote_c( item->dat.wpn.slayer ) );

	save_crypt_tab( fp, "// flg\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.wpn.flg) );

	return TRUE;
}

/***************************************************************
* ࡦǡɶΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_armor_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_ARMOR )
		return FALSE;

	idx = trans_armor_kind_to_idx( item->dat.armor.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// add_def\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.armor.add_def) );

	save_crypt_tab( fp, "// add_crtcl\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.armor.add_crtcl) );

	save_crypt_tab( fp, "// add_ac\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.armor.add_ac) );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_potion_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_POTION )
		return FALSE;

	idx = trans_potion_kind_to_idx( item->dat.potion.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡδʪΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_scroll_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_SCROLL )
		return FALSE;

	idx = trans_scroll_kind_to_idx( item->dat.scroll.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡξΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_stick_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_STICK )
		return FALSE;

	idx = trans_stick_kind_to_idx( item->dat.stick.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_spell_kind_to_idx( item->dat.stick.spell_kind );
	save_crypt_tab( fp, "// spell_kind_idx\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.stick.n) );

	return TRUE;
}

/***************************************************************
* ࡦǡΥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_acce_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_ACCE )
		return FALSE;

	idx = trans_acce_kind_to_idx( item->dat.acce.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_ring_kind_to_idx( item->dat.acce.ring_kind );
	save_crypt_tab( fp, "// ring_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_amulet_kind_to_idx( item->dat.acce.amulet_kind );
	save_crypt_tab( fp, "// amulet_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_necklace_kind_to_idx( item->dat.acce.necklace_kind );
	save_crypt_tab( fp, "// necklace_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡγڴΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_inst_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_INST )
		return FALSE;

	idx = trans_inst_kind_to_idx( item->dat.inst.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// flg_limit\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.inst.flg_limit) );

	idx = trans_spell_kind_to_idx( item->dat.inst.spell_kind );
	save_crypt_tab( fp, "// spell_kind_idx\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡλΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_anthology_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_ANTHOLOGY )
		return FALSE;

	idx = trans_anthology_kind_to_idx( item->dat.anthology.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_light_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_LIGHT )
		return FALSE;

	idx = trans_light_kind_to_idx( item->dat.light.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.light.turn) );

	return TRUE;
}

/***************************************************************
* ࡦǡţΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_spike_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_SPIKE )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡοΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_food_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_FOOD )
		return FALSE;

	idx = trans_food_kind_to_idx( item->dat.food.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡȢΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_chest_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;
	item_t	*end, *p, *pp;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_CHEST )
		return FALSE;

	/* chest->contents */

	set_save_crypt_tab( fp, +1 );

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// contents item\n" );
	end = item->dat.chest.contents;
	for( p = end->next->next; p->prev != end; p = p->next ){
		pp = p->prev;

		save_crypt_tab( fp, "\n" );
		save_game_data_item_ver_1( fp, ver, flg_txt, mbr, pp );
	}

	set_save_crypt_tab( fp, -1 );

	/* chest->trap */

	save_crypt_tab( fp, "// trap\n" );
	set_save_crypt_tab( fp, +1 );

	/* chest->next, chest->prev */

	idx = trans_trap_kind_to_idx( item->dat.chest.trap->kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// x,\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.chest.trap->x) );

	save_crypt_tab( fp, "// y\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.chest.trap->y) );

	save_crypt_tab( fp, "// lev\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.chest.trap->lev) );

	save_crypt_tab( fp, "// difficulty\n" );
	save_crypt_tab( fp, "%ld,\n",
			(long)(item->dat.chest.trap->difficulty) );

	save_crypt_tab( fp, "// flg_chked\n" );
	save_crypt_tab( fp, "0x%08lx,\n",
			(long)(item->dat.chest.trap->flg_chked) );

	/* tab */

	set_save_crypt_tab( fp, -1 );

	/* chest->ref */

	save_crypt_tab( fp, "// ref\n" );
	save_crypt_tab( fp, "%ld,\n",
			(long)(item->dat.chest.contents->dat.chest.ref) );

	return TRUE;
}

/***************************************************************
* ࡦǡαΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_tobacco_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_TOBACCO )
		return FALSE;

	idx = trans_tobacco_kind_to_idx( item->dat.tobacco.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_tobacco_brand_to_idx( item->dat.tobacco.brand );
	save_crypt_tab( fp, "// brand\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.tobacco.turn) );

	return TRUE;
}

/***************************************************************
* ࡦǡΥѥפΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_pipe_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_PIPE )
		return FALSE;

	idx = trans_pipe_kind_to_idx( item->dat.pipe.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// turn\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.pipe.turn) );

	save_crypt_tab( fp, "// consume_turn\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.pipe.consume_turn) );

	return TRUE;
}

/***************************************************************
* ࡦǡεۤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_disposal_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_DISPOSAL )
		return FALSE;

	save_crypt_tab( fp, "// n\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.disposal.n) );

	save_crypt_tab( fp, "// max_n\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.disposal.max_n) );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ쥢åΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_rare_goods_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_RARE_GOODS )
		return FALSE;

	idx = trans_rare_goods_kind_to_idx( item->dat.rare_goods.kind );
	save_crypt_tab( fp, "// kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	idx = trans_mnstr_kind_to_idx( item->dat.rare_goods.mnstr_kind );
	save_crypt_tab( fp, "// mnstr_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡιΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_bone_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_BONE )
		return FALSE;
	if( item->dat.bone.mnstr_tab == NULL )
		return FALSE;

	idx = trans_mnstr_kind_to_idx(
			item->dat.bone.mnstr_tab->mnstr_kind );
	save_crypt_tab( fp, "// mnstr_kind\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	save_crypt_tab( fp, "// dun_lev\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(item->dat.bone.dun_lev) );

	return TRUE;
}

/***************************************************************
* ࡦǡζߤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_coin_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_COIN )
		return FALSE;

	idx = trans_coin_kind_to_idx( item->dat.coin.kind );
	save_crypt_tab( fp, "// coin\n" );
	save_crypt_tab( fp, "%ld,\n", (long)idx );

	return TRUE;
}

/***************************************************************
* ࡦǡΥߤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* mbr_t *mbr : С
* item_t *item : ƥ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_item_junk_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
)
{
	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_JUNK )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡοΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_potion_color_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_color_tab();
	idx_tab = get_color_idx_tab();

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// item color\n" );
	save_crypt_tab( fp, "potion_color = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		n_msg_t	name_n;

		if( tab[i].name_idx <= -1 )
			break;

		name_n = idx_tab[tab[i].name_idx];
		save_crypt_tab( fp, "// %s\n", MSG( name_n ) );
		save_crypt_tab( fp, "%ld,\n", tab[i].name_idx );
	}

	save_crypt_tab( fp, "// end\n" );
	save_crypt_tab( fp, "%ld,\n", (long)-1 );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡδʪΥȥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_scroll_ttl_syllable_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	scroll_tab_t	*tab;
	n_msg_t	*idx_tab;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	tab = get_scroll_tab_head();
	idx_tab = get_ttl_syllable_idx_tab();

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// item title syllable\n" );
	save_crypt_tab( fp, "scroll_ttl_syllable = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( tab[i].name_n == N_MSG_NULL )
			break;

		save_crypt_tab( fp, "// %s\n", tab[i].name );

		set_save_crypt_tab( fp, +1 );

		for( j = 0; j < SCROLL_TTL_SYLLABLE_MAX_N; j++ ){
			n_msg_idx_t	idx;

			idx = tab[i].ttl_idx[j];

			if( idx > -1 ){
				save_crypt_tab( fp, "// %s\n",
						MSG( idx_tab[idx] ) );
			} else {
				save_crypt_tab( fp, "// ----\n" );
			}

			save_crypt_tab( fp, "%ld,\n", idx );
		}

		save_crypt_tab( fp, "// end\n" );
		save_crypt_tab( fp, "%ld,\n", (long)-1 );

		set_save_crypt_tab( fp, -1 );
	}

	save_crypt_tab( fp, "// end\n" );
	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡξκΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* stick_kind_t kind : μ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_stick_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	stick_kind_t kind
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// item material\n" );

	idx_tab = get_stick_material_idx_tab();
	tab = NULL;

	switch( kind ){
	case STICK_KIND_NULL:
	case STICK_KIND_MAX_N:
		break;
	case STICK_KIND_WAND:
		save_crypt_tab( fp, "wand_material = " );

		tab = get_wand_material_tab();
		break;
	case STICK_KIND_ROD:
		save_crypt_tab( fp, "rod_material = " );

		tab = get_rod_material_tab();
		break;
	case STICK_KIND_STAFF:
		save_crypt_tab( fp, "staff_material = " );

		tab = get_staff_material_tab();
		break;
	}
	if( tab == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		n_msg_t	name_n;

		if( tab[i].name_idx <= -1 )
			break;

		name_n = idx_tab[tab[i].name_idx];
		save_crypt_tab( fp, "// %s\n", MSG( name_n ) );
		save_crypt_tab( fp, "%ld,\n", tab[i].name_idx );
	}

	save_crypt_tab( fp, "// end\n" );
	save_crypt_tab( fp, "%ld,\n", (long)-1 );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥκΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* acce_kind_t kind : μ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_acce_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	acce_kind_t kind
)
{
	ls_identified_t	*tab;
	n_msg_t	*idx_tab;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// item material\n" );

	idx_tab = get_acce_material_idx_tab();
	tab = NULL;

	switch( kind ){
	case ACCE_KIND_NULL:
	case ACCE_KIND_MAX_N:
		break;
	case ACCE_KIND_RING:
		save_crypt_tab( fp, "ring_material = " );

		tab = get_ring_material_tab();
		break;
	case ACCE_KIND_AMULET:
		save_crypt_tab( fp, "amulet_material = " );

		tab = get_amulet_material_tab();
		break;
	case ACCE_KIND_NECKLACE:
		save_crypt_tab( fp, "necklace_material = " );

		tab = get_necklace_material_tab();
		break;
	}
	if( tab == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		n_msg_t	name_n;

		if( tab[i].name_idx <= -1 )
			break;

		name_n = idx_tab[tab[i].name_idx];
		save_crypt_tab( fp, "// %s\n", MSG( name_n ) );
		save_crypt_tab( fp, "%ld,\n", tab[i].name_idx );
	}

	save_crypt_tab( fp, "// end\n" );
	save_crypt_tab( fp, "%ld,\n", (long)-1 );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡμ̥ե饰Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_potion_identified_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	potion_tab_t	*tab;
	potion_kind_t	kind;
	long	max_idx;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	max_idx = sizeof( g_potion_trans_tab )
			/ sizeof( g_potion_trans_tab[0] );

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// identified flags potion\n" );
	save_crypt_tab( fp, "potion_identified = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < max_idx; i++ ){
		kind = trans_idx_to_potion_kind( i );
		tab = get_potion_tab( kind );

		if( tab == NULL ){
			save_crypt_tab( fp, "// NULL\n" );
			save_crypt_tab( fp, "0,\n" );
		} else {
			save_crypt_tab( fp, "// %s\n", tab->name );
			save_crypt_tab( fp, "%ld,\n",
					(long)(tab->flg_identified) );
		}
	}

	save_crypt_tab( fp, "// end\n" );
	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡδʪμ̥ե饰Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_scroll_identified_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	scroll_tab_t	*tab;
	scroll_kind_t	kind;
	long	max_idx;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	max_idx = sizeof( g_scroll_trans_tab )
			/ sizeof( g_scroll_trans_tab[0] );

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// identified flags scroll\n" );
	save_crypt_tab( fp, "scroll_identified = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < max_idx; i++ ){
		kind = trans_idx_to_scroll_kind( i );
		tab = get_scroll_tab( kind );

		if( tab == NULL ){
			save_crypt_tab( fp, "// NULL\n" );
			save_crypt_tab( fp, "0,\n" );
		} else {
			save_crypt_tab( fp, "// %s\n", tab->name );
			save_crypt_tab( fp, "%ld,\n",
					(long)(tab->flg_identified) );
		}
	}

	save_crypt_tab( fp, "// end\n" );
	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡꥹȤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_auto_mark_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	mbr_t	**ls_mbr;
	auto_mark_t	*ls;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// auto mark\n" );

	save_crypt_tab( fp, "\n" );
	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		char	*ttl;

		ttl = get_msg_ttl_auto_mark_code( j );
		if( ttl == NULL )
			continue;

		save_crypt_tab( fp, "auto_mark_title %ld = \"%s\"\n",
				j, cv_esc_quote_str( ttl ) );
	}

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "auto_mark %ld = ", i );
		set_save_crypt_tab( fp, +1 );

		ls = get_ls_auto_mark( i );
		for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
			if( !save_game_data_auto_mark_ver_1(
					fp, ver, flg_txt, &(ls[j]) ) ){
				return FALSE;
			}
		}

		set_save_crypt_tab( fp, -1 );
	}

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		if( !save_game_data_auto_mark_appoint_item_ver_1(
				fp, ver, flg_txt, i ) ){
			return FALSE;
		}
	}

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡΥƥΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* long ls_mbr_n : Сꥹֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_auto_mark_appoint_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
)
{
	mbr_t	**ls_mbr;
	auto_mark_appoint_item_t	*ls;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;
	if( ls_mbr[ls_mbr_n] == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// %s\n", ls_mbr[ls_mbr_n]->name );
	save_crypt_tab( fp, "auto_mark_appoint_item %ld = ", ls_mbr_n );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		ls = get_ls_auto_mark_appoint_item( ls_mbr_n, i );
		if( ls == NULL )
			continue;

		save_crypt_tab( fp, "// %s\n",
				get_msg_ttl_auto_mark_name( i ) );
		set_save_crypt_tab( fp, +1 );

		for( j = 0; j < AUTO_MARK_APPOINT_ITEM_MAX_N; j++ ){
			if( ls[j].mjr == FACE_MJR_NULL )
				break;

			save_crypt_tab( fp, "\n" );
			save_crypt_tab( fp, "// %s\n",
					get_item_mnr_name( ls[j].mjr,
					ls[j].mnr ) );

			save_crypt_tab( fp, "// mjr\n" );
			save_crypt_tab( fp, "\'%s\',\n",
					cv_esc_quote_c( ls[j].mjr ) );

			save_crypt_tab( fp, "// mnr\n" );
			save_crypt_tab( fp, "\'%s\',\n",
					cv_esc_quote_c( ls[j].mnr ) );

			save_crypt_tab( fp, "// flg_ena\n" );
			save_crypt_tab( fp, "%ld,\n",
					(long)(ls[j].flg_ena) );
		}

		set_save_crypt_tab( fp, -1 );
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥ⡼ɡե饰Υ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_flg_srch_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	mbr_t	**ls_mbr;
	bool_t	*ls;
	long	i;

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;

	ls = get_ls_flg_srch();
	if( ls == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// list flag search\n" );
	save_crypt_tab( fp, "flg_srch = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		do {
			if( ls_mbr[i] == NULL )
				break;
			if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
				break;

			save_crypt_tab( fp, "//%s\n", ls_mbr[i]->name );
		} while( 0 );

		save_crypt_tab( fp, "%ld, //%ld\n", (long)(ls[i]), i );
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡμưޡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* const auto_mark_t *a : ưޡ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_auto_mark_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	const auto_mark_t *a
)
{
	long	idx;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( a == NULL )
		return FALSE;

	set_save_crypt_tab( fp, +1 );

	idx = trans_am_trgt_to_idx( a->trgt );
	save_crypt_tab( fp, "// target\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	idx = trans_am_dist_to_idx( a->dist );
	save_crypt_tab( fp, "// distance\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	idx = trans_am_act_to_idx( a->act );
	save_crypt_tab( fp, "// action\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	idx = trans_am_cond_to_idx( a->cond );
	save_crypt_tab( fp, "// condition\n" );
	save_crypt_tab( fp, "%ld,\n", idx );

	save_crypt_tab( fp, "// macro\n" );
	save_crypt_tab( fp, "\"%s\",\n", cv_esc_quote_str( a->macro ) );

	save_crypt_tab( fp, "// flag\n" );
	save_crypt_tab( fp, "%ld,\n", (long)(a->flg) );

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡμʸꥹȤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_spell_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	mbr_t	**ls_mbr;
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ls_mbr = get_ls_mbr();
	if( ls_mbr == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// spell\n" );

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i] == NULL )
			continue;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		save_crypt_tab( fp, "\n" );
		save_crypt_tab( fp, "spell %ld = ", i );
		set_save_crypt_tab( fp, +1 );

		for( j = 0; j < SPELL_KIND_MAX_N; j++ ){
			spell_kind_t	kind;
			cast_tab_t	*tab;

			kind = trans_idx_to_spell_kind( j );

			tab = get_cast_tab( ls_mbr[i], kind );
			if( tab == NULL )
				continue;

			if( !save_game_data_spell_ver_1(
					fp, ver, flg_txt, tab ) ){
				return FALSE;
			}
		}

		set_save_crypt_tab( fp, -1 );
	}

	return TRUE;
}

/***************************************************************
* ࡦǡμʸΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* cast_tab_t *tab : ʸλѲġԲĤΥꥹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_spell_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	cast_tab_t *tab
)
{
	char	*name;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;
	if( tab == NULL )
		return FALSE;

	name = get_spell_name( tab->kind );
	if( name == NULL )
		name = "";

	save_crypt_tab( fp, "// %s\n", name );
	save_crypt_tab( fp, "%ld,\n", tab->flg_cast );

	return TRUE;
}

/***************************************************************
* ࡦǡΥСΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_mbr_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	party_t	*pty = get_party();
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "member_formation = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < MBR_MAX_N; i++ ){
		bool_t	flg_null;

		flg_null = FALSE;

		if( pty->mbr[i] == NULL ){
			flg_null = TRUE;
		} else if( pty->mbr[i]->mbr_n == MBR_N_NOT_JOIN ){
			flg_null = TRUE;
		} else if( chk_flg( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST ) ){
			flg_null = TRUE;
		}

		if( flg_null ){
			save_crypt_tab( fp, "// NULL\n" );
			save_crypt_tab( fp, "-1,\n" );
		} else {
			save_crypt_tab( fp, "// %s\n",
					pty->mbr[i]->name );
			save_crypt_tab( fp, "%ld,\n",
					pty->mbr[i]->ls_mbr_n );
		}
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΥڥåȤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_pet_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	pet_t	**pet = get_party_pet();
	pet_t	**ls_pet = get_ls_pet();
	long	i, j;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "pet_formation = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < PET_MAX_N; i++ ){
		bool_t	flg_null;

		flg_null = FALSE;

		if( pet[i] == NULL ){
			flg_null = TRUE;
		} else if( chk_flg( pet[i]->stat, FLG_STAT_NOT_EXIST ) ){
			flg_null = TRUE;
		}

		if( flg_null ){
			save_crypt_tab( fp, "// NULL\n" );
			save_crypt_tab( fp, "-1,\n" );
		} else {
			for( j = 0; j < LS_PET_MAX_N; j++ )
				if( ls_pet[j] == pet[i] )
					break;

			if( j < LS_PET_MAX_N ){
				save_crypt_tab( fp, "// %s\n",
						pet[i]->name );
				save_crypt_tab( fp, "%ld,\n", j );
			}
		}
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* ࡦǡΰΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_request_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
)
{
	request_t	*req, *p;
	long	idx;
	long	i;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	req = get_request_ls();
	if( req == NULL )
		return FALSE;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "request = " );
	set_save_crypt_tab( fp, +1 );

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( req[i].kind == REQUEST_KIND_NULL )
			continue;

		set_save_crypt_tab( fp, +1 );

		if( !chk_ver_old( ver, 1, 1, 4 ) ){
			save_crypt_tab( fp, "// n\n" );
			save_crypt_tab( fp, "%ld,\n", i );
			p = &(req[i]);
		}

		idx = trans_request_kind_to_idx( req[i].kind );
		save_crypt_tab( fp, "// kind\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		save_crypt_tab( fp, "// dun_min_lev\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].dun_min_lev );
		save_crypt_tab( fp, "// dun_max_lev\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].dun_max_lev );
		save_crypt_tab( fp, "// dun_true_lev\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].dun_true_lev );

		save_crypt_tab( fp, "// prize\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].prize) );
		save_crypt_tab( fp, "// exp\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].exp );
		save_crypt_tab( fp, "// limit\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].limit );

		save_crypt_tab( fp, "// flg_contract\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].flg_contract) );
		save_crypt_tab( fp, "// flg_contract_mbr\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].flg_contract_mbr) );
		save_crypt_tab( fp, "// contract_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_contract_name) );
		idx = trans_sex_kind_to_idx( (sex_t)(req[i].contract_sex) );
		save_crypt_tab( fp, "// contract_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );
		save_crypt_tab( fp, "// flg_finish\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].flg_finish) );

		idx = trans_rare_goods_kind_to_idx( req[i].rare_goods_kind );
		save_crypt_tab( fp, "// rare_goods_kind\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		save_crypt_tab( fp, "// flg_mnstr_is_npc\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].flg_mnstr_is_npc) );

		idx = trans_mnstr_kind_to_idx( req[i].mnstr_kind );
		save_crypt_tab( fp, "// mnstr_kind\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		save_crypt_tab( fp, "// mnstr_n\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].mnstr_n );
		save_crypt_tab( fp, "// mnstr_exterminate_n\n" );
		save_crypt_tab( fp, "%ld,\n", req[i].mnstr_exterminate_n );

		save_crypt_tab( fp, "// heading\n" );
		save_crypt_tab( fp, "\"%s\",\n", req[i].heading );
		save_crypt_tab( fp, "// idx_fmt\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].idx_fmt) );
		save_crypt_tab( fp, "// msg\n" );
		save_crypt_tab( fp, "\"%s\",\n", req[i].msg );

		save_crypt_tab( fp, "// idx_client_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_client_name) );
		save_crypt_tab( fp, "// idx_mnstr_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_mnstr_name) );
		save_crypt_tab( fp, "// idx_rescue_trgt_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_rescue_trgt_name) );
		save_crypt_tab( fp, "// idx_client_family_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_client_family_name) );
		save_crypt_tab( fp, "// idx_client_mate_name\n" );
		save_crypt_tab( fp, "%ld,\n",
				(long)(req[i].idx_client_mate_name) );

		idx = trans_sex_kind_to_idx( req[i].client_sex );
		save_crypt_tab( fp, "// client_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		idx = trans_sex_kind_to_idx( req[i].mnstr_sex );
		save_crypt_tab( fp, "// mnstr_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		idx = trans_sex_kind_to_idx( req[i].rescue_trgt_sex );
		save_crypt_tab( fp, "// rescue_trgt_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		idx = trans_sex_kind_to_idx( req[i].client_family_sex );
		save_crypt_tab( fp, "// client_family_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		idx = trans_sex_kind_to_idx( req[i].client_mate_sex );
		save_crypt_tab( fp, "// client_mate_sex\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		idx = trans_mnstr_kind_to_idx( req[i].rescue_trgt_kind );
		save_crypt_tab( fp, "// rescue_trgt_kind\n" );
		save_crypt_tab( fp, "%ld,\n", idx );

		save_crypt_tab( fp, "// when_1\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].idx_when_1) );
		save_crypt_tab( fp, "// when_2\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].idx_when_2) );
		save_crypt_tab( fp, "// weapon\n" );
		save_crypt_tab( fp, "%ld,\n", (long)(req[i].idx_weapon) );

		set_save_crypt_tab( fp, -1 );
	}

	set_save_crypt_tab( fp, -1 );

	return TRUE;
}

/***************************************************************
* Υ(С 1)
* const ver_t *ver : եΥС
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_cnf_ver_1( const ver_t *ver, long n )
{
	FILE	*fp;
	time_t	save_time_buf;
	struct tm	*save_time;
	bool_t	flg_txt = TRUE;

	if( ver == NULL )
		return FALSE;

	fp = open_game_data_cnf( 'w', n );
	if( fp == NULL )
		return FALSE;

	/* header */

	fprintf( fp, "%s%ld.%ld.%ld\n",
			STR_GAME_DATA_HEAD,
			ver->mjr, ver->mnr, ver->pat );

	time( &save_time_buf );
	save_time = localtime( &save_time_buf );
	if( save_time == NULL )
		return FALSE;
	fprintf( fp, "%04ld: %04d/%02d/%02d  %02d:%02d:%02d\n",
			g_game_data_save_n,
			save_time->tm_year + 1900,
			save_time->tm_mon + 1,
			save_time->tm_mday,
			save_time->tm_hour,
			save_time->tm_min,
			save_time->tm_sec );

	reset_save_crypt( fp, flg_txt );
	reset_save_crypt_tab();

	/* data */

	if( !save_game_data_cnf_contents( fp, ver ) ){
		fclose( fp );
		return FALSE;
	}

	/* footer */

	save_crypt_str( fp, "\n" );
	save_crypt_tab( fp, "// end\n" );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ࡦǡƤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_data_cnf_contents(
	FILE *fp, const ver_t *ver
)
{
	bool_t	flg_err = FALSE;

	flg_err |= !save_game_conf_contents( fp, ver );
	flg_err |= !save_game_data_auto_mark_ls_ver_1( fp, ver, TRUE );

	if( flg_err )
		return FALSE;
	else
		return TRUE;
}

/***************************************************************
* ץ쥤Υ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_replay( void )
{
	bool_t	flg_success = FALSE;
	long	n;

	if( get_flg_play_replay() )
		return TRUE;

	n = SAVE_N_AUTO;
	if( save_game_replay_slot( n ) )
		flg_success = TRUE;

	n = get_replay_save_n();
	if( save_game_replay_slot( n ) )
		flg_success = TRUE;

	if( !flg_success )
		print_msg( FLG_NULL, MSG_CHK_REG_REPLAY_ERR );

	return flg_success;
}

/***************************************************************
* ץ쥤Υ(åȻꤢ)
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_replay_slot( long n )
{
	bool_t	flg_success = FALSE;
	ver_t	ver;

	if( !chk_reg_replay( n ) )
		return FALSE;

	ver.mjr = GAME_DATA_VER_MJR;
	ver.mnr = GAME_DATA_VER_MNR;
	ver.pat = GAME_DATA_VER_PAT;

	switch( ver.mjr ){
	case 1:
		flg_success = save_game_replay_ver_1( &ver,  n );
		break;
	default:
		flg_success = FALSE;
		break;
	}

	if( flg_success && (n != SAVE_N_BUG_REPO) )
		print_msg( FLG_NULL, MSG_SAVE_GAME_REPLAY_SUCCESS, n );

	return flg_success;
}

/***************************************************************
* ХݡȤΥץ쥤Υ
* return : 顼̵ä?
***************************************************************/

bool_t	save_bug_repo_replay( void )
{
	bool_t	flg_success = TRUE;

	if( get_flg_play_replay() )
		return TRUE;

	if( !copy_file_bug_repo() )
		flg_success = FALSE;
	if( !save_game_replay_slot( SAVE_N_BUG_REPO ) )
		flg_success = FALSE;

	if( flg_success ){
		print_msg( FLG_NULL, MSG_REPLAY_BUG_REPO_1 );
		print_msg( FLG_NULL, MSG_REPLAY_BUG_REPO_2 );
		print_msg( FLG_NULL, "[%s]", dir_name_bug_repo );
		print_msg( FLG_NULL, "Email : %s", STR_E_MAIL );
	} else {
		print_msg( FLG_NULL, MSG_CHK_REG_REPLAY_ERR );
	}

	return flg_success;
}

/***************************************************************
* ХݡȤΥࡦǡեΥԡ
* return : 顼̵ä?
***************************************************************/

bool_t	copy_file_bug_repo( void )
{
	char	path_src[FILE_NAME_MAX_LEN + 1];
	char	path_dst[FILE_NAME_MAX_LEN + 1];
	long	n;

	n = get_replay_save_n();
	if( n == SAVE_N_AUTO )
		return FALSE;

	/* txt */

	get_path_game_data_txt( path_src, n );
	get_path_bug_repo_txt( path_dst );
	if( !copy_file( path_src, path_dst ) )
		return FALSE;

	/* bin */

	get_path_game_data_bin( path_src, n );
	get_path_bug_repo_bin( path_dst );
	if( !copy_file( path_src, path_dst ) )
		return FALSE;

	/* cnf */

	get_path_game_data_cnf( path_src, n );
	get_path_bug_repo_cnf( path_dst );
	if( !copy_file( path_src, path_dst ) )
		return FALSE;

	/* rep */
	/* empty */

	return TRUE;
}

/***************************************************************
* ץ쥤Υ(С 1)
* const ver_t *ver : եΥС
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_replay_ver_1( const ver_t *ver, long n )
{
	FILE	*fp;
	time_t	save_time_buf;
	struct tm	*save_time;
	bool_t	flg_txt = TRUE;

	if( ver == NULL )
		return FALSE;

	fp = open_game_replay( 'w', n );
	if( fp == NULL )
		return FALSE;

	/* header */

	fprintf( fp, "%s%ld.%ld.%ld\n",
			STR_GAME_REPLAY_HEAD,
			ver->mjr, ver->mnr, ver->pat );

	time( &save_time_buf );
	save_time = localtime( &save_time_buf );
	if( save_time == NULL )
		return FALSE;
	fprintf( fp, "%04ld: %04d/%02d/%02d  %02d:%02d:%02d\n",
			g_game_data_save_n,
			save_time->tm_year + 1900,
			save_time->tm_mon + 1,
			save_time->tm_mday,
			save_time->tm_hour,
			save_time->tm_min,
			save_time->tm_sec );

	reset_save_crypt( fp, flg_txt );
	reset_save_crypt_tab();

	/* data */

	if( !save_game_replay_contents( fp, ver, n ) ){
		fclose( fp );
		return FALSE;
	}

	/* footer */

	save_crypt_str( fp, "\n" );
	save_crypt_tab( fp, "// end\n" );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ץ쥤ƤΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* long n : ǡåֹ
* return : 顼̵ä?
***************************************************************/

bool_t	save_game_replay_contents(
	FILE *fp, const ver_t *ver, long n
)
{
	replay_t	*p;
	replay_kind_t	pre_kind;
	char	*msg;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	pre_kind = REPLAY_KIND_MAX_N;

	save_crypt_tab( fp, "\n" );
	save_crypt_tab( fp, "// replay\n" );

	save_crypt_tab( fp, "\n" );
	for( p = get_replay_head( n ); p != NULL; p = p->next ){
		if( p->kind == pre_kind )
			msg = NULL;
		else
			msg = get_msg_replay_kind( p );

		if( (msg != NULL) && (msg[0] != '\0') )
			save_crypt_tab( fp, "%s\n", msg );

		save_crypt_tab( fp, "\t\"%s\",\n",
				cv_esc_quote_str(
				cv_esc_ctrl_str(
				p->buf ) ) );

		pre_kind = p->kind;
	}

	return TRUE;
}

/***************************************************************
* եåΥ
* char *path : եΥեѥ
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf( char *path )
{
	ver_t	ver;
	FILE	*fp;
	bool_t	flg_err;

	flg_err = TRUE;

	/* ե򥪡ץ */

	fp = fopen( path, "r" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( path, TRUE );

	/* إåɤ߹ */

	if( !load_graph_conf_head( fp, &ver ) ){
		fclose( fp );
		return TRUE;
	}

	/* СΥå */

	if( !chk_ver_old( &ver,
			GRAPH_CONF_VER_MJR,
			GRAPH_CONF_VER_MNR,
			GRAPH_CONF_VER_PAT ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		fclose( fp );
		return TRUE;
	}

	/* ǡɤ߹ */

	switch( ver.mjr ){
	case 1:
		load_graph_conf_data_ver_1( fp, &ver );
		flg_err = get_rc_lex_err();
		break;
	default:
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_A,
				ver.mjr, ver.mnr, ver.pat );
		print_msg( FLG_MSG_ERR, MSG_ERR_FILE_VER_B );

		flg_err = TRUE;
		break;
	}

	/* ե򥯥 */

	if( fclose( fp ) == EOF )
		return TRUE;

	/* 顼åɽ */

	if( flg_err ){
		print_err( MSG_ERR_RC );
		print_err( "'%s'", get_rc_lex_file_name() );
	}

	return TRUE;
}

/***************************************************************
* եåΥإåΥ
* FILE *fp : ե
* ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_head( FILE *fp, ver_t *ver )
{
	const long	len_head = str_len_std( STR_GRAPH_CONF_HEAD );
	char	*s;

	if( fp == NULL )
		return FALSE;
	if( ver == NULL )
		return FALSE;

	ver->mjr = 0;
	ver->mnr = 0;
	ver->pat = 0;

	s = load_line( fp, TRUE );
	if( strncmp( s, STR_GRAPH_CONF_HEAD, len_head ) != 0 ){
		print_lex_err( MSG_ERR_LOAD_GRAPH_CONF_HEAD );
		return FALSE;
	}

	/* С󡦥å */

	if( str_len_std( s ) < len_head )
		return FALSE;
	s = &(s[len_head]);

	sscanf( s, " %ld.%ld.%ld ", &(ver->mjr), &(ver->mnr), &(ver->pat) );

	if( (ver->mjr == 0) && (ver->mnr == 0) && (ver->pat == 0) )
		return FALSE;

	/**/

	return TRUE;
}

/***************************************************************
* եåΥǡΥ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
***************************************************************/

void	load_graph_conf_data_ver_1( FILE *fp, const ver_t *ver )
{
	while( 1 ){
		if( !load_graph_conf_parse_ver_1( fp, ver ) )
			break;
	}
}

/***************************************************************
* եåΥѡ(С 1)
* FILE *fp : ե
* const ver_t *ver : եΥС
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_parse_ver_1( FILE *fp, const ver_t *ver )
{
	rc_token_t	t[MAX_TOKEN];
	rc_union_t	u[MAX_TOKEN];
	bool_t	flg_err_exit, flg_err;
	long	i;

	flg_err_exit = FALSE;

	for( i = 0; i < MAX_TOKEN; i++ )
		t[i] = RC_TOKEN_EOF;

	for( i = 0; i < MAX_TOKEN; i++ ){
		t[i] = rc_lex( fp, &(u[i]), flg_err_exit );
		if( t[i] == RC_TOKEN_EOF )
			break;
		if( t[i] == '\n' )
			break;
	}
	if( i >= MAX_TOKEN ){
		for( i = 0; i < LOOP_MAX_100; i++ ){
			rc_token_t	t;
			rc_union_t	u;

			t = rc_lex( fp, &u, flg_err_exit );
			if( t == RC_TOKEN_EOF )
				break;
			if( t == '\n' )
				break;
		}
	}

	flg_err = FALSE;

	if( t[0] == RC_TOKEN_EOF ){
		return FALSE;
	} else if( t[0] == '\n' ){
		return TRUE;
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == '{')
			&& (t[2] == '\n') ){
		/* foo { */

		if( !load_graph_conf_block_begin(
				fp, ver, flg_err_exit,
				u[0].str, 0 ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == '}')
			&& (t[1] == '\n') ){
		/* } */

		if( !load_graph_conf_block_end(
				fp, ver, flg_err_exit,
				"", 0 ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_NUM)
			&& (t[3] == '\n') ){
		/* foo = n */

		if( !load_graph_conf_set_val(
				fp, ver, flg_err_exit,
				u[0].str, u[2].n ) ){
			flg_err = TRUE;
		}
	} else if( (t[0] == RC_TOKEN_ID)
			&& (t[1] == RC_TOKEN_EQ_OP)
			&& (t[2] == RC_TOKEN_STR)
			&& (t[3] == '\n') ){
		/* foo = str */

		if( !load_graph_conf_set_str(
				fp, ver, flg_err_exit,
				u[0].str, u[2].str ) ){
			flg_err = TRUE;
		}
	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE );
		flg_err = TRUE;
	}

	if( flg_err ){
		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
		return FALSE;
	} else {
		return TRUE;
	}
}

/***************************************************************
* եåΥ֥å򳫻
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ֥å̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_block_begin(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long val
)
{
	return call_sel_conf_eval_block_begin();
}

/***************************************************************
* եåΥ֥åλ
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ֥å̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_block_end(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long val
)
{
	return call_sel_conf_eval_block_end();
}

/***************************************************************
* եåѿ˿ͤ
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ѿ̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_set_val(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long val
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( strcmp( id, "scale" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_SCALE, val );

	} else if( strcmp( id, "tile_size_x" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_TILE_SIZE_X, val );

	} else if( strcmp( id, "tile_size_y" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_TILE_SIZE_Y, val );

	} else if( strcmp( id, "text_mode" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_TEXT_MODE, val );

	} else if( strcmp( id, "font_size_point" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_FONT_SIZE_POINT, val );

	} else if( strcmp( id, "font_size_dot" ) == 0 ){
		return call_sel_conf_eval_set_num(
				GRAPH_CONF_TOKEN_FONT_SIZE_DOT, val );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );
		print_lex_err( "'%s'", id );
		return FALSE;
	}

	return FALSE;
#else
	return TRUE;
#endif
}

/***************************************************************
* եåѿʸ
* FILE *fp : ե
* const ver_t *ver : եΥС
* bool_t flg_err_exit : 顼ǽλ뤫?
* char *id : ѿ̾
* long val : 
* return : 顼̵ä?
***************************************************************/

bool_t	load_graph_conf_set_str(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, char *str
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( strcmp( id, "title" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_TITLE, str );

	} else if( strcmp( id, "character_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_CHARACTER_PATERN, str );

	} else if( strcmp( id, "pc_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_PC_PATERN, str );

	} else if( strcmp( id, "monster_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_MONSTER_PATERN, str );

	} else if( strcmp( id, "wall_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_WALL_PATERN, str );

	} else if( strcmp( id, "door_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_DOOR_PATERN, str );

	} else if( strcmp( id, "signboard_patern" ) == 0 ){
		return call_sel_conf_eval_set_str(
				GRAPH_CONF_TOKEN_SIGNBOARD_PATERN, str );

	} else {
		print_lex_err( MSG_S, MSG_ERR_RC_PARSE_DEF_ID );

		return FALSE;
	}

	return FALSE;
#else
	return TRUE;
#endif
}

/***************************************************************
* ࡦǡեΥƥȤΥѥ֤
* char *path : ѥ֤
* long n : ǡåֹ
***************************************************************/

void	get_path_game_data_txt( char *path, long n )
{
	if( n == SAVE_N_BUG_REPO ){
		get_path_bug_repo_txt( path );
		return;
	}

	sprintf( path, "%s/%s%02ld%s",
			dir_name_game_data_txt,
			STR_FILE_NAME_GAME_DATA_TXT,
			n,
			STR_EXT_NAME_GAME_DATA_TXT );
}

/***************************************************************
* ࡦǡեΥХʥΥѥ֤
* char *path : ѥ֤
* long n : ǡåֹ
***************************************************************/

void	get_path_game_data_bin( char *path, long n )
{
	if( n == SAVE_N_BUG_REPO ){
		get_path_bug_repo_bin( path );
		return;
	}

	sprintf( path, "%s/%s%02ld%s",
			dir_name_game_data_bin,
			STR_FILE_NAME_GAME_DATA_BIN,
			n,
			STR_EXT_NAME_GAME_DATA_BIN );
}

/***************************************************************
* ࡦǡեΥѥ֤
* char *path : ѥ֤
* long n : ǡåֹ
***************************************************************/

void	get_path_game_data_cnf( char *path, long n )
{
	if( n == SAVE_N_BUG_REPO ){
		get_path_bug_repo_cnf( path );
		return;
	}

	sprintf( path, "%s/%s%02ld%s",
			dir_name_game_data_cnf,
			STR_FILE_NAME_GAME_DATA_CNF,
			n,
			STR_EXT_NAME_GAME_DATA_CNF );
}

/***************************************************************
* ࡦǡեΥץ쥤Υѥ֤
* char *path : ѥ֤
* long n : ǡåֹ
***************************************************************/

void	get_path_game_data_rep( char *path, long n )
{
	if( n == SAVE_N_BUG_REPO ){
		get_path_bug_repo_rep( path );
		return;
	}

	sprintf( path, "%s/%s%02ld%s",
			dir_name_game_data_rep,
			STR_FILE_NAME_GAME_DATA_REP,
			n,
			STR_EXT_NAME_GAME_DATA_REP );
}

/***************************************************************
* ХݡȤΥƥȤΥѥ֤
* char *path : ѥ֤
***************************************************************/

void	get_path_bug_repo_txt( char *path )
{
	sprintf( path, "%s/%s%s",
			dir_name_bug_repo,
			STR_FILE_NAME_BUG_REPO_TXT,
			STR_EXT_NAME_BUG_REPO_TXT );
}

/***************************************************************
* ХݡȤΥХʥΥѥ֤
* char *path : ѥ֤
***************************************************************/

void	get_path_bug_repo_bin( char *path )
{
	sprintf( path, "%s/%s%s",
			dir_name_bug_repo,
			STR_FILE_NAME_BUG_REPO_BIN,
			STR_EXT_NAME_BUG_REPO_BIN );
}

/***************************************************************
* ХݡȤΥѥ֤
* char *path : ѥ֤
***************************************************************/

void	get_path_bug_repo_cnf( char *path )
{
	sprintf( path, "%s/%s%s",
			dir_name_bug_repo,
			STR_FILE_NAME_BUG_REPO_CNF,
			STR_EXT_NAME_BUG_REPO_CNF );
}

/***************************************************************
* ХݡȤΥץ쥤Υѥ֤
* char *path : ѥ֤
***************************************************************/

void	get_path_bug_repo_rep( char *path )
{
	sprintf( path, "%s/%s%s",
			dir_name_bug_repo,
			STR_FILE_NAME_BUG_REPO_REP,
			STR_EXT_NAME_BUG_REPO_REP );
}

/***************************************************************
* ࡦǡեΥץ
* char type : 'r' = ꡼ , 'w' = 饤
* long n : ǡåֹ
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : ե롦ݥ
***************************************************************/

FILE	*open_game_data( char type, long n, bool_t flg_txt )
{
	char	path[FILE_NAME_MAX_LEN + 1];
	FILE	*fp;

	if( flg_txt ){
		get_path_game_data_txt( path, n );

		if( type == 'r' )
			fp = fopen( path, "r" );
		else if( type == 'w' )
			fp = fopen( path, "w" );
		else
			fp = NULL;
	} else {
		get_path_game_data_bin( path, n );

		if( type == 'r' )
			fp = fopen( path, "rb" );
		else if( type == 'w' )
			fp = fopen( path, "wb" );
		else
			fp = NULL;
	}

	reset_load_save( path, flg_txt );

	return fp;
}

/***************************************************************
* ꡦեΥץ
* char type : 'r' = ꡼ , 'w' = 饤
* long n : ǡåֹ
* return : ե롦ݥ
***************************************************************/

FILE	*open_game_data_cnf( char type, long n )
{
	char	path[FILE_NAME_MAX_LEN + 1];
	FILE	*fp;

	get_path_game_data_cnf( path, n );

	if( type == 'r' )
		fp = fopen( path, "r" );
	else if( type == 'w' )
		fp = fopen( path, "w" );
	else
		fp = NULL;

	reset_load_save( path, TRUE );

	return fp;
}

/***************************************************************
* ץ쥤եΥץ
* char type : 'r' = ꡼ , 'w' = 饤
* long n : ǡåֹ
* return : ե롦ݥ
***************************************************************/

FILE	*open_game_replay( char type, long n )
{
	char	path[FILE_NAME_MAX_LEN + 1];
	FILE	*fp;

	get_path_game_data_rep( path, n );

	if( type == 'r' )
		fp = fopen( path, "r" );
	else if( type == 'w' )
		fp = fopen( path, "w" );
	else
		fp = NULL;

	reset_load_save( path, TRUE );

	return fp;
}

/***************************************************************
* ץ쥤եκ
* long n : ǡåֹ
***************************************************************/

void	remove_replay_file( long n )
{
	FILE	*fp;

	fp = open_game_replay( 'w', n );

	if( fp != NULL )
		fclose( fp );
}

/***************************************************************
* ࡦǡեΥȥ֤
* char *msg : ȥ֤
* long n : ǡåֹ
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : Ǥ˥ե뤬ͭ뤫?
***************************************************************/

bool_t	get_save_load_ttl(
	char *msg, long n,
	bool_t flg_txt, bool_t flg_replay
)
{
	static char	buf[BUF_LINE_LEN + 1];

	if( get_game_data_head_time( buf, n, flg_txt, flg_replay ) ){
		sprintf( msg, MSG_SAVE_LOAD_TTL_FMT, n, buf );

		return TRUE;
	} else {
		sprintf( msg, MSG_SAVE_LOAD_TTL_FMT, n,
				MSG_SAVE_LOAD_TTL_NULL );

		return FALSE;
	}

	return FALSE;
}

/***************************************************************
* ࡦǡեΥɤ߹
* char *str : ֤
* long n : ǡåֹ
* bool_t flg_txt : ƥȡ⡼ɤ?
* return : 顼̵ä?
***************************************************************/

bool_t	get_game_data_head_time(
	char *str, long n,
	bool_t flg_txt, bool_t flg_replay
)
{
	FILE	*fp;
	size_t	idx;

	if( str == NULL )
		return FALSE;

	if( flg_replay )
		fp = open_game_replay( 'r', n );
	else
		fp = open_game_data( 'r', n, flg_txt );
	if( fp == NULL )
		return FALSE;

	if( fgets( str, BUF_LINE_LEN, fp ) == NULL )
		return FALSE;
	if( fgets( str, BUF_LINE_LEN, fp ) == NULL )
		return FALSE;

	idx = strcspn( str, "\n\r" );
	if( idx >= 0 )
		str[idx] = '\0';

	return TRUE;
}

/***************************************************************
* ե뤫 1 ʸɤ߹
* FILE *fp : ե
* bool_t flg_chk_eof : եνλå뤫?
* return : ɤ߹ʸ
***************************************************************/

long	load_char( FILE *fp, bool_t flg_chk_eof )
{
	return rc_lex_getc( fp, flg_chk_eof, TRUE );
}

/***************************************************************
* ե뤫 1 ɤ߹(ԤȥȤФ)
* FILE *fp : ե
* bool_t flg_chk_eof : եνλå뤫?
* return : ɤ߹
***************************************************************/

char	*load_line_skip_spc( FILE *fp, bool_t flg_chk_eof )
{
	char	*s;

	while( !feof( fp ) ){
		s = load_line( fp, flg_chk_eof );

		if( s[0] == '#' )
			continue;
		if( s[strspn( s, " \t\n\r" )] == '\0' )
			continue;

		return s;
	}

	if( flg_chk_eof ){
		fclose( fp );
		print_err( MSG_S, MSG_ERR_LOAD_EOF );
		exit_game( EXIT_FAILURE );
	}

	return NULL;
}

/***************************************************************
* ե뤫 1 ɤ߹
* FILE *fp : ե
* bool_t flg_chk_eof : եνλå뤫?
* return : ɤ߹
***************************************************************/

char	*load_line( FILE *fp, bool_t flg_chk_eof )
{
	static char	buf[BUF_LINE_LEN + 1];

	if( !feof( fp ) ){
		load_crypt_str( fp, buf, BUF_LINE_LEN );

		return buf;
	}

	if( flg_chk_eof ){
		fclose( fp );
		print_err( MSG_S, MSG_ERR_LOAD_EOF );
		exit_game( EXIT_FAILURE );
	}

	return NULL;
}

/***************************************************************
* Υե̾
* char *name : ե̾긵
* return : ꤵ줿ե̾
***************************************************************/

char	*set_rc_lex_file_name( char *name )
{
	str_nz_cpy( g_rc_lex_file_name, name, FILE_NAME_MAX_LEN );

	return g_rc_lex_file_name;
}

/***************************************************************
* Υե֤̾
* return : ե̾
***************************************************************/

char	*get_rc_lex_file_name( void )
{
	return g_rc_lex_file_name;
}

/***************************************************************
* θߤιֹ
* return : ֹ
***************************************************************/

long	clr_rc_lex_line( void )
{
	g_rc_lex_line = 1;

	return g_rc_lex_line;
}

/***************************************************************
* θߤιֹ򥤥󥯥Ȥ
* return : ֹ
***************************************************************/

long	inc_rc_lex_line( void )
{
	g_rc_lex_line++;

	return g_rc_lex_line;
}

/***************************************************************
* θߤιֹǥȤ
* return : ֹ
***************************************************************/

long	dec_rc_lex_line( void )
{
	g_rc_lex_line--;

	return g_rc_lex_line;
}

/***************************************************************
* θߤιֹ֤
* return : ֹ
***************************************************************/

long	get_rc_lex_line( void )
{
	return g_rc_lex_line;
}

/***************************************************************
* Υ顼֤
* bool_t flg : ꤹ륨顼
* return : 顼
***************************************************************/

bool_t	set_rc_lex_err( bool_t flg )
{
	g_flg_rc_lex_err = flg;

	return g_flg_rc_lex_err;
}

/***************************************************************
* Υ顼֤֤
* return : 顼
***************************************************************/

bool_t	get_rc_lex_err( void )
{
	return g_flg_rc_lex_err;
}

/***************************************************************
* եλϤ򤹤
* FILE *fp : ե
* rc_union_t *u : ϤΥå
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : ȡ
***************************************************************/

rc_token_t	rc_lex( FILE *fp, rc_union_t *u, bool_t flg_err_exit )
{
	static char	buf[TOKEN_MAX_LEN + 1];
	long	c;
	long	n;

	if( g_un_token != RC_TOKEN_NULL ){
		rc_token_t	pre_t;

		pre_t = g_un_token;
		g_un_token = RC_TOKEN_NULL;
		*u = g_un_union;

		return pre_t;
	}

	while( 1 ){
		c = rc_lex_getc( fp, FALSE, flg_err_exit );

		switch( c ){
		case EOF:
			return RC_TOKEN_EOF;
		case ' ':
		case '\t':
			continue;
		case '\n':
		case '\r':
			return( (rc_token_t)'\n' );
		case '/':
			c = rc_lex_getc( fp, FALSE, flg_err_exit );
			if( c != '/' ){
				rc_lex_ungetc( fp, c );
				c = '/';
				break;
			}
			/* break; */
		case '#':
			while( 1 ){
				load_crypt_str( fp, buf, TOKEN_MAX_LEN );
				if( str_len_std( buf ) != TOKEN_MAX_LEN )
					break;
				if( buf[TOKEN_MAX_LEN - 1] == '\n' )
					break;
			}
			continue;
		case '\'':
			rc_lex_char( fp, u, flg_err_exit );

			c = rc_lex_getc( fp, TRUE, flg_err_exit );
			if( c != '\'' ){
				print_lex_err( MSG_S, MSG_ERR_RC_LEX_CHAR );
				if( flg_err_exit )
					exit_game( EXIT_FAILURE );
			}
			return RC_TOKEN_CHAR;
		case '\"':
			return( rc_lex_str( fp, u, flg_err_exit ) );
		case '0':
			c = rc_lex_getc( fp, TRUE, flg_err_exit );
			if( ('0' <= c) && (c <= '7') ){
				rc_lex_ungetc( fp, c );
				n = rc_lex_oct( fp,
						TOKEN_MAX_LEN,
						flg_err_exit );
			} else if( (c == 'x') || (c == 'X') ){
				n = rc_lex_hex_dec( fp,
						TOKEN_MAX_LEN,
						flg_err_exit );
			} else {
				rc_lex_ungetc( fp, c );
				n = 0;
			}

			if( u != NULL )
				u->n = n;
			return RC_TOKEN_NUM;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			rc_lex_ungetc( fp, c );
			n = rc_lex_dec( fp,
					TOKEN_MAX_LEN,
					flg_err_exit );

			if( u != NULL )
				u->n = n;
			return RC_TOKEN_NUM;
		case '+':
		case '-':
			if( u != NULL )
				u->c = c;
			return RC_TOKEN_ADD_OP;
		case '=':
			if( u != NULL )
				u->c = c;
			return RC_TOKEN_EQ_OP;
		case '{':
		case '}':
		case ',':
			if( u != NULL )
				u->c = c;
			return( (rc_token_t)c );
		default:
			if( isalpha( c ) || (c == '_') ){
				rc_lex_ungetc( fp, c );
				rc_lex_id( fp, u, flg_err_exit );
				return RC_TOKEN_ID;
			} else {
				break;
			}
		}

		break;
	}

	print_lex_err( MSG_ERR_RC_LEX, (char)c, (long)c );
	if( flg_err_exit )
		exit_game( EXIT_FAILURE );

	return RC_TOKEN_EOF;
}

/***************************************************************
* Ϥä 1 ȡ᤹
* FILE *fp : ե
* rc_union_t *u : ϤΥå
* rc_token_t t : ȡ
***************************************************************/

void	rc_unlex( FILE *fp, const rc_union_t *u, rc_token_t t )
{
	g_un_token = t;
	g_un_union = *u;
}

/***************************************************************
* ե 1 ʸϤ
* FILE *fp : ե
* rc_union_t *u : ϤΥå
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : ȡ
***************************************************************/

rc_token_t	rc_lex_char( FILE *fp, rc_union_t *u, bool_t flg_err_exit )
{
	long	c, cc;

	cc = '\0';

	c = rc_lex_getc( fp, TRUE, flg_err_exit );
	if( c == EOF )
		return RC_TOKEN_EOF;

	if( c == '\\' ){
		c = rc_lex_getc( fp, TRUE, flg_err_exit );
		if( c == EOF )
			return RC_TOKEN_EOF;

		switch( c ){
		case '\\':
			cc = '\\';
			break;
		case '0':
			c = rc_lex_getc( fp, TRUE, flg_err_exit );

			if( (c == 'x') || (c == 'X') ){
				cc = rc_lex_hex_dec( fp, 4, flg_err_exit );
			} else {
				rc_lex_ungetc( fp, c );
				cc = rc_lex_oct( fp, 3, flg_err_exit );
			}
			break;
		case 'x':
			cc = rc_lex_hex_dec( fp, 2, flg_err_exit );
			break;
		case 't':
			cc = '\t';
			break;
		case 'r':
			cc = '\r';
			break;
		case 'n':
			cc = '\n';
			break;
		case '\'':
			cc = '\'';
			break;
		case '\"':
			cc = '\"';
			break;
		default:
			cc = c;
			break;
		}
	} else if( c == '^' ){
		c = rc_lex_getc( fp, TRUE, flg_err_exit );
		if( c == EOF )
			return RC_TOKEN_EOF;

		cc = toupper( c ) - '@';
	} else {
		cc = c;
	}

	if( u != NULL )
		u->c = cc;
	return RC_TOKEN_CHAR;
}

/***************************************************************
* եʸϤ
* FILE *fp : ե
* rc_union_t *u : ϤΥå
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : ȡ
***************************************************************/

rc_token_t	rc_lex_str( FILE *fp, rc_union_t *u, bool_t flg_err_exit )
{
	rc_union_t	uu;
	long	c;
	long	i;

	for( i = 0; i < TOKEN_MAX_LEN; i++ ){
		rc_token_t	token;

		c = rc_lex_getc( fp, TRUE, flg_err_exit );
		if( c == '\"' )
			break;
		else
			rc_lex_ungetc( fp, c );

		token = rc_lex_char( fp, &uu, flg_err_exit );
		if( token == RC_TOKEN_EOF )
			return RC_TOKEN_EOF;

		if( u != NULL )
		  u->str[i] = (char)(uu.c);
	}

	if( u != NULL )
		u->str[i] = '\0';

	return RC_TOKEN_STR;
}

/***************************************************************
* ե 8 ʿϤ
* FILE *fp : ե
* long len : ʸ
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 
***************************************************************/

long	rc_lex_oct( FILE *fp, long len, bool_t flg_err_exit )
{
	return rc_lex_digit( fp, 8, len, flg_err_exit );
}

/***************************************************************
* ե 10 ʿϤ
* FILE *fp : ե
* long len : ʸ
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 
***************************************************************/

long	rc_lex_dec( FILE *fp, long len, bool_t flg_err_exit )
{
	return rc_lex_digit( fp, 10, len, flg_err_exit );
}

/***************************************************************
* ե 16 ʿϤ
* FILE *fp : ե
* long len : ʸ
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 
***************************************************************/

long	rc_lex_hex_dec( FILE *fp, long len, bool_t flg_err_exit )
{
	return rc_lex_digit( fp, 16, len, flg_err_exit );
}

/***************************************************************
* ե n ʿϤ
* FILE *fp : ե
* long base : 
* long len : ʸ
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 
***************************************************************/

long	rc_lex_digit( FILE *fp, long base, long len, bool_t flg_err_exit )
{
	long	ret, n;
	long	c;
	long	i;

	ret = 0;
	n = 0;
	c = rc_lex_getc( fp, FALSE, flg_err_exit );

	for( i = 0; i < len; i++ ){
		if( ('0' <= c) && (c <= '9') ){
			n = c - '0';
		} else if( ('a' <= c) && (c <= 'z') ){
			n = c - 'a' + 10;
		} else if( ('A' <= c) && (c <= 'Z') ){
			n = c - 'A' + 10;
		} else {
			break;
		}

		if( n >= base )
			break;

		ret *= base;
		ret += n;

		c = rc_lex_getc( fp, FALSE, flg_err_exit );
	}

	rc_lex_ungetc( fp, c );

	return ret;
}

/***************************************************************
* եμ̻ҤϤ
* FILE *fp : ե
* rc_union_t *u : ϤΥå
* bool_t flg_err_exit : 顼ǽλ뤫?
***************************************************************/

void	rc_lex_id( FILE *fp, rc_union_t *u, bool_t flg_err_exit )
{
	long	c;
	long	i;

	i = 0;

	while( 1 ){
		c = rc_lex_getc( fp, FALSE, flg_err_exit );

		if( isalpha( c ) || (c == '_') || isdigit( c ) ){
			if( (u != NULL) && (i < TOKEN_MAX_LEN) ){
				u->str[i] = (char)c;
				i++;
			}
		} else {
			rc_lex_ungetc( fp, c );
			break;
		}
	}

	u->str[i] = '\0';
}

/***************************************************************
* ե뤫 1 ʸɤ߹
* FILE *fp : ե
* bool_t flg_chk_eof : եνå뤫?
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : ɤ߹ʸ
***************************************************************/

long	rc_lex_getc( FILE *fp, bool_t flg_chk_eof, bool_t flg_err_exit )
{
	if( !feof( fp ) )
		return load_crypt_c( fp );

	if( flg_chk_eof ){
		fclose( fp );
		print_lex_err( MSG_S, MSG_ERR_LOAD_EOF );

		if( flg_err_exit )
			exit_game( EXIT_FAILURE );
	}

	return EOF;
}

/***************************************************************
* Ϥä 1 ʸ᤹
* FILE *fp : ե
* long c : ᤹ʸ
***************************************************************/

void	rc_lex_ungetc( FILE *fp, long c )
{
	if( c == '\n' )
		dec_rc_lex_line();

	un_load_crypt_c( fp, c );
}

/***************************************************************
* Хååסե̾դѤ
* char *fname : ե̾
* return : դѤ?
***************************************************************/

bool_t	rename_back_up_file( char *fname )
{
	long	i;
	long	path_len;
	char	str_n[15 + 1];
	static char	bak_fname[FILE_NAME_MAX_LEN + 1];

	if( !chk_exist_file( fname ) )
		return FALSE;

	path_len = strrchr( fname, '/' ) - fname + 1;
	if( path_len > FILE_NAME_MAX_LEN )
		path_len = FILE_NAME_MAX_LEN;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		sprintf( str_n, STR_EXT_NAME_BAK_1, i );

		str_nz_cpy( bak_fname, fname, FILE_NAME_MAX_LEN );
		bak_fname[FILE_NAME_MAX_LEN] = '\0';
		str_max_n_cat( bak_fname, str_n, FILE_NAME_MAX_LEN );
		str_max_n_cat( bak_fname, STR_EXT_NAME_BAK_2,
				FILE_NAME_MAX_LEN );

		if( chk_exist_file( bak_fname ) )
			continue;

		if( rename( fname, bak_fname ) == 0 ){
			print_wrn( MSG_WRN_RENAME, fname, bak_fname );
			return TRUE;
		}
	}

	return FALSE;
}

/***************************************************************
* ޥåפϤե̾桼Ϥ
* char *s : ե̾
* return : ե̾(󥻥ʤ NULL)
***************************************************************/

char	*get_out_map_file_name( char *s )
{
	long	i;
	const long	max_i = LOOP_MAX_1000;
	static char	fname[FILE_NAME_MAX_LEN + 1];
	static char	num_s[10 + 1];
	long	y;
	ask_t	ask;

	set_map_total( 0, 0, MAP_MAX_X, MAP_MAX_Y );
	wipe_all();

	/* ǥեȤΥե̾ */
	for( i = 0; i < max_i; i++ ){
		sprintf( num_s, STR_EXT_NAME_OUT_MAP, i );

		str_nz_cpy( fname, dir_name_game, FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_DIR_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_FILE_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, num_s,
				FILE_NAME_MAX_LEN );

		if( !chk_exist_file( fname ) )
			break;
	}
	if( i >= max_i )
		return NULL;

	y = 0;
	print_str( 0, y, MSG_OUT_MAP_FILE_1 );
	y++;
	print_str( 0, y, MSG_OUT_MAP_FILE_2, fname );
	y++;

	/* ե̾ */
	str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	game_gets( -1, -1, MSG_OUT_MAP_FILE_1,
			s, FILE_NAME_MAX_LEN, TRUE );

	if( s[0] == '\0' ){
		str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	} else if( (s[0] == '/') || (s[0] == '~') ){
		str_nz_cpy( fname, s, FILE_NAME_MAX_LEN );
	} else {
		str_nz_cpy( fname, dir_name_game, FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_DIR_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, s,
				FILE_NAME_MAX_LEN );

		str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	}

	print_str( 0, y, MSG_OUT_MAP_FILE_3, fname );
	y++;

	/* ˽Ϥ뤫ǧȤ */
	ask = exec_menu_ask( MSG_OUT_MAP_FILE_ASK_OK, ASK_NO, FALSE );

	wipe_menu();

	switch( ask ){
	case ASK_YES:
		return s;
	case ASK_NO:
	case ASK_CANCEL:
	case ASK_ERR:
		break;
	}

	return NULL;
}

/***************************************************************
* ޥåפե˽Ϥ
* return : 顼̵ä?
***************************************************************/

bool_t	out_map_file( void )
{
	static char	fname[FILE_NAME_MAX_LEN + 1];
	long	x, y;
	dun_t	*dun;
	FILE	*fp;

	if( get_out_map_file_name( fname ) == NULL )
		return FALSE;

	fp = fopen( fname, "w" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( fname, TRUE );

	dun = get_dun();

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			fprintf( fp, "%c%c",
					dun->map.total.mjr[y][x],
					dun->map.total.mnr[y][x] );
		}
		fprintf( fp, "\n" );
	}

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ǥå饭饯μѴ
* long idx : ǥå
* return : 饯μ
***************************************************************/

chr_kind_t	trans_idx_to_chr_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_chr_trans_tab )
			/ sizeof( g_chr_trans_tab[0] );

	if( idx < 0 )
		return CHR_KIND_NULL;
	if( idx >= max_idx )
		return CHR_KIND_NULL;

	return( g_chr_trans_tab[idx] );
}

/***************************************************************
* 饯μफ饤ǥåѴ
* chr_kind_t k : 饯μ
* return : ǥå
***************************************************************/

long	trans_chr_kind_to_idx( chr_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_chr_trans_tab )
			/ sizeof( g_chr_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_chr_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåᥤ²Ѵ
* long idx : ǥå
* return : ᥤ²
***************************************************************/

main_race_t	trans_idx_to_main_race_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_main_race_trans_tab )
			/ sizeof( g_main_race_trans_tab[0] );

	if( idx < 0 )
		return MAIN_RACE_HUMAN;
	if( idx >= max_idx )
		return MAIN_RACE_HUMAN;

	return( g_main_race_trans_tab[idx] );
}

/***************************************************************
* ᥤ²饤ǥåѴ
* main_race_t k : ᥤ²
* return : ǥå
***************************************************************/

long	trans_main_race_kind_to_idx( main_race_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_main_race_trans_tab )
			/ sizeof( g_main_race_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_main_race_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饵ּ²Ѵ
* long idx : ǥå
* return : ּ²
***************************************************************/

sub_race_t	trans_idx_to_sub_race_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_sub_race_trans_tab )
			/ sizeof( g_sub_race_trans_tab[0] );

	if( idx < 0 )
		return SUB_RACE_NULL;
	if( idx >= max_idx )
		return SUB_RACE_NULL;

	return( g_sub_race_trans_tab[idx] );
}

/***************************************************************
* ּ²饤ǥåѴ
* sub_race_t k : ּ²
* return : ǥå
***************************************************************/

long	trans_sub_race_kind_to_idx( sub_race_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_sub_race_trans_tab )
			/ sizeof( g_sub_race_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_sub_race_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå̤Ѵ
* long idx : ǥå
* return : 
***************************************************************/

sex_t	trans_idx_to_sex_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_sex_trans_tab )
			/ sizeof( g_sex_trans_tab[0] );

	if( idx < 0 )
		return SEX_NULL;
	if( idx >= max_idx )
		return SEX_NULL;

	return( g_sex_trans_tab[idx] );
}

/***************************************************************
* ̤饤ǥåѴ
* sex_t k : 
* return : ǥå
***************************************************************/

long	trans_sex_kind_to_idx( sex_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_sex_trans_tab )
			/ sizeof( g_sex_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_sex_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå⤭μѴ
* long idx : ǥå
* return : ⤭μ
***************************************************************/

move_kind_t	trans_idx_to_move_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_move_trans_tab )
			/ sizeof( g_move_trans_tab[0] );

	if( idx < 0 )
		return MOVE_KIND_NULL;
	if( idx >= max_idx )
		return MOVE_KIND_NULL;

	return( g_move_trans_tab[idx] );
}

/***************************************************************
* ⤭μफ饤ǥåѴ
* move_kind_t k : ⤭μ
* return : ǥå
***************************************************************/

long	trans_move_kind_to_idx( move_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_move_trans_tab )
			/ sizeof( g_move_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_move_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå⤭ǡμѴ
* long idx : ǥå
* return : ⤭ǡμ
***************************************************************/

move_ls_kind_t	trans_idx_to_move_ls_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_move_ls_trans_tab )
			/ sizeof( g_move_ls_trans_tab[0] );

	if( idx < 0 )
		return MOVE_LS_KIND_FIND;
	if( idx >= max_idx )
		return MOVE_LS_KIND_FIND;

	return( g_move_ls_trans_tab[idx] );
}

/***************************************************************
* ⤭ǡμफ饤ǥåѴ
* move_ls_kind_t k : ⤭ǡμ
* return : ǥå
***************************************************************/

long	trans_move_ls_kind_to_idx( move_ls_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_move_ls_trans_tab )
			/ sizeof( g_move_ls_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_move_ls_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饢Ѵ
* long idx : ǥå
* return : 
***************************************************************/

act_kind_t	trans_idx_to_act_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_act_trans_tab )
			/ sizeof( g_act_trans_tab[0] );

	if( idx < 0 )
		return ACT_KIND_NULL;
	if( idx >= max_idx )
		return ACT_KIND_NULL;

	return( g_act_trans_tab[idx] );
}

/***************************************************************
* 󤫤饤ǥåѴ
* act_kind_t k : 
* return : ǥå
***************************************************************/

long	trans_act_kind_to_idx( act_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_act_trans_tab )
			/ sizeof( g_act_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_act_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饿åȤμѴ
* long idx : ǥå
* return : åȤμ
***************************************************************/

trgt_kind_t	trans_idx_to_trgt_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_trgt_trans_tab )
			/ sizeof( g_trgt_trans_tab[0] );

	if( idx < 0 )
		return TRGT_KIND_NULL;
	if( idx >= max_idx )
		return TRGT_KIND_NULL;

	return( g_trgt_trans_tab[idx] );
}

/***************************************************************
* åȤμफ饤ǥåѴ
* trgt_kind_t k : åȤμ
* return : ǥå
***************************************************************/

long	trans_trgt_kind_to_idx( trgt_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_trgt_trans_tab )
			/ sizeof( g_trgt_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_trgt_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåֹ礤Ѵ
* long idx : ǥå
* return : ֹ礤
***************************************************************/

dist_t	trans_idx_to_dist_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_dist_trans_tab )
			/ sizeof( g_dist_trans_tab[0] );

	if( idx < 0 )
		return DIST_NEAR;
	if( idx >= max_idx )
		return DIST_NEAR;

	return( g_dist_trans_tab[idx] );
}

/***************************************************************
* ֹ礤饤ǥåѴ
* dist_t k : ֹ礤
* return : ǥå
***************************************************************/

long	trans_dist_kind_to_idx( dist_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_dist_trans_tab )
			/ sizeof( g_dist_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_dist_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饿åȤμѴ
* long idx : ǥå
* return : åȤμ
***************************************************************/

auto_mark_trgt_t	trans_idx_to_am_trgt( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_am_trgt_trans_tab )
			/ sizeof( g_am_trgt_trans_tab[0] );

	if( idx < 0 )
		return AUTO_MARK_TRGT_CLEAR;
	if( idx >= max_idx )
		return AUTO_MARK_TRGT_CLEAR;

	return( g_am_trgt_trans_tab[idx] );
}

/***************************************************************
* åȤμफ饤ǥåѴ
* auto_mark_trgt_t k : åȤμ
* return : ǥå
***************************************************************/

long	trans_am_trgt_to_idx( auto_mark_trgt_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_am_trgt_trans_tab )
			/ sizeof( g_am_trgt_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_am_trgt_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåֹ礤Ѵ
* long idx : ǥå
* return : ֹ礤
***************************************************************/

auto_mark_dist_t	trans_idx_to_am_dist( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_am_dist_trans_tab )
			/ sizeof( g_am_dist_trans_tab[0] );

	if( idx < 0 )
		return AUTO_MARK_DIST_NEAR;
	if( idx >= max_idx )
		return AUTO_MARK_DIST_NEAR;

	return( g_am_dist_trans_tab[idx] );
}

/***************************************************************
* ֹ礤饤ǥåѴ
* auto_mark_dist_t k : ֹ礤
* return : ǥå
***************************************************************/

long	trans_am_dist_to_idx( auto_mark_dist_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_am_dist_trans_tab )
			/ sizeof( g_am_dist_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_am_dist_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåѴ
* long idx : ǥå
* return : 
***************************************************************/

auto_mark_act_t	trans_idx_to_am_act( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_am_act_trans_tab )
			/ sizeof( g_am_act_trans_tab[0] );

	if( idx < 0 )
		return AUTO_MARK_ACT_FIGHT;
	if( idx >= max_idx )
		return AUTO_MARK_ACT_FIGHT;

	return( g_am_act_trans_tab[idx] );
}

/***************************************************************
* 狼饤ǥåѴ
* auto_mark_act_t k : 
* return : ǥå
***************************************************************/

long	trans_am_act_to_idx( auto_mark_act_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_am_act_trans_tab )
			/ sizeof( g_am_act_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_am_act_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåѴ
* long idx : ǥå
* return : 
***************************************************************/

auto_mark_cond_t	trans_idx_to_am_cond( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_am_cond_trans_tab )
			/ sizeof( g_am_cond_trans_tab[0] );

	if( idx < 0 )
		return AUTO_MARK_COND_DISPERSE;
	if( idx >= max_idx )
		return AUTO_MARK_COND_DISPERSE;

	return( g_am_cond_trans_tab[idx] );
}

/***************************************************************
* 狼饤ǥåѴ
* auto_mark_cond_t k : 
* return : ǥå
***************************************************************/

long	trans_am_cond_to_idx( auto_mark_cond_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_am_cond_trans_tab )
			/ sizeof( g_am_cond_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_am_cond_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåȿѴ
* long idx : ǥå
* return : ȿ
***************************************************************/

attitude_t	trans_idx_to_attitude_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_attitude_trans_tab )
			/ sizeof( g_attitude_trans_tab[0] );

	if( idx < 0 )
		return ATTITUDE_MATE;
	if( idx >= max_idx )
		return ATTITUDE_MATE;

	return( g_attitude_trans_tab[idx] );
}

/***************************************************************
* ȿ饤ǥåѴ
* attitude_t k : ȿ
* return : ǥå
***************************************************************/

long	trans_attitude_kind_to_idx( attitude_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_attitude_trans_tab )
			/ sizeof( g_attitude_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_attitude_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饢ƥμѴ
* long idx : ǥå
* return : ƥμ
***************************************************************/

item_kind_t	trans_idx_to_item_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_item_trans_tab )
			/ sizeof( g_item_trans_tab[0] );

	if( idx < 0 )
		return ITEM_KIND_NULL;
	if( idx >= max_idx )
		return ITEM_KIND_NULL;

	return( g_item_trans_tab[idx] );
}

/***************************************************************
* ƥμफ饤ǥåѴ
* item_kind_t k : ƥμ
* return : ǥå
***************************************************************/

long	trans_item_kind_to_idx( item_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_item_trans_tab )
			/ sizeof( g_item_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_item_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

wpn_kind_t	trans_idx_to_wpn_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_wpn_trans_tab )
			/ sizeof( g_wpn_trans_tab[0] );

	if( idx < 0 )
		return WPN_KIND_NULL;
	if( idx >= max_idx )
		return WPN_KIND_NULL;

	return( g_wpn_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* wpn_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_wpn_kind_to_idx( wpn_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_wpn_trans_tab )
			/ sizeof( g_wpn_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_wpn_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåݤμѴ
* long idx : ǥå
* return : ݤμ
***************************************************************/

bow_kind_t	trans_idx_to_bow_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_bow_trans_tab )
			/ sizeof( g_bow_trans_tab[0] );

	if( idx < 0 )
		return BOW_KIND_NULL;
	if( idx >= max_idx )
		return BOW_KIND_NULL;

	return( g_bow_trans_tab[idx] );
}

/***************************************************************
* ݤμफ饤ǥåѴ
* bow_kind_t k : ݤμ
* return : ǥå
***************************************************************/

long	trans_bow_kind_to_idx( bow_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_bow_trans_tab )
			/ sizeof( g_bow_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_bow_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåɶμѴ
* long idx : ǥå
* return : ɶμ
***************************************************************/

armor_kind_t	trans_idx_to_armor_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_armor_trans_tab )
			/ sizeof( g_armor_trans_tab[0] );

	if( idx < 0 )
		return ARMOR_KIND_NULL;
	if( idx >= max_idx )
		return ARMOR_KIND_NULL;

	return( g_armor_trans_tab[idx] );
}

/***************************************************************
* ɶμफ饤ǥåѴ
* armor_kind_t k : ɶμ
* return : ǥå
***************************************************************/

long	trans_armor_kind_to_idx( armor_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_armor_trans_tab )
			/ sizeof( g_armor_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_armor_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

potion_kind_t	trans_idx_to_potion_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_potion_trans_tab )
			/ sizeof( g_potion_trans_tab[0] );

	if( idx < 0 )
		return POTION_KIND_NULL;
	if( idx >= max_idx )
		return POTION_KIND_NULL;

	return( g_potion_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* potion_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_potion_kind_to_idx( potion_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_potion_trans_tab )
			/ sizeof( g_potion_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_potion_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå鴬ʪμѴ
* long idx : ǥå
* return : ʪμ
***************************************************************/

scroll_kind_t	trans_idx_to_scroll_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_scroll_trans_tab )
			/ sizeof( g_scroll_trans_tab[0] );

	if( idx < 0 )
		return SCROLL_KIND_NULL;
	if( idx >= max_idx )
		return SCROLL_KIND_NULL;

	return( g_scroll_trans_tab[idx] );
}

/***************************************************************
* ʪμफ饤ǥåѴ
* scroll_kind_t k : ʪμ
* return : ǥå
***************************************************************/

long	trans_scroll_kind_to_idx( scroll_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_scroll_trans_tab )
			/ sizeof( g_scroll_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_scroll_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

stick_kind_t	trans_idx_to_stick_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_stick_trans_tab )
			/ sizeof( g_stick_trans_tab[0] );

	if( idx < 0 )
		return STICK_KIND_NULL;
	if( idx >= max_idx )
		return STICK_KIND_NULL;

	return( g_stick_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* stick_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_stick_kind_to_idx( stick_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_stick_trans_tab )
			/ sizeof( g_stick_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_stick_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饢μѴ
* long idx : ǥå
* return : μ
***************************************************************/

acce_kind_t	trans_idx_to_acce_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_acce_trans_tab )
			/ sizeof( g_acce_trans_tab[0] );

	if( idx < 0 )
		return ACCE_KIND_NULL;
	if( idx >= max_idx )
		return ACCE_KIND_NULL;

	return( g_acce_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* acce_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_acce_kind_to_idx( acce_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_acce_trans_tab )
			/ sizeof( g_acce_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_acce_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåؤμѴ
* long idx : ǥå
* return : ؤμ
***************************************************************/

ring_kind_t	trans_idx_to_ring_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_ring_trans_tab )
			/ sizeof( g_ring_trans_tab[0] );

	if( idx < 0 )
		return RING_KIND_NULL;
	if( idx >= max_idx )
		return RING_KIND_NULL;

	return( g_ring_trans_tab[idx] );
}

/***************************************************************
* ؤμफ饤ǥåѴ
* ring_kind_t k : ؤμ
* return : ǥå
***************************************************************/

long	trans_ring_kind_to_idx( ring_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_ring_trans_tab )
			/ sizeof( g_ring_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_ring_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

amulet_kind_t	trans_idx_to_amulet_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_amulet_trans_tab )
			/ sizeof( g_amulet_trans_tab[0] );

	if( idx < 0 )
		return AMULET_KIND_NULL;
	if( idx >= max_idx )
		return AMULET_KIND_NULL;

	return( g_amulet_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* amulet_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_amulet_kind_to_idx( amulet_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_amulet_trans_tab )
			/ sizeof( g_amulet_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_amulet_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåؤμѴ
* long idx : ǥå
* return : ؤμ
***************************************************************/

necklace_kind_t	trans_idx_to_necklace_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_necklace_trans_tab )
			/ sizeof( g_necklace_trans_tab[0] );

	if( idx < 0 )
		return NECKLACE_KIND_NULL;
	if( idx >= max_idx )
		return NECKLACE_KIND_NULL;

	return( g_necklace_trans_tab[idx] );
}

/***************************************************************
* ؤμफ饤ǥåѴ
* necklace_kind_t k : ؤμ
* return : ǥå
***************************************************************/

long	trans_necklace_kind_to_idx( necklace_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_necklace_trans_tab )
			/ sizeof( g_necklace_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_necklace_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåڴμѴ
* long idx : ǥå
* return : ڴμ
***************************************************************/

inst_kind_t	trans_idx_to_inst_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_inst_trans_tab )
			/ sizeof( g_inst_trans_tab[0] );

	if( idx < 0 )
		return INST_KIND_NULL;
	if( idx >= max_idx )
		return INST_KIND_NULL;

	return( g_inst_trans_tab[idx] );
}

/***************************************************************
* ڴμफ饤ǥåѴ
* inst_kind_t k : ڴμ
* return : ǥå
***************************************************************/

long	trans_inst_kind_to_idx( inst_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_inst_trans_tab )
			/ sizeof( g_inst_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_inst_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

anthology_kind_t	trans_idx_to_anthology_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_anthology_trans_tab )
			/ sizeof( g_anthology_trans_tab[0] );

	if( idx < 0 )
		return ANTHOLOGY_KIND_NULL;
	if( idx >= max_idx )
		return ANTHOLOGY_KIND_NULL;

	return( g_anthology_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* anthology_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_anthology_kind_to_idx( anthology_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_anthology_trans_tab )
			/ sizeof( g_anthology_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_anthology_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

light_kind_t	trans_idx_to_light_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_light_trans_tab )
			/ sizeof( g_light_trans_tab[0] );

	if( idx < 0 )
		return LIGHT_KIND_NULL;
	if( idx >= max_idx )
		return LIGHT_KIND_NULL;

	return( g_light_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* light_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_light_kind_to_idx( light_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_light_trans_tab )
			/ sizeof( g_light_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_light_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå鿩μѴ
* long idx : ǥå
* return : μ
***************************************************************/

food_kind_t	trans_idx_to_food_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_food_trans_tab )
			/ sizeof( g_food_trans_tab[0] );

	if( idx < 0 )
		return FOOD_KIND_NULL;
	if( idx >= max_idx )
		return FOOD_KIND_NULL;

	return( g_food_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* food_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_food_kind_to_idx( food_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_food_trans_tab )
			/ sizeof( g_food_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_food_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

tobacco_kind_t	trans_idx_to_tobacco_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_tobacco_trans_tab )
			/ sizeof( g_tobacco_trans_tab[0] );

	if( idx < 0 )
		return TOBACCO_KIND_NULL;
	if( idx >= max_idx )
		return TOBACCO_KIND_NULL;

	return( g_tobacco_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* tobacco_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_tobacco_kind_to_idx( tobacco_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_tobacco_trans_tab )
			/ sizeof( g_tobacco_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_tobacco_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåΥ֥ɤѴ
* long idx : ǥå
* return : Υ֥
***************************************************************/

tobacco_brand_t	trans_idx_to_tobacco_brand( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_tobacco_brand_trans_tab )
			/ sizeof( g_tobacco_brand_trans_tab[0] );

	if( idx < 0 )
		return TOBACCO_BRAND_NULL;
	if( idx >= max_idx )
		return TOBACCO_BRAND_NULL;

	return( g_tobacco_brand_trans_tab[idx] );
}

/***************************************************************
* Υ֥ɤ饤ǥåѴ
* tobacco_brand_t k : Υ֥ɤμ
* return : ǥå
***************************************************************/

long	trans_tobacco_brand_to_idx( tobacco_brand_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_tobacco_brand_trans_tab )
			/ sizeof( g_tobacco_brand_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_tobacco_brand_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåѥפμѴ
* long idx : ǥå
* return : ѥפμ
***************************************************************/

pipe_kind_t	trans_idx_to_pipe_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_pipe_trans_tab )
			/ sizeof( g_pipe_trans_tab[0] );

	if( idx < 0 )
		return PIPE_KIND_NULL;
	if( idx >= max_idx )
		return PIPE_KIND_NULL;

	return( g_pipe_trans_tab[idx] );
}

/***************************************************************
* ѥפμफ饤ǥåѴ
* pipe_kind_t k : ѥפμ
* return : ǥå
***************************************************************/

long	trans_pipe_kind_to_idx( pipe_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_pipe_trans_tab )
			/ sizeof( g_pipe_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_pipe_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå쥢åμѴ
* long idx : ǥå
* return : 쥢åμ
***************************************************************/

rare_goods_kind_t	trans_idx_to_rare_goods_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_rare_goods_trans_tab )
			/ sizeof( g_rare_goods_trans_tab[0] );

	if( idx < 0 )
		return RARE_GOODS_KIND_NULL;
	if( idx >= max_idx )
		return RARE_GOODS_KIND_NULL;

	return( g_rare_goods_trans_tab[idx] );
}

/***************************************************************
* 쥢åμफ饤ǥåѴ
* rare_goods_kind_t k : 쥢åμ
* return : ǥå
***************************************************************/

long	trans_rare_goods_kind_to_idx( rare_goods_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_rare_goods_trans_tab )
			/ sizeof( g_rare_goods_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_rare_goods_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå饳μѴ
* long idx : ǥå
* return : μ
***************************************************************/

coin_kind_t	trans_idx_to_coin_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_coin_trans_tab )
			/ sizeof( g_coin_trans_tab[0] );

	if( idx < 0 )
		return COIN_KIND_NULL;
	if( idx >= max_idx )
		return COIN_KIND_NULL;

	return( g_coin_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* coin_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_coin_kind_to_idx( coin_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_coin_trans_tab )
			/ sizeof( g_coin_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_coin_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåʸμѴ
* long idx : ǥå
* return : ʸμ
***************************************************************/

spell_kind_t	trans_idx_to_spell_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_spell_trans_tab )
			/ sizeof( g_spell_trans_tab[0] );

	if( idx < 0 )
		return SPELL_KIND_NULL;
	if( idx >= max_idx )
		return SPELL_KIND_NULL;

	return( g_spell_trans_tab[idx] );
}

/***************************************************************
* ʸμफ饤ǥåѴ
* spell_kind_t k : ʸμ
* return : ǥå
***************************************************************/

long	trans_spell_kind_to_idx( spell_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_spell_trans_tab )
			/ sizeof( g_spell_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_spell_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå󥹥μѴ
* long idx : ǥå
* return : 󥹥μ
***************************************************************/

mnstr_kind_t	trans_idx_to_mnstr_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_mnstr_trans_tab )
			/ sizeof( g_mnstr_trans_tab[0] );

	if( idx < 0 )
		return MNSTR_KIND_NULL;
	if( idx >= max_idx )
		return MNSTR_KIND_NULL;

	return( g_mnstr_trans_tab[idx] );
}

/***************************************************************
* 󥹥μफ饤ǥåѴ
* mnstr_kind_t k : 󥹥μ
* return : ǥå
***************************************************************/

long	trans_mnstr_kind_to_idx( mnstr_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_mnstr_trans_tab )
			/ sizeof( g_mnstr_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_mnstr_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå櫤μѴ
* long idx : ǥå
* return : 櫤μ
***************************************************************/

trap_kind_t	trans_idx_to_trap_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_trap_trans_tab )
			/ sizeof( g_trap_trans_tab[0] );

	if( idx < 0 )
		return TRAP_KIND_NULL;
	if( idx >= max_idx )
		return TRAP_KIND_NULL;

	return( g_trap_trans_tab[idx] );
}

/***************************************************************
* 櫤μफ饤ǥåѴ
* trap_kind_t k : 櫤μ
* return : ǥå
***************************************************************/

long	trans_trap_kind_to_idx( trap_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_trap_trans_tab )
			/ sizeof( g_trap_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_trap_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥå̤μѴ
* long idx : ǥå
* return : ̤μ
***************************************************************/

fx_kind_t	trans_idx_to_fx_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_fx_trans_tab )
			/ sizeof( g_fx_trans_tab[0] );

	if( idx < 0 )
		return FX_KIND_NULL;
	if( idx >= max_idx )
		return FX_KIND_NULL;

	return( g_fx_trans_tab[idx] );
}

/***************************************************************
* ̤μफ饤ǥåѴ
* fx_kind_t k : ̤μ
* return : ǥå
***************************************************************/

long	trans_fx_kind_to_idx( fx_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_fx_trans_tab )
			/ sizeof( g_fx_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_fx_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ǥåμѴ
* long idx : ǥå
* return : μ
***************************************************************/

request_kind_t	trans_idx_to_request_kind( long idx )
{
	long	max_idx;

	max_idx = sizeof( g_request_trans_tab )
			/ sizeof( g_request_trans_tab[0] );

	if( idx < 0 )
		return REQUEST_KIND_NULL;
	if( idx >= max_idx )
		return REQUEST_KIND_NULL;

	return( g_request_trans_tab[idx] );
}

/***************************************************************
* μफ饤ǥåѴ
* request_kind_t k : μ
* return : ǥå
***************************************************************/

long	trans_request_kind_to_idx( request_kind_t k )
{
	long	max_idx;
	long	i;

	max_idx = sizeof( g_request_trans_tab )
			/ sizeof( g_request_trans_tab[0] );

	for( i = 0; i < max_idx; i++ )
		if( g_request_trans_tab[i] == k )
			return i;

	return 0;
}

/***************************************************************
* ե򥳥ԡ
* const char *src : ԡեѥ
* const char *dst : ԡեѥ
* return : 顼̵ä?
***************************************************************/

bool_t	copy_file( const char *src, const char *dst )
{
	FILE	*fp_src, *fp_dst;
	bool_t	flg_success = TRUE;
	long	c;

	if( src == NULL )
		return FALSE;
	if( dst == NULL )
		return FALSE;

	fp_src = fopen( src, "rb" );
	if( fp_src == NULL )
		return FALSE;

	fp_dst = fopen( dst, "wb" );
	if( fp_dst == NULL )
		return FALSE;

	while( !feof( fp_src ) ){
		c = getc( fp_src );
		if( c == EOF ){
			if( !feof( fp_src ) )
				flg_success = FALSE;
			break;
		}

		if( putc( c, fp_dst ) == EOF ){
			if( !feof( fp_src ) )
				flg_success = FALSE;
			break;
		}
	}

	if( fclose( fp_dst ) != 0 )
		flg_success = FALSE;
	if( fclose( fp_src ) != 0 )
		flg_success = FALSE;

	return flg_success;
}

/***************************************************************
* ѥȥե̾Ĥʤƥեѥˤ
* char *path : ѥ
* char *file : ե̾
* return : եѥ
***************************************************************/

char	*cat_path( char *path, char *file )
{
	static char	dst[FILE_NAME_MAX_LEN + 1];

	str_nz_cpy( dst, path, FILE_NAME_MAX_LEN );
	str_max_n_cat( dst, STR_SLASH, FILE_NAME_MAX_LEN );
	str_max_n_cat( dst, file, FILE_NAME_MAX_LEN );

	return dst;
}

/***************************************************************
* ե뤬¸ߤ뤫Ĵ٤
* char *s : ե̾
* return : ¸ߤ?
***************************************************************/

bool_t	chk_exist_file( char *s )
{
	FILE	*fp;

	fp = fopen( s, "r" );
	if( fp == NULL )
		return FALSE;

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ǥ쥯ȥ꤬¸ߤ뤫Ĵ٤
* char *s : ǥ쥯ȥ̾
* return : ¸ߤ?
***************************************************************/

bool_t	chk_exist_dir( char *s )
{
	FILE	*fp;

#ifdef	D_DOS
	make_dir( s );
	return TRUE;
#endif	/* D_DOS */

	fp = fopen( s, "r" );
	if( fp == NULL )
		return FALSE;

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ǥ쥯ȥ򷡤
* char *s : ǥ쥯ȥ̾
* return : 顼̵ä?
***************************************************************/

bool_t	make_dir( char *path )
{
	char	cur_path[FILE_NAME_MAX_LEN + 1];
	char	*p;

	if( path == NULL )
		return FALSE;

	str_nz_cpy( cur_path, path, FILE_NAME_MAX_LEN );

	p = cur_path;
	while( 1 ){
		p = strchr( p + 1, '/' );
		if( p == NULL )
			break;
		if( *p == '\0' )
			break;

		*p = '\0';
		make_dir_node( cur_path );
		*p = '/';
	}
	make_dir_node( cur_path );

	return TRUE;
}

/***************************************************************
* ǥ쥯ȥ 1 ķ
* char *s : ǥ쥯ȥ̾
* return : 顼̵ä?
***************************************************************/

bool_t	make_dir_node( char *path )
{
	if( path == NULL )
		return FALSE;
#ifdef	D_DOS
	if( _mkdir( path ) )
		return TRUE;
	else
		return FALSE;
#elif	HAVE_MKDIR
	if( mkdir( path, S_IFDIR | 0755 ) == 0 )
		return TRUE;
	else
		return FALSE;
#else	/* HAVE_MKDIR */
	if( mknod( path, S_IFDIR | 0755, 0 ) == 0 )
		return TRUE;
	else
		return FALSE;
#endif	/* HAVE_MKDIR */
	return FALSE;
}

/***************************************************************
* ʸȤʤ饨פ
* const long c : Ѵʸ
* return : Ѵʸ
***************************************************************/

char	*cv_esc_quote_c( const long c )
{
	static char	buf[TOKEN_MAX_LEN + 1];

	buf[0] = (unsigned char)c;
	buf[1] = '\0';

	return( cv_esc_quote_str( buf ) );
}

/***************************************************************
* ʸΥȤ򥨥פ
* const char *str : Ѵʸ
* return : Ѵʸ
***************************************************************/

char	*cv_esc_quote_str( const char *str )
{
	static char	buf[TOKEN_MAX_LEN + 1];
	long	src_idx, dst_idx;

	src_idx = 0;
	dst_idx = 0;
	for( src_idx = 0; src_idx < TOKEN_MAX_LEN; src_idx++ ){
		long	c;

		c = str[src_idx];
		if( c == '\0' )
			break;

		if( (c == '\'') || (c == '\"') ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = (char)(c);
		} else if( c == '\n' ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = 'n';
		} else if( c == '\r' ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = 'n';
		} else {
			buf[dst_idx] = str[src_idx];
		}

		dst_idx++;
	}

	buf[dst_idx] = '\0';

	return buf;
}

/***************************************************************
* ʸΥȥ롦ɤ򥨥פ
* ȤϽʤ
* const char *str : Ѵʸ
* return : Ѵʸ
***************************************************************/

char	*cv_esc_ctrl_str( const char *str )
{
	static char	buf[TOKEN_MAX_LEN + 16 + 1];
	long	src_idx, dst_idx;

	buf[0] = '\0';
	if( str == NULL )
		return buf;

	src_idx = 0;
	dst_idx = 0;
	for( src_idx = 0; src_idx < TOKEN_MAX_LEN; src_idx++, dst_idx++ ){
		long	c;

		c = str[src_idx];
		if( c == '\0' )
			break;

		if( c >= 128 ){
			buf[dst_idx] = c;

			src_idx++;
			c = str[src_idx];
			if( c == '\0' )
				break;

			dst_idx++;
			buf[dst_idx] = c;
		} else if( c == '\\' ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = '\\';
		} else if( c == '\n' ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = 'n';
		} else if( c == '\r' ){
			buf[dst_idx] = '\\';
			dst_idx++;

			buf[dst_idx] = 'r';
		} else if( c < ' ' ){
			buf[dst_idx] = '^';
			dst_idx++;

			buf[dst_idx] = (char)(c + '@');
		} else {
			buf[dst_idx] = str[src_idx];
		}
	}

	buf[dst_idx] = '\0';

	return buf;
}

/***************************************************************
* Ź沽
* long n : μ
* return : μ
***************************************************************/

long	srandm_crypt( long n )
{
	g_randm_crypt_seed = n;

	return g_randm_crypt_seed;
}

/***************************************************************
* ʸŹ沽
* long c : ʸ
* return : Ź沽ʸ
***************************************************************/

long	randm_crypt( long c )
{
	long	a;

	if( c == EOF )
		return EOF;

	g_randm_crypt_seed += 15349;
	g_randm_crypt_seed *= 3793;
	g_randm_crypt_seed += 598393;
	a = (g_randm_crypt_seed & 0xffff0000) >> 16;
	g_randm_crypt_seed = ((g_randm_crypt_seed & 0x0000ffff) << 16) + a;
	g_randm_crypt_seed = labs( g_randm_crypt_seed );
	g_randm_crypt_seed += 379;
	g_randm_crypt_seed &= 0x7fffffff;

	c ^= g_randm_crypt_seed;
	c &= 0xff;

	return c;
}

/***************************************************************
* ϤȹʸϤ
* char *path : եΥեѥ
* bool_t flg_txt : ƥȡ⡼ɤ?
***************************************************************/

void	reset_load_save( char *path, bool_t flg_txt )
{
	g_crypt_sum = 0;
	g_un_c = '\0';
	g_un_token = RC_TOKEN_NULL;

	set_flg_crypt_txt( flg_txt );

	set_rc_lex_file_name( path );
	clr_rc_lex_line();
	set_rc_lex_err( FALSE );
}

/***************************************************************
* Ź沽⡼ɤ
* bool_t flg_txt : ƥȡ⡼ɤ?
***************************************************************/

void	set_flg_crypt_txt( bool_t flg_txt )
{
	g_flg_crypt_txt = flg_txt;
}

/***************************************************************
* Ź沽⡼ɤꤷƥɳ
* FILE *fp : ե
* bool_t flg_txt : ƥȡ⡼ɤ?
***************************************************************/

void	reset_load_crypt( FILE *fp, bool_t flg_txt )
{
	if( flg_txt ){
		load_line( fp, TRUE );
	} else {
		char	*s;
		long	n;

		s = load_line( fp, TRUE );
		sscanf( s, "bin %ld", &n );
		srandm_crypt( n );
	}
}

/***************************************************************
* Ź沽⡼ɤꤷƥֳ
* FILE *fp : ե
* bool_t flg_txt : ƥȡ⡼ɤ?
***************************************************************/

void	reset_save_crypt( FILE *fp, bool_t flg_txt )
{
	if( flg_txt ){
		fprintf( fp, "text\n" );
	} else {
		fprintf( fp, "bin %ld\n",
				srandm_crypt( time( NULL ) ) );
	}
}

/***************************************************************
* ν
***************************************************************/

void	reset_save_crypt_tab( void )
{
	g_tab_lev = 0;
}

/***************************************************************
* 
* FILE *fp : ե
* long n : 
* return : 
***************************************************************/

long	set_save_crypt_tab( FILE *fp, long n )
{
	if( n >= +1 )
		save_crypt_tab( fp, "{\n" );

	g_tab_lev += n;

	if( n <= -1 )
		save_crypt_tab( fp, "},\n" );

	return g_tab_lev;
}

/***************************************************************
* դ printf
* FILE *fp : ե
* const char *s : եޥå
* ... : 
* return : 
***************************************************************/

long	save_crypt_tab( FILE *fp, const char *s, ... )
{
	static char	buf[1024 + 1];
	va_list	argptr;
	long	i;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	for( i = 0; i < g_tab_lev; i++ )
		save_crypt_str( fp, "\t" );

	save_crypt_str( fp, "%s", buf );

	return g_tab_lev;
}

/***************************************************************
* Ź沽ʸ
* FILE *fp : ե
* const char *s : եޥå
* ... : 
* return : 
***************************************************************/

long	save_crypt_str( FILE *fp, const char *s, ... )
{
	static char	buf[1024 + 1];
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	if( g_flg_crypt_txt ){
		fputs( buf, fp );
	} else {
		long	i;

		for( i = 0; buf[i] != '\0'; i++ ){
			g_crypt_sum += buf[i];

			fputc( randm_crypt( buf[i] ), fp );

			if( buf[i] == '\n' ){
				fputc( g_crypt_sum, fp );
				fputc( randm_crypt( '\n' ), fp );

				g_crypt_sum = 0;
			}
		}
	}

	return g_tab_lev;
}

/***************************************************************
* Ź沽ʸ
* FILE *fp : ե
* char *buf : ʸ
* long n : ʸκĹ
* return : ʸĹ
***************************************************************/

long	load_crypt_str( FILE *fp, char *buf, long n )
{
	long	c;
	long	i;

	if( feof( fp ) ){
		buf[0] = '\0';
		return 0;
	}

	for( i = 0; i < n; i++ ){
		c = load_crypt_c( fp );
		if( c == EOF )
			c = '\n';

		buf[i] = (char)c;
		if( c == '\n' ){
			return i;
		}
	}

	buf[i] = '\0';
	return i;
}

/***************************************************************
* Ź沽ʸ
* FILE *fp : ե
* return : Ϥʸ
***************************************************************/

long	load_crypt_c( FILE *fp )
{
	long	c;

	if( feof( fp ) )
		return EOF;

	if( g_un_c != '\0' ){
		c = g_un_c;
		g_un_c = '\0';

		return c;
	}

	c = fgetc( fp );
	if( c == EOF )
		return EOF;

	if( g_flg_crypt_txt ){
		if( c == '\n' ){
			c = fgetc( fp );
			if( c != '\r' ){
				ungetc( c, fp );
			}

			inc_rc_lex_line();
			c = '\n';
		} else if( c == '\r' ){
			inc_rc_lex_line();
			c = '\n';
		}
	} else {
		c = randm_crypt( c );
		g_crypt_sum += (char)c;

		if( (c == '\n') || (c == '\r') ){
			if( fgetc( fp ) == g_crypt_sum ){
				g_crypt_sum = 0;
				randm_crypt( fgetc( fp ) );

				return '\n';
			} else {
				print_err( MSG_S, MSG_ERR_LOAD_BIN );
				exit_game( EXIT_FAILURE );
			}
		}
	}

	return c;
}

/***************************************************************
* Ź沽ʸϤμä
* FILE *fp : ե
* long c : äʸ
***************************************************************/

void	un_load_crypt_c( FILE *fp, long c )
{
	g_un_c = c;
}
