/*-*-c++-*-
 * $Id: cdumpviewdisplay.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CDUMPVIEWDISPLAY_H
#define CDUMPVIEWDISPLAY_H

#include "osdep.h"
#ifndef WIN32
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#endif

#include <qscrollview.h>
#include <qcstring.h>

#include "crashtypes.h"

class QTimer;

class QLcrashApp;
class CPaintArea;

/**Displays the data dump.
  *@author Michael Geselbracht
  */

class CDumpViewDisplay : public QScrollView  {
   Q_OBJECT

public:
	CDumpViewDisplay(QLcrashApp* app, QWidget *parent=0, const char *name=0);
	~CDumpViewDisplay();
	
	void displayAddress(UINT64 addr);
	inline UINT64 address() const {
		return oAddr;
	}
	
signals:
	void sigMessage(QString msg, int time);
	void sigAddrJump(); // emited if user double clicked on an address
	
public slots:
	void slotDisplayFormat(int);
	void slotDisplayType(int);
	void slotDisplayByteOrder(int);
	
protected slots:
	void slotTimeout();
	void slotAreaMouseMoved(QMouseEvent*);
	void slotAreaMousePressed(QMouseEvent*);
	void slotAreaMouseDoubleClicked(QMouseEvent*);
	void slotAreaPaintEvent();

protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual void paintEvent(QPaintEvent*);
	virtual void drawContents(QPainter*, int, int, int, int);
	void updateSelection(QMouseEvent*);
	void updateDump();
	void postUpdate();
	void paintCell(QPainter*, int row);
	void printDialog(bool pointer);
	
	// Check the byteorder of THIS machine. Result goes in 'oLittleEndian'.
	void checkEndianity();
	
	/*  Get value at address (base + offset) of size bytes.
		Note that 'offset' must not be greater than 15. The byteorder
		is determined by 'oUseLittleEndian'. 'le' specifies if you want little endian or not.
	*/
	UINT64 getValue(bool le, UINT64 base, int offset, int size, bool* success=0);
	
private:
	QLcrashApp* oApp;
	CPaintArea* oArea;
	qlc::DumpFormat oDumpFormat;
	qlc::DumpType oDumpType;
	UINT64 oAddr;
	QTimer* oTimer;
	
	// these are altered by 'updateDump()'
	int oFontHeight;
	int oFontAscent;
	int oNSpace;
	int oWidthAddr;
	int oWidthDump;
	int oWidthASCII;
	int oWidthDumpSpace;
	int oBlocksize;
	int oDigitsPerBlock;
	int oMarkedCol;
	
	UINT64 oMarkedRow;
	UINT64 oMarkedAddr;
	bool oTargetLittleEndian; // byte order of the target machine
	bool oLittleEndian; // byte order of this machine
	bool oUseLittleEndian; // byte order of display
	int oWordSize; // sizeof(long) of target machine - copied from document
	QCString oFmt;
	bool oSelection;
	bool oDeleting;
};

#endif
