/*
 *  include/asm-s390/kl_mem.h
 */

#ifndef __ASM_KL_MEM_H
#define __ASM_KL_MEM_H

#define KL_PGDIR_SHIFT        20
#define KL_PGDIR_SIZE         (1UL << KL_PGDIR_SHIFT)
#define KL_PGDIR_MASK         (~(KL_PGDIR_SIZE-1))

#define KL_PMD_SHIFT          KL_PGDIR_SHIFT
#define KL_PMD_SIZE           KL_PGDIR_SIZE
#define KL_PMD_MASK           KL_PGDIR_MASK

#define KL_PTRS_PER_PGD       2048
#define KL_PTRS_PER_PMD       1
#define KL_PTRS_PER_PTE       256

#define KL_PMD_BASE_MASK      (~((1UL<<6)-1))
#define KL_PT_BASE_MASK       KL_PMD_BASE_MASK
#define KL_PAGE_BASE_MASK     (~((1UL<<12)-1))


#define KL_KADDR_IS_HIGHMEM(vaddr) (0)

#endif /* __ASM_KL_MEM_H */
