.TH lkstm 8
.SH NAME
lkstm \- Control maskset in LKST.
.br
.SH SYNOPSIS
lkstm \fIcommand\fR [ \fIoption(s)\fR ]
.SH DESCRIPTION
This command controls maskset in LKST, such as reading, writing, deletion, changing, and displaying list of all masksets.
.SH COMMANDS
.TP
.B all
Output a list of masksets and display content of all masksets.


.TP 
\fBdelete/del \-m \fImaskset_id
Delete a maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify an id of a maskset to be deleted.
.PP

.TP
.B list/ls
Output a list of all masksets.

.TP
\fBread \fR[\fB\-m \fImaskset_id\fR] [\fB-A\fR] [\fB-a\fR] [\fB-d\fR]
Output a content of maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify an id of a maskset to be read. If omitted, a currently selected
maskset is read.
.TP 1i
.B \ \ \ \ \ \ \-A
Read all masksets.
.TP 1i
.B \ \ \ \ \ \ \-a
Do not omit not registered event type. It ignored if "\-d" option is
specified.
.TP 1i
.B \ \ \ \ \ \ \-d
Do not display a description of each event type.
.PP

.TP
\fBset \-m \fImaskset_id
Change currently selected maskset. 
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify an id of a maskset to be selected.
.PP

.TP 
\fBwrite \fR[\fB\-m \fImaskset_id\fR] [\fB-f \fIfile_name\fR] [\fB-n \fImaskset_name\fR] [\fB-S\fR]
Write a new maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify an id of the maskset to be written. If omitted, empty id is
selected automatically.
.TP 1i
.B \ \ \ \ \ \ \-f \fIfile_name
Specify a file which the content of the maskset is written. If ommited,
standard input is used as input. This file can be created by "read"
command as template.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify a name of the maskset. If omitted, the name of the maskset
is set as "new_maskset".
.TP 1i
.B \ \ \ \ \ \ \-S
Change a currently selected maskset to the written maskset.
.PP

.TP
.B version/ver
Print version information.
.PP

.TP
.B help
Print help message.
.PP
.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH REFERENCES
.BR lkst (8),
.BR ioctl(LKST_IOC_MASKSET_READ) (2),
.BR ioctl(LKST_IOC_MASKSET_WRITE) (2),
.BR ioctl(LKST_IOC_MASKSET_LIST) (2),
.BR ioctl(LKST_IOC_MASKSET_SET) (2),
.BR ioctl(LKST_IOC_MASKSET_DELETE) (2)
