.TH lkstlogd 8
.SH NAME
lkstlogd \- Linxu Kernel State Tracer logging utility.
.br
.SH SYNOPSIS
lkstlogd [\fB-a\fR] [\fB-b \fIbuffer_size\fR] [\fB\-l \fIlimit_size\fR] [\fB-n \fInumber\fR] [\fB-f \fIlog_file_name\fR] [\fB-hv\fR]
.SH DESCRIPTION
.B lkstlogd \fRsupports to analyze faults which do not crash kernel; typically faults
as follows:
.PP
.in +1i
.B A certain application can never start.
.br
.B A certain daemon process ends suddenly, but the cause is unknown.
.in -1i

.B lkstlogd \fRprovides functions as follows:

When a specific signal is sent to \fBlkstlogd\fR, \fBlkstlogd\fR starts to write event logs, which is recorded by lkst, to a specified file. And \fBlkstlogd\fR continues writing the file until the signal is sent again.

In addition, when another special signal is sent, \fBlkstlogd\fR saves currently writing file and creates new one. 
.SH OPTIONS
.TP 
.B \-a
Start to write event logs to a file with starting \fBlkstlogd\fR.

.TP 
.B \-b \fIbuffer_size
Specify buffer size to create at initialization. (Default 2MByte)

.TP
.B \-l \fIlimit_size
Specify a maximum size of log file in byte.
If the file size has reached the maximum size, \fBlkstlogd\fR rewinds the write pointer to head of the file.
The default size if 10MByte.

.TP
.B \-n \fInumber
Specify number of buffer (for each CPU) to create at initialization. (Default 2)

.TP
.B \-f \fIlog_file_name
Specify log file name.

.TP
.B \-h 
Print help message.

.TP
.B \-v
Print version information.
.SH OUTPUT FORMAT
Same as output of \fBlkstbuf\fR command.

.SH SIGNALS
\fBlkstlogd\fR receives signals. To send signal to \fBlkstlogd\fR, use `kill` command as follow.
.IP
.B kill \-SIGNAL `cat /var/run/lkstlogd.pid`
.PP
.TP
.B SIGHUP
Re\-initialize \fBlkstlogd\fR. All the opened files are closed, and all child processes are terminated. Then \fBlkstlogd\fR is restarted.
.TP
.B SIGTERM
Terminate \fBlkstlogd\fR.
.TP
.B SIGUSR1
Start to write event logs to a file.
When \fBlkstlogd\fR receives it again, \fBlkstlogd\fR stops writing logs.
.TP
.B SIGUSR2
Change a file to write event logs.
.SH FILES
.TP
.I /var/log/lkst/sebuf<cpu_number>.<serial_number>
\fBlkstlogd\fR writes event logs to different files for each CPU.
In addition, when \fBlkstlogd\fR receives \fBSIGUSR2\fR, saves currently writing file, and create new file of which \fIserial_number\fR is increased by 1, and start writing to the file. This file can be changed by using \fB-f\fR option.
.TP
.I /var/run/lkstlogd.pid
This file holds process ID of \fBlkstlogd\fR.
\fBlkstlogd\fR checks presence of this file at first. If it is, \fBlkstlogd\fR exits as error.
.TP
.I /etc/sysconfig/lkstlogd
Configuration file for \fBlkstlogd\fR.
This file format is shown as follows:

.IP
.nf
.B # comment
.B LKSTLOGDOPTION="\-l 8388608"
.fi

# at line head shows this line is comment sentence. In \fBLKSTLOGDOPTION\fR, start options of \fBlkstlogd\fR are written.
This file is read and interpreted by \fIrc\fR file at system initialization.
.SH REFERENCES
.BR ioctl(LKST_IOC_BUFFER_READ) (2),
.BR lkstbuf (8)
