/**
 * @file  ShellContextMenu.h
 * @brief Windows VF̃ReLXgj[`.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#pragma once

#include "MiscUtil.h"

namespace GenericUtility {

	/**
	 * Windows VF̃ReLXgj[.
	 */
	class CShellContextMenu : boost::noncopyable
	{
	public:
		CShellContextMenu();
		~CShellContextMenu();

		/**
		 * .
		 * @param[in] hWnd     ReLXgj[̐eƂȂEBhEnh
		 * @param[in] lpszPath ReLXgj[̑ΏۂƂȂt@C̃tpX
		 */
		bool Initialize(HWND hWnd, LPCTSTR lpszPath);
		/**
		 * I.
		 */
		void Terminate();

		/**
		 * ReLXgj[ǉ.
		 * @note O Initialize() sĂKv
		 * @see IContextMenu::QueryContextMenu()
		 */
		bool QueryContextMenu(
			HMENU hmenu,
			UINT indexMenu,
			UINT idCmdFirst = 1,
			UINT idCmdLast = 0x7fff,
			UINT uFlags = CMF_NORMAL);

		/**
		 * ReLXgj[̃R}hs.
		 * @param[in] nID ReLXgj[őIꂽR}h ID
		 * @note O QueryContextMenu() sĂKv
		 * @see IContextMenu::InvokeCommand()
		 */
		bool InvokeCommand(UINT nID);

		/**
		 * ReLXgj[p̃bZ[W.
		 * PreTranslateMessage() Ăׂ΂悢.
		 * @retval true  ܂ QueryContextMenu() ĂȂA邢͏ɐ
		 * @retval false IContextMenu2::HandleMenuMsg() ̎sɎs
		 * @see IContextMenu2::HandleMenuMsg()
		 */
		bool HandleMenuMsg(MSG* pMsg);

	private:
		/// ReLXgj[̐eƂȂEBhEnh
		HWND m_hWnd;

		/// ReLXgj[
		CComPtr  <IContextMenu>  m_spContextMenu;
		/// ReLXgj[ (for HandleMenuMsg())
		CComQIPtr<IContextMenu2> m_spContextMenu2;

		/// R}h ID ŏl
		UINT m_idCmdFirst;
		/// R}h ID ől
		UINT m_idCmdLast;
	};

}	// namespace GenericUtility
